/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.config;

import com.evermind.security.User;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.management.openmbean.CompositeData;
import oracle.j2ee.admin.jmx.exception.config.ConfigMBeanException;
import oracle.oc4j.admin.config.CommandParser;
import oracle.oc4j.admin.config.ConfigUtils;
import oracle.oc4j.admin.config.CreationException;
import oracle.oc4j.admin.config.InstanceConfig;
import oracle.oc4j.admin.config.LocalizationHelper;
import oracle.oc4j.admin.internal.OpmnConfigCallBack;
import oracle.oc4j.admin.jmx.server.mbeans.model.ModelMBeanFactory;
import oracle.oc4j.admin.jmx.server.state.JMXStateFactoryImpl;
import oracle.oc4j.admin.management.callbackinterfaces.OpmnCompCallBackIf;
import oracle.oc4j.admin.management.callbackinterfaces.OpmnProcOc4jCallBackIf;
import oracle.oc4j.admin.management.mbeans.OpmnConfig;
import oracle.oc4j.admin.management.mbeans.OpmnConfigMBean;

public class Oc4jCreator {
    static String DEFAULT_GROUP_NAME = "default_group";
    static String CONFIG_MBEAN_NAME = "default";
    static String DEFAULT_DOMAIN = "oc4j";
    static String HOME_INSTANCE = "home";
    static final String SEP = File.separator;
    static LocalizationHelper _locHelper = null;

    public Oc4jCreator() {
        JMXStateFactoryImpl.init();
        _locHelper = new LocalizationHelper();
        ConfigUtils.doDebug(Boolean.getBoolean("oc4j.creation.debug"));
    }

    public void doCreation(String oracleHome, String configHome, String oc4jName, String password, Map extraParams, OpmnProcOc4jCallBackIf oc4jCallBack) throws CreationException {
        InstanceConfig instanceConfig = new InstanceConfig(oracleHome, configHome, oc4jName);
        instanceConfig.checkExistingDirectory();
        try {
            instanceConfig.installNewInstance();
            instanceConfig.updateXML(extraParams);
            String dap = (String)extraParams.get("defaultAdminPass");
            if (dap == null || dap.equals("false")) {
                instanceConfig.activateUser(password);
            }
            this.updateOpmnXml(oracleHome, configHome, oc4jCallBack, oc4jName, extraParams);
        }
        catch (CreationException ce) {
            try {
                instanceConfig.permitRemove(true);
            }
            catch (CreationException e) {
                throw new CreationException(e, _locHelper.getMessage("Error_clean_up_failed_instance") + e.getMessage());
            }
            throw ce;
        }
        catch (Exception e) {
            try {
                instanceConfig.permitRemove(true);
            }
            catch (CreationException ce) {
                throw new CreationException(ce, _locHelper.getMessage("Error_clean_up_failed_instance") + ce.getMessage());
            }
            throw new CreationException(e);
        }
    }

    public static void main(String[] args) {
        Oc4jCreator creator = new Oc4jCreator();
        if (args == null || args.length == 0 || args[0].equals("-help")) {
            System.out.println(Oc4jCreator.getUsage());
            System.exit(9);
        }
        CommandParser parser = new CommandParser();
        ArrayList<String> arguments = new ArrayList<String>(Arrays.asList(args));
        try {
            parser.parseArguments(arguments);
        }
        catch (CreationException ce) {
            ConfigUtils.log(ce);
            System.out.println(ce.getMessage());
            System.out.println(Oc4jCreator.getUsage());
            System.exit(1);
        }
        if (parser.getNumProcs() != null && !parser.getNumProcs().equals("1") && parser.getPort() != null) {
            System.out.println(_locHelper.getMessage("Numprocs_httpport"));
            System.exit(1);
        }
        System.out.println(_locHelper.getMessage("Creating_oc4j", parser.getInstanceName()));
        Map extraParams = parser.getExtraParams();
        MBeanServer mbeanServer = MBeanServerFactory.createMBeanServer();
        OpmnConfig opmnConfigMBean = null;
        boolean isNewGroup = false;
        try {
            opmnConfigMBean = creator.registerOpmnConfigMBean(mbeanServer, parser.getOracleHome(), parser.getConfigHome());
            creator.checkExistingOC4J(mbeanServer, parser.getInstanceName());
            String groupName = creator.getGroupName(parser);
            isNewGroup = creator.checkExistingGroup(mbeanServer, opmnConfigMBean, groupName);
            String password = creator.getPassword(parser);
            creator.invokeCreateOc4j(mbeanServer, groupName, parser.getInstanceName(), password, extraParams);
            creator.syncLocalOpmnMBeans(parser);
            System.out.println(_locHelper.getMessage("New_oc4j_created", parser.getInstanceName(), parser.getGroupName()));
        }
        catch (CreationException ce) {
            ConfigUtils.log(ce);
            System.out.println(_locHelper.getMessage("Error_creating") + ce.getMessage());
            if (isNewGroup) {
                creator.rollbackOc4jGroup(mbeanServer, opmnConfigMBean, parser.getGroupName());
            }
            System.exit(1);
        }
        catch (Exception e) {
            ConfigUtils.log(e);
            System.out.println(_locHelper.getMessage("Error_creating") + e.getMessage());
            if (isNewGroup) {
                creator.rollbackOc4jGroup(mbeanServer, opmnConfigMBean, parser.getGroupName());
            }
            System.exit(1);
        }
        System.exit(0);
    }

    private void syncLocalOpmnMBeans(CommandParser parser) throws CreationException {
        if (ConfigUtils.pingOPMN(parser.getConfigHome())) {
            ConfigUtils.reloadOPMN(parser.getConfigHome());
            if (!parser.defaultAdminPass()) {
                ConfigUtils.syncLocalOpmnMBeans(parser.getConfigHome(), parser.getInstanceName());
            }
        }
    }

    private String getPassword(CommandParser parser) throws CreationException, IOException {
        String password = new String();
        if (!parser.defaultAdminPass()) {
            password = ConfigUtils.queryPasswordFromUser(parser.getInstanceName());
        }
        return password;
    }

    private String getGroupName(CommandParser parser) {
        String groupName = null;
        if (parser.getGroupName() == null) {
            groupName = DEFAULT_GROUP_NAME;
            parser.setGroupName(groupName);
        } else {
            groupName = parser.getGroupName();
        }
        return groupName;
    }

    static String getUsage() {
        return "\nUsage: \ncreateinstance <arguments> \n\nwhere arguments are: \n  -instanceName <name> :Name of new instance to be created.\n  -configHome <dir>    :(optional)Target directory where new instance\n                        is located.\n  -groupName <group>   :(optional)Name of group to which \n                        the new instance will be added.\n  -protocol <protocol> :(optional)Protocol for default-web-site.\n  -httpPort <port>     :(optional)Http port for default-web-site.\n                        Required in J2EE Server and Process Management\n                        install type only.\n  -numProcs <num>      :(optional)Number of processes to be started.\n                        If not specified, default to 1.\n  -startASControl      :(optional)Start the Application Server Control\n                        when starting this new instance. \n  -ASControlIsRoutable :(optional)Make the Application Server Control\n                        routable when started.\n  -noCloneHome         :(optional)create oc4j without cloning home instance.\n";
    }

    private boolean checkExistingGroup(MBeanServer mbeanServer, OpmnConfigMBean opmnConfigMBean, String groupName) throws CreationException {
        boolean isNewGroup = false;
        try {
            ObjectName compOc4jGroupName = new ObjectName("*:type=OpmnCompOc4jGroup,OpmnConfig=" + CONFIG_MBEAN_NAME + ",name=" + groupName);
            ConfigUtils.log(_locHelper.getMessage("ObjectName", "OpmnCompOc4jGroupMBean") + compOc4jGroupName.toString());
            Set<ObjectName> groupMBeans = mbeanServer.queryNames(compOc4jGroupName, null);
            boolean found = false;
            if (!groupMBeans.isEmpty()) {
                found = true;
            }
            if (!found) {
                Object[] params = new Object[]{new String(groupName)};
                String[] signatures = new String[]{new String("java.lang.String")};
                ObjectName newGroupObjectName = (ObjectName)mbeanServer.invoke(opmnConfigMBean.getObjectName(), "createOc4jGroup", params, signatures);
                isNewGroup = true;
            }
        }
        catch (MBeanException e) {
            ConfigMBeanException cme = (ConfigMBeanException)e.getCause();
            throw new CreationException(e, e.getMessage() + ": " + cme.getMessage());
        }
        catch (Exception e) {
            throw new CreationException(e, e.getMessage());
        }
        ConfigUtils.log(_locHelper.getMessage("Check_existing_group", groupName, new Boolean(isNewGroup).toString()));
        return isNewGroup;
    }

    private void checkExistingOC4J(MBeanServer mbeanServer, String oc4jName) throws CreationException {
        ConfigUtils.log(_locHelper.getMessage("Check_existing_oc4j", oc4jName));
        try {
            ObjectName oc4jMBeanName = new ObjectName("*:type=OpmnProcOc4j,OpmnConfig=" + CONFIG_MBEAN_NAME + ",name=" + oc4jName + ",*");
            ConfigUtils.log(_locHelper.getMessage("ObjectName", "OpmnConfigMBean") + oc4jMBeanName.toString());
            Object[] oc4jMBeans = mbeanServer.queryNames(oc4jMBeanName, null).toArray();
            if (oc4jMBeans.length >= 1) {
                for (int i = 0; i < oc4jMBeans.length; ++i) {
                    if (!((ObjectName)oc4jMBeans[i]).getDomain().equals(DEFAULT_DOMAIN)) continue;
                    ConfigUtils.log(_locHelper.getMessage("ObjectName", "domain " + DEFAULT_DOMAIN) + ((ObjectName)oc4jMBeans[i]).toString());
                    String groupName = ((ObjectName)oc4jMBeans[i]).getKeyProperty("OpmnCompOc4jGroup");
                    String error = _locHelper.getMessage("instance_exists", oc4jName, groupName);
                    System.out.println(error);
                    System.exit(1);
                }
            }
        }
        catch (MalformedObjectNameException me) {
            throw new CreationException(me.getMessage());
        }
        catch (Exception e) {
            throw new CreationException(e, e.getMessage());
        }
    }

    private boolean checkExistingHome(MBeanServer mbeanServer, String oc4jName) throws CreationException {
        try {
            ObjectName oc4jMBeanName = new ObjectName("*:type=OpmnProcOc4j,OpmnConfig=" + CONFIG_MBEAN_NAME + ",name=" + oc4jName + ",*");
            ConfigUtils.log(_locHelper.getMessage("ObjectName", "OpmnConfigMBean") + oc4jMBeanName.toString());
            Object[] oc4jMBeans = mbeanServer.queryNames(oc4jMBeanName, null).toArray();
            if (oc4jMBeans.length >= 1) {
                for (int i = 0; i < oc4jMBeans.length; ++i) {
                    if (!((ObjectName)oc4jMBeans[i]).getDomain().equals(DEFAULT_DOMAIN)) continue;
                    ConfigUtils.log(_locHelper.getMessage("ObjectName", "domain " + DEFAULT_DOMAIN) + ((ObjectName)oc4jMBeans[i]).toString());
                    return true;
                }
            }
            return false;
        }
        catch (MalformedObjectNameException me) {
            throw new CreationException(me.getMessage());
        }
        catch (Exception e) {
            throw new CreationException(e, e.getMessage());
        }
    }

    void rollbackOc4jGroup(MBeanServer mbeanServer, OpmnConfig opmnConfigMBean, String groupName) {
        try {
            Object[] params = new Object[]{new String(groupName)};
            String[] signatures = new String[]{new String("java.lang.String")};
            ObjectName newGroupObjectName = (ObjectName)mbeanServer.invoke(opmnConfigMBean.getObjectName(), "removeOc4jGroup", params, signatures);
        }
        catch (MBeanException e) {
            ConfigUtils.log(e);
            ConfigMBeanException cme = (ConfigMBeanException)e.getCause();
            System.out.println(_locHelper.getMessage("Failed_to_recover") + e.getMessage() + ": " + cme.getMessage());
            System.exit(1);
        }
        catch (Exception e) {
            ConfigUtils.log(e);
            System.out.println(_locHelper.getMessage("Failed_to_recover") + e.getMessage());
            System.exit(1);
        }
    }

    private OpmnConfig registerOpmnConfigMBean(MBeanServer mbeanServer, String oracleHome, String configHome) throws CreationException {
        ConfigUtils.log(_locHelper.getMessage("Register_OpmnConfigMBean", oracleHome, configHome));
        OpmnConfig opmnConfigMBean = null;
        try {
            opmnConfigMBean = new OpmnConfig(new OpmnConfigCallBack(CONFIG_MBEAN_NAME, oracleHome, configHome));
            ObjectName opmnConfigMBeanObjectName = opmnConfigMBean.getObjectName();
            if (mbeanServer.isRegistered(opmnConfigMBeanObjectName)) {
                throw new CreationException(_locHelper.getMessage("opmnconfmbean_already_registered", opmnConfigMBeanObjectName.toString()));
            }
            mbeanServer.registerMBean(ModelMBeanFactory.getModelMBean(opmnConfigMBean), opmnConfigMBeanObjectName);
        }
        catch (Exception e) {
            ConfigUtils.log(e);
            throw new CreationException(e, e.getMessage());
        }
        return opmnConfigMBean;
    }

    private void invokeCreateOc4j(MBeanServer mbeanServer, String groupName, String oc4jName, String password, Map extraParams) throws CreationException {
        ConfigUtils.log(_locHelper.getMessage("invoke_create_oc4j_on_opmn_mbeans", groupName, oc4jName));
        try {
            ObjectName compOc4jGroupName = new ObjectName("*:type=OpmnCompOc4jGroup,OpmnConfig=" + CONFIG_MBEAN_NAME + ",name=" + groupName);
            Object[] compOc4jGroupMBeans = mbeanServer.queryNames(compOc4jGroupName, null).toArray();
            ObjectName compOc4jGroupMBean = null;
            if (compOc4jGroupMBeans.length == 0) {
                throw new CreationException(_locHelper.getMessage("group_not_exist", groupName));
            }
            if (compOc4jGroupMBeans.length >= 1) {
                for (int i = 0; i < compOc4jGroupMBeans.length; ++i) {
                    if (!((ObjectName)compOc4jGroupMBeans[i]).getDomain().equals(DEFAULT_DOMAIN)) continue;
                    compOc4jGroupMBean = (ObjectName)compOc4jGroupMBeans[i];
                }
            }
            if (compOc4jGroupMBean == null) {
                throw new CreationException(_locHelper.getMessage("Can_not_find_mbean") + compOc4jGroupName.toString());
            }
            Object[] params = new Object[]{new String(oc4jName), new String(password), new Boolean((String)extraParams.get("start.oc4j")), new HashMap(extraParams)};
            String[] signatures = new String[]{new String("java.lang.String"), new String("java.lang.String"), new String("boolean"), new String("java.util.Map")};
            ObjectName newOc4jName = (ObjectName)mbeanServer.invoke(compOc4jGroupMBean, "createOc4j", params, signatures);
        }
        catch (MBeanException ce) {
            ConfigMBeanException cme = (ConfigMBeanException)ce.getCause();
            throw new CreationException(cme, cme.getMessage());
        }
        catch (Exception e) {
            throw new CreationException(e, e.getMessage());
        }
    }

    private void updateOpmnXml(String oracleHome, String configHome, OpmnProcOc4jCallBackIf oc4jCallBack, String oc4jName, Map extraParams) throws CreationException {
        String protocol = null;
        String range = null;
        String defaultPortRangeForAJP = "12501-12600";
        try {
            String numProcs;
            CompositeData portValueForHome;
            if (!oracleHome.equals(configHome)) {
                ConfigUtils.log("Updating opmn.xml: setting attribute \"working-dir=$ORACLE_HOME/j2ee/home\".");
                oc4jCallBack.setAttr("working-dir", "$ORACLE_HOME/j2ee/home");
            }
            if ((portValueForHome = oc4jCallBack.getPort("default-web-site")) == null) {
                throw new CreationException(_locHelper.getMessage("missing_port_for_default-web-site"));
            }
            String homeProtocol = (String)portValueForHome.get("protocol");
            ConfigUtils.log("Updating opmn.xml: get protocol for home/template instance: " + homeProtocol);
            String newProtocol = (String)extraParams.get("protocol");
            String newPortRange = (String)extraParams.get("port");
            protocol = newProtocol != null ? newProtocol : homeProtocol;
            ConfigUtils.log("Updating opmn.xml: instance " + oc4jName + " has protocol: " + homeProtocol);
            if (protocol.equalsIgnoreCase("ajp")) {
                if (!this.OHSExisting(oc4jCallBack, "OpmnCompOhs")) {
                    System.out.println(_locHelper.getMessage("ajp_no_ohs_warning"));
                }
                if (newPortRange != null) {
                    System.out.println(_locHelper.getMessage("no_new_port_range_warning"));
                }
                range = defaultPortRangeForAJP;
            } else if (protocol.equalsIgnoreCase("http")) {
                if (newPortRange == null) {
                    throw new CreationException(_locHelper.getMessage("is_j2ee_opmn_intall_type"));
                }
                range = newPortRange;
            }
            ConfigUtils.log("Updating opmn.xml: default-web-site range=" + range + " protocol=" + protocol);
            oc4jCallBack.setPort("default-web-site", range, protocol);
            String javaOptions = oc4jCallBack.getJVMOptions();
            javaOptions = javaOptions.replaceAll("/home/", "/" + oc4jName + "/");
            int index = javaOptions.indexOf("-server ");
            String os = System.getProperty("java.vendor");
            if (os.indexOf("IBM Corporation") == 0 && index != -1) {
                javaOptions = javaOptions.substring(0, index) + javaOptions.substring(index + 8, javaOptions.length());
            }
            if (!oracleHome.equals(configHome)) {
                javaOptions = javaOptions.replaceAll("ORACLE_HOME/", "ORACLE_CONFIG_HOME/");
            }
            oc4jCallBack.setJVMOptions(javaOptions);
            javaOptions = oc4jCallBack.getParameter("stop-parameters", "java-options");
            javaOptions = javaOptions.replaceAll("/home/", "/" + oc4jName + "/");
            if (!oracleHome.equals(configHome)) {
                javaOptions = javaOptions.replaceAll("ORACLE_HOME/", "ORACLE_CONFIG_HOME/");
            }
            oc4jCallBack.setParameter("stop-parameters", "java-options", javaOptions);
            boolean enabled = oc4jCallBack.isEnabled();
            if (!enabled) {
                oc4jCallBack.setEnabled(true);
            }
            if ((numProcs = (String)extraParams.get("numprocs")) != null) {
                oc4jCallBack.setnumProcs(new Integer(numProcs));
            }
        }
        catch (Exception e) {
            throw new CreationException(e, _locHelper.getMessage("invalid_protocol") + e.getMessage());
        }
    }

    private boolean OHSExisting(OpmnProcOc4jCallBackIf oc4jCallBack, String compType) {
        boolean existing = false;
        OpmnCompCallBackIf[] comps = oc4jCallBack.getParent().getParent().getComponents();
        for (int i = 0; i < comps.length; ++i) {
            if (!comps[i].getType().equals(compType)) continue;
            existing = true;
        }
        return existing;
    }

    private void removeOpmnMBean(MBeanServer mbeanServer, String name, String oracleHome, String configHome) throws CreationException, InstanceNotFoundException, MBeanException, ReflectionException {
        if (!oracleHome.equals(configHome)) {
            ConfigUtils.log("oracleHome = " + oracleHome + ", configHome = " + configHome);
            String homePath = configHome + SEP + "j2ee" + SEP + name;
            if (this.checkExistingHome(mbeanServer, name) && !new File(homePath).exists()) {
                ObjectName compOc4jGroupMBean = ConfigUtils.getCompOc4jGroupMBean(mbeanServer, name);
                Object[] params = new Object[]{new String(name)};
                String[] signatures = new String[]{new String("java.lang.String")};
                ConfigUtils.log("Removing " + name + "snippet from opmn.xml under " + configHome);
                ObjectName newOc4jName = (ObjectName)mbeanServer.invoke(compOc4jGroupMBean, "removeOc4j", params, signatures);
                if (ConfigUtils.pingOPMN(configHome)) {
                    ConfigUtils.log("Reload OPMN from " + configHome);
                    ConfigUtils.reloadOPMN(configHome);
                    User user = null;
                    try {
                        user = ConfigUtils.getAdminUser(configHome, name);
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    if (user == null) {
                        user = ConfigUtils.getAdminUser(configHome, "home");
                    }
                    ConfigUtils.syncLocalOpmnMBeans(configHome, user);
                }
            }
        }
    }
}

