/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.config;

import com.evermind.io.IOUtils;
import com.evermind.io.OutputStreamLogger;
import com.evermind.mail.MailLogger;
import com.evermind.net.URLLogger;
import com.evermind.server.OC4JServer;
import com.evermind.server.XMLServerConfig;
import com.evermind.server.deployment.EnterpriseArchive;
import com.evermind.server.deployment.MailSessionInfo;
import com.evermind.util.CollectionLogger;
import com.evermind.util.ConfigUtils;
import com.evermind.util.JavaUtilLoggingLogger;
import com.evermind.util.ODLLogger;
import com.evermind.xml.XMLUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import javax.mail.Session;
import javax.mail.internet.AddressException;
import oracle.oc4j.configuration.ConfigException;
import oracle.oc4j.configuration.XMLSerializableBase;
import org.w3c.dom.DOMException;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class LogConfig
extends XMLSerializableBase {
    private List _logMailAddresses;
    private List _logPaths;
    private List _odlLoggers;
    private List _javaUtilLoggingLoggers;
    private CollectionLogger _logger;
    private StringBuffer _dmsStr;
    private String _name;
    private URL _base;
    private URL _url;
    private MailSessionInfo _mail;

    public LogConfig(EnterpriseArchive parent) throws ConfigException {
        if (parent == null) {
            throw new ConfigException("parent for LogConfig() should not be null");
        }
        this._base = parent.getDeploymentURL();
        this._url = parent.getURL();
        this._name = parent.getName();
        this._mail = parent.getDefaultMailSession(true);
        this._logPaths = new ArrayList();
        this._logPaths.add("application.log");
    }

    public LogConfig(EnterpriseArchive parent, Node node) throws ConfigException {
        super(node);
        if (parent == null) {
            throw new ConfigException("parent for LogConfig() should not be null");
        }
        this._base = parent.getDeploymentURL();
        this._url = parent.getURL();
        this._name = parent.getName();
        this._mail = parent.getDefaultMailSession(true);
    }

    public LogConfig(XMLServerConfig parent, Node node) throws ConfigException {
        super(node);
        if (parent == null) {
            throw new ConfigException("parent for LogConfig() should not be null");
        }
        this._base = parent.getURL();
        this._url = parent.getURL();
        this._name = parent.getName();
        this._mail = null;
    }

    public void read(Node node) throws DOMException, ConfigException {
        NodeList list = node.getChildNodes();
        if (list == null) {
            return;
        }
        for (int i = 0; i < list.getLength(); ++i) {
            Node child = list.item(i);
            String name = child.getNodeName();
            if (name.equals("file")) {
                this.parseFileNode(child);
                continue;
            }
            if (name.equals("odl")) {
                this.parseOdlNode(child);
                continue;
            }
            if (name.equals("redirect-to-java-util-logging-logger")) {
                this.parseJavaUtilLoggingLoggerNode(child);
                continue;
            }
            if (!name.equals("mail")) continue;
            this.parseMailNode(child);
        }
    }

    public void write(PrintWriter out, String indent) throws IOException {
        int i;
        if (this._logMailAddresses == null && this._logPaths == null && this._odlLoggers == null && this._javaUtilLoggingLoggers == null) {
            return;
        }
        out.println(indent + "<log>");
        if (this._logPaths != null) {
            for (i = 0; i < this._logPaths.size(); ++i) {
                out.println(indent + "\t<file path=\"" + this._logPaths.get(i).toString() + "\" />");
            }
        }
        if (this._odlLoggers != null) {
            for (i = 0; i < this._odlLoggers.size(); ++i) {
                ((ODLLogger)this._odlLoggers.get(i)).writeXML(out, indent);
            }
        }
        if (this._javaUtilLoggingLoggers != null) {
            for (i = 0; i < this._javaUtilLoggingLoggers.size(); ++i) {
                out.println(indent + "\t<redirect-to-java-util-logging value=\"true\" />");
            }
        }
        if (this._logMailAddresses != null) {
            for (i = 0; i < this._logMailAddresses.size(); ++i) {
                out.println(indent + "\t<mail address=\"" + XMLUtils.encode(this._logMailAddresses.get(i).toString()) + "\" />");
            }
        }
        out.println(indent + "</log>");
    }

    public CollectionLogger getCollectionLogger() throws ConfigException {
        if (this._logger != null) {
            return this._logger;
        }
        if (this._logMailAddresses == null && this._logPaths == null && this._odlLoggers == null && this._javaUtilLoggingLoggers == null) {
            return null;
        }
        this._logger = new CollectionLogger();
        this._dmsStr = new StringBuffer();
        this.addFileLoggers();
        this.addOdlLoggers();
        this.addMailLoggers();
        this.addJavaUtilLoggingLoggers();
        this._logger.setLogTimestamp(true);
        return this._logger;
    }

    public String getDMSString() {
        if (this._dmsStr == null) {
            return null;
        }
        return this._dmsStr.toString();
    }

    private void parseFileNode(Node node) throws DOMException, ConfigException {
        String path = XMLUtils.getNodeAttribute(node, "path");
        if (path == null) {
            throw new ConfigException("<log> tag with <file> subtag with missing path attribute in " + this._url);
        }
        if (this._logPaths == null) {
            this._logPaths = new ArrayList();
        }
        if (!this._logPaths.contains(path)) {
            this._logPaths.add(path);
        }
    }

    private void parseOdlNode(Node node) throws DOMException, ConfigException {
        String path = XMLUtils.getNodeAttribute(node, "path");
        if (path == null) {
            throw new ConfigException("<odl> tag with required path attribute missing");
        }
        int maxFileSize = Integer.parseInt(XMLUtils.getNodeAttribute(node, "max-file-size"));
        int maxDirectorySize = Integer.parseInt(XMLUtils.getNodeAttribute(node, "max-directory-size"));
        ODLLogger odlLogger = null;
        try {
            odlLogger = new ODLLogger(path, maxFileSize, maxDirectorySize);
        }
        catch (InstantiationException e) {
            throw new ConfigException("Unable to instantiate ODLLogger: " + e.getMessage());
        }
        if (this._odlLoggers == null) {
            this._odlLoggers = new ArrayList();
        }
        if (!this._odlLoggers.contains(odlLogger)) {
            this._odlLoggers.add(odlLogger);
        }
    }

    private void parseJavaUtilLoggingLoggerNode(Node node) throws DOMException, ConfigException {
        String value = XMLUtils.getNodeAttribute(node, "value");
        if (value == null) {
            throw new ConfigException("<log> tag with <redirect-to-java-util-logging-logger> subtag with missing value attribute in " + this._url);
        }
        if (value.equals("true")) {
            JavaUtilLoggingLogger javaUtilLoggingLogger = new JavaUtilLoggingLogger();
            if (this._javaUtilLoggingLoggers == null) {
                this._javaUtilLoggingLoggers = new ArrayList();
            }
            if (!this._javaUtilLoggingLoggers.contains(javaUtilLoggingLogger)) {
                this._javaUtilLoggingLoggers.add(javaUtilLoggingLogger);
            }
        }
    }

    private void parseMailNode(Node node) throws DOMException, ConfigException {
        String mail = XMLUtils.getNodeAttribute(node, "address");
        if (mail == null) {
            throw new ConfigException("<log> tag with <mail> subtag with missing address attribute in " + this._url);
        }
        if (this._logMailAddresses == null) {
            this._logMailAddresses = new ArrayList();
        }
        if (!this._logMailAddresses.contains(mail)) {
            this._logMailAddresses.add(mail);
        }
    }

    private void addFileLoggers() throws ConfigException {
        if (this._logPaths == null) {
            return;
        }
        for (int i = 0; i < this._logPaths.size(); ++i) {
            String path = (String)this._logPaths.get(i);
            try {
                URL url = ConfigUtils.getURL(this._base, path);
                OutputStreamLogger urlLogger = null;
                if (url.getProtocol().equals("file")) {
                    String name = IOUtils.getInstancePath(url.getFile(), OC4JServer.getInstanceId(), true);
                    File f = new File(name);
                    if (f != null && !f.exists()) {
                        File parent = f.getParentFile();
                        if (!parent.exists()) {
                            parent.mkdirs();
                        }
                        f.createNewFile();
                    }
                    if (i > 0) {
                        this._dmsStr.append(", ");
                    }
                    this._dmsStr.append(name);
                    urlLogger = new OutputStreamLogger(new FileOutputStream(name, true));
                } else {
                    urlLogger = new URLLogger(url);
                }
                this._logger.addLogger(urlLogger);
                continue;
            }
            catch (IOException e) {
                throw new ConfigException("Error initializing _logger for " + path + ": " + e.getMessage());
            }
        }
    }

    private void addOdlLoggers() throws ConfigException {
        if (this._odlLoggers == null) {
            return;
        }
        for (int i = 0; i < this._odlLoggers.size(); ++i) {
            ODLLogger odlLogger = (ODLLogger)this._odlLoggers.get(i);
            try {
                URL url = ConfigUtils.getURL(this._base, odlLogger.getPath());
                String name = IOUtils.getInstancePath(url.getFile(), OC4JServer.getInstanceId(), true);
                odlLogger.setCanonicalPath(name);
                odlLogger.init(null);
                if (!odlLogger.isInitialized()) {
                    throw new ConfigException("Error initializing ODL Logger for " + odlLogger);
                }
                if (i > 0) {
                    this._dmsStr.append(", ");
                }
                this._dmsStr.append(name + "/log.xml");
                this._logger.addLogger(odlLogger);
                continue;
            }
            catch (IOException e) {
                throw new ConfigException("Error initializing _logger for " + odlLogger + ": " + e.getMessage());
            }
        }
    }

    private void addJavaUtilLoggingLoggers() throws ConfigException {
        if (this._javaUtilLoggingLoggers == null) {
            return;
        }
        for (int i = 0; i < this._javaUtilLoggingLoggers.size(); ++i) {
            JavaUtilLoggingLogger javaUtilLoggingLogger = (JavaUtilLoggingLogger)this._javaUtilLoggingLoggers.get(i);
            if (javaUtilLoggingLogger != null) {
                Properties properties = new Properties();
                if (this._name != null && this._url != null) {
                    properties.setProperty("name", this._name);
                    properties.setProperty("parentName", new File(this._url.getPath()).getParentFile().getName());
                    properties.setProperty("urlFileName", new File(this._url.getPath()).getName());
                }
                javaUtilLoggingLogger.init(properties);
            }
            this._logger.addLogger(javaUtilLoggingLogger);
        }
    }

    private void addMailLoggers() throws ConfigException {
        if (this._logMailAddresses == null) {
            return;
        }
        Session session = this._mail == null ? Session.getDefaultInstance((Properties)new Properties(), null) : this._mail.getSession();
        try {
            MailLogger mailLogger = new MailLogger(this._logMailAddresses.toArray(new String[this._logMailAddresses.size()]), session, this._name + " log");
            mailLogger.setLogExceptionsOnly(true);
            this._logger.addLogger(mailLogger);
        }
        catch (AddressException e) {
            throw new ConfigException("Error initializing log mailers for " + this._name);
        }
    }
}

