/*
 * Decompiled with CFR 0.152.
 */
package oracle.j2ee.ws.server;

import com.evermind.xml.XMLConfig;
import java.lang.reflect.Constructor;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.j2ee.ws.server.deployment.oc4j.WebServicesDescriptor;

public class WebServicesDescriptorFactory {
    private static final String WS_DESC_IMPL_CLASS = "oracle.j2ee.ws.server.portability.adapters.oc4j.WebServicesDescriptorAdapter";
    private static WebServicesDescriptorFactory s_instance = new WebServicesDescriptorFactory();
    private Class m_implClass = null;

    private WebServicesDescriptorFactory() {
        try {
            this.m_implClass = Class.forName(WS_DESC_IMPL_CLASS);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Cannot find the " + WebServicesDescriptor.class.getName() + " implementation class: " + WS_DESC_IMPL_CLASS);
        }
    }

    public static WebServicesDescriptorFactory getInstance() {
        return s_instance;
    }

    public WebServicesDescriptor newWebServicesDescriptor(XMLConfig config) {
        return this.newWebServicesDescriptor(config, false);
    }

    public WebServicesDescriptor newWebServicesDescriptor(XMLConfig config, boolean useDeploymentContext) {
        WebServicesDescriptor desc = null;
        try {
            Constructor ctor = this.m_implClass.getConstructor(XMLConfig.class, Boolean.class);
            desc = (WebServicesDescriptor)ctor.newInstance(config, useDeploymentContext);
        }
        catch (Exception e) {
            Logger.getLogger("oracle.webservices").log(Level.SEVERE, e.getMessage(), e);
        }
        return desc;
    }
}

