/*
 * Decompiled with CFR 0.152.
 */
package oracle.j2ee.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;

public final class UUID
implements Serializable {
    protected final long mostSig;
    protected final long leastSig;
    protected static SecureRandom secRand;
    private static final String ALGORITHM = "SHA1PRNG";

    public UUID() {
        UUID.createSecureRandom();
        byte[] secRandBuf16 = new byte[16];
        secRand.nextBytes(secRandBuf16);
        secRandBuf16[6] = (byte)(secRandBuf16[6] & 0xF);
        secRandBuf16[6] = (byte)(secRandBuf16[6] | 0x40);
        secRandBuf16[8] = (byte)(secRandBuf16[8] & 0x3F);
        secRandBuf16[8] = (byte)(secRandBuf16[8] | 0x80);
        secRandBuf16[10] = (byte)(secRandBuf16[10] | 0x80);
        long mostSig = 0L;
        for (int i = 0; i < 8; ++i) {
            mostSig = mostSig << 8 | (long)(secRandBuf16[i] & 0xFF);
        }
        long leastSig = 0L;
        for (int i = 8; i < 16; ++i) {
            leastSig = leastSig << 8 | (long)(secRandBuf16[i] & 0xFF);
        }
        this.mostSig = mostSig;
        this.leastSig = leastSig;
    }

    public UUID(byte[] bytes) {
        try {
            ByteArrayInputStream is = new ByteArrayInputStream(this.pad16(bytes));
            DataInputStream dis = new DataInputStream(is);
            this.mostSig = dis.readLong();
            this.leastSig = dis.readLong();
        }
        catch (IOException ioe) {
            throw new Error("UUID(): this should never happen: " + ioe);
        }
    }

    public UUID(long mostSig, long leastSig) {
        this.mostSig = mostSig;
        this.leastSig = leastSig;
    }

    public UUID(DataInput in) throws IOException {
        this.mostSig = in.readLong();
        this.leastSig = in.readLong();
    }

    public UUID(String aString) {
        try {
            ByteArrayInputStream bis = new ByteArrayInputStream(this.pad(aString).getBytes());
            DataInputStream in = new DataInputStream(bis);
            this.mostSig = in.readLong();
            this.leastSig = in.readLong();
        }
        catch (IOException e) {
            throw new Error("UUID(): Padding failure");
        }
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof UUID)) {
            return false;
        }
        UUID sid = (UUID)obj;
        return this.mostSig == sid.mostSig && this.leastSig == sid.leastSig;
    }

    public byte[] getBytes() {
        try {
            ByteArrayOutputStream bs = new ByteArrayOutputStream();
            DataOutputStream ds = new DataOutputStream(bs);
            this.writeBytes(ds);
            return bs.toByteArray();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public long getLeastSignificantBits() {
        return this.leastSig;
    }

    public long getMostSignificantBits() {
        return this.mostSig;
    }

    public int hashCode() {
        return (int)(this.mostSig >> 32 ^ this.mostSig ^ this.leastSig >> 32 ^ this.leastSig);
    }

    public static UUID newUUID() {
        byte[] secRandBuf16 = new byte[16];
        UUID.createSecureRandom();
        secRand.nextBytes(secRandBuf16);
        secRandBuf16[6] = (byte)(secRandBuf16[6] & 0xF);
        secRandBuf16[6] = (byte)(secRandBuf16[6] | 0x40);
        secRandBuf16[8] = (byte)(secRandBuf16[8] & 0x3F);
        secRandBuf16[8] = (byte)(secRandBuf16[8] | 0x80);
        secRandBuf16[10] = (byte)(secRandBuf16[10] | 0x80);
        long mostSig = 0L;
        for (int i = 0; i < 8; ++i) {
            mostSig = mostSig << 8 | (long)(secRandBuf16[i] & 0xFF);
        }
        long leastSig = 0L;
        for (int i = 8; i < 16; ++i) {
            leastSig = leastSig << 8 | (long)(secRandBuf16[i] & 0xFF);
        }
        return new UUID(mostSig, leastSig);
    }

    public static void createSecureRandom() {
        if (secRand == null) {
            try {
                secRand = SecureRandom.getInstance(ALGORITHM);
            }
            catch (NoSuchAlgorithmException ex) {
                secRand = new SecureRandom();
            }
            secRand.setSeed(System.currentTimeMillis());
        }
    }

    protected String pad(String aString) {
        String paddedString = aString;
        if (paddedString.length() < 16) {
            int size;
            for (int i = size = paddedString.length(); i < 16; ++i) {
                paddedString = paddedString + " ";
            }
        }
        return paddedString;
    }

    protected byte[] pad16(byte[] bytes) {
        int i;
        if (bytes.length == 16) {
            return bytes;
        }
        byte[] padded = new byte[16];
        for (i = 0; i < bytes.length; ++i) {
            padded[i] = bytes[i];
        }
        for (i = bytes.length; i < 16; ++i) {
            padded[i] = 0;
        }
        return padded;
    }

    public String toByteString() {
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            DataOutputStream dataOutput = new DataOutputStream(bos);
            this.writeBytes(dataOutput);
            return bos.toString();
        }
        catch (IOException e) {
            new Error("UUID.toByteString(): should never happen: " + e);
            return "";
        }
    }

    public String toString() {
        int i;
        char[] dest = new char[32];
        String s = Long.toHexString(this.mostSig);
        int l = s.length();
        for (i = 16; i > l; --i) {
            dest[16 - i] = 48;
        }
        s.getChars(0, l, dest, 16 - l);
        s = Long.toHexString(this.leastSig);
        l = s.length();
        for (i = 16; i > l; --i) {
            dest[32 - i] = 48;
        }
        s.getChars(0, l, dest, 32 - l);
        return new String(dest);
    }

    public static UUID toUUID(String aNewFormatUUIDString) {
        String aUUIDString = aNewFormatUUIDString.substring(0, 8) + "-" + aNewFormatUUIDString.substring(8, 12) + "-" + aNewFormatUUIDString.substring(12, 16) + "-" + aNewFormatUUIDString.substring(16, 20) + "-" + aNewFormatUUIDString.substring(20, 32);
        long theMostSig = 0L;
        long theLeastSig = 0L;
        try {
            StreamTokenizer st = new StreamTokenizer(new StringReader(aUUIDString));
            st.ordinaryChars(48, 57);
            st.wordChars(48, 57);
            st.whitespaceChars(45, 45);
            st.nextToken();
            String hex1 = st.sval;
            st.nextToken();
            String hex2 = st.sval;
            st.nextToken();
            String hex3 = st.sval;
            st.nextToken();
            String hex4 = st.sval;
            st.nextToken();
            String hex5 = st.sval;
            try {
                long leftMost = Long.parseLong(hex1, 16);
                long middleMost = Long.parseLong(hex2, 16);
                long rightMost = Long.parseLong(hex3, 16);
                long leftLeast = Long.parseLong(hex4, 16);
                long rightLeast = Long.parseLong(hex5, 16);
                theMostSig = leftMost << 32 | middleMost << 16 | rightMost;
                theLeastSig = leftLeast << 48 | rightLeast;
            }
            catch (NumberFormatException e) {
                throw new Error("UUID.toUUID(): " + e);
            }
        }
        catch (IOException ioe) {
            throw new Error("UUID.toUUID(): " + ioe);
        }
        return new UUID(theMostSig, theLeastSig);
    }

    public void writeBytes(DataOutput out) throws IOException {
        out.writeLong(this.mostSig);
        out.writeLong(this.leastSig);
    }
}

