/*
 * Decompiled with CFR 0.152.
 */
package oracle.j2ee.util;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.logging.ConsoleHandler;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;

public class LogFormatter
extends SimpleFormatter {
    private String lineSeparator = System.getProperty("line.separator");

    public synchronized String format(LogRecord record) {
        StringBuffer sb = new StringBuffer();
        StringBuffer text = new StringBuffer();
        String message = this.formatMessage(record);
        sb.append(record.getLevel().getLocalizedName());
        sb.append(": ");
        sb.append(message);
        sb.append(this.lineSeparator);
        if (record.getThrown() != null) {
            try {
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter(sw);
                record.getThrown().printStackTrace(pw);
                pw.close();
                sb.append(sw.toString());
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        return sb.toString();
    }

    public static void configFormatter(Logger logger) {
        Logger l = logger;
        do {
            Formatter formatter;
            Handler[] handlers;
            if ((handlers = l.getHandlers()) == null || handlers.length <= 0) continue;
            if (l.getName().length() > 0) {
                return;
            }
            if (handlers.length == 1 && handlers[0] instanceof ConsoleHandler && (formatter = handlers[0].getFormatter()) != null && !(formatter instanceof LogFormatter)) {
                handlers[0].setFormatter(new LogFormatter());
            }
            return;
        } while ((l = l.getParent()) != null);
    }
}

