/*
 * Decompiled with CFR 0.152.
 */
package oracle.j2ee.rmi;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.security.GeneralSecurityException;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.j2ee.rmi.RMIMessageBundle;
import oracle.j2ee.util.CustomerLogger;
import oracle.j2ee.util.LoggingUtils;
import oracle.oc4j.util.HexDisplay;

public class RmiTransportMessages {
    private static Logger m_logger = CustomerLogger.getLogger("oracle.j2ee.rmi.transport", RMIMessageBundle.class.getName());

    public static void warningReleaseErrorDuringShutdown(Throwable reason) {
        m_logger.log(Level.WARNING, "J2EE RMI-00001", reason);
    }

    public static Logger getLogger() {
        return m_logger;
    }

    private static boolean isLoggable(Level level) {
        return m_logger.isLoggable(level);
    }

    public static void fineTunneledRequest(URL url, byte[] bytes) {
        if (RmiTransportMessages.isLoggable(Level.FINEST)) {
            m_logger.log(Level.FINEST, "J2EE RMI-01002", new Object[]{url, HexDisplay.format(bytes)});
        } else {
            m_logger.log(Level.FINE, "J2EE RMI-01001", url);
        }
    }

    public static InputStream fineTunneledResponse(URLConnection connection) throws IOException {
        if (!RmiTransportMessages.isLoggable(Level.FINEST)) {
            m_logger.log(Level.FINE, "J2EE RMI-01003", connection.getURL());
            return connection.getInputStream();
        }
        InputStream inputStream = connection.getInputStream();
        byte[] buffer = new byte[1024];
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        int count = inputStream.read(buffer);
        while (count > 0) {
            baos.write(buffer, 0, count);
            count = inputStream.read(buffer);
        }
        m_logger.log(Level.FINEST, "J2EE RMI-01004", new Object[]{connection.getURL(), HexDisplay.format(baos.toByteArray())});
        return new ByteArrayInputStream(baos.toByteArray());
    }

    public static void fineTunneledAuthorizationHeader(String authorizationHeader) {
        m_logger.log(Level.FINE, "J2EE RMI-01005", authorizationHeader);
    }

    public static void warnTunnelSSlConfigFailure(GeneralSecurityException e) {
        m_logger.log(Level.WARNING, "J2EE RMI-01006", e.toString());
        LoggingUtils.logWarningStackTrace(m_logger, e);
    }
}

