/*
 * Decompiled with CFR 0.152.
 */
package oracle.j2ee.jndi;

import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.j2ee.jndi.JndiMessageBundle;
import oracle.j2ee.util.CustomerLogger;

public class JndiMessages {
    private static Logger m_logger = CustomerLogger.getLogger("oracle.j2ee.jndi", JndiMessageBundle.class.getName());

    public static void warningInvalidResourceEnvironmentReference(String resourceEnvRefName, Throwable reason) {
        m_logger.log(Level.WARNING, "J2EE JNDI-00001", resourceEnvRefName);
        JndiMessages.logException(reason);
    }

    public static void warningInvalidResourceReference(String resourceRefName, Throwable reason) {
        m_logger.log(Level.WARNING, "J2EE JNDI-00002", resourceRefName);
        JndiMessages.logException(reason);
    }

    public static void warningInvalidEJBReference(String ejbRefName, Throwable reason) {
        m_logger.log(Level.WARNING, "J2EE JNDI-00009", ejbRefName);
        JndiMessages.logException(reason);
    }

    public static void warningInvalidResourceReferenceLocation(String resourceRefName) {
        m_logger.log(Level.WARNING, "J2EE JNDI-00003", resourceRefName);
    }

    public static void warningInvalidReferencePossibleCircularReference(String refName, String location) {
        if (JndiMessages.isLoggable(Level.WARNING)) {
            m_logger.log(Level.WARNING, "J2EE JNDI-00006", new Object[]{refName, location});
        }
    }

    public static void warningNoTypeFoundAtLocation(String type, String location) {
        if (JndiMessages.isLoggable(Level.WARNING)) {
            m_logger.log(Level.WARNING, "J2EE JNDI-00004", new Object[]{type, location});
        }
    }

    public static void warningEmptyStackWithAssociateUserEnabled() {
        if (JndiMessages.isLoggable(Level.WARNING)) {
            m_logger.log(Level.WARNING, "J2EE JNDI-00007");
        }
    }

    public static void warningEmptyStackAfterDisAssociateUser() {
        if (JndiMessages.isLoggable(Level.WARNING)) {
            m_logger.log(Level.WARNING, "J2EE JNDI-00008");
        }
    }

    public static void warningMultipleReferencesOnRefName(String name) {
        if (JndiMessages.isLoggable(Level.WARNING)) {
            m_logger.log(Level.WARNING, "J2EE JNDI-00010", new Object[]{name});
        }
    }

    public static void logException(Throwable reason) {
        m_logger.log(Level.FINER, "J2EE JNDI-00005", reason);
    }

    static Logger getLogger() {
        return m_logger;
    }

    private static boolean isLoggable(Level level) {
        return m_logger.isLoggable(level);
    }
}

