/*
 * Decompiled with CFR 0.152.
 */
package oracle.j2ee.connector.work;

import com.evermind.server.ThreadState;
import com.evermind.server.connector.ApplicationConnectionManager;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.resource.spi.work.ExecutionContext;
import javax.resource.spi.work.WorkCompletedException;
import javax.resource.spi.work.WorkException;
import javax.transaction.Synchronization;
import javax.transaction.xa.XAException;
import javax.transaction.xa.Xid;
import oracle.j2ee.connector.logging.JCATraceLogger;
import oracle.j2ee.connector.work.ExecutionContextManager;

class ExecutionContextWrapper
implements Synchronization {
    private static Logger m_logger = JCATraceLogger.getLogger(ApplicationConnectionManager.class);
    private static ExecutionContextManager m_executionManager = ExecutionContextManager.getInstance();
    private ExecutionContext m_executionContext = null;
    static final int MAX_TRANSACTION_TIMEOUT = Integer.MAX_VALUE;

    ExecutionContextWrapper(ExecutionContext executionContext) throws WorkException {
        this.m_executionContext = executionContext;
    }

    private void validateExecutionContext(ExecutionContext executionContext) throws WorkException {
        if (executionContext != null && executionContext.getXid() == null) {
            WorkCompletedException wce = new WorkCompletedException("Invalid execution context : null Xid.");
            wce.setErrorCode("3");
            throw wce;
        }
    }

    public long getTransactionTimeout() {
        if (this.m_executionContext == null) {
            return 0L;
        }
        long transactionTimeout = this.m_executionContext.getTransactionTimeout();
        if (transactionTimeout > Integer.MAX_VALUE) {
            transactionTimeout = Integer.MAX_VALUE;
        } else if (transactionTimeout == -1L) {
            transactionTimeout = Integer.MAX_VALUE;
        }
        return transactionTimeout;
    }

    public Xid getXid() {
        return this.m_executionContext == null ? null : this.m_executionContext.getXid();
    }

    boolean isActive() {
        if (this.getXid() == null) {
            return false;
        }
        return m_executionManager.isActive(this.m_executionContext);
    }

    void setActive(boolean isActive) {
        if (this.getXid() == null) {
            return;
        }
        m_executionManager.setActive(this.m_executionContext, isActive);
    }

    void setup() throws WorkCompletedException {
        if (this.getXid() == null) {
            return;
        }
        m_executionManager.setup(this.m_executionContext, (int)this.getTransactionTimeout(), this);
    }

    void tearDown() throws WorkCompletedException {
        if (this.getXid() == null) {
            return;
        }
        m_executionManager.tearDown();
    }

    void rollback() throws XAException {
        if (this.getXid() == null) {
            return;
        }
        m_executionManager.setActive(this.m_executionContext, false);
        m_executionManager.rollback(this.m_executionContext);
    }

    void push() throws WorkCompletedException {
        m_executionManager.pushContext(this.m_executionContext);
    }

    void pop() throws WorkCompletedException {
        m_executionManager.popContext();
    }

    public void afterCompletion(int status) {
        if (m_logger.isLoggable(Level.FINEST)) {
            m_logger.finest("Thr[" + ThreadState.getCurrentState().toString() + "]-" + "ExecutionContextWrapper:afterCompletion status = " + status);
        }
        if (this.getXid() == null) {
            return;
        }
        m_executionManager.remove(this.m_executionContext);
    }

    public void beforeCompletion() {
    }
}

