/*
 * Decompiled with CFR 0.152.
 */
package oracle.j2ee.connector.work;

import com.evermind.server.ThreadState;
import com.evermind.server.connector.ApplicationConnectionManager;
import com.evermind.util.HashedByteArray;
import java.util.HashMap;
import java.util.Stack;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.resource.spi.XATerminator;
import javax.resource.spi.work.ExecutionContext;
import javax.resource.spi.work.WorkCompletedException;
import javax.transaction.Synchronization;
import javax.transaction.xa.XAException;
import javax.transaction.xa.Xid;
import oracle.as.j2ee.transaction.SubordinateTransactionManager;
import oracle.j2ee.connector.logging.JCATraceLogger;
import oracle.j2ee.connector.work.WorkManagerImpl;
import oracle.j2ee.connector.work.WorkTransactionState;

class ExecutionContextManager {
    private static Logger m_logger = JCATraceLogger.getLogger(ApplicationConnectionManager.class);
    private static final ExecutionContextManager INSTANCE = new ExecutionContextManager();
    private HashMap m_workTxStates = new HashMap();
    private SubordinateTransactionManager m_tm = null;
    private XATerminator m_xaTerminator = null;
    private ThreadLocal m_contextStack = new ThreadLocal();

    ExecutionContextManager() {
    }

    public static ExecutionContextManager getInstance() {
        if (ExecutionContextManager.INSTANCE.m_tm == null || ExecutionContextManager.INSTANCE.m_xaTerminator == null) {
            throw new IllegalStateException("Singleton instance has not been initialized.");
        }
        return INSTANCE;
    }

    static void initialize(SubordinateTransactionManager tm, XATerminator xaTerminator) {
        if (m_logger.isLoggable(Level.FINEST)) {
            m_logger.finest("Thr[" + ThreadState.getCurrentState().toString() + "]-" + "ExecutionContextManager:initialize tm = " + tm + " xaTerminator = " + xaTerminator);
        }
        if (tm == null) {
            throw new IllegalArgumentException("Transaction manager can't be null.");
        }
        if (xaTerminator == null) {
            throw new IllegalArgumentException("XATermintor can't be null.");
        }
        ExecutionContextManager.INSTANCE.m_tm = tm;
        ExecutionContextManager.INSTANCE.m_xaTerminator = xaTerminator;
    }

    synchronized boolean isActive(ExecutionContext context) {
        return this.isWorkTransactionActive(this.getXid(context));
    }

    synchronized void setActive(ExecutionContext context, boolean isActive) {
        if (m_logger.isLoggable(Level.FINEST)) {
            m_logger.finest("Thr[" + ThreadState.getCurrentState().toString() + "]-" + "ExecutionContextManager:setActive context = " + context + " isActive = " + isActive);
        }
        this.setWorkTransactionActive(this.getXid(context), isActive);
    }

    synchronized boolean isWorkTransactionActive(Xid xid) {
        if (xid == null) {
            return false;
        }
        WorkTransactionState txState = (WorkTransactionState)this.m_workTxStates.get(this.createKey(xid));
        if (txState != null) {
            return txState != WorkTransactionState.EXISTS;
        }
        return false;
    }

    synchronized void setWorkTransactionActive(Xid xid, boolean isActive) {
        if (m_logger.isLoggable(Level.FINEST)) {
            m_logger.finest("Thr[" + ThreadState.getCurrentState().toString() + "]-" + "ExecutionContextManager:setWorkTransactionActive xid = " + xid + " isActive = " + isActive);
        }
        if (xid == null) {
            return;
        }
        HashedByteArray hashedXid = this.createKey(xid);
        if (isActive) {
            if (this.m_workTxStates.containsKey(hashedXid)) {
                this.m_workTxStates.put(hashedXid, WorkTransactionState.ACTIVE);
            } else {
                this.m_workTxStates.put(hashedXid, WorkTransactionState.INITIAL);
            }
        } else {
            this.m_workTxStates.put(hashedXid, WorkTransactionState.EXISTS);
        }
    }

    synchronized void remove(ExecutionContext context) {
        Xid xid;
        if (m_logger.isLoggable(Level.FINEST)) {
            m_logger.finest("Thr[" + ThreadState.getCurrentState().toString() + "]-" + "ExecutionContextManager:remove context = " + context);
        }
        if ((xid = this.getXid(context)) != null) {
            this.m_workTxStates.remove(this.createKey(this.getXid(context)));
        }
    }

    synchronized boolean contains(ExecutionContext context) {
        Xid xid = this.getXid(context);
        if (xid == null) {
            return false;
        }
        return this.m_workTxStates.containsKey(this.createKey(this.getXid(context)));
    }

    void setup(ExecutionContext context, int transactionTimeout, Synchronization sync) throws WorkCompletedException {
        try {
            Xid xid = this.getXid(context);
            if (xid == null) {
                return;
            }
            WorkTransactionState txState = (WorkTransactionState)this.m_workTxStates.get(this.createKey(xid));
            if (txState != WorkTransactionState.INITIAL && txState != WorkTransactionState.ACTIVE) {
                throw new IllegalStateException("Setup called in illegal state: " + txState);
            }
            this.m_tm.importTransaction(xid, transactionTimeout, sync, null);
        }
        catch (Exception e) {
            WorkManagerImpl.log("Can't infect thread : caught " + e);
            WorkCompletedException wce = new WorkCompletedException("Can't infect thread.", (Throwable)e);
            wce.setErrorCode("3");
            throw wce;
        }
    }

    void tearDown() throws WorkCompletedException {
        try {
            this.m_tm.endInfection();
        }
        catch (Exception e) {
            WorkManagerImpl.log("Can't end infection : caught " + e);
            WorkCompletedException wce = new WorkCompletedException("Can't end infection: " + e, (Throwable)e);
            wce.setErrorCode("3");
            throw wce;
        }
    }

    void pushContext(ExecutionContext context) throws WorkCompletedException {
        if (m_logger.isLoggable(Level.FINEST)) {
            m_logger.finest("Thr[" + ThreadState.getCurrentState().toString() + "]-" + "ExecutionContextManager:pushContext context = " + context);
        }
        try {
            Stack stack = this.getContextStack();
            if (stack.size() > 0 && stack.peek() != null) {
                this.m_tm.endInfection();
            }
            stack.push(context);
        }
        catch (Exception e) {
            WorkManagerImpl.log("Can't push execution context : caught " + e);
            WorkCompletedException wce = new WorkCompletedException("Can't push execution context.", (Throwable)e);
            wce.setErrorCode("3");
            throw wce;
        }
    }

    void popContext() throws WorkCompletedException {
        if (m_logger.isLoggable(Level.FINEST)) {
            m_logger.finest("Thr[" + ThreadState.getCurrentState().toString() + "]-" + "ExecutionContextManager:popContext");
        }
        try {
            ExecutionContext suspendedContext;
            Xid xid;
            Stack stack = this.getContextStack();
            stack.pop();
            if (stack.size() > 0 && (xid = this.getXid(suspendedContext = (ExecutionContext)stack.peek())) != null) {
                this.m_tm.infectThread(xid, 0, null, true);
            }
        }
        catch (Exception e) {
            WorkManagerImpl.log("Can't pop execution context : caught " + e);
            WorkCompletedException wce = new WorkCompletedException("Can't pop execution context.", (Throwable)e);
            wce.setErrorCode("3");
            throw wce;
        }
    }

    void rollback(ExecutionContext context) throws XAException {
        if (m_logger.isLoggable(Level.FINEST)) {
            m_logger.finest("Thr[" + ThreadState.getCurrentState().toString() + "]-" + "ExecutionContextManager:rollback context = " + context);
        }
        this.m_xaTerminator.rollback(this.getXid(context));
    }

    private HashedByteArray createKey(Xid xid) {
        HashedByteArray hashedXid = new HashedByteArray(xid.getGlobalTransactionId());
        return hashedXid;
    }

    private Stack getContextStack() {
        Stack stack = (Stack)this.m_contextStack.get();
        if (stack == null) {
            stack = new Stack();
            this.m_contextStack.set(stack);
        }
        return stack;
    }

    private Xid getXid(ExecutionContext executionContext) {
        return executionContext == null ? null : executionContext.getXid();
    }
}

