/*
 * Decompiled with CFR 0.152.
 */
package oracle.j2ee.connector.proxy;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import oracle.j2ee.connector.proxy.AbstractProxy;
import oracle.j2ee.connector.proxy.BCELProxyBuilder;
import oracle.j2ee.connector.proxy.BCELProxyClassLoader;
import oracle.j2ee.connector.proxy.ProxyBuilder;
import oracle.j2ee.connector.proxy.ProxyFactory;
import org.apache.bcel.classfile.Attribute;
import org.apache.bcel.classfile.ConstantPool;
import org.apache.bcel.classfile.Field;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.generic.ClassGen;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.InstructionFactory;
import org.apache.bcel.generic.MethodGen;
import org.apache.bcel.generic.Type;

public class BCELProxyFactory
implements ProxyFactory {
    public static final int PROXY_RESULTS_NONE = 0;
    public static final int PROXY_RESULTS_SPECIFIED = 1;
    public static final int PROXY_RESULTS_SPECIFIED_AND_OBJECT = 2;
    public static final int PROXY_RESULTS_ALL = 3;
    protected BCELProxyClassLoader m_BCELProxyClassLoader = null;
    private Map m_proxyInterfaces;
    private Map m_getNoProxyResultMethods = new HashMap();
    private HashSet m_knownProxyTypes = new HashSet();
    private HashSet m_knownNonProxyTypes = new HashSet();
    private int m_proxyResults = 0;
    private Map m_proxyClassNames = new HashMap();
    private static final int JAVA_CAFE_BABE = -889275714;
    private Map m_proxySuperClassMap;
    private Class m_defaultProxySuperClassType;
    private Map m_proxyCloneableInstances = new HashMap();
    protected static final String PRE_INVOKE_METHOD_NAME_PREFIX = "preInvokeBCELProxy_";

    public BCELProxyFactory(BCELProxyClassLoader BCELProxyClassLoader2, Map proxyInterfaceMap, Map proxySuperClassMap, Class proxySuperClassType, int proxyResults) {
        this.m_BCELProxyClassLoader = BCELProxyClassLoader2;
        this.setProxyInterfaceMap(proxyInterfaceMap);
        this.setProxySuperClassMap(proxySuperClassMap);
        this.m_defaultProxySuperClassType = proxySuperClassType;
        this.m_proxyResults = proxyResults;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AbstractProxy getProxy(ProxyBuilder builder) throws InstantiationException {
        AbstractProxy cloneableInstance;
        Object target = builder.getTarget();
        if (target == null) {
            return null;
        }
        AbstractProxy proxy = null;
        Class<?> targetClass = target.getClass();
        Map map = this.m_proxyCloneableInstances;
        synchronized (map) {
            cloneableInstance = (AbstractProxy)this.m_proxyCloneableInstances.get(targetClass);
            if (cloneableInstance == null) {
                cloneableInstance = this.createProxy(this.getProxyClassName(targetClass), (BCELProxyBuilder)builder, targetClass, builder.getRequiredTypeClassName());
                this.m_proxyCloneableInstances.put(targetClass, cloneableInstance);
            }
        }
        proxy = builder.cloneProxy(cloneableInstance);
        proxy.oc4j_setFactory(this);
        return proxy;
    }

    public boolean isProxyType(Class type) {
        boolean retval = false;
        if (type == String.class || type.isPrimitive()) {
            return false;
        }
        if (this.m_knownNonProxyTypes.contains(type)) {
            return false;
        }
        if (this.m_knownProxyTypes.contains(type)) {
            return true;
        }
        boolean bl = retval = this.getProxySuperClass(type) != null;
        if (retval) {
            this.m_knownProxyTypes.add(type);
        } else {
            this.m_knownNonProxyTypes.add(type);
        }
        return retval;
    }

    public synchronized void setProxyInterfaceMap(Map interfaceMap) {
        if (interfaceMap != null) {
            this.getProxyInterfaceMap().putAll(interfaceMap);
        }
    }

    public synchronized void setProxyInterfaceMapping(Class key, Class[] proxyInterfaces) {
        this.getProxyInterfaceMap().put(key, proxyInterfaces);
    }

    public synchronized void setNoProxyResultMethods(Class superType, Set methods) {
        if (methods != null) {
            Iterator iterator = methods.iterator();
            while (iterator.hasNext()) {
                this.setNoProxyResultMethod(superType, (java.lang.reflect.Method)iterator.next());
            }
        }
    }

    public synchronized void setNoProxyResultMethod(Class superType, java.lang.reflect.Method method) {
        Set methods = this.getNoProxyResultMethods(superType);
        methods.add(method);
    }

    public void setDefaultProxySuperClassType(Class defaultProxySuperClassType) {
        this.m_defaultProxySuperClassType = defaultProxySuperClassType;
    }

    public synchronized void setProxySuperClassMap(Map superClassMap) {
        if (superClassMap != null) {
            this.getProxySuperClassMap().putAll(superClassMap);
        }
    }

    public synchronized void setProxySuperClassMapping(Class key, Class superType) {
        this.getProxySuperClassMap().put(key, superType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] getBytes(ClassGen cg) throws IOException {
        int[] interfaces = cg.getInterfaces();
        Field[] fields = cg.getFields();
        Method[] methods = cg.getMethods();
        Attribute[] attributes = cg.getAttributes();
        ConstantPool constant_pool = cg.getConstantPool().getFinalConstantPool();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            DataOutputStream outputStream = new DataOutputStream(byteArrayOutputStream);
            try {
                int i;
                outputStream.writeInt(-889275714);
                outputStream.writeShort(cg.getMinor());
                outputStream.writeShort(cg.getMajor());
                constant_pool.dump(outputStream);
                outputStream.writeShort(cg.getAccessFlags());
                outputStream.writeShort(cg.getClassNameIndex());
                outputStream.writeShort(cg.getSuperclassNameIndex());
                outputStream.writeShort(interfaces.length);
                for (i = 0; i < interfaces.length; ++i) {
                    outputStream.writeShort(interfaces[i]);
                }
                outputStream.writeShort(fields.length);
                for (i = 0; i < fields.length; ++i) {
                    fields[i].dump(outputStream);
                }
                outputStream.writeShort(methods.length);
                for (i = 0; i < methods.length; ++i) {
                    methods[i].dump(outputStream);
                }
                if (attributes != null) {
                    outputStream.writeShort(attributes.length);
                    for (i = 0; i < attributes.length; ++i) {
                        attributes[i].dump(outputStream);
                    }
                } else {
                    outputStream.writeShort(0);
                }
            }
            finally {
                outputStream.close();
            }
        }
        finally {
            byteArrayOutputStream.close();
        }
        return byteArrayOutputStream.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    protected AbstractProxy createProxy(String name, BCELProxyBuilder builder, Class targetClass, String requiredTypeClassName) throws InstantiationException {
        BCELProxyClassLoader bCELProxyClassLoader = this.m_BCELProxyClassLoader;
        synchronized (bCELProxyClassLoader) {
            void var6_6;
            Class cl;
            if (this.m_BCELProxyClassLoader.isClassDefined(name)) {
                cl = this.getProxyClass(name);
            } else {
                Class clazz = BCELProxyFactory.class;
                synchronized (clazz) {
                    try {
                        Class superClass = this.getProxySuperClass(targetClass);
                        Class[] interfaces = this.getTargetInterfacesForProxy(targetClass, requiredTypeClassName);
                        if (superClass == null) {
                            superClass = Object.class;
                        }
                        ClassGen classGen = new ClassGen(name, superClass.getName(), "", 1, this.getInterfaceNames(interfaces));
                        ConstantPoolGen constantPool = classGen.getConstantPool();
                        InstructionFactory instructionFactory = new InstructionFactory(classGen);
                        this.addConstructor(name, builder, superClass, constantPool, instructionFactory, classGen);
                        this.addMethods(name, builder, superClass, interfaces, constantPool, instructionFactory, classGen);
                        cl = BCELProxyFactory.defineClass(classGen, name, this.m_BCELProxyClassLoader);
                    }
                    catch (Exception e) {
                        InstantiationException ie = new InstantiationException(e.toString());
                        ie.initCause(e);
                        throw ie;
                    }
                }
            }
            return builder.instantiate((Class)var6_6);
        }
    }

    public static Class defineClass(ClassGen classGen, String name, BCELProxyClassLoader loader) throws IOException {
        byte[] bytes = BCELProxyFactory.getBytes(classGen);
        return loader.defineClass(name, bytes);
    }

    public BCELProxyClassLoader getBCELProxyClassLoader() {
        return this.m_BCELProxyClassLoader;
    }

    protected String getProxyClassName(Class targetClass) {
        StringBuffer name = (StringBuffer)this.m_proxyClassNames.get(targetClass);
        if (name == null) {
            name = new StringBuffer(targetClass.getName() + "_Proxy");
            for (int i = 0; i < name.length(); ++i) {
                if (Character.isJavaIdentifierPart(name.charAt(i))) continue;
                name.setCharAt(i, '_');
            }
            this.m_proxyClassNames.put(targetClass, name);
        }
        return name.toString();
    }

    protected Class getProxySuperClass(Class type) {
        Class superType = null;
        if (this.canTypeBeProxied(type) && (superType = this.getProxySuperClassFromMap(type)) == null) {
            superType = this.m_defaultProxySuperClassType;
        }
        return superType;
    }

    private Class getProxyClass(String name) throws InstantiationException {
        try {
            return this.m_BCELProxyClassLoader.loadClass(name);
        }
        catch (ClassNotFoundException e) {
            throw new InstantiationException(e.toString());
        }
    }

    private void addConstructor(String name, BCELProxyBuilder builder, Class superClass, ConstantPoolGen constantPool, InstructionFactory instructionFactory, ClassGen classGenerator) {
        MethodGen mg = builder.buildConstructor(name, superClass, constantPool, instructionFactory);
        mg.stripAttributes(true);
        mg.setMaxStack();
        mg.setMaxLocals();
        classGenerator.addMethod(mg.getMethod());
    }

    private void addMethods(String name, BCELProxyBuilder builder, Class superClass, Class[] interfaces, ConstantPoolGen constantPool, InstructionFactory instructionFactory, ClassGen classGenerator) {
        if (interfaces == null) {
            return;
        }
        for (int i = 0; i < interfaces.length; ++i) {
            this.addInterfaceMethods(name, builder, superClass, interfaces[i], constantPool, instructionFactory, classGenerator);
        }
    }

    private void addInterfaceMethods(String name, BCELProxyBuilder builder, Class superClass, Class intf, ConstantPoolGen constantPool, InstructionFactory instructionFactory, ClassGen classGenerator) {
        java.lang.reflect.Method[] methods = intf.getMethods();
        for (int i = 0; i < methods.length; ++i) {
            if (!this.shouldMethodBeAdded(superClass, methods[i]) || classGenerator.containsMethod(methods[i].getName(), Type.getSignature((java.lang.reflect.Method)methods[i])) != null) continue;
            boolean proxyResults = this.shouldProxyMethodResults(superClass, methods[i]);
            MethodGen mg = builder.buildMethod(name, intf, methods[i], constantPool, instructionFactory, proxyResults, this.getPreInvokeMethod(superClass, methods[i]));
            mg.stripAttributes(true);
            mg.setMaxStack();
            mg.setMaxLocals();
            classGenerator.addMethod(mg.getMethod());
        }
    }

    private java.lang.reflect.Method getPreInvokeMethod(Class superClass, java.lang.reflect.Method method) {
        try {
            return superClass.getMethod(PRE_INVOKE_METHOD_NAME_PREFIX + method.getName(), method.getParameterTypes());
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return null;
        }
    }

    private boolean shouldMethodBeAdded(Class superClass, java.lang.reflect.Method method) {
        try {
            java.lang.reflect.Method superMethod = superClass.getMethod(method.getName(), method.getParameterTypes());
            if ((superMethod.getModifiers() & 0x400) == 0) {
                return false;
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        return true;
    }

    private String[] getInterfaceNames(Class[] interfaces) {
        String[] interfaceNames = new String[interfaces.length];
        for (int i = 0; i < interfaces.length; ++i) {
            interfaceNames[i] = interfaces[i].getName();
        }
        return interfaceNames;
    }

    private boolean canTypeBeProxied(Class type) {
        Class[] interfaces = type.isInterface() ? new Class[]{type} : new InterfaceList(type).getInterfaces();
        for (int i = 0; i < interfaces.length; ++i) {
            if (interfaces[i].getMethods().length <= 0) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Class[] getTargetInterfacesForProxy(Class targetType, String requiredTypeClassName) throws ClassNotFoundException {
        if (this.m_proxyInterfaces == null) {
            return new InterfaceList(targetType).getInterfaces();
        }
        Class[] proxyInterfaces = null;
        Map map = this.m_proxyInterfaces;
        synchronized (map) {
            if (proxyInterfaces == null) {
                if (requiredTypeClassName != null) {
                    Class<?> requiredType = Class.forName(requiredTypeClassName);
                    proxyInterfaces = (Class[])this.m_proxyInterfaces.get(requiredType);
                }
                if (proxyInterfaces == null) {
                    proxyInterfaces = new InterfaceList(targetType).getInterfaces();
                }
            }
        }
        return proxyInterfaces;
    }

    private boolean shouldProxyMethodResults(Class superClass, java.lang.reflect.Method method) {
        Class<?> methodReturnType = method.getReturnType();
        switch (this.m_proxyResults) {
            case 0: {
                return false;
            }
            case 1: {
                if (this.getProxySuperClassFromMap(methodReturnType) != null) break;
                return false;
            }
            case 2: {
                if (methodReturnType == Object.class || this.getProxySuperClassFromMap(methodReturnType) != null) break;
                return false;
            }
        }
        Set noProxyResultMethods = this.getNoProxyResultMethods(superClass);
        if (noProxyResultMethods != null && noProxyResultMethods.contains(method)) {
            return false;
        }
        boolean shouldProxyMethodResults = false;
        shouldProxyMethodResults = methodReturnType == Object.class || methodReturnType.isInterface() && this.isProxyType(methodReturnType);
        return shouldProxyMethodResults;
    }

    private synchronized Set getNoProxyResultMethods(Class superType) {
        HashSet methods = (HashSet)this.m_getNoProxyResultMethods.get(superType);
        if (methods == null) {
            methods = new HashSet();
            this.m_getNoProxyResultMethods.put(superType, methods);
        }
        return methods;
    }

    private synchronized Map getProxyInterfaceMap() {
        if (this.m_proxyInterfaces == null) {
            this.m_proxyInterfaces = new HashMap();
        }
        return this.m_proxyInterfaces;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Class getProxySuperClassFromMap(Class type) {
        if (type == null || this.m_proxySuperClassMap == null) {
            return null;
        }
        Class proxySuperClass = null;
        Map map = this.m_proxySuperClassMap;
        synchronized (map) {
            proxySuperClass = (Class)this.m_proxySuperClassMap.get(type);
            if (proxySuperClass == null) {
                Iterator iterator = this.m_proxySuperClassMap.keySet().iterator();
                while (iterator.hasNext()) {
                    Class keyClass = (Class)iterator.next();
                    if (!keyClass.isInterface() || !keyClass.isAssignableFrom(type)) continue;
                    Class keyProxySuperClass = (Class)this.m_proxySuperClassMap.get(keyClass);
                    if (proxySuperClass != null && !proxySuperClass.isAssignableFrom(keyProxySuperClass)) continue;
                    proxySuperClass = keyProxySuperClass;
                }
                if (proxySuperClass != null) {
                    this.m_proxySuperClassMap.put(type, proxySuperClass);
                }
            }
        }
        return proxySuperClass;
    }

    private synchronized Map getProxySuperClassMap() {
        if (this.m_proxySuperClassMap == null) {
            this.m_proxySuperClassMap = new LinkedHashMap();
        }
        return this.m_proxySuperClassMap;
    }

    class InterfaceList {
        HashSet m_interfaces = new HashSet();

        public InterfaceList(Class type) {
            this.addInterfaces(type);
        }

        public void addInterfaces(Class type) {
            if (type == null) {
                return;
            }
            Class<?>[] proxyInterfaces = type.getInterfaces();
            for (int i = 0; i < proxyInterfaces.length; ++i) {
                Class<?> proxyInterface = proxyInterfaces[i];
                if (!Modifier.isPublic(proxyInterface.getModifiers())) continue;
                this.m_interfaces.add(proxyInterface);
            }
            this.addInterfaces(type.getSuperclass());
        }

        public Class[] getInterfaces() {
            Class[] interfaces = new Class[this.m_interfaces.size()];
            int i = 0;
            Iterator iterator = this.m_interfaces.iterator();
            while (iterator.hasNext()) {
                interfaces[i++] = (Class)iterator.next();
            }
            return interfaces;
        }
    }
}

