/*
 * Decompiled with CFR 0.152.
 */
package oracle.j2ee.connector.messageinflow;

import com.evermind.server.ThreadState;
import com.evermind.server.ejb.EJBUtils;
import com.evermind.server.ejb.InvocationContextPool;
import com.evermind.server.ejb.MessageDrivenContextImpl;
import com.evermind.server.ejb.MessageInflowArtifact;
import com.evermind.server.ejb.MessageInflowContract;
import com.evermind.server.ejb.interceptor.MethodState;
import java.lang.reflect.Method;
import javax.ejb.EJBException;
import javax.resource.spi.endpoint.MessageEndpoint;
import javax.transaction.xa.XAResource;
import oracle.j2ee.connector.logging.JCAMessageInflowMessages;
import oracle.j2ee.connector.messageinflow.ConcurrencyDisallowedException;
import oracle.j2ee.connector.messageinflow.MessageEndpointFactoryImpl;
import oracle.j2ee.connector.messageinflow.MessageEndpointReadyForServiceState;
import oracle.j2ee.connector.messageinflow.MessageEndpointReleasedState;
import oracle.j2ee.connector.messageinflow.MessageEndpointState;
import oracle.j2ee.connector.messageinflow.MessageEndpointWaitingForAfterDeliveryState;
import oracle.j2ee.connector.messageinflow.MessageEndpointWaitingForDeliveryState;

public class MessageEndpointImpl
implements MessageEndpoint {
    protected MessageInflowContract m_mdbHome;
    private MessageEndpointFactoryImpl m_factory;
    private XAResource m_xaRes;
    private MessageInflowArtifact mi_artifact;
    private Method m_currentMethod;
    private MessageEndpointState m_currentState;
    private MessageEndpointState m_readyState;
    private MessageEndpointState m_waitingForDeliveryState;
    private MessageEndpointState m_waitingForAfterDeliveryState;
    private MessageEndpointState m_releasedState;
    private Thread owner;
    private long m_deliverDMSToken;
    private Object ownerLock;

    public MessageEndpointImpl(MessageInflowContract mdbHome, XAResource res, MessageEndpointFactoryImpl factory) {
        this.m_mdbHome = mdbHome;
        this.m_factory = factory;
        this.mi_artifact = null;
        this.m_readyState = new MessageEndpointReadyForServiceState(this);
        this.m_waitingForDeliveryState = new MessageEndpointWaitingForDeliveryState(this);
        this.m_waitingForAfterDeliveryState = new MessageEndpointWaitingForAfterDeliveryState(this);
        this.m_releasedState = new MessageEndpointReleasedState(this);
        this.m_currentState = this.m_readyState;
        this.m_xaRes = res;
        this.m_currentMethod = null;
        this.owner = null;
        this.ownerLock = new Object();
        this.m_factory.endpointCreated();
    }

    void changeState(int state) {
        switch (state) {
            case 0: {
                this.m_currentState = this.m_readyState;
                return;
            }
            case 1: {
                this.m_currentState = this.m_waitingForDeliveryState;
                return;
            }
            case 2: {
                this.m_currentState = this.m_waitingForAfterDeliveryState;
                return;
            }
            case 3: {
                this.m_currentState = this.m_releasedState;
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setOwnership() throws ConcurrencyDisallowedException {
        Object object = this.ownerLock;
        synchronized (object) {
            this.checkOwnership();
            this.owner = Thread.currentThread();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void checkOwnership() throws ConcurrencyDisallowedException {
        Object object = this.ownerLock;
        synchronized (object) {
            if (this.hasOwner() && this.owner != Thread.currentThread()) {
                throw new ConcurrencyDisallowedException();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void releaseOwnership() throws ConcurrencyDisallowedException {
        Object object = this.ownerLock;
        synchronized (object) {
            this.checkOwnership();
            this.clearOwner();
        }
    }

    protected Method getMethod() {
        return this.m_currentMethod;
    }

    void setMethod(Method mthd) {
        this.m_currentMethod = mthd;
    }

    void setMessageInflowArtifact(MessageInflowArtifact artifact) {
        this.mi_artifact = artifact;
    }

    protected MessageInflowArtifact getMessageInflowArtifact() {
        return this.mi_artifact;
    }

    protected MessageInflowContract getMdbHome() {
        return this.m_mdbHome;
    }

    protected MessageEndpointFactoryImpl getFactory() {
        return this.m_factory;
    }

    public void beforeDelivery(Method mthd) {
        this.m_currentState.beforeDelivery(mthd, this.m_xaRes);
    }

    public void afterDelivery() {
        this.m_currentState.afterDelivery();
    }

    public void release() {
        if (this.m_currentState.equals(this.m_waitingForDeliveryState) || this.m_currentState.equals(this.m_waitingForAfterDeliveryState)) {
            JCAMessageInflowMessages.warningReleaseEndpointWithoutDeliveryCompletion();
        }
        this.changeState(3);
        this.m_factory.endpointReleased();
    }

    protected void startOfActualDelivery(Method mthd) {
        this.m_currentState.startOfActualDelivery(mthd, this.m_xaRes);
        this.m_deliverDMSToken = this.m_factory.messageDeliveryStarted();
    }

    protected void endOfActualDelivery() {
        this.m_currentState.endOfActualDelivery();
        this.m_factory.messageDeliveryEnded(this.m_deliverDMSToken);
    }

    private void clearOwner() {
        this.owner = null;
    }

    private boolean hasOwner() {
        return this.owner != null;
    }

    public void finalize() {
        this.m_factory.endpointReleased();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object OC4J_invokeMethod(MethodState methodState, Object[] methodParams, ThreadState thread) throws Exception {
        Object returnValue = null;
        try {
            this.getMdbHome().incrementActiveHandlers(1);
            this.startOfActualDelivery(methodState.getInterfaceMethod());
            this.getMdbHome().beforeInvocation(this.mi_artifact);
            MessageDrivenContextImpl ctx = this.mi_artifact.getMessageDrivenContext();
            Throwable listenerMethodEx = null;
            Throwable handledEx = null;
            try {
                returnValue = InvocationContextPool.invoke(thread, methodState, ctx.getBean(), ctx, methodParams, null, null);
                this.getFactory().updateSuccessfulDMSCount();
            }
            catch (Throwable t) {
                listenerMethodEx = t;
            }
            try {
                handledEx = this.getMdbHome().afterInvocation(this.mi_artifact, this.getMethod(), listenerMethodEx);
            }
            catch (Throwable t) {
                handledEx = t;
            }
            if (handledEx != null) {
                if (listenerMethodEx == handledEx) {
                    this.getFactory().updateAppExceptionDMSCount();
                } else {
                    this.getFactory().updateSysExceptionDMSCount();
                }
                throw (Exception)handledEx;
            }
            Object var10_10 = null;
        }
        catch (Throwable throwable) {
            Object var10_11 = null;
            try {
                this.endOfActualDelivery();
            }
            finally {
                this.getMdbHome().incrementActiveHandlers(-1);
            }
            throw throwable;
        }
        try {
            this.endOfActualDelivery();
        }
        finally {
            this.getMdbHome().incrementActiveHandlers(-1);
        }
        return returnValue;
    }

    protected void OC4J_startCall(ThreadState thread, boolean firstCallOnStack) {
    }

    protected void OC4J_endCall(ThreadState thread, boolean firstCallOnStack) {
    }

    protected void OC4J_handleUncheckedException(Throwable throwable) {
        if (throwable instanceof EJBException) {
            throw (EJBException)throwable;
        }
        throw EJBUtils.createEJBException(new Exception(throwable));
    }
}

