/*
 * Decompiled with CFR 0.152.
 */
package oracle.j2ee.connector.messageinflow;

import com.evermind.server.ApplicationServer;
import com.evermind.server.ejb.MessageInflowContract;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import javax.resource.spi.UnavailableException;
import javax.resource.spi.endpoint.MessageEndpoint;
import javax.resource.spi.endpoint.MessageEndpointFactory;
import javax.transaction.xa.XAResource;
import oracle.dms.instrument.EventIntf;
import oracle.dms.instrument.NounIntf;
import oracle.dms.instrument.PhaseEventIntf;
import oracle.dms.instrument.StateIntf;
import oracle.j2ee.connector.MessageEndpointFactoryAdminDetail;
import oracle.j2ee.connector.transaction.XAResourceWrapper;

public class MessageEndpointFactoryImpl
implements MessageEndpointFactory,
MessageEndpointFactoryAdminDetail {
    private Class m_mepType;
    private MessageInflowContract m_inflwSrvcPrvdr;
    private Constructor m_constr;
    boolean m_released = false;
    private NounIntf m_noun;
    private int m_numEndpoints = 0;
    private PhaseEventIntf m_msgDeliveryCountPhaseEvent;
    private EventIntf m_sucMsgDeliveryCountEvent;
    private EventIntf m_failedDeliveryCountEvent;
    private EventIntf m_systemExceptionCountEvent;
    private EventIntf m_appExceptionCountEvent;
    private StateIntf m_msgEndptCountState;
    private String m_raLocation;
    private String m_endpointName;

    public MessageEndpointFactoryImpl(Class messageEndpointType, MessageInflowContract inflwSrvcPrvdr, NounIntf mdbNoun, String raLocation, String endpointName) throws InstantiationException {
        this.m_mepType = messageEndpointType;
        this.m_inflwSrvcPrvdr = inflwSrvcPrvdr;
        this.m_noun = mdbNoun;
        this.m_raLocation = raLocation;
        this.m_endpointName = endpointName;
        try {
            this.m_constr = this.m_mepType.getConstructor(Class.forName("com.evermind.server.ejb.MessageInflowContract"), Class.forName("javax.transaction.xa.XAResource"), Class.forName("oracle.j2ee.connector.messageinflow.MessageEndpointFactoryImpl"));
            if (ApplicationServer.DMS_GATE && this.m_noun != null) {
                ApplicationServer.stateFactory().create(this.m_noun, "messageEndpointType", "Class name", "Message endpoint type", (Object)this.m_mepType.getName());
                this.m_msgEndptCountState = ApplicationServer.stateFactory().create(this.m_noun, "messageEndpointCount", "number of message endpoints", "number of message endpoints", 0);
                this.m_msgDeliveryCountPhaseEvent = ApplicationServer.phaseEventFactory().create(this.m_noun, "messageDelivery", "Message delivery attempts");
                this.m_msgDeliveryCountPhaseEvent.deriveMetric(46);
                this.m_sucMsgDeliveryCountEvent = ApplicationServer.eventFactory().create(this.m_noun, "successfulMessageDeliveryCount", "number of successful message deliveries");
                this.m_failedDeliveryCountEvent = ApplicationServer.eventFactory().create(this.m_noun, "failedMessageDeliveryCount", "number of failed message deliveries");
                this.m_systemExceptionCountEvent = ApplicationServer.eventFactory().create(this.m_noun, "systemExceptionCount", "number of SystemExceptions thrown");
                this.m_appExceptionCountEvent = ApplicationServer.eventFactory().create(this.m_noun, "applicationExceptionCount", "number of application exceptions thrown");
            }
        }
        catch (Exception e) {
            throw new InstantiationException("Unable to construct MessageEndpointFactory. " + e.getMessage());
        }
    }

    public MessageEndpoint createEndpoint(XAResource xares) throws UnavailableException {
        if (this.m_released) {
            throw new UnavailableException("The endpoint factory has been shut down.");
        }
        try {
            XAResourceWrapper xaresWrapper = null;
            if (xares != null) {
                xaresWrapper = new XAResourceWrapper(xares, this.m_raLocation, this.m_endpointName);
            }
            Object mep = this.m_constr.newInstance(this.m_inflwSrvcPrvdr, xaresWrapper, this);
            return (MessageEndpoint)mep;
        }
        catch (Exception e) {
            throw new UnavailableException("Unable to create endpoint." + e.getMessage());
        }
    }

    public boolean isDeliveryTransacted(Method mthd) throws NoSuchMethodException {
        return this.m_inflwSrvcPrvdr.isDeliveryTransacted(mthd);
    }

    public String getEndpointName() {
        return this.m_endpointName;
    }

    public void release() {
        this.m_released = true;
    }

    public boolean isReleased() {
        return this.m_released;
    }

    public void updateSuccessfulDMSCount() {
        if (ApplicationServer.DMS_GATE && this.m_sucMsgDeliveryCountEvent != null) {
            this.m_sucMsgDeliveryCountEvent.occurred();
        }
    }

    public void updateFailureDMSCount() {
        if (ApplicationServer.DMS_GATE && this.m_failedDeliveryCountEvent != null) {
            this.m_failedDeliveryCountEvent.occurred();
        }
    }

    public void updateSysExceptionDMSCount() {
        if (ApplicationServer.DMS_GATE) {
            if (this.m_systemExceptionCountEvent != null) {
                this.m_systemExceptionCountEvent.occurred();
            }
            this.updateFailureDMSCount();
        }
    }

    public void updateAppExceptionDMSCount() {
        if (ApplicationServer.DMS_GATE) {
            if (this.m_appExceptionCountEvent != null) {
                this.m_appExceptionCountEvent.occurred();
            }
            this.updateFailureDMSCount();
        }
    }

    public long messageDeliveryStarted() {
        if (ApplicationServer.DMS_GATE && this.m_msgDeliveryCountPhaseEvent != null) {
            return this.m_msgDeliveryCountPhaseEvent.start();
        }
        return 0L;
    }

    public void messageDeliveryEnded(long token) {
        if (ApplicationServer.DMS_GATE && this.m_msgDeliveryCountPhaseEvent != null) {
            this.m_msgDeliveryCountPhaseEvent.stop(token);
        }
    }

    public synchronized void endpointCreated() {
        if (ApplicationServer.DMS_GATE && this.m_msgEndptCountState != null) {
            this.m_msgEndptCountState.update(++this.m_numEndpoints);
        }
    }

    public synchronized void endpointReleased() {
        if (ApplicationServer.DMS_GATE && this.m_msgEndptCountState != null) {
            this.m_msgEndptCountState.update(--this.m_numEndpoints);
        }
    }

    public PhaseEventIntf getMsgDeliveryCountPhaseEvent() {
        return this.m_msgDeliveryCountPhaseEvent;
    }

    public EventIntf getSucMsgDeliveryCountEvent() {
        return this.m_sucMsgDeliveryCountEvent;
    }

    public EventIntf getFailedDeliveryCountEvent() {
        return this.m_failedDeliveryCountEvent;
    }

    public EventIntf getSystemExceptionCountEvent() {
        return this.m_systemExceptionCountEvent;
    }

    public StateIntf getMsgEndptCountState() {
        return this.m_msgEndptCountState;
    }

    public EventIntf getAppExceptionCountEvent() {
        return this.m_appExceptionCountEvent;
    }
}

