/*
 * Decompiled with CFR 0.152.
 */
package oracle.j2ee.clustering;

import com.evermind.server.cluster.ServerIdentification;
import com.oracle.jgroups.ChannelAdapter;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.j2ee.clustering.ChannelAdapterFactory;
import oracle.j2ee.clustering.ClusteringMessageDispatcher;
import oracle.j2ee.clustering.CustomMessage;
import oracle.j2ee.clustering.CustomMessageHandler;
import oracle.j2ee.clustering.MessageDispatchException;
import oracle.j2ee.util.TraceLogger;
import org.jgroups.Address;
import org.jgroups.ChannelClosedException;
import org.jgroups.ChannelNotConnectedException;
import org.jgroups.Message;
import org.jgroups.MessageListener;
import org.jgroups.stack.IpAddress;

public class JGroupsMessageDispatcher
implements ClusteringMessageDispatcher {
    private ChannelAdapterFactory m_adapterFactory = null;
    private static Logger m_logger = TraceLogger.getLogger(JGroupsMessageDispatcher.class);
    private Map m_mapOfCustomHandlersToListeners = new HashMap();

    public JGroupsMessageDispatcher(ChannelAdapterFactory adapterFactory) {
        this.m_adapterFactory = adapterFactory;
    }

    public void registerMessageHandler(String groupName, CustomMessageHandler handler) throws MessageDispatchException {
        ChannelAdapter adapter = this.m_adapterFactory.getChannelAdapter(groupName);
        if (adapter == null) {
            throw new MessageDispatchException("Unknown group specified");
        }
        CustomHandlerAdapter listener = new CustomHandlerAdapter(handler);
        adapter.addListener(listener);
        this.m_mapOfCustomHandlersToListeners.put(handler, listener);
    }

    public void unRegisterMessageHandler(String groupName, CustomMessageHandler handler) throws MessageDispatchException {
        ChannelAdapter adapter = this.m_adapterFactory.getChannelAdapter(groupName);
        if (adapter == null) {
            throw new MessageDispatchException("Unknown group specified");
        }
        MessageListener listenerToRemove = (MessageListener)this.m_mapOfCustomHandlersToListeners.remove(handler);
        adapter.removeListener(listenerToRemove);
    }

    public void publishMessage(String groupName, CustomMessage message) throws MessageDispatchException {
        ChannelAdapter adapter = this.m_adapterFactory.getChannelAdapter(groupName);
        try {
            if (adapter == null) {
                throw new MessageDispatchException("Cannot publish to unknown group");
            }
            adapter.send(null, message);
        }
        catch (ChannelNotConnectedException channelNotConnectedException) {
            throw new MessageDispatchException(channelNotConnectedException.getMessage(), channelNotConnectedException);
        }
        catch (ChannelClosedException channelClosedException) {
            throw new MessageDispatchException(channelClosedException.getMessage(), channelClosedException);
        }
    }

    public void closeGroup(String groupName) throws MessageDispatchException {
        ChannelAdapter adapter = this.m_adapterFactory.getChannelAdapter(groupName);
        if (adapter == null) {
            throw new MessageDispatchException("Cannot call close on unknown group");
        }
        adapter.stop();
    }

    public ServerIdentification[] getKnownPeers(String groupName) {
        ChannelAdapter adapter = this.m_adapterFactory.getChannelAdapter(groupName);
        if (adapter != null) {
            List membersOfView = adapter.getMembers();
            Iterator iterator = membersOfView.iterator();
            LinkedList<ServerIdentification> listOfServers = new LinkedList<ServerIdentification>();
            while (iterator.hasNext()) {
                Address address = (Address)iterator.next();
                if (!(address instanceof IpAddress)) continue;
                IpAddress ipAddress = (IpAddress)address;
                ServerIdentification server = new ServerIdentification(ipAddress.getIpAddress().getHostAddress(), ipAddress.getPort(), 0L);
                listOfServers.add(server);
            }
            if (listOfServers.size() > 0) {
                return this.buildArrayFromListOfServers(listOfServers);
            }
        } else if (m_logger.isLoggable(Level.FINEST)) {
            m_logger.finest("Channel adapter not found for name = " + groupName);
        }
        return new ServerIdentification[0];
    }

    private ServerIdentification[] buildArrayFromListOfServers(List listOfServers) {
        ServerIdentification[] arrayOfServers = new ServerIdentification[listOfServers.size()];
        Iterator serverIterator = listOfServers.iterator();
        int count = 0;
        while (serverIterator.hasNext()) {
            arrayOfServers[count] = (ServerIdentification)serverIterator.next();
            ++count;
        }
        return arrayOfServers;
    }

    private static class CustomHandlerAdapter
    implements MessageListener {
        private CustomMessageHandler m_msgHandler = null;

        public CustomHandlerAdapter(CustomMessageHandler handler) {
            this.m_msgHandler = handler;
        }

        public void receive(Message message) {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(message.getBuffer());
            try {
                ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream);
                Object receivedObj = objectInputStream.readObject();
                if (receivedObj instanceof CustomMessage) {
                    this.m_msgHandler.handleMessage((CustomMessage)receivedObj);
                }
            }
            catch (IOException ioException) {
                m_logger.log(Level.FINEST, ioException.getMessage(), ioException);
            }
            catch (ClassNotFoundException classNotFoundException) {
                m_logger.log(Level.FINEST, classNotFoundException.getMessage(), classNotFoundException);
            }
        }

        public byte[] getState() {
            return new byte[0];
        }

        public void setState(byte[] bytes) {
        }
    }
}

