/*
 * Decompiled with CFR 0.152.
 */
package oracle.ias.container.timer;

import com.evermind.security.User;
import com.evermind.server.ApplicationServer;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Date;
import java.util.logging.Logger;
import javax.ejb.EJBException;
import javax.ejb.NoSuchObjectLocalException;
import javax.ejb.TimerHandle;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import oracle.ias.container.logging.ContainerServiceTraceLogger;
import oracle.ias.container.timer.EJBTimerHandle;
import oracle.ias.container.timer.TimerCallbacks;
import oracle.ias.container.timer.TimerEntry;
import oracle.ias.container.timer.TimerService;
import oracle.ias.container.timer.internal.CronEntry;
import oracle.ias.container.timer.internal.TimeBasedEntry;

public class Timer
implements Synchronization,
Serializable,
oracle.oc4j.admin.management.shared.Timer {
    private static Logger m_logger = ContainerServiceTraceLogger.getTraceLogger(Timer.class);
    public static final int k_created = 0;
    public static final int k_scheduled = 1;
    public static final int k_delivered = 2;
    public static final int k_cancelled = 3;
    public static final int k_annulled = 4;
    protected int _state;
    protected int _prevState;
    private ClassLoader _classLoader;
    private long _containerId;
    private long _timerId;
    private TimerEntry _timerEntry;
    private boolean _registeredForTxn;
    public Object passivateLock;

    private void init() {
        this._timerEntry = null;
        this._timerId = TimerService.getNextTimerID();
        this._containerId = TimerService.getContainerID();
        this._state = 0;
        this._prevState = 0;
        this._registeredForTxn = false;
        this.passivateLock = new Object();
    }

    protected Timer() {
    }

    public Timer(TimerEntry entry, TimerCallbacks callbacks) {
        this.init();
        this._timerEntry = entry;
        entry.timer = this;
        if (callbacks != null) {
            callbacks.postInitTimer(this);
        }
    }

    public Object getPK() {
        return this._timerEntry.getPK();
    }

    public boolean isBeanCreated() {
        return this._timerEntry._isBeanCreated;
    }

    public int getBeanType() {
        return this._timerEntry._beanType;
    }

    public boolean isLocal() {
        return this._timerEntry._isLocal;
    }

    public void setBeanInfo(Object pk, boolean isBeanCreated, boolean isLocal, int beanType, boolean saveUser, User user) {
        this._timerEntry._pk = pk;
        this._timerEntry._isBeanCreated = isBeanCreated;
        this._timerEntry._isLocal = isLocal;
        this._timerEntry._beanType = beanType;
        this._timerEntry._saveCreator = saveUser;
        this._timerEntry._creator = user;
    }

    public boolean savedCreator() {
        return this._timerEntry._saveCreator;
    }

    public User getCreator() {
        return this._timerEntry.getCreator();
    }

    public void beforeCompletion() {
        m_logger.finest("beforeCompletion " + this);
    }

    public void afterCompletion(int status) {
        m_logger.finest("afterCompletion " + this + " status " + status);
        if (status == 3) {
            this.commitTimerOperation();
        } else {
            this.rollbackTimerOperation();
        }
        this._registeredForTxn = false;
    }

    private void commitTimerOperation() {
        if (this._state == 0) {
            this.setState(1);
            TimerService.instance().writePersistentStore(this);
        }
        if (this._state == 3) {
            this.setState(4);
            TimerService.instance().rmTimer(this);
            TimerService.instance().rmPersistentStore(this);
        }
    }

    private void rollbackTimerOperation() {
        if (this._state == 0) {
            this.setState(4);
            TimerService.instance().rmTimer(this);
        }
        if (this._state == 3) {
            this.setState(this.getPrevState());
        }
    }

    public void registerForTxn() {
        if (this.isBeanCreated()) {
            try {
                Transaction tx = ApplicationServer.getInstance().getTransactionManager().getTransaction();
                if (tx != null && !this._registeredForTxn) {
                    tx.registerSynchronization((Synchronization)this);
                    this._registeredForTxn = true;
                }
            }
            catch (Exception e) {
                m_logger.finest(e.getMessage());
            }
        }
    }

    public long getTimerId() {
        return this._timerId;
    }

    public void setTimerId(long timerId) {
        this._timerId = timerId;
    }

    private String getStateAsString() {
        switch (this._state) {
            case 0: {
                return "k_created";
            }
            case 1: {
                return "k_scheduled";
            }
            case 2: {
                return "k_delivered";
            }
            case 3: {
                return "k_cancelled";
            }
            case 4: {
                return "k_annulled";
            }
        }
        return "_state NOT FOUND";
    }

    public int getPrevState() {
        return this._prevState;
    }

    public int getState() {
        return this._state;
    }

    public void setState(int s) {
        this._prevState = this._state;
        this._state = s;
    }

    public ClassLoader getClassLoader() {
        return this._classLoader;
    }

    public long getContainerId() {
        return this._containerId;
    }

    public void setContainerId(long containerId) {
        this._containerId = containerId;
    }

    public String getApplicationId() {
        return this._timerEntry.getApplication();
    }

    public boolean isActive() {
        return this._state == 1;
    }

    public boolean isCancelled() {
        return this._state == 3;
    }

    public long getTimeRemaining() throws IllegalStateException, NoSuchObjectLocalException {
        this.checkActiveState();
        return this._timerEntry.getTimeRemaining();
    }

    public Date getNextTimeout() throws IllegalStateException, NoSuchObjectLocalException {
        this.checkActiveState();
        return this._timerEntry.getNextTimeout();
    }

    public Serializable getInfo() throws IllegalStateException, NoSuchObjectLocalException {
        this.checkActiveState();
        return this._timerEntry.getInfo();
    }

    public Date getLastExecutionTime() {
        return new Date(this._timerEntry.getLastExecution());
    }

    public void cancel() throws IllegalStateException, NoSuchObjectLocalException {
        this.checkActiveState();
        try {
            if (ApplicationServer.getInstance().getTransactionManager().getTransaction() == null) {
                this.setState(4);
                TimerService.instance().rmTimer(this);
                TimerService.instance().rmPersistentStore(this);
            } else {
                this.setState(3);
                this.registerForTxn();
            }
        }
        catch (SystemException systemException) {
            // empty catch block
        }
    }

    public TimerHandle getHandle() throws IllegalStateException, NoSuchObjectLocalException, EJBException {
        this.checkActiveState();
        return new EJBTimerHandle(this);
    }

    protected void checkActiveState() throws NoSuchObjectLocalException {
        if (this._state == 2) {
            m_logger.finest("Timer has been delivered");
            throw new NoSuchObjectLocalException("Timer has been delivered");
        }
        if (this._state == 4) {
            m_logger.finest("Timer has been delivered");
            throw new NoSuchObjectLocalException("Timer has been annulled");
        }
    }

    public TimerEntry getTimerEntry() {
        return this._timerEntry;
    }

    public boolean equals(Object obj) {
        boolean retValue = false;
        if (obj instanceof Timer) {
            Timer t = (Timer)obj;
            try {
                this.checkActiveState();
                retValue = this._containerId == t.getContainerId() && this._timerId == t.getTimerId();
            }
            catch (Exception e) {
                retValue = false;
            }
        }
        return retValue;
    }

    public String toString() {
        String _str = "ContainerId: " + this._containerId + " TimerId: " + this._timerId;
        _str = _str + " LastExecutionTime: " + this.getLastExecutionTime();
        _str = _str + " NextTimeOut: " + this.getNextTimeout();
        return _str;
    }

    public int hashCode() {
        int result = this._state;
        result = 29 * result + (int)(this._containerId ^ this._containerId >>> 32);
        result = 29 * result + (int)(this._timerId ^ this._timerId >>> 32);
        result = 29 * result + this._timerEntry.hashCode();
        return result;
    }

    private void readObject(ObjectInputStream in) throws ClassNotFoundException, IOException {
        this.init();
        this._timerId = in.readLong();
        this._state = in.readInt();
        boolean isCron = in.readBoolean();
        this._timerEntry = isCron ? new CronEntry() : new TimeBasedEntry();
        boolean hasTimeEntry = in.readBoolean();
        if (hasTimeEntry) {
            this._timerEntry.readEntry(in);
            this._timerEntry.timer = this;
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeLong(this._timerId);
        out.writeInt(this._state);
        if (this._timerEntry instanceof CronEntry) {
            out.writeBoolean(true);
        } else {
            out.writeBoolean(false);
        }
        if (this._timerEntry != null) {
            out.writeBoolean(true);
            this._timerEntry.writeEntry(out);
        } else {
            out.writeBoolean(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void passivate() {
        Object object = this.passivateLock;
        synchronized (object) {
            this._timerEntry.passivate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void activate() {
        Object object = this.passivateLock;
        synchronized (object) {
            this._timerEntry.activate();
        }
    }

    public boolean isPassivated() {
        return this._timerEntry.isPassivated();
    }

    public void setIsScheduled(boolean state) {
        this._timerEntry.setIsScheduled(state);
    }

    public boolean isScheduled() {
        return this._timerEntry.isScheduled();
    }
}

