/*
 * Decompiled with CFR 0.152.
 */
package oracle.ias.container.scheduler;

import [Ljava.lang.String;;
import com.evermind.security.User;
import com.evermind.server.Application;
import com.evermind.server.ThreadState;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.ias.container.logging.ContainerServiceMessages;
import oracle.ias.container.logging.ContainerServiceTraceLogger;
import oracle.ias.container.scheduler.Task;
import oracle.ias.container.timer.Timer;
import oracle.ias.container.timer.TimerEntry;
import oracle.ias.container.timer.TimerEvent;
import oracle.ias.container.timer.TimerService;

public class TimerTask
extends Task {
    private static TimerService _timerService = TimerService.instance();
    private static Logger m_logger = ContainerServiceTraceLogger.getTraceLogger(TimerTask.class);

    public TimerTask(TimerEvent timerEvent) {
        super(timerEvent);
        timerEvent.setRunnable(this);
        this._event = timerEvent;
        Timer timer = timerEvent.getTimer();
        m_logger.finest("classRef: " + timer.getTimerEntry().getFullClassName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runBeanTimer(Timer timer, TimerAppInfo info) {
        if (timer.getBeanType() == 1) {
            RuntimeException anException = new RuntimeException("TimerTask.run() - Only Entity/StatelessSession/MessageDriven beans can use Timers!!");
            ContainerServiceMessages.warningException(anException);
            m_logger.finest(anException.getMessage());
            throw anException;
        }
        ThreadState state = ThreadState.getCurrentState();
        int timerStatus = 2;
        try {
            User prevUser = null;
            if (!info.isRunning()) {
                return;
            }
            state.contextContainer = info.getApplication();
            try {
                prevUser = state.user;
                if (timer.savedCreator()) {
                    state.user = timer.getCreator();
                }
                info.invokeTimer(timer);
                timerStatus = 2;
            }
            finally {
                state.user = prevUser;
            }
        }
        catch (Exception e) {
            timerStatus = 4;
            m_logger.log(Level.FINEST, e.getMessage(), e);
        }
        finally {
            this.checkBeanTimer(timer, timerStatus);
            state.reset();
        }
    }

    private void checkBeanTimer(Timer timer, int status) {
        try {
            timer.getTimerEntry().execute();
            if (timer.getTimerEntry().repeats()) {
                if (timer.getState() == 1) {
                    _timerService.writePersistentStore(timer);
                }
            } else {
                timer.setState(status);
                _timerService.rmTimer(timer);
                _timerService.rmPersistentStore(timer);
            }
        }
        catch (Exception e) {
            m_logger.log(Level.FINEST, e.getMessage(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runJavaClientTimer(Timer timer, String className) {
        int timerStatus = 2;
        try {
            Class<?> cl = Class.forName(className);
            Class[] argTypes = new Class[]{String;.class};
            TimerEntry entry = timer.getTimerEntry();
            Serializable ser = entry.getInfo();
            Object[] arg = new Object[]{(String[])ser};
            if (ser != null) {
                Object[] args = new Object[]{(String[])ser};
                arg = args;
            }
            try {
                Method main = cl.getMethod("main", argTypes);
                main.invoke(null, arg);
            }
            catch (NoSuchMethodException e) {
                Runnable runMe = null;
                try {
                    Constructor<?> con = cl.getConstructor(argTypes);
                    runMe = (Runnable)con.newInstance(arg);
                }
                catch (NoSuchMethodException e2) {
                    runMe = (Runnable)cl.newInstance();
                }
                if (runMe != null) {
                    runMe.run();
                }
            }
        }
        catch (Exception e) {
            m_logger.log(Level.FINEST, e.getMessage(), e);
            timerStatus = 4;
        }
        finally {
            this.checkBeanTimer(timer, timerStatus);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        Timer timer;
        block15: {
            block14: {
                timer = ((TimerEvent)this._event).getTimer();
                String className = null;
                try {
                    block13: {
                        try {
                            this._event.setState(3, true);
                            if (!timer.isActive()) {
                                Object var8_3 = null;
                                break block13;
                            }
                            TimerEntry entry = timer.getTimerEntry();
                            className = entry != null ? entry.getFullClassName() : null;
                            TimerAppInfo info = className != null && timer.isBeanCreated() ? new TimerAppInfo(_timerService, className) : null;
                            Object object = timer.passivateLock;
                            synchronized (object) {
                                if (timer.isPassivated()) {
                                    timer.getTimerEntry().rewindLastScheduled();
                                    // MONITOREXIT @DISABLED, blocks:[0, 1, 4, 11] lbl18 : MonitorExitStatement: MONITOREXIT : var5_13
                                    break block14;
                                }
                                if (timer.isBeanCreated()) {
                                    this.runBeanTimer(timer, info);
                                } else {
                                    this.runJavaClientTimer(timer, className);
                                }
                                break block15;
                            }
                        }
                        catch (NoSuchElementException e) {
                            RuntimeException anException = new RuntimeException("TimerTask.run() Invalid className: (" + className + ")format" + e);
                            ContainerServiceMessages.warningException(anException);
                            m_logger.finest(anException.getMessage());
                            throw anException;
                        }
                        catch (Throwable t) {
                            RuntimeException anException = new RuntimeException(t);
                            ContainerServiceMessages.warningException(anException);
                            m_logger.finest(anException.getMessage());
                            throw anException;
                        }
                    }
                    this._event.setState(4, true);
                }
                catch (Throwable throwable) {
                    Object var8_6 = null;
                    this._event.setState(4, true);
                    timer.getTimerEntry().reSchedule();
                    throw throwable;
                }
                timer.getTimerEntry().reSchedule();
                return;
            }
            Object var8_4 = null;
            this._event.setState(4, true);
            timer.getTimerEntry().reSchedule();
            return;
        }
        Object var8_5 = null;
        this._event.setState(4, true);
        timer.getTimerEntry().reSchedule();
    }

    public void init() {
        Timer timer = ((TimerEvent)this._event).getTimer();
        String className = timer.getTimerEntry().getFullClassName();
        if (className == null) {
            RuntimeException anException = new RuntimeException("No class specified for timer " + timer);
            ContainerServiceMessages.warningException(anException);
            m_logger.finest(anException.getMessage());
            throw anException;
        }
        this._task = this;
    }

    private static class TimerAppInfo {
        private String _appName;
        private String _jarName;
        private String _beanName;
        private Application _application;
        private boolean _appRunning;

        public TimerAppInfo(TimerService service, String className) throws NoSuchElementException, InstantiationException {
            StringTokenizer st = new StringTokenizer(className, "|");
            this._appName = st.nextToken();
            this._jarName = st.nextToken();
            this._beanName = st.nextToken();
            this._application = service.getAppServer().getApplication(this._appName);
            this._appRunning = this._application != null && this._application.getstate() == 1;
        }

        Application getApplication() {
            return this._application;
        }

        boolean isRunning() {
            return this._appRunning;
        }

        void invokeTimer(Timer timer) throws Exception {
            if (this._appRunning) {
                this._application.getEJBContainer().invokeTimer(this._jarName, this._beanName, timer);
            }
        }
    }
}

