/*
 * Decompiled with CFR 0.152.
 */
package oracle.ias.container.event;

import EDU.oswego.cs.dl.util.concurrent.ReentrantLock;
import EDU.oswego.cs.dl.util.concurrent.Sync;
import EDU.oswego.cs.dl.util.concurrent.SyncSet;
import EDU.oswego.cs.dl.util.concurrent.WriterPreferenceReadWriteLock;
import com.evermind.util.ServicesProperties;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.ias.container.ContainerService;
import oracle.ias.container.event.Event;
import oracle.ias.container.event.Filter;
import oracle.ias.container.event.InvalidEventTypeException;
import oracle.ias.container.event.Publisher;
import oracle.ias.container.event.PullPublisher;
import oracle.ias.container.event.PullSubscriber;
import oracle.ias.container.event.PushSubscriber;
import oracle.ias.container.event.Subscriber;
import oracle.ias.container.event.Subscription;
import oracle.j2ee.util.TraceLogger;

public class EventService
extends ContainerService {
    private ArrayList m_subscriptions = null;
    private Class m_eventClass = null;
    private SyncSet m_eventsQueue = null;
    private WriterPreferenceReadWriteLock m_subscriptionLock;
    private Object m_publishersLock = new Object();
    private LinkedList m_pullPublishers = null;
    private LinkedList m_pushPublishers;
    public static int k_eventServiceId = 1401;
    private static Logger m_logger = TraceLogger.getLogger(EventService.class);
    private static EventService _instance = null;
    private static int m_id = 0;
    static /* synthetic */ Class class$oracle$ias$container$event$NullFilter;

    private EventService() {
        super("Event Service");
        _instance = this;
        try {
            this.m_eventClass = Class.forName("oracle.ias.container.event.Event");
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        this.m_subscriptionLock = new WriterPreferenceReadWriteLock();
        this.m_subscriptions = new ArrayList();
        this.m_eventsQueue = new SyncSet(new HashSet(), (Sync)new ReentrantLock(), (Sync)new ReentrantLock());
        this.m_serviceId = k_eventServiceId;
    }

    public static EventService instance() {
        if (_instance == null) {
            _instance = new EventService();
        }
        return _instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doPublisherPull() {
        if (this.m_pullPublishers == null) {
            return;
        }
        Object object = this.m_publishersLock;
        synchronized (object) {
            Iterator iter = this.m_pullPublishers.iterator();
            while (iter.hasNext()) {
                PullPublisher publisher = (PullPublisher)iter.next();
                LinkedList events = publisher.pullEvents();
                SyncSet syncSet = this.m_eventsQueue;
                synchronized (syncSet) {
                    this.m_eventsQueue.addAll((Collection)events);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doSubscriberPush() {
        Event[] events = null;
        SyncSet syncSet = this.m_eventsQueue;
        synchronized (syncSet) {
            events = (Event[])this.m_eventsQueue.toArray(new Event[0]);
            this.m_eventsQueue.clear();
        }
        try {
            for (int i = 0; i < events.length; ++i) {
                Event event = events[i];
                this.inform(event);
            }
        }
        catch (ConcurrentModificationException e) {
            System.err.println("ConcurrentModificationException " + e.getMessage());
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean push(Event[] events) {
        try {
            SyncSet syncSet = this.m_eventsQueue;
            synchronized (syncSet) {
                this.m_eventsQueue.addAll(Arrays.asList(events));
            }
            this.wake();
            return true;
        }
        catch (UnsupportedOperationException e) {
            if (ServicesProperties.getContainerServiceDebug()) {
                m_logger.log(Level.WARNING, "This is an expected exception that can occur during shutdown");
                e.printStackTrace();
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean push(Event event) {
        try {
            SyncSet syncSet = this.m_eventsQueue;
            synchronized (syncSet) {
                this.m_eventsQueue.add(event);
            }
            this.wake();
            return true;
        }
        catch (UnsupportedOperationException e) {
            if (ServicesProperties.getContainerServiceDebug()) {
                m_logger.log(Level.WARNING, "This is an expected exception that can occur during shutdown");
                e.printStackTrace();
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean inform(Event event) {
        try {
            this.m_subscriptionLock.readLock().acquire();
            Iterator subscriptionIter = this.m_subscriptions.iterator();
            event.touch();
            while (subscriptionIter.hasNext()) {
                Subscription subscription = (Subscription)subscriptionIter.next();
                if (!subscription.eventType.isAssignableFrom(event.getClass()) || subscription.filter != null && subscription.filter.getClass() != (class$oracle$ias$container$event$NullFilter == null ? EventService.class$("oracle.ias.container.event.NullFilter") : class$oracle$ias$container$event$NullFilter) && !subscription.filter.apply(event)) continue;
                if (subscription.subscriber instanceof PushSubscriber) {
                    ((PushSubscriber)subscription.subscriber).inform(event);
                    continue;
                }
                subscription.queue(event);
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        finally {
            this.m_subscriptionLock.readLock().release();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void subscribe(Class eventType, Filter filter, Subscriber subscriber) throws InvalidEventTypeException {
        if (!this.m_eventClass.isAssignableFrom(eventType)) {
            throw new InvalidEventTypeException();
        }
        Subscription subscription = new Subscription(eventType, filter, subscriber);
        try {
            this.m_subscriptionLock.writeLock().acquire();
            if (!this.m_subscriptions.contains(subscription)) {
                this.m_subscriptions.add(subscription);
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        finally {
            this.m_subscriptionLock.writeLock().release();
            this.wake();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unsubscribe(Class eventType, Filter filter, Subscriber subscriber) throws InvalidEventTypeException {
        if (!this.m_eventClass.isAssignableFrom(eventType)) {
            throw new InvalidEventTypeException();
        }
        Subscription sub = new Subscription(eventType, filter, subscriber);
        try {
            this.m_subscriptionLock.writeLock().acquire();
            int index = this.m_subscriptions.indexOf(sub);
            if (index != -1) {
                sub = (Subscription)this.m_subscriptions.get(index);
                sub.deactivate();
                this.m_subscriptions.remove(sub);
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        finally {
            this.m_subscriptionLock.writeLock().release();
            this.wake();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ArrayList getSubscriptions(Subscriber subscriber) {
        ArrayList<Subscription> list = new ArrayList<Subscription>();
        try {
            this.m_subscriptionLock.readLock().acquire();
            Iterator iter = this.m_subscriptions.iterator();
            while (iter.hasNext()) {
                Subscription subscription = (Subscription)iter.next();
                if (!subscription.subscriber.equals(subscriber)) continue;
                list.add(subscription);
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        finally {
            this.m_subscriptionLock.readLock().release();
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unsubscribe(Subscription subscription) {
        try {
            this.m_subscriptionLock.writeLock().acquire();
            this.m_subscriptions.remove(subscription);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        finally {
            this.m_subscriptionLock.writeLock().release();
            this.wake();
        }
    }

    public Event pull(PullSubscriber pullSubscriber) {
        Subscription sub;
        ArrayList subs = this.getSubscriptions(pullSubscriber);
        Event event = null;
        for (int i = 0; !(i >= subs.size() || (sub = (Subscription)subs.get(i)).isActive() && (event = sub.deQueue()) != null); ++i) {
        }
        this.wake();
        return event;
    }

    public ArrayList pullAll(PullSubscriber pullSubscriber) {
        ArrayList subs = this.getSubscriptions(pullSubscriber);
        ArrayList events = null;
        Iterator iter = subs.iterator();
        while (iter.hasNext()) {
            ArrayList subEvents;
            Object obj = iter.next();
            Subscription sub = (Subscription)obj;
            if (!sub.isActive() || (subEvents = sub.deQueueAll()) == null) continue;
            if (events == null) {
                events = new ArrayList(subEvents.size());
            }
            events.addAll(subEvents);
        }
        this.wake();
        return events;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean register(Publisher publisher) {
        Object object = this.m_publishersLock;
        synchronized (object) {
            if (publisher instanceof PullPublisher) {
                if (this.m_pullPublishers == null) {
                    this.m_pullPublishers = new LinkedList();
                }
                if (!this.m_pullPublishers.contains(publisher)) {
                    this.m_pullPublishers.addLast(publisher);
                }
            } else {
                if (this.m_pushPublishers == null) {
                    this.m_pushPublishers = new LinkedList();
                    this.m_pushPublishers.addLast(publisher);
                }
                if (!this.m_pushPublishers.contains(publisher)) {
                    this.m_pushPublishers.addLast(publisher);
                }
            }
        }
        this.wake();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean unregister(Publisher publisher) {
        boolean retCode = false;
        if (publisher instanceof PullPublisher) {
            Object object = this.m_publishersLock;
            synchronized (object) {
                if (this.m_pullPublishers != null && !this.m_pullPublishers.contains(publisher)) {
                    retCode = this.m_pullPublishers.remove(publisher);
                }
            }
        }
        Object object = this.m_publishersLock;
        synchronized (object) {
            if (this.m_pushPublishers != null && !this.m_pushPublishers.contains(publisher)) {
                retCode = this.m_pushPublishers.remove(publisher);
            }
        }
        this.wake();
        return retCode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection getEventTypes() {
        ArrayList<Class> list = null;
        try {
            this.m_subscriptionLock.readLock().acquire();
            list = new ArrayList<Class>(this.m_subscriptions.size());
            Iterator iter = this.m_subscriptions.iterator();
            while (iter.hasNext()) {
                Subscription subscription = (Subscription)iter.next();
                if (list.contains(subscription.eventType)) continue;
                list.add(subscription.eventType);
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        finally {
            this.m_subscriptionLock.readLock().release();
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection getFilters() {
        ArrayList<Filter> list = null;
        try {
            this.m_subscriptionLock.readLock().acquire();
            list = new ArrayList<Filter>(this.m_subscriptions.size());
            Iterator iter = this.m_subscriptions.iterator();
            while (iter.hasNext()) {
                Subscription subscription = (Subscription)iter.next();
                if (list.contains(subscription.filter)) continue;
                list.add(subscription.filter);
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        finally {
            this.m_subscriptionLock.readLock().release();
        }
        return list;
    }

    public boolean initialize() {
        this.m_status = 0;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean shutdown() {
        block10: {
            try {
                this.m_subscriptionLock.writeLock().acquire();
                this.m_subscriptions.clear();
                if (this.m_pullPublishers == null) break block10;
                Object object = this.m_publishersLock;
                synchronized (object) {
                    if (this.m_pullPublishers != null) {
                        this.m_pullPublishers.clear();
                    }
                    if (this.m_pushPublishers != null) {
                        this.m_pushPublishers.clear();
                    }
                }
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            finally {
                this.m_subscriptionLock.writeLock().release();
            }
        }
        return super.shutdown();
    }

    public void doRun() throws InterruptedException {
        this.doPublisherPull();
        this.doSubscriberPush();
        this.doPublisherInform();
        if (this.m_pullPublishers == null && this.queueIsEmpty()) {
            this.sleep(Integer.MAX_VALUE);
        } else {
            this.sleep(this._defaultInterval);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean queueIsEmpty() {
        SyncSet syncSet = this.m_eventsQueue;
        synchronized (syncSet) {
            return this.m_eventsQueue.isEmpty();
        }
    }

    private void doPublisherInform() {
    }

    public void doStop() throws InterruptedException {
        if (ServicesProperties.getContainerServiceDebug()) {
            System.out.println("doStop " + this);
        }
    }

    public void doPause() throws InterruptedException {
        if (ServicesProperties.getContainerServiceDebug()) {
            System.out.println("doPause " + this);
        }
        this.sleep(this._defaultInterval);
    }

    public synchronized int getNewId() {
        return m_id++;
    }
}

