/*
 * Decompiled with CFR 0.152.
 */
package oracle.as.j2ee.transaction.tpc.recovery;

import com.evermind.server.ApplicationServerTransactionManager;
import com.evermind.server.RecoverableSinglePhaseResource;
import com.evermind.server.SubordinateXAResourceImpl;
import com.evermind.server.TwoPhaseCommitProvider;
import com.evermind.server.WrappedXAResource;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import oracle.as.j2ee.transaction.tpc.Branch;
import oracle.as.j2ee.transaction.tpc.Coordinator;
import oracle.as.j2ee.transaction.tpc.GlobalTransaction;
import oracle.as.j2ee.transaction.tpc.NormalXid;
import oracle.as.j2ee.transaction.tpc.ProtocolError;
import oracle.as.j2ee.transaction.tpc.RMFactoryJndiLocation;
import oracle.as.j2ee.transaction.tpc.RMId;
import oracle.as.j2ee.transaction.tpc.RecoveredRMId;
import oracle.as.j2ee.transaction.tpc.ResourceManagerFactory;
import oracle.as.j2ee.transaction.tpc.TPCException;
import oracle.as.j2ee.transaction.tpc.TwoPhaseCommitEngine;
import oracle.as.j2ee.transaction.tpc.recovery.RecoveringTransaction;
import oracle.as.j2ee.transaction.tpc.recovery.RecoveryManager;
import oracle.as.j2ee.transaction.tpc.recovery.RecoveryManagerAdmin;
import oracle.as.j2ee.transaction.tpc.recovery.RecoveryManagerAdminImpl;
import oracle.j2ee.transaction.TransactionMessages;
import oracle.j2ee.transaction.recovery.RecoveryAbandonmentDetail;

public class RecoveryManagerPresumedAbort
implements RecoveryManager {
    private static HashMap m_resourceManagerFactoryMap = new HashMap();
    HashMap m_locationToXAResourceMap = new HashMap();
    private final Object m_cancellationLock = new Object();
    private boolean m_cancelled;
    private boolean m_isServerInitialized = false;
    private long m_sleepTime = 300000L;
    private Set m_recoveringTransactions = new HashSet();
    private Set m_partiallyReconstructedTransactions = new HashSet();
    private Map m_rmidLocationToXidSetPresumedAbortMap = new HashMap();
    private Map m_committedTidToRLRCNameMap = new HashMap();
    private Map m_rlrcNameToXAResourcesSetMap = new HashMap();
    private Set m_unacquiredResourceRMIdsSet = new HashSet();
    private RecoveryManagerAdmin m_recoveryAdminImpl = new RecoveryManagerAdminImpl(this);

    public RecoveryManagerPresumedAbort(int recoveryRetryInterval, RecoveryAbandonmentDetail[] recoveryAbandonmentDetails) {
        this.m_sleepTime = recoveryRetryInterval * 1000;
        this.m_recoveryAdminImpl.setRecoveryAbandonmentDetails(recoveryAbandonmentDetails);
    }

    public static void addResourceManagerFactory(String location, ResourceManagerFactory resourceManagerFactory) {
        m_resourceManagerFactoryMap.put(location, resourceManagerFactory);
    }

    public static void removeResourceManagerFactory(String location) {
        m_resourceManagerFactoryMap.remove(location);
    }

    private ResourceManagerFactory getResourceManagerFactoryForLocation(String location) {
        return (ResourceManagerFactory)m_resourceManagerFactoryMap.get(location);
    }

    public void addUnacquiredResource(RMId rmid) {
        this.m_unacquiredResourceRMIdsSet.add(rmid);
    }

    public boolean isNoPotentialForUnrecoveredTransactions() {
        this.displayInformation();
        return this.isNoPotentialForUnrecoveredTransactions(true);
    }

    private void displayInformation() {
        TransactionMessages.finer("RecoveryManager : " + this.m_partiallyReconstructedTransactions.size() + " recovering transaction(s) partially reconstructed from log remain(s)");
        TransactionMessages.finer(">>>>>>>>>>>>>>>>>>>>>>>");
        TransactionMessages.finer("" + this.m_partiallyReconstructedTransactions);
        TransactionMessages.finer(">>>>>>>>>>>>>>>>>>>>>>>");
        TransactionMessages.finer("RecoveryManager : " + this.m_recoveringTransactions.size() + " recovering transaction(s) reconstructed from log remain(s)");
        TransactionMessages.finer(">>>>>>>>>>>>>>>>>>>>>>>");
        TransactionMessages.finer("" + this.m_recoveringTransactions);
        TransactionMessages.finer(">>>>>>>>>>>>>>>>>>>>>>>");
        TransactionMessages.finer("RecoveryManager : " + this.m_locationToXAResourceMap.size() + " XAResource(s) remain(s) in the cache");
        TransactionMessages.finer(">>>>>>>>>>>>>>>>>>>>>>>");
        TransactionMessages.finer("" + this.m_locationToXAResourceMap);
        TransactionMessages.finer(">>>>>>>>>>>>>>>>>>>>>>>");
        TransactionMessages.finer("RecoveryManager : " + this.m_rmidLocationToXidSetPresumedAbortMap.size() + " resource(s) with one or more in-doubt Xids remain(s)");
        TransactionMessages.finer(">>>>>>>>>>>>>>>>>>>>>>>");
        TransactionMessages.finer("" + this.m_rmidLocationToXidSetPresumedAbortMap);
        TransactionMessages.finer(">>>>>>>>>>>>>>>>>>>>>>>");
        TransactionMessages.finer("RecoveryManager : " + this.m_unacquiredResourceRMIdsSet.size() + " resource(s) that could not be acquired remain(s)");
        TransactionMessages.finer(">>>>>>>>>>>>>>>>>>>>>>>");
        TransactionMessages.finer("" + this.m_unacquiredResourceRMIdsSet);
        TransactionMessages.finer(">>>>>>>>>>>>>>>>>>>>>>>");
        TransactionMessages.finer("RecoveryManager : " + this.m_committedTidToRLRCNameMap.size() + " transaction id(s) for recoverable last resource commit record(s) remain(s)");
        TransactionMessages.finer(">>>>>>>>>>>>>>>>>>>>>>>");
        TransactionMessages.finer("" + this.m_committedTidToRLRCNameMap);
        TransactionMessages.finer(">>>>>>>>>>>>>>>>>>>>>>>");
    }

    private boolean isNoPotentialForUnrecoveredTransactions(boolean committedTidToRLRCNameMapRelevant) {
        return this.m_partiallyReconstructedTransactions.size() == 0 && this.m_recoveringTransactions.size() == 0 && this.m_locationToXAResourceMap.size() == 0 && this.m_rmidLocationToXidSetPresumedAbortMap.size() == 0 && (!committedTidToRLRCNameMapRelevant || this.m_committedTidToRLRCNameMap.size() == 0);
    }

    public RecoveryManagerAdmin getRecoveryManagerAdmin() {
        return this.m_recoveryAdminImpl;
    }

    public synchronized void add(GlobalTransaction tx) {
        try {
            RecoveringTransaction nTrans = this.lookup(tx);
            if (nTrans == null) {
                nTrans = new RecoveringTransaction(tx, this);
                this.setBranchStates(nTrans);
                this.getRecoveringTransactions().add(nTrans);
            }
        }
        catch (TPCException e) {
            if (!this.m_isServerInitialized) {
                tx.incrementRecoveryReattemptCount();
            }
            this.getPartiallyReconstructedTransactions().add(new RecoveringTransaction(tx, null));
            if (this.m_isServerInitialized) {
                TransactionMessages.warningUnableToResolveAddingBackToQueue(tx, e);
            }
        }
        catch (Exception e) {
            TransactionMessages.severeUnableToResolve(tx, e);
        }
    }

    public TwoPhaseCommitProvider restoreInDoubtBranches(GlobalTransaction inDoubtTx) {
        RecoveringTransaction rt = new RecoveringTransaction(inDoubtTx, this);
        try {
            this.setBranchStates(rt);
        }
        catch (TPCException e) {
            TransactionMessages.warningUnableToReconstructBranches(inDoubtTx, e);
        }
        Coordinator coordinator = new Coordinator(rt.getGlobalTransaction(), this);
        coordinator.setRecovering();
        return new TwoPhaseCommitEngine(coordinator);
    }

    private void setBranchStates(RecoveringTransaction tx) throws TPCException {
        tx.resolveBranchStates();
        tx.fillInMissingXAResources();
    }

    RecoveringTransaction lookup(GlobalTransaction trans) {
        RecoveringTransaction found = null;
        Iterator recoveringTxsIterator = this.getRecoveringTransactions().iterator();
        while (recoveringTxsIterator.hasNext() && found == null) {
            RecoveringTransaction t = (RecoveringTransaction)recoveringTxsIterator.next();
            if (!t.getGlobalTransaction().equals(trans)) continue;
            found = t;
        }
        return found;
    }

    public void processAll() {
        this.m_recoveryAdminImpl.processAbandonments();
        this.processUnacquiredResources();
        this.processAllPartiallyReconstructedTransactions();
        this.processAllRecoveringTransactions();
        this.processIndoubtTransactions();
        this.queueRLRCTids();
        this.releaseUnUsedXAResources();
        this.displayInformation();
    }

    private void queueRLRCTids() {
        if (!this.isNoPotentialForUnrecoveredTransactions(false)) {
            return;
        }
        Iterator committedTidToRLRCNameMapIterator = this.m_committedTidToRLRCNameMap.keySet().iterator();
        while (committedTidToRLRCNameMapIterator.hasNext()) {
            byte[] tid = (byte[])committedTidToRLRCNameMapIterator.next();
            String rlrcName = (String)this.m_committedTidToRLRCNameMap.get(tid);
            NormalXid xid = new NormalXid(tid, 1330790740);
            TransactionMessages.finer("RecoveryManager queued commit record for deletion with Xid :" + xid);
            this.queueTxForCommitRecordPurge(xid, rlrcName, rlrcName);
            committedTidToRLRCNameMapIterator.remove();
        }
    }

    private void processUnacquiredResources() {
        Iterator unacquiredResourcesIterator = this.m_unacquiredResourceRMIdsSet.iterator();
        while (unacquiredResourcesIterator.hasNext()) {
            RMId rmid = null;
            try {
                rmid = (RMId)unacquiredResourcesIterator.next();
                this.acquireXAResource(rmid);
                unacquiredResourcesIterator.remove();
            }
            catch (TPCException e) {
                TransactionMessages.warning("Unable to acquire resource for recovery : " + rmid + "\n" + e);
            }
        }
    }

    private void processIndoubtTransactions() {
        Iterator rmidLocationToXidSetPresumedAbortMap_RMIDEntryIterator = this.m_rmidLocationToXidSetPresumedAbortMap.entrySet().iterator();
        while (rmidLocationToXidSetPresumedAbortMap_RMIDEntryIterator.hasNext() && !this.isCancelled()) {
            XAResource xaResource;
            Map.Entry entry = rmidLocationToXidSetPresumedAbortMap_RMIDEntryIterator.next();
            String jndiLocation = (String)entry.getKey();
            if (this.isRMIdLocationInvolvedInPartiallyReconstructedTransaction(jndiLocation) || this.isXAResourceInvolvedInTxWithUnacquirableSinglePhaseResource(xaResource = (XAResource)this.m_locationToXAResourceMap.get(jndiLocation)) || !this.processIndoubtXidsForRMId(jndiLocation, xaResource, (Set)entry.getValue())) continue;
            rmidLocationToXidSetPresumedAbortMap_RMIDEntryIterator.remove();
        }
        Iterator rlrcValuesIterator = this.m_rlrcNameToXAResourcesSetMap.values().iterator();
        while (rlrcValuesIterator.hasNext()) {
            if (!((Set)rlrcValuesIterator.next()).isEmpty()) continue;
            rlrcValuesIterator.remove();
        }
    }

    private boolean isRMIdLocationInvolvedInPartiallyReconstructedTransaction(String jndiLocation) {
        Iterator partiallyReconstructedTransactionsIterator = this.m_partiallyReconstructedTransactions.iterator();
        while (partiallyReconstructedTransactionsIterator.hasNext()) {
            GlobalTransaction globalTx = ((RecoveringTransaction)partiallyReconstructedTransactionsIterator.next()).getGlobalTransaction();
            for (int i = 0; i < globalTx.numberOfBranches(); ++i) {
                if (!globalTx.getBranch(i).getRmId().getRMFactoryJndiLocation().getJndiLocation().equals(jndiLocation)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isXAResourceInvolvedInTxWithUnacquirableSinglePhaseResource(XAResource xaResource) {
        boolean isXAResourceInvolvedInTxWithUnacquirableSinglePhaseResource = false;
        Iterator unacquireResourcesIterator = this.m_unacquiredResourceRMIdsSet.iterator();
        while (unacquireResourcesIterator.hasNext()) {
            Set setOfXAResourceInvolvedInTxWithGivenSinglePhaseResource;
            String unacquiredResourceLocation = ((RMId)unacquireResourcesIterator.next()).getRMFactoryJndiLocation().getJndiLocation();
            if (!this.m_rlrcNameToXAResourcesSetMap.containsKey(unacquiredResourceLocation) || !(setOfXAResourceInvolvedInTxWithGivenSinglePhaseResource = (Set)this.m_rlrcNameToXAResourcesSetMap.get(unacquiredResourceLocation)).contains(xaResource)) continue;
            isXAResourceInvolvedInTxWithUnacquirableSinglePhaseResource = true;
        }
        return isXAResourceInvolvedInTxWithUnacquirableSinglePhaseResource;
    }

    private boolean processIndoubtXidsForRMId(String jndiLocation, XAResource xaResource, Set xids) {
        boolean isXAResourceProcessSuccessfully = true;
        Iterator indoubtXidIterator = xids.iterator();
        String rlrcName = null;
        HashSet<String> setOfRLRCNames = new HashSet<String>();
        while (indoubtXidIterator.hasNext()) {
            Xid xid = (Xid)indoubtXidIterator.next();
            rlrcName = this.getRLRCNameForXid(xid);
            if (rlrcName != null) {
                if (!this.commitXidOnXAResourceInvolvedInRLRC(jndiLocation, xid, xaResource, rlrcName)) {
                    isXAResourceProcessSuccessfully = false;
                    continue;
                }
                this.m_committedTidToRLRCNameMap.remove(xid.getGlobalTransactionId());
                setOfRLRCNames.add(rlrcName);
                continue;
            }
            if (this.rollbackXidOnXAResource(jndiLocation, xid, xaResource)) continue;
            isXAResourceProcessSuccessfully = false;
        }
        Iterator setOfRLRCNamesIterator = setOfRLRCNames.iterator();
        while (setOfRLRCNamesIterator.hasNext()) {
            Set set = (Set)this.m_rlrcNameToXAResourcesSetMap.get(setOfRLRCNamesIterator.next());
            if (set == null) continue;
            set.remove(jndiLocation);
            if (!set.isEmpty()) continue;
            this.m_rlrcNameToXAResourcesSetMap.remove(xaResource);
        }
        return isXAResourceProcessSuccessfully;
    }

    private boolean rollbackXidOnXAResource(String jndiLocation, Xid xid, XAResource xaResource) {
        try {
            TransactionMessages.finer("About to recover via presumed-abort (rollback) " + jndiLocation + " with Xid :" + NormalXid.toString(xid));
            xaResource.rollback(xid);
            TransactionMessages.finer("Successfully rolledback " + jndiLocation + " with Xid :" + NormalXid.toString(xid));
        }
        catch (XAException e) {
            if (e.errorCode != -4) {
                TransactionMessages.warning("Unable to rollback resource at " + jndiLocation + " : " + xid);
                return false;
            }
            TransactionMessages.finer("XAER_NOTA XAException during presumed-abort (rollback)This may be expected. : " + e);
        }
        return true;
    }

    private boolean commitXidOnXAResourceInvolvedInRLRC(String jndiLocation, Xid xid, XAResource xaResource, String rlrcName) {
        try {
            TransactionMessages.finer("About to recover via commit " + jndiLocation + " involved in RLRC transaction with Xid :" + xid);
            xaResource.commit(xid, false);
            TransactionMessages.finer("Successfully committed " + jndiLocation + " involved in RLRC transaction with Xid :" + xid);
            this.queueTxForCommitRecordPurge(xid, rlrcName, jndiLocation);
        }
        catch (XAException e) {
            if (e.errorCode != -4) {
                TransactionMessages.warning("Unable to commit resource participating in a recoverable last resource commit transaction at " + jndiLocation + " : " + xid);
                return false;
            }
            TransactionMessages.finer("XAER_NOTA XAException during commit of a resource participating in a recoverable last resource commit transaction.  This may be expected. : " + e);
        }
        return true;
    }

    private void queueTxForCommitRecordPurge(Xid xid, String rlrcName, String jndiLocation) {
        GlobalTransaction globalTransaction = new GlobalTransaction(null, xid);
        RecoveredRMId rmid = new RecoveredRMId(rlrcName, "", rlrcName);
        globalTransaction.addRecoverableSinglePhaseBranch((XAResource)this.m_locationToXAResourceMap.get(rlrcName), xid, rmid, 12);
        ApplicationServerTransactionManager.getRecoverableSinglePhaseResourceReaperTask().add(globalTransaction);
        TransactionMessages.finer("Successfully queued for deletion commit record for  " + jndiLocation + " involved in RLRC transaction with Xid :" + xid);
    }

    private String getRLRCNameForXid(Xid xid) {
        byte[] tid = null;
        Iterator tidIterator = this.m_committedTidToRLRCNameMap.keySet().iterator();
        while (tidIterator.hasNext()) {
            tid = (byte[])tidIterator.next();
            if (!this.isByteArraysEqual(tid, xid.getGlobalTransactionId())) continue;
            return (String)this.m_committedTidToRLRCNameMap.get(tid);
        }
        return null;
    }

    boolean isByteArraysEqual(byte[] firstByteArray, byte[] secondByteArray) {
        if (firstByteArray == null || secondByteArray == null || firstByteArray.length != secondByteArray.length) {
            return false;
        }
        for (int i = 0; i < firstByteArray.length; ++i) {
            if (firstByteArray[i] == secondByteArray[i]) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void releaseUnUsedXAResources() {
        RecoveryManagerPresumedAbort recoveryManagerPresumedAbort = this;
        synchronized (recoveryManagerPresumedAbort) {
            Iterator xaresIterator = this.m_locationToXAResourceMap.keySet().iterator();
            HashSet<String> xaresToRemove = new HashSet<String>();
            while (xaresIterator.hasNext()) {
                String xaresLocation = (String)xaresIterator.next();
                if (this.m_locationToXAResourceMap.get(xaresLocation) instanceof RecoverableSinglePhaseResource || this.m_rmidLocationToXidSetPresumedAbortMap.containsKey(xaresLocation)) continue;
                boolean isXAResNeeded = false;
                Iterator partialsInterator = this.getPartiallyReconstructedTransactions().iterator();
                while (partialsInterator.hasNext() && !isXAResNeeded) {
                    isXAResNeeded = this.isXAResNeeded((RecoveringTransaction)partialsInterator.next(), xaresLocation);
                }
                Iterator recoveringInterator = this.getRecoveringTransactions().iterator();
                if (isXAResNeeded) continue;
                while (recoveringInterator.hasNext() && !isXAResNeeded) {
                    isXAResNeeded = this.isXAResNeeded((RecoveringTransaction)recoveringInterator.next(), xaresLocation);
                }
                if (isXAResNeeded) continue;
                xaresToRemove.add(xaresLocation);
            }
            Iterator xaresToRemoveIterator = xaresToRemove.iterator();
            while (xaresToRemoveIterator.hasNext()) {
                this.m_locationToXAResourceMap.remove(xaresToRemoveIterator.next());
            }
        }
    }

    private boolean isXAResNeeded(RecoveringTransaction partiallyReconstructedTransaction, String xaresLocation) {
        boolean isXAResNeeded = false;
        int numberOfBranches = partiallyReconstructedTransaction.getGlobalTransaction().numberOfBranches();
        for (int i = 0; i < numberOfBranches; ++i) {
            Branch branch = partiallyReconstructedTransaction.getGlobalTransaction().getBranch(i);
            RMFactoryJndiLocation rmFactoryJndiLocation = branch.getRmId().getRMFactoryJndiLocation();
            if (!rmFactoryJndiLocation.equals(xaresLocation) && !this.m_rmidLocationToXidSetPresumedAbortMap.containsKey(xaresLocation)) continue;
            isXAResNeeded = true;
        }
        return isXAResNeeded;
    }

    public boolean isXAResourceUnacquired(String location) {
        Iterator unacquiredResourcesIterator = this.m_unacquiredResourceRMIdsSet.iterator();
        while (unacquiredResourcesIterator.hasNext()) {
            if (!((RMId)unacquiredResourcesIterator.next()).getRMFactoryJndiLocation().getJndiLocation().equals(location)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processAllPartiallyReconstructedTransactions() {
        LinkedList temp = new LinkedList(this.getPartiallyReconstructedTransactions());
        Iterator iter = temp.iterator();
        while (iter.hasNext()) {
            GlobalTransaction tx = null;
            try {
                RecoveringTransaction partialRecTx = (RecoveringTransaction)iter.next();
                tx = partialRecTx.getGlobalTransaction();
                RecoveryManagerPresumedAbort recoveryManagerPresumedAbort = this;
                synchronized (recoveryManagerPresumedAbort) {
                    this.getPartiallyReconstructedTransactions().remove(partialRecTx);
                }
                this.add(tx);
            }
            catch (Exception e) {
                TransactionMessages.severeUnableToResolve(tx, e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processAllRecoveringTransactions() {
        LinkedList oldWaiting = new LinkedList(this.getRecoveringTransactions());
        Iterator transIt = oldWaiting.iterator();
        while (transIt.hasNext()) {
            Object object = this.m_cancellationLock;
            synchronized (object) {
                if (this.isCancelled()) {
                    break;
                }
                this.attemptToResolve((RecoveringTransaction)transIt.next());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void attemptToResolve(RecoveringTransaction recoveringTransaction) {
        try {
            TransactionMessages.finer("About to recover via commit " + recoveringTransaction.getGlobalTransaction());
            if (recoveringTransaction.resolve()) {
                TransactionMessages.finer("Successfully committed " + recoveringTransaction.getGlobalTransaction());
            } else {
                TransactionMessages.finer("Successfully committed " + recoveringTransaction.getGlobalTransaction());
            }
        }
        catch (ProtocolError e) {
            TransactionMessages.severeProtoAttemptingToResolve(recoveringTransaction.getGlobalTransaction(), e);
        }
        finally {
            this.getRecoveringTransactions().remove(recoveringTransaction);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel() {
        Object object = this.m_cancellationLock;
        synchronized (object) {
            this.m_cancelled = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isCancelled() {
        Object object = this.m_cancellationLock;
        synchronized (object) {
            return this.m_cancelled;
        }
    }

    public void run() {
        this.m_isServerInitialized = true;
        while (!this.isCancelled()) {
            try {
                TransactionMessages.finer("Beginning recovery manager processing...");
                this.processAll();
                TransactionMessages.finer("Finished recovery manager processing.  Next processing will begin in " + this.m_sleepTime / 1000L + " seconds");
                Thread.sleep(this.m_sleepTime);
                this.checkInterrupt();
            }
            catch (InterruptedException e) {
                this.cancel();
            }
        }
    }

    private void checkInterrupt() {
        if (Thread.currentThread().isInterrupted()) {
            this.cancel();
        }
    }

    public XAResource acquireXAResource(RMId rmid) throws TPCException {
        return this.acquireXAResource(rmid, true, true, true);
    }

    public XAResource acquireXAResource(RMId rmid, boolean isRecoverScanToBeConducted) throws TPCException {
        return this.acquireXAResource(rmid, isRecoverScanToBeConducted, false, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XAResource acquireXAResource(RMId rmid, boolean isRecoverScanToBeConducted, boolean isRecoverCommittingCallToBeConducted, boolean isXidProcessingToBeConducted) throws TPCException {
        XAResource xAResource;
        block9: {
            boolean recoverScanSuccess;
            String rmFactoryJndiLocation;
            XAResource xaResource;
            block7: {
                XAResource xAResource2;
                block8: {
                    xaResource = null;
                    rmFactoryJndiLocation = null;
                    recoverScanSuccess = false;
                    try {
                        rmFactoryJndiLocation = rmid.getRMFactoryJndiLocation().getJndiLocation();
                        xaResource = this.m_locationToXAResourceMap.containsKey(rmFactoryJndiLocation) ? (XAResource)this.m_locationToXAResourceMap.get(rmFactoryJndiLocation) : this.getNewXAResource(rmid, rmFactoryJndiLocation);
                        if (xaResource == null) {
                            throw new TPCException(rmid.getRMFactoryJndiLocation().getJndiLocation() + " is null");
                        }
                        if (isRecoverScanToBeConducted) break block7;
                        this.m_locationToXAResourceMap.put(rmFactoryJndiLocation, xaResource);
                        xAResource2 = xaResource;
                        Object var11_10 = null;
                        if (xaResource != null && recoverScanSuccess) break block8;
                        this.m_locationToXAResourceMap.remove(rmFactoryJndiLocation);
                    }
                    catch (Throwable throwable) {
                        block10: {
                            Object var11_12 = null;
                            if (xaResource != null && recoverScanSuccess) break block10;
                            this.m_locationToXAResourceMap.remove(rmFactoryJndiLocation);
                        }
                        throw throwable;
                    }
                }
                return xAResource2;
            }
            recoverScanSuccess = this.verifyRecoverScanSuccess(xaResource, rmFactoryJndiLocation, isRecoverCommittingCallToBeConducted, isXidProcessingToBeConducted);
            this.m_locationToXAResourceMap.put(rmFactoryJndiLocation, xaResource);
            if (rmid instanceof RecoveredRMId) {
                String rlrcName;
                RecoveredRMId recoveredRMId = (RecoveredRMId)rmid;
                String string = rlrcName = recoveredRMId.getRLRCLocation() == null ? "" : recoveredRMId.getRLRCLocation();
                if (!rlrcName.equals("")) {
                    if (!this.m_rlrcNameToXAResourcesSetMap.containsValue(rlrcName)) {
                        this.m_rlrcNameToXAResourcesSetMap.put(rlrcName, new HashSet());
                    }
                    ((Set)this.m_rlrcNameToXAResourcesSetMap.get(rlrcName)).add(xaResource);
                }
            }
            xAResource = xaResource;
            Object var11_11 = null;
            if (xaResource != null && recoverScanSuccess) break block9;
            this.m_locationToXAResourceMap.remove(rmFactoryJndiLocation);
        }
        return xAResource;
    }

    private XAResource getNewXAResource(RMId rmid, String rmFactoryJndiLocation) throws TPCException {
        ResourceManagerFactory obj;
        if (rmFactoryJndiLocation.equals("oc4j:internal/serverXAResource")) {
            try {
                obj = SubordinateXAResourceImpl.instance();
            }
            catch (IllegalStateException ise) {
                TPCException tpcException = new TPCException("IllegalStateException thrown while attempting to get SubordinateXAResource is unavailable");
                tpcException.initCause(ise);
                throw tpcException;
            }
        } else {
            obj = this.getResourceManagerFactoryForLocation(rmFactoryJndiLocation);
        }
        if (!(obj instanceof ResourceManagerFactory)) {
            throw new TPCException((obj == null ? "null" : obj.getClass().getName()) + " at " + rmFactoryJndiLocation + " is not a ResourceManagerFactory");
        }
        XAResource xaResource = ((ResourceManagerFactory)obj).connect(rmid.getRMFactoryArg());
        return xaResource;
    }

    private boolean verifyRecoverScanSuccess(XAResource xaResource, String rmFactoryJndiLocation, boolean isRecoverCommittingCallToBeConducted, boolean isXidProcessingToBeConducted) throws TPCException {
        XAResource unwrapedResource = xaResource;
        while (unwrapedResource instanceof WrappedXAResource) {
            unwrapedResource = ((WrappedXAResource)((Object)unwrapedResource)).getWrappedResource();
        }
        if (!isXidProcessingToBeConducted || unwrapedResource instanceof RecoverableSinglePhaseResource) {
            try {
                xaResource.recover(0x1000000);
            }
            catch (XAException xae) {
                throw new TPCException(TransactionMessages.warningRecoveryScanFailed(rmFactoryJndiLocation, xae));
            }
            return !isRecoverCommittingCallToBeConducted || !(unwrapedResource instanceof RecoverableSinglePhaseResource) || this.parseRecoverableSinglePhaseResource(unwrapedResource, rmFactoryJndiLocation);
        }
        return this.processXAResourceXids(xaResource, rmFactoryJndiLocation);
    }

    boolean processXAResourceXids(XAResource xaResource, String rmFactoryJndiLocation) throws TPCException {
        Xid[] xids = this.gatherXidsFromXAResource(xaResource, rmFactoryJndiLocation, false);
        HashSet<Xid> presumedAbortXidSet = new HashSet<Xid>();
        for (int i = 0; i < xids.length; ++i) {
            TransactionMessages.finer("Xid returned from scan of " + rmFactoryJndiLocation + " [" + i + "] : " + NormalXid.toString(xids[i]));
            if (xids[i].getFormatId() != 1330790740) continue;
            byte[] txid = xids[i].getGlobalTransactionId();
            boolean isThisServersId = true;
            for (int ii = 0; ii < 8; ++ii) {
                if (txid[ii] == ApplicationServerTransactionManager.getClusterIDBytes()[ii]) continue;
                isThisServersId = false;
                break;
            }
            if (!isThisServersId || this.isTxIdInRecoveringTransactionList(this.getPartiallyReconstructedTransactions(), xids[i].getGlobalTransactionId()) || this.isTxIdInRecoveringTransactionList(this.getRecoveringTransactions(), xids[i].getGlobalTransactionId())) continue;
            TransactionMessages.finer("Adding to presumed abort map Xid returned from scan of " + rmFactoryJndiLocation + " [" + i + "] : " + NormalXid.toString(xids[i]));
            presumedAbortXidSet.add(xids[i]);
        }
        if (!presumedAbortXidSet.isEmpty()) {
            this.m_rmidLocationToXidSetPresumedAbortMap.put(rmFactoryJndiLocation, presumedAbortXidSet);
        }
        return true;
    }

    Xid[] gatherXidsFromXAResource(XAResource xaResource, String rmFactoryJndiLocation, boolean isAdmin) throws TPCException {
        Xid[] xids;
        try {
            xids = xaResource.recover(0x1000000);
            TransactionMessages.finer(rmFactoryJndiLocation + " recover(XAResource.TMSTARTRSCAN) returned " + xids.length + " Xid(s)");
        }
        catch (XAException xae) {
            throw new TPCException(TransactionMessages.warningRecoveryScanFailed(rmFactoryJndiLocation, xae));
        }
        int numberOfTMNOFLAGScan = 0;
        boolean isUniqueArray = true;
        while (isUniqueArray) {
            try {
                Xid[] xidsFromTMNOFLAGSScan = xaResource.recover(0);
                TransactionMessages.finer(rmFactoryJndiLocation + " recover(XAResource.TMNOFLAGS) number " + ++numberOfTMNOFLAGScan + " returned " + xids.length + " Xid(s)");
                if (xidsFromTMNOFLAGSScan.length == 0) {
                    return xids;
                }
                HashSet<Xid> xidsFoundInTMNOFLAGSButNotInTMSTARTRSCAN = new HashSet<Xid>();
                for (int i = 0; i < xidsFromTMNOFLAGSScan.length && isUniqueArray; ++i) {
                    for (int ii = 0; ii < xids.length && isUniqueArray; ++ii) {
                        if (this.isXidsEqual(xidsFromTMNOFLAGSScan[i], xids[ii])) {
                            isUniqueArray = false;
                            if (isAdmin) continue;
                            return xids;
                        }
                        xidsFoundInTMNOFLAGSButNotInTMSTARTRSCAN.add(xidsFromTMNOFLAGSScan[i]);
                    }
                }
                Xid[] swapArray = new Xid[xids.length + xidsFoundInTMNOFLAGSButNotInTMSTARTRSCAN.size()];
                System.arraycopy(xids, 0, swapArray, 0, xids.length);
                Iterator iterator = xidsFoundInTMNOFLAGSButNotInTMSTARTRSCAN.iterator();
                int i = xids.length;
                while (iterator.hasNext()) {
                    swapArray[i++] = (Xid)iterator.next();
                }
                xids = swapArray;
            }
            catch (XAException xae) {
                isUniqueArray = false;
            }
        }
        return xids;
    }

    public boolean isXidsEqual(Xid xid1, Xid xid2) {
        return xid1.getFormatId() == xid2.getFormatId() && Arrays.equals(xid1.getGlobalTransactionId(), xid2.getGlobalTransactionId()) && Arrays.equals(xid1.getBranchQualifier(), xid2.getBranchQualifier());
    }

    private boolean parseRecoverableSinglePhaseResource(XAResource xaResource, String rmFactoryJndiLocation) throws TPCException {
        byte[][] tids;
        try {
            tids = ((RecoverableSinglePhaseResource)((Object)xaResource)).recoverCommitted();
        }
        catch (XAException xae) {
            String msg = "XAException during recoverCommitted call on " + rmFactoryJndiLocation + " :" + xae;
            TransactionMessages.warning(msg);
            TPCException tpcException = new TPCException(msg);
            tpcException.initCause(xae);
            throw tpcException;
        }
        for (int i = 0; i < tids.length; ++i) {
            this.m_committedTidToRLRCNameMap.put(tids[i], rmFactoryJndiLocation);
        }
        return true;
    }

    private boolean isTxIdInRecoveringTransactionList(Set recoveringTransactionSet, byte[] txId) {
        Iterator iterator = recoveringTransactionSet.iterator();
        while (iterator.hasNext()) {
            byte[] recoveringTransactionTxId = ((RecoveringTransaction)iterator.next()).getGlobalTransaction().getXid().getGlobalTransactionId();
            if (!Arrays.equals(recoveringTransactionTxId, txId)) continue;
            return true;
        }
        return false;
    }

    public long getSleepTime() {
        return this.m_sleepTime;
    }

    public void setSleepTime(long sleepTime) {
        this.m_sleepTime = sleepTime;
    }

    public Set getRecoveringTransactions() {
        return this.m_recoveringTransactions;
    }

    public Set getPartiallyReconstructedTransactions() {
        return this.m_partiallyReconstructedTransactions;
    }

    public int getNumberOfRecoveringTxs() {
        return this.getPartiallyReconstructedTransactions().size() + this.getRecoveringTransactions().size();
    }

    public boolean isRecovering(Xid xid) {
        GlobalTransaction t = null;
        Iterator iter = this.getRecoveringTransactions().iterator();
        while (iter.hasNext()) {
            t = ((RecoveringTransaction)iter.next()).getGlobalTransaction();
            if (!t.getXid().equals(xid)) continue;
            return true;
        }
        iter = this.getPartiallyReconstructedTransactions().iterator();
        while (iter.hasNext()) {
            t = ((RecoveringTransaction)iter.next()).getGlobalTransaction();
            if (!t.getXid().equals(xid)) continue;
            return true;
        }
        return false;
    }
}

