/*
 * Decompiled with CFR 0.152.
 */
package oracle.as.j2ee.transaction.tpc;

import com.evermind.server.TwoPhaseCommitProvider;
import javax.transaction.HeuristicCommitException;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import oracle.as.j2ee.transaction.propagation.ParentReference;
import oracle.as.j2ee.transaction.tpc.Coordinator;
import oracle.as.j2ee.transaction.tpc.GlobalTransaction;
import oracle.as.j2ee.transaction.tpc.Store;
import oracle.as.j2ee.transaction.tpc.recovery.RecoveryManager;

public class TwoPhaseCommitEngine
implements TwoPhaseCommitProvider {
    private Coordinator m_coordinator;

    public TwoPhaseCommitEngine(Xid xid, Store store, RecoveryManager recoveryManager, int retryCount, boolean participantRecoverable, String type) {
        this.m_coordinator = new Coordinator(xid, store, recoveryManager, participantRecoverable);
        this.m_coordinator.setMaximumRetryCount(retryCount);
        this.m_coordinator.setType(type);
    }

    public TwoPhaseCommitEngine(Coordinator coordinator) {
        this.m_coordinator = coordinator;
    }

    public void commit(XAResource[] resources, Xid[] xids) throws RollbackException, HeuristicMixedException, HeuristicCommitException, HeuristicRollbackException, SystemException {
        this.m_coordinator.resolve(xids, resources, false);
    }

    public int getStatus() {
        return this.m_coordinator.getTransaction().getTransactionState();
    }

    public int prepare(Xid[] xids, XAResource[] resources, ParentReference pr) throws XAException, SystemException {
        try {
            this.m_coordinator.prepare(xids, resources, null);
        }
        catch (SystemException e) {
            XAException xe = new XAException(-3);
            xe.initCause(e);
            throw xe;
        }
        catch (RollbackException e) {
            XAException xe = new XAException(100);
            xe.initCause(e);
            throw xe;
        }
        return 0;
    }

    public void commit(boolean heuristic) throws XAException, SystemException {
        if (this.m_coordinator == null || this.m_coordinator.getTransaction().isFinished()) {
            throw new XAException(-4);
        }
        try {
            this.m_coordinator.commit(heuristic);
        }
        catch (RollbackException e) {
            XAException xe = new XAException(-3);
            xe.initCause(e);
            throw xe;
        }
        catch (HeuristicRollbackException e) {
            XAException xe = new XAException(6);
            xe.initCause(e);
            throw xe;
        }
        catch (HeuristicCommitException e) {
            XAException xe = new XAException(7);
            xe.initCause(e);
            throw xe;
        }
        catch (HeuristicMixedException e) {
            XAException xe = new XAException(5);
            xe.initCause(e);
            throw xe;
        }
    }

    public void rollback(boolean heuristic) throws XAException, SystemException {
        if (this.m_coordinator == null || this.m_coordinator.getTransaction().isFinished()) {
            throw new XAException(-4);
        }
        try {
            this.m_coordinator.rollback(heuristic);
        }
        catch (HeuristicRollbackException e) {
            XAException xe = new XAException(6);
            xe.initCause(e);
            throw xe;
        }
        catch (HeuristicCommitException e) {
            XAException xe = new XAException(7);
            xe.initCause(e);
            throw xe;
        }
        catch (HeuristicMixedException e) {
            XAException xe = new XAException(5);
            xe.initCause(e);
            throw xe;
        }
    }

    public void forget() throws XAException {
        if (this.m_coordinator == null || this.m_coordinator.getTransaction().isFinished()) {
            throw new XAException(-4);
        }
        try {
            this.m_coordinator.forget();
        }
        catch (SystemException e) {
            XAException xe = new XAException(-3);
            xe.initCause(e);
            throw xe;
        }
        catch (IllegalStateException e) {
            XAException xe = new XAException(-6);
            xe.initCause(e);
            throw xe;
        }
    }

    public int getRetryCount() {
        return this.m_coordinator.getRetryCount();
    }

    public GlobalTransaction getGlobalTransaction() {
        return this.m_coordinator.getTransaction();
    }
}

