/*
 * Decompiled with CFR 0.152.
 */
package oracle.as.j2ee.transaction.tpc;

import java.util.LinkedList;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import oracle.as.j2ee.transaction.TransactionState;
import oracle.as.j2ee.transaction.propagation.ParentReference;
import oracle.as.j2ee.transaction.tpc.Branch;
import oracle.as.j2ee.transaction.tpc.RMId;
import oracle.as.j2ee.transaction.tpc.RecoverableSinglePhaseBranch;
import oracle.as.j2ee.transaction.tpc.SinglePhaseBranch;
import oracle.as.j2ee.transaction.tpc.Store;
import oracle.as.j2ee.transaction.tpc.XAState;

public class GlobalTransaction {
    private Store m_store;
    private Xid m_xid;
    private int m_state;
    private String m_type;
    private long m_startTime;
    private int m_recoveryReattemptCount;
    private LinkedList m_branches = new LinkedList();
    static int[] associated_ = new int[17];
    static int[] allowed_ = new int[17];
    static String[] toString_ = new String[17];
    private ParentReference m_parentReference;
    static InitInfo[] initInfo = new InitInfo[]{new InitInfo(0, "ACTIVE", 5, 65), new InitInfo(1, "READ ONLY", 5, 128), new InitInfo(2, "ROLLBACK ONLY", 5, 65), new InitInfo(3, "ROLLINGBACK", 3, 131), new InitInfo(4, "COMMIT1", 2, 129), new InitInfo(5, "COMMITTING", 1, 130), new InitInfo(6, "PREPARING", 0, 1), new InitInfo(7, "HEURISTIC COMMITTING", 1, 130), new InitInfo(8, "HEURISTIC ROLLINGBACK", 3, 131), new InitInfo(9, "IN DOUBT", 5, 2), new InitInfo(10, "HEURISTIC COMMITTED", 5, 480), new InitInfo(11, "HEURISTIC ROLLEDBACK", 5, 480), new InitInfo(12, "COMMITTED", 5, 480), new InitInfo(13, "ROLLEDBACK", 5, 480), new InitInfo(14, "INCONSISTENT", 5, 511), new InitInfo(15, "HEURISTIC INCONSISTENT", 5, 511)};

    public GlobalTransaction(Store store, Xid xid) {
        this(store, xid, 0, null);
    }

    public GlobalTransaction(Store store, Xid xid, int initialState, ParentReference pr) {
        this.m_store = store;
        this.m_xid = xid;
        this.m_state = initialState;
        this.m_parentReference = pr;
        this.m_startTime = System.currentTimeMillis();
    }

    public Xid getXid() {
        return this.m_xid;
    }

    public Store getStore() {
        return this.m_store;
    }

    public int getTransactionState() {
        return this.m_state;
    }

    public void setTransactionState(int state) {
        this.m_state = state;
    }

    public void setType(String type) {
        this.m_type = type;
    }

    public String getType() {
        return this.m_type;
    }

    public int getRecoveryReattemptCount() {
        return this.m_recoveryReattemptCount;
    }

    public void incrementRecoveryReattemptCount() {
        ++this.m_recoveryReattemptCount;
    }

    public void setStartTime(long startTime) {
        this.m_startTime = startTime;
    }

    public long getTimeActive() {
        return System.currentTimeMillis() - this.m_startTime;
    }

    public boolean is(int transactionState) {
        return this.m_state == transactionState;
    }

    void addBranch(XAResource rm, Xid xId, RMId rmId, int status) {
        Branch branch = new Branch(this, rm, xId, rmId, status);
        this.m_branches.addLast(branch);
    }

    void addSinglePhaseBranch(XAResource rm, Xid xId, int status) {
        SinglePhaseBranch branch = new SinglePhaseBranch(this, rm, xId, status);
        this.m_branches.addLast(branch);
    }

    public void addRecoverableSinglePhaseBranch(XAResource rm, Xid xId, RMId rmid, int status) {
        RecoverableSinglePhaseBranch branch = new RecoverableSinglePhaseBranch(this, rm, xId, rmid, status);
        this.m_branches.addLast(branch);
    }

    public Branch getBranch(int index) {
        return (Branch)this.m_branches.get(index);
    }

    public int numberOfBranches() {
        return this.m_branches.size();
    }

    public boolean reorderBranches(Branch branch, XAException e) {
        if (branch.getException() != null) {
            return false;
        }
        this.m_branches.remove(branch);
        this.m_branches.addLast(branch);
        return true;
    }

    public boolean isResolved() {
        return this.is(12) || this.is(13);
    }

    public boolean isHeuristicCompleted() {
        return this.is(15) || this.is(10) || this.is(11);
    }

    public boolean isHeuristic() {
        return this.isHeuristicCompleted() || this.is(7) || this.is(8);
    }

    public boolean allBranchesCommitted() {
        return this.allAre(164);
    }

    boolean hasHeuristicCommittedBranches() {
        return this.someAre(4);
    }

    boolean allBranchesHeuristicCommitted() {
        return this.allAre(4);
    }

    public boolean allBranchesRolledback() {
        return this.allAre(200);
    }

    boolean hasHeuristicRolledbackBranches() {
        return this.someAre(8);
    }

    public boolean allBranchesHeuristicRolledback() {
        return this.allAre(8);
    }

    public boolean allBranchesFinished() {
        return this.allAre(508);
    }

    public boolean isFinished() {
        return this.isResolved() || this.m_state == 14;
    }

    public boolean isRolledback() {
        return this.allBranchesRolledback() && this.is(13);
    }

    public boolean isRollingback() {
        return this.m_state == 3 || this.m_state == 8;
    }

    public boolean isCommitting() {
        return this.m_state == 5 || this.m_state == 7;
    }

    boolean hasMixedHeuristicBranches() {
        if (!this.allBranchesFinished()) {
            return false;
        }
        return this.someAre(272) || this.isCommitting() && this.hasHeuristicRolledbackBranches() && !this.someAre(64) || this.isRollingback() && this.hasHeuristicCommittedBranches() && !this.someAre(32);
    }

    boolean hasInconsistentBranches() {
        return !this.allBranchesCommitted() && !this.allBranchesRolledback();
    }

    public boolean isMixed() {
        return this.m_state == 14 || this.m_state == 15;
    }

    private boolean allAre(int xas) {
        boolean ok = true;
        for (int xBranch = 0; xBranch < this.m_branches.size() && ok; ++xBranch) {
            if (this.getBranch(xBranch).getXAState().couldBe(xas)) continue;
            return false;
        }
        return true;
    }

    int getAggregatedBranchStates() {
        int as = 0;
        for (int xBranch = 0; xBranch < this.m_branches.size(); ++xBranch) {
            as |= this.getBranch(xBranch).getXAState().getState();
        }
        return as;
    }

    private boolean someAre(int xas) {
        boolean ok = false;
        for (int xBranch = 0; xBranch < this.m_branches.size() && !ok && !(ok = this.getBranch(xBranch).getXAState().couldBe(xas)); ++xBranch) {
        }
        return ok;
    }

    private static int associatedAction(int ts) {
        return associated_[ts];
    }

    public int associatedAction() {
        return GlobalTransaction.associatedAction(this.getTransactionState());
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("Global Transaction ").append(this.m_xid);
        buf.append(", type=").append(this.getType());
        buf.append(", state=").append(TransactionState.toString(this.getTransactionState()));
        buf.append(", time in completion or recovering=").append(this.getTimeActive());
        if (this.m_recoveryReattemptCount != 0) {
            buf.append(", recovery reattempt count if applicable=").append(this.m_recoveryReattemptCount);
        }
        buf.append(")").append("\n{\n");
        for (int xBranch = 0; xBranch < this.numberOfBranches(); ++xBranch) {
            if (xBranch != 0) {
                buf.append(",\n");
            }
            buf.append(this.getBranch(xBranch).toString());
        }
        buf.append("\n}");
        return buf.toString();
    }

    public ParentReference getParentReference() {
        return this.m_parentReference;
    }

    public int hashCode() {
        return this.m_xid.hashCode() + 11;
    }

    public boolean equals(Object other) {
        return other instanceof GlobalTransaction && GlobalTransaction.equals(this, (GlobalTransaction)other);
    }

    public static boolean equals(GlobalTransaction tx0, GlobalTransaction tx1) {
        return tx0.getXid().equals(tx1.getXid());
    }

    public void setParentReference(ParentReference parentReference) {
        this.m_parentReference = parentReference;
    }

    public RecoverableSinglePhaseBranch getRecoverableSinglePhaseBranch() {
        for (int i = 0; i < this.numberOfBranches(); ++i) {
            Branch branch = this.getBranch(i);
            if (!(branch instanceof RecoverableSinglePhaseBranch)) continue;
            return (RecoverableSinglePhaseBranch)branch;
        }
        return null;
    }

    static {
        for (int xI = 0; xI < initInfo.length; ++xI) {
            InitInfo i = initInfo[xI];
            int xas = i.xas;
            XAState state = new XAState(xas);
            state.spontaneous();
            xas |= state.getState();
            state = new XAState(xas);
            xas |= state.getState();
            state = new XAState(xas);
            state.spontaneous();
            int xTS = i.ts;
            GlobalTransaction.toString_[xTS] = i.name;
            GlobalTransaction.associated_[xTS] = i.action;
            GlobalTransaction.allowed_[xTS] = xas |= state.getState();
        }
    }

    private static class InitInfo {
        int ts;
        String name;
        int action;
        int xas;

        InitInfo(int ts, String name, int action, int xas) {
            this.ts = ts;
            this.name = name;
            this.action = action;
            this.xas = xas;
        }
    }
}

