/*
 * Decompiled with CFR 0.152.
 */
package oracle.as.j2ee.transaction.tpc;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import javax.transaction.xa.Xid;
import oracle.as.j2ee.transaction.tpc.FileStoreInputStream;
import oracle.as.j2ee.transaction.tpc.FileStorePooledFileChannel;
import oracle.as.j2ee.transaction.tpc.MultiFileStore;
import oracle.as.j2ee.transaction.tpc.Store;
import oracle.j2ee.transaction.TransactionMessages;
import oracle.oc4j.security.OC4JSecurity;

class FileChannelPool {
    private HashMap m_activeMap = new HashMap(32);
    private HashSet m_pooledSet = new HashSet(32);
    private int m_maxInPool;
    private int m_ttlRemovalBatchSize = 20;
    private String m_logLocation;
    private File m_activeDir;
    private File m_archiveDir;
    private int m_currentFileNumber = 0;

    FileChannelPool(String logLocation, File activeDir, File archiveDir, int maxInPool) {
        this.m_logLocation = logLocation;
        this.m_activeDir = activeDir;
        this.m_archiveDir = archiveDir;
        this.m_maxInPool = maxInPool;
    }

    String getLogLocation() {
        return this.m_logLocation;
    }

    String getArchiveLogLocation() {
        return this.m_logLocation + MultiFileStore.ARCHIVE_DIR_SUFFIX;
    }

    File getActiveDir() {
        return this.m_activeDir;
    }

    void setTTLRemovalBatchSize(int ttlRemovalBatchSize) {
        this.m_ttlRemovalBatchSize = ttlRemovalBatchSize > this.m_maxInPool ? this.m_maxInPool : (ttlRemovalBatchSize < 0 ? 0 : ttlRemovalBatchSize);
    }

    int getTTlRemovalBatchSize() {
        return this.m_ttlRemovalBatchSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void putInActiveMap(Xid xid, FileStorePooledFileChannel fileChannel) {
        FileChannelPool fileChannelPool = this;
        synchronized (fileChannelPool) {
            this.m_activeMap.put(xid, fileChannel);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    FileStorePooledFileChannel getActivePooledFileChannelForXid(Xid xid) {
        FileChannelPool fileChannelPool = this;
        synchronized (fileChannelPool) {
            return (FileStorePooledFileChannel)this.m_activeMap.get(xid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void moveFromActiveToPool(Xid xid) throws IOException, Store.StoreException {
        FileStorePooledFileChannel fileChannel = null;
        FileChannelPool fileChannelPool = this;
        synchronized (fileChannelPool) {
            fileChannel = (FileStorePooledFileChannel)this.m_activeMap.remove(xid);
        }
        if (fileChannel != null) {
            fileChannel.truncate(0L);
            fileChannel.position(0L);
            fileChannel.force(false);
            fileChannelPool = this;
            synchronized (fileChannelPool) {
                this.m_pooledSet.add(fileChannel);
            }
            return;
        }
        fileChannel = this.checkArchive(xid);
        if (fileChannel != null) {
            File file = new File(fileChannel.getFileName());
            if (file.exists()) {
                file.delete();
            }
            return;
        }
        throw new Store.StoreException("File does not exist for " + xid);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    FileStorePooledFileChannel getNewPooledFileChannel(Xid xid) throws IOException {
        FileChannelPool fileChannelPool = this;
        synchronized (fileChannelPool) {
            if (this.m_pooledSet.isEmpty()) {
                this.releaseOldRefIfNecessary();
                this.createPooledFileChannelAndPutInMap(xid);
            } else {
                Object o = this.m_pooledSet.iterator().next();
                this.m_pooledSet.remove(o);
                this.putInActiveMap(xid, (FileStorePooledFileChannel)o);
            }
            return this.getActivePooledFileChannelForXid(xid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void createPooledFileChannelAndPutInMap(Xid xid) throws FileNotFoundException, IOException {
        FileChannelPool fileChannelPool = this;
        synchronized (fileChannelPool) {
            File file = new File(this.getNextFullFileName());
            this.putInActiveMap(xid, new FileStorePooledFileChannel(xid, OC4JSecurity.newFileOutputStream(file), file.getName()));
        }
    }

    void closeAllFileOutputs() {
        try {
            Iterator<Object> iterator = this.m_activeMap.values().iterator();
            while (iterator.hasNext()) {
                ((FileStorePooledFileChannel)iterator.next()).getFileOutputStream().close();
            }
            iterator = this.m_pooledSet.iterator();
            while (iterator.hasNext()) {
                ((FileStorePooledFileChannel)iterator.next()).getFileOutputStream().close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    String getCurrentFullFileName() {
        return this.getFullFilePathForFileNumber(this.m_currentFileNumber);
    }

    String getNextFullFileName() {
        return this.getFullFilePathForFileNumber(++this.m_currentFileNumber);
    }

    private String getFullFilePathForFileNumber(int filennumber) {
        return this.getLogLocation() + File.separatorChar + "tx." + filennumber;
    }

    int getCurrentFileNumber() {
        return this.m_currentFileNumber;
    }

    void setCurrentFileNumber(int currentFileNumber) {
        this.m_currentFileNumber = currentFileNumber;
    }

    void releaseOldRefIfNecessary() {
        if (this.m_activeMap.size() < this.m_maxInPool) {
            return;
        }
        int sizeOfActiveMap = this.m_activeMap.size();
        long[] datesInPool = new long[sizeOfActiveMap];
        Xid[] xidsInPool = new Xid[sizeOfActiveMap];
        this.orderFromOldestToYoungest(datesInPool, xidsInPool);
        this.moveOldestToArchive(sizeOfActiveMap, xidsInPool);
    }

    private void orderFromOldestToYoungest(long[] datesInPool, Xid[] xidsInPool) {
        int i = 0;
        Iterator iterator = this.m_activeMap.values().iterator();
        while (iterator.hasNext()) {
            Xid xid;
            FileStorePooledFileChannel fileStorePooledFileChannel = (FileStorePooledFileChannel)iterator.next();
            datesInPool[i] = fileStorePooledFileChannel.getTimeCreated();
            xidsInPool[i] = xid = fileStorePooledFileChannel.getXid();
            ++i;
        }
        for (int outerLoop = this.m_activeMap.size() - 1; outerLoop > 1; --outerLoop) {
            for (int innerLoop = 0; innerLoop < outerLoop; ++innerLoop) {
                if (datesInPool[innerLoop] <= datesInPool[innerLoop + 1]) continue;
                this.sortXidsFromYoungestToOldest(datesInPool, xidsInPool, innerLoop, innerLoop + 1);
            }
        }
    }

    private void sortXidsFromYoungestToOldest(long[] datesInPool, Xid[] xidsInPool, int one, int two) {
        long temp = datesInPool[one];
        datesInPool[one] = datesInPool[two];
        datesInPool[two] = temp;
        Xid tempXid = xidsInPool[one];
        xidsInPool[one] = xidsInPool[two];
        xidsInPool[two] = tempXid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void moveOldestToArchive(int sizeOfActiveMap, Xid[] xidsInPool) {
        File file = this.m_archiveDir;
        synchronized (file) {
            int numberToRemove = this.getTTlRemovalBatchSize() > sizeOfActiveMap ? sizeOfActiveMap - 1 : this.getTTlRemovalBatchSize();
            for (int ii = 0; ii < numberToRemove; ++ii) {
                FileStorePooledFileChannel pooledFileChannel = (FileStorePooledFileChannel)this.m_activeMap.remove(xidsInPool[sizeOfActiveMap - 1 - ii]);
                if (pooledFileChannel == null) continue;
                String fileName = pooledFileChannel.getFileName();
                new File(this.getLogLocation() + File.separatorChar + fileName).renameTo(new File(this.getArchiveLogLocation() + File.separatorChar + fileName));
            }
        }
    }

    synchronized FileStorePooledFileChannel checkArchive(Xid xid) throws Store.StoreException, IOException {
        TransactionMessages.warningMaxInPoolExceeded(this.m_maxInPool);
        File file = this.getFileFromArchive(xid);
        int fileNumber = ++this.m_currentFileNumber;
        if (!file.renameTo(new File(this.getFullFilePathForFileNumber(fileNumber)))) {
            throw new Store.StoreException("Unable to move file from archive to active state for " + xid);
        }
        FileStorePooledFileChannel channel = new FileStorePooledFileChannel(xid, OC4JSecurity.newFileOutputStream(file), "tx." + fileNumber);
        channel.position(channel.size());
        this.putInActiveMap(xid, channel);
        return channel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    File getFileFromArchive(Xid xid) throws Store.StoreException {
        File file = this.m_archiveDir;
        synchronized (file) {
            File[] files = this.m_archiveDir.listFiles();
            try {
                if (files == null) {
                    throw new Store.StoreException("Transaction log file does not exist or is corrupt for " + xid);
                }
                String fileName = null;
                for (int i = 0; i < files.length; ++i) {
                    FileStoreInputStream in = new FileStoreInputStream(files[i]);
                    try {
                        fileName = files[i].getCanonicalPath();
                        if (!this.getXidFromFile(in, fileName).equals(xid)) continue;
                        File file2 = files[i];
                        return file2;
                    }
                    catch (IOException e) {
                        TransactionMessages.warningUnableToProcessTxDueToIOEx(e);
                        continue;
                    }
                    catch (Store.StoreException e) {
                        TransactionMessages.fineEmptyOrCorruptFile(e);
                        continue;
                    }
                    finally {
                        in.close();
                    }
                }
                throw new Store.StoreException("Transaction log file does not exist or is corrupt for " + xid);
            }
            catch (FileNotFoundException e) {
                Store.StoreException se = new Store.StoreException("Log directory " + this.m_logLocation + " does not exist. ");
                se.initCause(e);
                throw se;
            }
            catch (IOException ioe) {
                Store.StoreException se = new Store.StoreException("IO failure");
                se.initCause(ioe);
                throw se;
            }
        }
    }

    Xid getXidFromFile(FileStoreInputStream in, String fileName) throws IOException, Store.StoreException {
        int firstLineType = in.nextLineType();
        if (firstLineType != 2) {
            if (firstLineType == -1) {
                throw new Store.StoreException(fileName + " is empty.");
            }
            throw new Store.StoreException(fileName + " is corrupt as it does not contain a transaction record.");
        }
        return in.readXid();
    }

    String getTypeFromFile(FileStoreInputStream in, String fileName) throws IOException, Store.StoreException {
        return in.readTransactionType();
    }
}

