/*
 * Decompiled with CFR 0.152.
 */
package oracle.as.j2ee.transaction.tpc;

import java.sql.SQLException;
import oracle.as.j2ee.transaction.tpc.DatabaseStore;
import oracle.as.j2ee.transaction.tpc.DatabaseStoreConnection;
import oracle.as.j2ee.transaction.tpc.Store;
import oracle.j2ee.transaction.TransactionMessages;

public class DatabaseStoreBatchWriter
implements Runnable {
    DatabaseStore m_store;
    DatabaseStoreConnection m_conn;
    final Object m_lock;
    long m_batchInterval;
    static final int CANCELLED = -1;

    DatabaseStoreBatchWriter(Object lock, long batchInterval, DatabaseStore store) {
        this.m_lock = lock;
        this.m_batchInterval = batchInterval;
        this.m_store = store;
    }

    void setDatabaseStoreConnection(DatabaseStoreConnection conn) {
        this.m_conn = conn;
    }

    void setBatchInterval(int batchInterval) {
        this.m_batchInterval = batchInterval;
    }

    public void run() {
        while (this.m_batchInterval != -1L) {
            this.executeBatch();
            try {
                if (this.m_batchInterval == -1L) continue;
                Thread.sleep(this.m_batchInterval);
            }
            catch (InterruptedException ee) {
                TransactionMessages.severe("InterruptedException during " + this.m_conn.getDescription() + " to database store." + "\nThe store will be unable to write to log," + " server restart will be necessary to log new transactions : " + ee);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel() {
        Object object = this.m_lock;
        synchronized (object) {
            this.m_batchInterval = -1L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void executeBatch() {
        try {
            Object object = this.m_lock;
            synchronized (object) {
                boolean isTimeToCommitNoteTransactionAndWorkIsConducted;
                if (TransactionMessages.isLevelFinest()) {
                    TransactionMessages.finest("Begin database store " + this.m_conn.getDescription() + " execute batch check, time : " + System.currentTimeMillis());
                }
                boolean bl = isTimeToCommitNoteTransactionAndWorkIsConducted = this.m_conn.getLastBatchExecuteTime() + this.m_batchInterval < System.currentTimeMillis() && this.m_conn.isWorkConducted();
                if (!isTimeToCommitNoteTransactionAndWorkIsConducted) {
                    return;
                }
                long timeForExecuteBranchStart = 0L;
                if (TransactionMessages.isLevelFinest()) {
                    timeForExecuteBranchStart = System.currentTimeMillis();
                    TransactionMessages.finest("Starting database store " + this.m_conn.getDescription() + " execute batch as work is conducted, time : " + timeForExecuteBranchStart);
                }
                this.m_conn.executeBatches();
                this.m_conn.setWorkConducted(false);
                if (TransactionMessages.isLevelFinest()) {
                    long timeForExecuteBranchEnd = System.currentTimeMillis();
                    TransactionMessages.finest("Finished database store " + this.m_conn.getDescription() + " execute batch and about to notify, time : " + timeForExecuteBranchEnd + " total time : " + (timeForExecuteBranchEnd - timeForExecuteBranchStart));
                }
                this.m_lock.notifyAll();
            }
        }
        catch (SQLException ee) {
            String msg = "SQLException during " + this.m_conn.getDescription() + " to database store." + "\nThe store will attempt to recreate connections, however," + " server restart may be necessary to log new transactions : " + ee;
            TransactionMessages.warning(msg);
            this.attemptToRecoverDatabaseStore();
        }
    }

    private void attemptToRecoverDatabaseStore() {
        boolean isConnRecoverySuccessful = false;
        while (!isConnRecoverySuccessful) {
            try {
                Thread.sleep(this.m_store.m_waitTimeout + 10000L);
                try {
                    this.m_store.recoverConnection(this.m_conn.getDescription());
                    isConnRecoverySuccessful = true;
                }
                catch (SQLException e) {
                    TransactionMessages.warning("Failure in database store logging of transaction logs.  Attempt to recover was unsuccessful and will be reattempted: " + e);
                }
                catch (Store.StoreException e) {
                    TransactionMessages.warning("Failure in database store logging of transaction logs.  Attempt to recover was unsuccessful and will be reattempted: " + e);
                }
            }
            catch (InterruptedException ee) {
                String msg = "Attempt to recover database store interrupted\nThe store will be unable to write to log, server restart may be necessary to log new transactions : " + ee;
                TransactionMessages.warning(msg);
            }
        }
    }
}

