/*
 * Decompiled with CFR 0.152.
 */
package oracle.as.j2ee.transaction.tpc;

import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import javax.naming.Context;
import javax.naming.NamingException;
import javax.sql.DataSource;
import javax.transaction.xa.Xid;
import oracle.as.j2ee.transaction.MiddleTierCoordinatorConfiguration;
import oracle.as.j2ee.transaction.propagation.ParentReference;
import oracle.as.j2ee.transaction.tpc.Branch;
import oracle.as.j2ee.transaction.tpc.DatabaseStoreBatchWriter;
import oracle.as.j2ee.transaction.tpc.DatabaseStoreConnection;
import oracle.as.j2ee.transaction.tpc.GlobalTransaction;
import oracle.as.j2ee.transaction.tpc.NormalXid;
import oracle.as.j2ee.transaction.tpc.RMId;
import oracle.as.j2ee.transaction.tpc.RecoveredRMId;
import oracle.as.j2ee.transaction.tpc.Store;
import oracle.as.j2ee.transaction.tpc.recovery.RecoveringTransactionInfo;
import oracle.j2ee.transaction.TransactionMessages;
import oracle.jdbc.driver.OracleDriver;
import oracle.jdbc.pool.OracleDataSource;
import oracle.oc4j.sql.ManagedDataSource;

public class DatabaseStore
extends Store {
    DatabaseStoreConnection m_noteTransactionConnection;
    DatabaseStoreConnection m_noteStateConnection;
    DatabaseStoreConnection m_noteForgetConnection;
    Connection m_noteRecoverConnection;
    final Object m_noteTransactionLock = new Object();
    final Object m_noteStateLock = new Object();
    final Object m_noteForgetLock = new Object();
    final Object m_noteRecoverLock = new Object();
    private String m_lookupName;
    private Context m_context;
    private DataSource m_dataSource;
    private String m_userName;
    private String m_passWord;
    private static final byte[] NULL_BRANCH_QUAL = new byte[65];
    long m_waitTimeout = new Integer(System.getProperty("transaction.databasestore.maxwait", "30000")).intValue();
    private boolean m_isOldSchema = false;
    private static final String TXTABLENAME_OLD = "OC4J_TRANSACTION";
    private static final String TXTABLENAME = "OC4J_TX";
    private static final String BRANCHTABLENAME_OLD = "OC4J_BRANCH";
    private static final String BRANCHTABLENAME = "OC4J_TX_BRANCH";
    private static final String LOCKTABLENAME = "OC4J_TX_LOCK";
    private static final String RESOURCESTABLENAME = "OC4J_RESOURCES";
    private static final String TID = "TID";
    private static final String FORMATID = "FORMATID";
    private static final String BRANCHQUAL = "BRANCHQUAL";
    private static final String PARENTBRANCHQUAL = "PARENTBRANCHQUAL";
    private static final String STATE = "STATE";
    private static final String JNDINAME = "JNDINAME";
    private static final String ARG = "ARG";
    private static final String PARENTREF_PROTOCOL = "PARENTREF_PROTOCOL";
    private static final String PARENTREF_ENDPOINT = "PARENTREF_ENDPOINT";
    private static final String INSTANCE = "INSTANCE";
    private static final String TYPE = "TYPE";
    private static final String RLRCNAME = "RLRCNAME";
    private String insertTxSQL;
    private String updateTxSQL;
    private String deleteTxSQL;
    private String selectTxForInstanceSQL;
    private String selectTxForTidSQL;
    private String insertResourceSQL;
    private String selectResourceSQL;
    private String purgeResourcesSQL;
    private PreparedStatement m_txInsertStmt;
    private PreparedStatement m_branchInsertStmt;
    private PreparedStatement m_txUpdateStmt;
    private PreparedStatement m_txDeleteStmt;
    private PreparedStatement m_txSelectTxForInstanceStmt;
    private PreparedStatement m_selectBranchesForXidStmt;
    private PreparedStatement m_selectForXidStmt;
    private PreparedStatement m_insertResourceStmt;
    private PreparedStatement m_selectResourcesStmt;
    private PreparedStatement m_purgeResourcesStmt;
    private String insertBranchSQL;
    private String selectBranchSQL;
    private DatabaseStoreBatchWriter m_batchTransactionWriter;
    private DatabaseStoreBatchWriter m_batchStateWriter;
    private DatabaseStoreBatchWriter m_batchForgetWriter;
    private String m_offlineUpdateServerId;
    private static final String NOTE_FORGET = "note forget";
    private static final String NOTE_STATE = "note state";
    private static final String NOTE_TRANSACTION = "note transaction";

    public DatabaseStore(MiddleTierCoordinatorConfiguration config, Context ctx, String serverId) throws Store.StoreException {
        super(serverId);
        this.m_context = ctx;
        this.m_lookupName = config.getLocation();
        this.m_userName = config.getUserName();
        this.m_passWord = config.getPassword();
        this.setConnsAndStmts(this.getValidDataSource(), config);
    }

    public DatabaseStore(String location, String username, String password) throws Store.StoreException {
        super("*");
        this.m_offlineUpdateServerId = "*";
        try {
            DriverManager.registerDriver((Driver)new OracleDriver());
            this.m_noteRecoverConnection = DriverManager.getConnection(location, username, password);
            this.determineSchemaVersionAndExistingRecordCount(this.m_noteRecoverConnection);
            this.setTxSQLForTableName();
            this.createRecoverStmts();
        }
        catch (SQLException e) {
            Store.StoreException storeEx = new Store.StoreException("Error creating database store");
            storeEx.initCause(e);
            throw storeEx;
        }
    }

    void lockStore() throws Store.StoreException {
        try {
            if (!this.m_noteRecoverConnection.prepareStatement("select instance from OC4J_TX_LOCK  where INSTANCE  = '" + this.serverId() + "' for update of instance nowait").executeQuery().next()) {
                TransactionMessages.finer("Creating lock for transaction store as one does not exist");
                this.m_noteRecoverConnection.prepareStatement("insert into OC4J_TX_LOCK values ('" + this.serverId() + "')").execute();
                this.m_noteRecoverConnection.prepareStatement("select instance from OC4J_TX_LOCK  where INSTANCE  = '" + this.serverId() + "' for update of instance nowait").execute();
            } else {
                TransactionMessages.finer("Lock for transaction store exists");
            }
        }
        catch (SQLException e) {
            Store.StoreException storeException = new Store.StoreException("SQLException occurred while locking database store.  Peer recovery may be in process");
            storeException.initCause(e);
            throw storeException;
        }
    }

    boolean recoverPeer() throws Store.StoreException {
        try {
            ResultSet locksResultSet = this.m_noteRecoverConnection.prepareCall("select INSTANCE from OC4J_TX_LOCK").executeQuery();
            String instanceToRecover = null;
            String instanceString = null;
            while (locksResultSet.next()) {
                try {
                    instanceString = locksResultSet.getString(INSTANCE);
                    if (instanceString.equals(this.serverId())) continue;
                    this.m_noteRecoverConnection.prepareCall("select instance from OC4J_TX_LOCK where INSTANCE  = '" + instanceString + "' for update of instance nowait").execute();
                    instanceToRecover = instanceString;
                    break;
                }
                catch (SQLException e) {
                    TransactionMessages.finest("Peer " + instanceString + " is locked");
                }
            }
            if (instanceToRecover != null) {
                String sql = "update OC4J_TX set INSTANCE = '" + this.serverId() + "' where " + INSTANCE + " = '" + instanceToRecover + "'";
                TransactionMessages.finer("Peer " + instanceString + " is not locked.  This server will attempt to recovery it's transactions");
                this.m_noteRecoverConnection.prepareCall(sql).execute();
                return true;
            }
        }
        catch (SQLException e) {
            Store.StoreException storeException = new Store.StoreException("Exception while detecting or recovering peer");
            storeException.initCause(e);
            throw storeException;
        }
        return false;
    }

    void setServerId(String updateServerId) {
        this.m_offlineUpdateServerId = updateServerId;
    }

    String serverId() {
        if (this.m_offlineUpdateServerId == null) {
            return super.serverId();
        }
        return this.m_offlineUpdateServerId;
    }

    long getWaitTimeout() {
        return this.m_waitTimeout;
    }

    boolean providesDurability() {
        return true;
    }

    private DataSource getValidDataSource() throws Store.StoreException {
        if (this.getLogLocation() == null) {
            throw new Store.StoreException("Lookup name not set");
        }
        try {
            this.m_dataSource = (DataSource)this.m_context.lookup(this.getLogLocation());
            if (this.m_dataSource instanceof ManagedDataSource) {
                throw new Store.StoreException(TransactionMessages.logAndReturnMessage(Level.SEVERE, "Datasource specified for transaction logging must be an Oracle native-data-source, not a managed-data-source : " + this.getLogLocation()));
            }
            if (!(this.m_dataSource instanceof OracleDataSource)) {
                throw new Store.StoreException(TransactionMessages.logAndReturnMessage(Level.SEVERE, "Datasource specified for transaction logging is a native-data-source :  but is not an Oracle datasource : " + this.getLogLocation()));
            }
            return this.m_dataSource;
        }
        catch (NamingException e) {
            String msg = "Datasource lookup failed for " + this.getLogLocation();
            TransactionMessages.severe(msg);
            Store.StoreException se = new Store.StoreException(msg);
            se.initCause(e);
            throw se;
        }
    }

    void setConnsAndStmts(DataSource dataSource, MiddleTierCoordinatorConfiguration config) throws Store.StoreException {
        try {
            Connection connection = this.getConnection();
            this.determineSchemaVersionAndExistingRecordCount(connection);
            this.setTxSQLForTableName();
            this.m_batchTransactionWriter = new DatabaseStoreBatchWriter(this.m_noteTransactionLock, config.getBatchCreateInterval(), this);
            this.createAndSetNoteTxConnAndStmts(connection);
            Thread thread = new Thread((Runnable)this.m_batchTransactionWriter, "2PC_DatabaseStoreBatchTransactionWriterThread");
            thread.setDaemon(true);
            thread.start();
            this.m_batchStateWriter = new DatabaseStoreBatchWriter(this.m_noteStateLock, config.getBatchStateInterval(), this);
            this.createAndSetNoteStateConnAndStmts();
            Thread thread2 = new Thread((Runnable)this.m_batchStateWriter, "2PC_DatabaseStoreBatchStateWriterThread");
            thread2.setDaemon(true);
            thread2.start();
            this.m_batchForgetWriter = new DatabaseStoreBatchWriter(this.m_noteForgetLock, config.getBatchPurgeInterval(), this);
            this.createAndSetForgetTxConnAndStmts();
            Thread thread3 = new Thread((Runnable)this.m_batchForgetWriter, "2PC_DatabaseStoreBatchForgetWriterThread");
            thread3.setDaemon(true);
            thread3.start();
            this.createAndSetRecoverConnAndStmts();
        }
        catch (SQLException sqle) {
            Store.StoreException se = new Store.StoreException("Initialization of connections for database store failed for " + this.getLogLocation());
            se.initCause(sqle);
            throw se;
        }
    }

    void recoverConnection(String connType) throws SQLException, Store.StoreException {
        if (connType.equals(NOTE_TRANSACTION)) {
            this.createAndSetNoteTxConnAndStmts(null);
        } else if (connType.equals(NOTE_STATE)) {
            this.createAndSetNoteStateConnAndStmts();
        } else if (connType.equals(NOTE_FORGET)) {
            this.createAndSetForgetTxConnAndStmts();
        }
    }

    private void createAndSetRecoverConnAndStmts() throws SQLException, Store.StoreException {
        this.m_noteRecoverConnection = this.getConnection();
        TransactionMessages.finer("Database store : recover connection created");
        this.createRecoverStmts();
    }

    private void createAndSetForgetTxConnAndStmts() throws SQLException, Store.StoreException {
        this.m_noteForgetConnection = new DatabaseStoreConnection(this.getConnection(), NOTE_FORGET);
        this.m_txDeleteStmt = this.m_noteForgetConnection.prepareStatement(this.deleteTxSQL);
        this.m_batchForgetWriter.setDatabaseStoreConnection(this.m_noteForgetConnection);
    }

    private void createAndSetNoteStateConnAndStmts() throws SQLException, Store.StoreException {
        this.m_noteStateConnection = new DatabaseStoreConnection(this.getConnection(), NOTE_STATE);
        this.m_txUpdateStmt = this.m_noteStateConnection.prepareStatement(this.updateTxSQL);
        this.m_batchStateWriter.setDatabaseStoreConnection(this.m_noteStateConnection);
    }

    private void createAndSetNoteTxConnAndStmts(Connection connection) throws SQLException, Store.StoreException {
        this.m_noteTransactionConnection = new DatabaseStoreConnection(connection != null ? connection : this.getConnection(), NOTE_TRANSACTION);
        this.m_txInsertStmt = this.m_noteTransactionConnection.prepareStatement(this.insertTxSQL);
        this.m_branchInsertStmt = this.m_noteTransactionConnection.prepareStatement(this.insertBranchSQL);
        this.m_batchTransactionWriter.setDatabaseStoreConnection(this.m_noteTransactionConnection);
    }

    private void determineSchemaVersionAndExistingRecordCount(Connection connection) throws Store.StoreException {
        int count = -1;
        try {
            count = this.getTxRecordCount(connection, TXTABLENAME);
        }
        catch (SQLException sqle) {
            // empty catch block
        }
        try {
            if (count == -1) {
                count = this.getTxRecordCount(connection, TXTABLENAME_OLD);
                this.m_isOldSchema = true;
                TransactionMessages.warning("Current database store sql schema not found, using old schema.  Schema must be updated in order to use all administrative features");
            }
        }
        catch (SQLException sqle) {
            Store.StoreException se = new Store.StoreException("Database store sql schema not found for" + this.getLogLocation() + "See documentation for required setup details.");
            se.initCause(sqle);
            throw se;
        }
        TransactionMessages.finer("Database store initialized.  Existing transaction record count : " + count);
    }

    private void setTxSQLForTableName() {
        String txtableName = this.m_isOldSchema ? TXTABLENAME_OLD : TXTABLENAME;
        this.insertTxSQL = "INSERT INTO " + txtableName + " ( " + TID + ", " + FORMATID + ", " + BRANCHQUAL + ", " + STATE + ", " + PARENTREF_PROTOCOL + ", " + PARENTREF_ENDPOINT + ", " + INSTANCE + (this.m_isOldSchema ? "" : ", TYPE") + " ) VALUES ( ?, ?, ?, ?, ?, ?, ?" + (this.m_isOldSchema ? "" : ", ?") + " )";
        this.updateTxSQL = "UPDATE " + txtableName + " SET " + STATE + " = ?  WHERE " + TID + " = ? AND " + FORMATID + " = ? AND " + BRANCHQUAL + " = ?";
        this.deleteTxSQL = "DELETE FROM " + txtableName + " WHERE " + TID + " = ? AND " + FORMATID + " = ? AND " + BRANCHQUAL + " = ?";
        boolean isOfflineUpdateServerIdAll = this.m_offlineUpdateServerId != null && this.m_offlineUpdateServerId.equals("*");
        this.selectTxForInstanceSQL = "SELECT TID, FORMATID, BRANCHQUAL, STATE, PARENTREF_PROTOCOL, PARENTREF_ENDPOINT" + (this.m_isOldSchema ? "" : ", TYPE") + (isOfflineUpdateServerIdAll ? ", INSTANCE" : "") + " FROM " + txtableName + (isOfflineUpdateServerIdAll ? "" : " WHERE INSTANCE = ? ");
        this.selectTxForTidSQL = "SELECT PARENTREF_PROTOCOL, PARENTREF_ENDPOINT" + (this.m_isOldSchema ? "" : ", TYPE") + ", STATE FROM " + txtableName + " WHERE " + TID + " =  ? AND " + FORMATID + " = ? AND " + BRANCHQUAL + " = ?";
        String branchTableName = this.m_isOldSchema ? BRANCHTABLENAME_OLD : BRANCHTABLENAME;
        this.insertBranchSQL = "INSERT INTO " + branchTableName + " ( " + TID + ", " + FORMATID + ", " + PARENTBRANCHQUAL + ", " + BRANCHQUAL + ", " + JNDINAME + ", " + ARG + " ) " + "VALUES ( ?, ?, ?, ?, ?, ? )";
        this.selectBranchSQL = "SELECT * FROM " + branchTableName + " WHERE " + TID + " = ? AND " + FORMATID + " = ? AND " + PARENTBRANCHQUAL + " = ?";
        this.insertResourceSQL = "INSERT INTO OC4J_RESOURCES ( INSTANCE, JNDINAME, ARG, RLRCNAME ) VALUES ( ?, ?, ?, ? )";
        this.selectResourceSQL = "SELECT * FROM OC4J_RESOURCES WHERE INSTANCE = ?";
        this.purgeResourcesSQL = "DELETE FROM OC4J_RESOURCES WHERE INSTANCE = ?";
    }

    private int getTxRecordCount(Connection connection, String tablename) throws SQLException {
        Statement stmt = connection.createStatement();
        ResultSet rs = stmt.executeQuery("select count(*) from " + tablename);
        rs.next();
        int rows = -1;
        rows = rs.getInt(1);
        rs.close();
        stmt.close();
        return rows;
    }

    private void createRecoverStmts() throws SQLException {
        this.m_txSelectTxForInstanceStmt = this.m_noteRecoverConnection.prepareStatement(this.selectTxForInstanceSQL);
        this.m_selectBranchesForXidStmt = this.m_noteRecoverConnection.prepareStatement(this.selectBranchSQL);
        this.m_selectForXidStmt = this.m_noteRecoverConnection.prepareStatement(this.selectTxForTidSQL);
        this.m_insertResourceStmt = this.m_noteRecoverConnection.prepareStatement(this.insertResourceSQL);
        this.m_selectResourcesStmt = this.m_noteRecoverConnection.prepareStatement(this.selectResourceSQL);
        this.m_purgeResourcesStmt = this.m_noteRecoverConnection.prepareStatement(this.purgeResourcesSQL);
    }

    private Connection getConnection() throws SQLException, Store.StoreException {
        if (this.m_userName != null && !this.m_userName.equals("")) {
            return this.m_dataSource.getConnection(this.m_userName, this.m_passWord);
        }
        Connection connection = this.m_dataSource.getConnection();
        if (connection != null) {
            return connection;
        }
        throw new Store.StoreException("Failed to create database store as connection was null.");
    }

    public String getLogLocation() {
        return this.m_lookupName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void noteTransaction(GlobalTransaction transaction, int newState) throws Store.StoreException {
        try {
            Object object = this.m_noteTransactionLock;
            synchronized (object) {
                this.insertTransaction(transaction, newState);
                this.m_noteTransactionConnection.setWorkConducted(true);
                try {
                    long timeBeforeWaiting = System.currentTimeMillis();
                    this.m_noteTransactionLock.wait(this.m_waitTimeout);
                    if (System.currentTimeMillis() >= timeBeforeWaiting + this.m_waitTimeout) {
                        throw new Store.StoreException("Timed-out while waiting for transaction entry to be inserted, see log for details");
                    }
                }
                catch (InterruptedException e) {
                    Store.StoreException se = new Store.StoreException("Interrupted while waiting for transaction entry to be inserted");
                    se.initCause(e);
                    throw se;
                }
            }
        }
        catch (SQLException e) {
            Store.StoreException se = new Store.StoreException("Cannot insert transaction due to SQLException : " + e);
            se.initCause(e);
            throw se;
        }
    }

    private void insertTransaction(GlobalTransaction transaction, int newState) throws SQLException, Store.StoreException {
        this.m_txInsertStmt.setBytes(1, transaction.getXid().getGlobalTransactionId());
        this.m_txInsertStmt.setInt(2, transaction.getXid().getFormatId());
        this.m_txInsertStmt.setBytes(3, this.mediateNullInXid(transaction.getXid().getBranchQualifier()));
        this.m_txInsertStmt.setInt(4, newState);
        ParentReference parentReference = transaction.getParentReference();
        this.m_txInsertStmt.setString(5, parentReference == null ? null : parentReference.getProtocol());
        this.m_txInsertStmt.setString(6, parentReference == null ? null : parentReference.getEndpoint());
        this.m_txInsertStmt.setString(7, this.serverId());
        if (!this.m_isOldSchema) {
            this.m_txInsertStmt.setString(8, transaction.getType());
        }
        this.m_txInsertStmt.addBatch();
        this.noteBranches(transaction);
    }

    private void noteBranches(GlobalTransaction transaction) throws Store.StoreException {
        try {
            for (int xBranch = 0; xBranch < transaction.numberOfBranches(); ++xBranch) {
                Branch branch = transaction.getBranch(xBranch);
                if (!branch.supportsRecovery()) continue;
                this.setBranchInsertStatement(branch);
                this.m_branchInsertStmt.addBatch();
            }
        }
        catch (SQLException e) {
            Store.StoreException se = new Store.StoreException("Cannot writeParentReference managers");
            se.initCause(e);
            throw se;
        }
    }

    private void setBranchInsertStatement(Branch branch) throws SQLException, Store.StoreException {
        RMId rmId = branch.getRmId();
        DatabaseStore.validateRMId(rmId, branch);
        this.m_branchInsertStmt.setBytes(1, branch.getXid().getGlobalTransactionId());
        this.m_branchInsertStmt.setInt(2, branch.getXid().getFormatId());
        this.m_branchInsertStmt.setBytes(3, this.mediateNullInXid(branch.getTransaction().getXid().getBranchQualifier()));
        this.m_branchInsertStmt.setBytes(4, branch.getXid().getBranchQualifier());
        this.m_branchInsertStmt.setString(5, rmId.getRMFactoryJndiLocation().getJndiLocation());
        this.m_branchInsertStmt.setString(6, rmId.getRMFactoryArg());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void noteState(GlobalTransaction transaction, int state) throws Store.StoreException {
        try {
            Object object = this.m_noteStateLock;
            synchronized (object) {
                this.updateTransaction(transaction, state);
                this.m_noteStateConnection.setWorkConducted(true);
                try {
                    long timeBeforeWaiting = System.currentTimeMillis();
                    this.m_noteStateLock.wait(this.m_waitTimeout);
                    if (System.currentTimeMillis() > timeBeforeWaiting + this.m_waitTimeout) {
                        throw new Store.StoreException("Timed-out while waiting for transaction state to be updated, see log for details");
                    }
                }
                catch (InterruptedException e) {
                    Store.StoreException se = new Store.StoreException("Interrupted while waiting for transaction state to be updated");
                    se.initCause(e);
                    throw se;
                }
            }
        }
        catch (SQLException e) {
            Store.StoreException se = new Store.StoreException("Could not find transaction log for " + transaction);
            se.initCause(e);
            throw se;
        }
    }

    private void updateTransaction(GlobalTransaction transaction, int state) throws SQLException {
        this.m_txUpdateStmt.setInt(1, state);
        this.m_txUpdateStmt.setBytes(2, transaction.getXid().getGlobalTransactionId());
        this.m_txUpdateStmt.setInt(3, transaction.getXid().getFormatId());
        this.m_txUpdateStmt.setBytes(4, this.mediateNullInXid(transaction.getXid().getBranchQualifier()));
        this.m_txUpdateStmt.addBatch();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void noteForget(GlobalTransaction transaction) throws Store.StoreException {
        try {
            Object object = this.m_noteForgetLock;
            synchronized (object) {
                this.deleteTransaction(transaction);
                this.m_noteForgetConnection.setWorkConducted(true);
            }
        }
        catch (SQLException e) {
            Store.StoreException se = new Store.StoreException("Database error deleting " + transaction);
            se.initCause(e);
            throw se;
        }
    }

    private void deleteTransaction(GlobalTransaction transaction) throws SQLException {
        this.m_txDeleteStmt.setBytes(1, transaction.getXid().getGlobalTransactionId());
        this.m_txDeleteStmt.setInt(2, transaction.getXid().getFormatId());
        this.m_txDeleteStmt.setBytes(3, this.mediateNullInXid(transaction.getXid().getBranchQualifier()));
        this.m_txDeleteStmt.addBatch();
    }

    public String toString() {
        return "Database Store using " + this.getLogLocation();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void noteResource(RMId rmid, String rlrcName) throws Store.StoreException {
        Object object = this.m_noteRecoverLock;
        synchronized (object) {
            try {
                this.m_insertResourceStmt.setString(1, this.serverId());
                this.m_insertResourceStmt.setString(2, rmid.getRMFactoryJndiLocation().getJndiLocation());
                this.m_insertResourceStmt.setString(3, rmid.getRMFactoryArg());
                this.m_insertResourceStmt.setString(4, rlrcName);
                this.m_insertResourceStmt.execute();
            }
            catch (SQLException e) {
                Store.StoreException storeException = new Store.StoreException("SQLException while noting resource : " + rmid.getRMFactoryJndiLocation().getJndiLocation());
                storeException.initCause(e);
                throw storeException;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List recover() throws Store.StoreException {
        Object object = this.m_noteRecoverLock;
        synchronized (object) {
            LinkedList<GlobalTransaction> list = new LinkedList<GlobalTransaction>();
            try {
                if (this.m_offlineUpdateServerId == null || !this.m_offlineUpdateServerId.equals("*")) {
                    this.m_txSelectTxForInstanceStmt.setString(1, this.serverId());
                }
                ResultSet results = this.m_txSelectTxForInstanceStmt.executeQuery();
                while (results.next()) {
                    GlobalTransaction tx = this.createGlobalTransaction(results);
                    this.buildBranchesForRecovery(tx);
                    list.add(tx);
                }
            }
            catch (SQLException e) {
                Store.StoreException se = new Store.StoreException("Database error during recover:" + e);
                se.initCause(e);
                throw se;
            }
            return list;
        }
    }

    public GlobalTransaction recover(Xid xid) throws Store.StoreException {
        Object object = this.m_noteRecoverLock;
        synchronized (object) {
            try {
                ResultSet results = this.executeRecoveryQuery(xid);
                if (!results.next()) {
                    throw new Store.StoreException("Transaction unknown");
                }
                if (this.m_offlineUpdateServerId != null) {
                    this.setServerId(results.getString(INSTANCE));
                }
                GlobalTransaction tx = new GlobalTransaction(this, xid, results.getInt(STATE), this.getParentReference(results));
                if (!this.m_isOldSchema) {
                    tx.setType(results.getString(TYPE));
                }
                this.buildBranchesForRecovery(tx);
                return tx;
            }
            catch (SQLException e) {
                Store.StoreException se = new Store.StoreException("Error in recovery");
                se.initCause(e);
                throw se;
            }
        }
    }

    List getRecoveringRMIds() throws Store.StoreException {
        LinkedList<RecoveredRMId> rmIdList = new LinkedList<RecoveredRMId>();
        try {
            this.m_selectResourcesStmt.setString(1, this.serverId());
            ResultSet resultSet = this.m_selectResourcesStmt.executeQuery();
            while (resultSet.next()) {
                RecoveredRMId recoveredRMId = new RecoveredRMId(resultSet.getString(2), resultSet.getString(3), resultSet.getString(4));
                rmIdList.add(recoveredRMId);
                this.rmIdJndiLocations.add(recoveredRMId.getRMFactoryJndiLocation().getJndiLocation() + recoveredRMId.getRLRCLocation() == null ? "" : recoveredRMId.getRLRCLocation());
            }
        }
        catch (SQLException e) {
            Store.StoreException storeException = new Store.StoreException("SQLException occurred while getting Recovering RMIds : " + e);
            storeException.initCause(e);
            throw storeException;
        }
        return rmIdList;
    }

    public RecoveringTransactionInfo getRecoveringTransactionInfo() throws Store.StoreException {
        return new RecoveringTransactionInfo(this.recover(), this.getRecoveringRMIds());
    }

    private ParentReference getParentReference(ResultSet results) throws SQLException {
        String parentrefProtocol = results.getString(PARENTREF_PROTOCOL);
        if (parentrefProtocol != null) {
            return new ParentReference(parentrefProtocol, results.getString(PARENTREF_ENDPOINT));
        }
        return null;
    }

    private ResultSet executeRecoveryQuery(Xid xid) throws SQLException {
        this.m_selectForXidStmt.setBytes(1, xid.getGlobalTransactionId());
        this.m_selectForXidStmt.setInt(2, xid.getFormatId());
        this.m_selectForXidStmt.setBytes(3, this.mediateNullInXid(xid.getBranchQualifier()));
        return this.m_selectForXidStmt.executeQuery();
    }

    private void buildBranchesForRecovery(GlobalTransaction transaction) throws SQLException {
        this.m_selectBranchesForXidStmt.setBytes(1, transaction.getXid().getGlobalTransactionId());
        this.m_selectBranchesForXidStmt.setInt(2, transaction.getXid().getFormatId());
        this.m_selectBranchesForXidStmt.setBytes(3, this.mediateNullInXid(transaction.getXid().getBranchQualifier()));
        ResultSet results = this.m_selectBranchesForXidStmt.executeQuery();
        while (results.next()) {
            NormalXid xid = new NormalXid(transaction.getXid().getGlobalTransactionId(), results.getInt(FORMATID), this.mediateNullInDatabase(results.getBytes(BRANCHQUAL)));
            RecoveredRMId recoveredRMId = new RecoveredRMId(results.getString(JNDINAME), results.getString(ARG), null);
            transaction.addBranch(null, xid, recoveredRMId, 0);
        }
    }

    private GlobalTransaction createGlobalTransaction(ResultSet results) throws SQLException {
        byte[] tid = results.getBytes(TID);
        int formatId = results.getInt(FORMATID);
        byte[] branchQualifier = this.mediateNullInDatabase(results.getBytes(BRANCHQUAL));
        GlobalTransaction tx = new GlobalTransaction(this, new NormalXid(tid, formatId, branchQualifier));
        tx.setTransactionState(results.getInt(STATE));
        tx.setParentReference(this.getParentReference(results));
        if (!this.m_isOldSchema) {
            tx.setType(results.getString(TYPE) + (this.m_offlineUpdateServerId != null && this.m_offlineUpdateServerId.equals("*") ? " " + results.getString(INSTANCE) : ""));
        }
        return tx;
    }

    private byte[] mediateNullInXid(byte[] branchQualifier) {
        if (branchQualifier.length == 0) {
            return NULL_BRANCH_QUAL;
        }
        return branchQualifier;
    }

    private byte[] mediateNullInDatabase(byte[] branchQualifier) {
        if (branchQualifier.length == 65 && branchQualifier[64] == 1) {
            return new byte[0];
        }
        return branchQualifier;
    }

    public boolean shutdown(boolean isClean) {
        try {
            TransactionMessages.finer("Shutting down database store");
            this.m_batchTransactionWriter.cancel();
            this.m_batchStateWriter.cancel();
            this.m_batchForgetWriter.cancel();
            if (this.m_noteTransactionConnection != null) {
                this.m_noteTransactionConnection.close();
                TransactionMessages.finer("Shutting down database store : closed note transaction connection");
            }
            if (this.m_noteStateConnection != null) {
                this.m_noteStateConnection.close();
                TransactionMessages.finer("Shutting down database store : closed note state connection");
            }
            if (this.m_noteForgetConnection != null) {
                this.m_noteForgetConnection.close();
                TransactionMessages.finer("Shutting down database store : closed note forget connection");
            }
            if (this.m_noteRecoverConnection != null) {
                this.m_purgeResourcesStmt.setString(1, this.serverId());
                this.m_purgeResourcesStmt.execute();
                TransactionMessages.finer("Shutting down database store : purged resource list");
                this.m_noteRecoverConnection.close();
                TransactionMessages.finer("Shutting down database store : closed recover connection");
            }
        }
        catch (SQLException sqlException) {
            TransactionMessages.warning("SQLException while shutting down database store : " + sqlException);
            return false;
        }
        return true;
    }

    static {
        Arrays.fill(NULL_BRANCH_QUAL, (byte)0);
        DatabaseStore.NULL_BRANCH_QUAL[64] = 1;
    }
}

