/*
 * Decompiled with CFR 0.152.
 */
package oracle.as.j2ee.transaction.recovery;

import com.evermind.server.ApplicationServerTransaction;
import com.evermind.server.ApplicationServerTransactionManager;
import com.evermind.server.ApplicationServerTransactionManagerAdmin;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import oracle.as.j2ee.transaction.recovery.BottomUpQueryHandler;
import oracle.j2ee.transaction.TransactionMessages;

public class BottomUpQueryCOR {
    private ApplicationServerTransactionManagerAdmin m_tm;
    List m_handlerChain = new LinkedList();

    public BottomUpQueryCOR(ApplicationServerTransactionManager tm) {
        this.m_tm = new ApplicationServerTransactionManagerAdmin(tm);
    }

    public void attemptQueries() {
        ApplicationServerTransaction[] txs = this.getCopyOfLongDurationInDoubts();
        this.matchTransactionsToQueryHandler(txs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void matchTransactionsToQueryHandler(ApplicationServerTransaction[] txs) {
        for (int i = 0; i < txs.length; ++i) {
            ApplicationServerTransaction applicationServerTransaction = txs[i];
            synchronized (applicationServerTransaction) {
                if (txs[i].getTransactionState() == 9) {
                    this.handleTransaction(txs[i]);
                } else {
                    this.m_tm.getLongDurationInDoubt().remove(txs[i]);
                }
                continue;
            }
        }
    }

    private ApplicationServerTransaction[] getCopyOfLongDurationInDoubts() {
        int length = this.m_tm.getLongDurationInDoubt().size();
        ApplicationServerTransaction[] txs = new ApplicationServerTransaction[length];
        txs = this.m_tm.getLongDurationInDoubt().toArray(txs);
        return txs;
    }

    private void handleTransaction(ApplicationServerTransaction tx) {
        Iterator iter = this.m_handlerChain.iterator();
        boolean handled = false;
        while (iter.hasNext()) {
            BottomUpQueryHandler b = (BottomUpQueryHandler)iter.next();
            if (!b.query(tx)) continue;
            handled = true;
            this.cleanup(tx);
            break;
        }
        if (!handled) {
            TransactionMessages.fineNoAppropriateProtocolHandler();
            this.cleanup(tx);
        }
    }

    private void cleanup(ApplicationServerTransaction tx) {
        this.m_tm.getLongDurationInDoubt().remove(tx);
    }

    public void registerHandler(BottomUpQueryHandler handler) {
        this.m_handlerChain.add(handler);
    }

    public boolean isEmpty() {
        return this.m_handlerChain.isEmpty();
    }
}

