/*
 * Decompiled with CFR 0.152.
 */
package oracle.as.j2ee.transaction;

import com.evermind.server.ApplicationServerTransaction;
import com.evermind.server.OracleTwoPhaseCommitDriver;
import com.evermind.server.TwoPhaseCommitProvider;
import javax.naming.Context;
import oracle.as.j2ee.transaction.CommitCoordinatorConfiguration;
import oracle.as.j2ee.transaction.CoordinatorCreationException;
import oracle.as.j2ee.transaction.InDbCoordinatorConfiguration;
import oracle.as.j2ee.transaction.MiddleTierCoordinatorConfiguration;
import oracle.as.j2ee.transaction.tpc.DatabaseStore;
import oracle.as.j2ee.transaction.tpc.MultiFileStore;
import oracle.as.j2ee.transaction.tpc.NullStore;
import oracle.as.j2ee.transaction.tpc.Store;
import oracle.as.j2ee.transaction.tpc.TwoPhaseCommitEngine;
import oracle.as.j2ee.transaction.tpc.recovery.RecoveryManager;

public class CommitCoordinatorFactory {
    private ConcreteCommitCoordinatorFactory m_concreteFactory;
    private boolean m_coordinatorSupportsLastResourceCommit = false;
    private boolean m_coordinatorDelegatesToDatabase = false;
    private RecoveryManager m_RecoveryManager = null;

    public CommitCoordinatorFactory(CommitCoordinatorConfiguration configuration, String serverId, Context ctx) throws CoordinatorCreationException {
        if (configuration instanceof MiddleTierCoordinatorConfiguration) {
            this.createMidTierCoordinator(configuration, serverId, ctx);
        } else if (configuration instanceof InDbCoordinatorConfiguration) {
            this.createDBCoordinator(configuration, serverId);
        } else {
            throw new CoordinatorCreationException("Invalid Commit Coordinator Configuration: " + configuration);
        }
    }

    public void setRecoveryManager(RecoveryManager recoveryManager) {
        this.m_RecoveryManager = recoveryManager;
    }

    private void createDBCoordinator(CommitCoordinatorConfiguration configuration, String serverId) {
        this.m_concreteFactory = new InDbConcreteFactory((InDbCoordinatorConfiguration)configuration, serverId);
        this.m_coordinatorDelegatesToDatabase = true;
    }

    private void createMidTierCoordinator(CommitCoordinatorConfiguration configuration, String serverId, Context ctx) throws CoordinatorCreationException {
        this.m_concreteFactory = new MiddleTierConcreteFactory((MiddleTierCoordinatorConfiguration)configuration, serverId, ctx);
    }

    public boolean coordinatorSupportsLastResourceCommit() {
        return this.m_coordinatorSupportsLastResourceCommit;
    }

    public boolean coordinatorDelegatesToDatabase() {
        return this.m_coordinatorDelegatesToDatabase;
    }

    public TwoPhaseCommitProvider createInstance(ApplicationServerTransaction tx) throws CoordinatorCreationException {
        return this.m_concreteFactory.createCommitCoordinator(tx);
    }

    public Store getStore() {
        return this.m_concreteFactory.getStore();
    }

    private class MiddleTierConcreteFactory
    implements ConcreteCommitCoordinatorFactory {
        private Store m_store;
        private int m_retryCount;

        private MiddleTierConcreteFactory(MiddleTierCoordinatorConfiguration configuration, String serverId, Context ctx) throws CoordinatorCreationException {
            this.createStore(configuration, serverId, ctx);
            this.m_retryCount = configuration.getRetryCount();
        }

        private void createStore(MiddleTierCoordinatorConfiguration configuration, String serverId, Context ctx) throws CoordinatorCreationException {
            switch (configuration.getLogType()) {
                case 0: {
                    this.createMultiFileStore(configuration, serverId);
                    CommitCoordinatorFactory.this.m_coordinatorSupportsLastResourceCommit = true;
                    break;
                }
                case 1: {
                    this.createDatabaseStore(configuration, serverId, ctx);
                    CommitCoordinatorFactory.this.m_coordinatorSupportsLastResourceCommit = true;
                    break;
                }
                case 2: {
                    this.createNullStore(serverId);
                    break;
                }
                default: {
                    throw new CoordinatorCreationException("Invalid log type " + configuration.getLogType());
                }
            }
        }

        private void createNullStore(String serverId) {
            this.m_store = new NullStore(serverId);
        }

        private void createMultiFileStore(MiddleTierCoordinatorConfiguration configuration, String serverId) throws CoordinatorCreationException {
            try {
                this.m_store = new MultiFileStore(configuration, serverId);
            }
            catch (Store.StoreException e) {
                this.throwCreationException(e, "Could not create the file store : " + e.getMessage());
            }
        }

        private void createDatabaseStore(MiddleTierCoordinatorConfiguration configuration, String serverId, Context ctx) throws CoordinatorCreationException {
            try {
                this.m_store = new DatabaseStore(configuration, ctx, serverId);
            }
            catch (Store.StoreException e) {
                this.throwCreationException(e, "Could not create the database store");
            }
        }

        private void throwCreationException(Exception e, String message) throws CoordinatorCreationException {
            CoordinatorCreationException ce = new CoordinatorCreationException(message);
            ce.initCause(e);
            throw ce;
        }

        public TwoPhaseCommitProvider createCommitCoordinator(ApplicationServerTransaction tx) throws CoordinatorCreationException {
            return new TwoPhaseCommitEngine(tx.getXid(), this.m_store, CommitCoordinatorFactory.this.m_RecoveryManager, this.m_retryCount, tx.isParticipantRecoverable(), tx.getType());
        }

        public Store getStore() {
            return this.m_store;
        }
    }

    private class InDbConcreteFactory
    implements ConcreteCommitCoordinatorFactory {
        private Store m_store;
        private String m_jndiLocation;
        private String m_userName;
        private String m_password;

        private InDbConcreteFactory(InDbCoordinatorConfiguration config, String serverId) {
            this.m_store = new NullStore(serverId);
            this.m_jndiLocation = config.getLocation();
            this.m_userName = config.getUserName();
            this.m_password = config.getPassword();
        }

        public TwoPhaseCommitProvider createCommitCoordinator(ApplicationServerTransaction tx) throws CoordinatorCreationException {
            OracleTwoPhaseCommitDriver coord = new OracleTwoPhaseCommitDriver();
            coord.setJndiName(this.m_jndiLocation);
            if (this.m_userName != null && this.m_password != null) {
                coord.setUserName(this.m_userName);
                coord.setPassword(this.m_password);
            }
            coord.setTransactionHandle(tx);
            return coord;
        }

        public Store getStore() {
            return this.m_store;
        }
    }

    private static interface ConcreteCommitCoordinatorFactory {
        public TwoPhaseCommitProvider createCommitCoordinator(ApplicationServerTransaction var1) throws CoordinatorCreationException;

        public Store getStore();
    }
}

