/*
 * Decompiled with CFR 0.152.
 */
package oracle.anubis.handlers.socket;

import java.io.FileInputStream;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;

public class SSLConfiguration {
    String keyStoreType = "JKS";
    String keyStoreFile;
    String password;
    String algorithm = "sunx509";
    String protocol = "TLS";

    public String getAlgorithm() {
        return this.algorithm;
    }

    public void setAlgorithm(String algorithm) {
        this.algorithm = algorithm;
    }

    public String getKeyStoreFile() {
        return this.keyStoreFile;
    }

    public void setKeyStoreFile(String keyStoreFile) {
        this.keyStoreFile = keyStoreFile;
    }

    public String getKeyStoreType() {
        return this.keyStoreType;
    }

    public void setKeyStoreType(String keyStoreType) {
        this.keyStoreType = keyStoreType;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    public SSLSocketFactory getFactory() throws GeneralSecurityException, IOException {
        KeyStore ks = KeyStore.getInstance(this.keyStoreType);
        ks.load(new FileInputStream(this.keyStoreFile), this.password.toCharArray());
        KeyManagerFactory kmf = KeyManagerFactory.getInstance(this.algorithm);
        kmf.init(ks, this.password.toCharArray());
        KeyManager[] km = kmf.getKeyManagers();
        TrustManagerFactory tmf = TrustManagerFactory.getInstance(this.algorithm);
        tmf.init(ks);
        TrustManager[] tm = tmf.getTrustManagers();
        SSLContext sslc = SSLContext.getInstance(this.protocol);
        sslc.init(km, tm, null);
        return sslc.getSocketFactory();
    }
}

