/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment;

import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.deployment.EnvironmentProperty;
import com.sun.enterprise.deployment.MailConfiguration;
import com.sun.enterprise.deployment.NamedDescriptor;
import com.sun.enterprise.deployment.web.ResourceReference;
import com.sun.enterprise.resource.ResourceInstaller;
import com.sun.enterprise.resource.ResourcePrincipal;
import javax.naming.InitialContext;
import javax.sql.DataSource;

public class ResourceReferenceDescriptor
extends EnvironmentProperty
implements NamedDescriptor,
ResourceReference {
    public static String APPLICATION_AUTHORIZATION = "Application";
    public static String CONTAINER_AUTHORIZATION = "Container";
    public static String RESOURCE_SHAREABLE = "Shareable";
    public static String RESOURCE_UNSHAREABLE = "Unshareable";
    private static final String URL_RESOURCE_TYPE = "java.net.URL";
    private String type;
    private ResourcePrincipal resourcePrincipal = null;
    private MailConfiguration mailConfiguration;
    private String authorization;
    private DataSource dataSource;
    private DataSource pmDataSource;
    private String sharingScope;

    public ResourceReferenceDescriptor(String name, String description, String type) {
        super(name, "", description);
        this.type = type;
        this.sharingScope = RESOURCE_SHAREABLE;
    }

    public ResourceReferenceDescriptor() {
        this.sharingScope = RESOURCE_SHAREABLE;
    }

    public String getJndiName() {
        return super.getValue();
    }

    public void setJndiName(String jndiName) {
        super.setValue(jndiName);
    }

    public String getSharingScope() {
        if (this.sharingScope == null) {
            return "";
        }
        return this.sharingScope;
    }

    public void setSharingScope(String ss) {
        this.sharingScope = ss;
    }

    public boolean isResolved() {
        return true;
    }

    public boolean isContainerAuthorization() {
        return this.getAuthorization().equals(CONTAINER_AUTHORIZATION);
    }

    public String getAuthorization() {
        if (this.authorization == null) {
            this.authorization = APPLICATION_AUTHORIZATION;
        }
        return this.authorization;
    }

    public void setAuthorization(String authorization) {
        if (Descriptor.isBoundsChecking()) {
            // empty if block
        }
        this.authorization = authorization;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public DataSource getPMJDBCDataSource() {
        if (this.pmDataSource == null) {
            try {
                InitialContext ctx = new InitialContext();
                String pmJndiName = ResourceInstaller.getPMJndiName((String)this.getJndiName());
                this.pmDataSource = (DataSource)ctx.lookup(pmJndiName);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.pmDataSource;
    }

    public DataSource getJDBCDataSource() {
        if (this.dataSource == null) {
            try {
                InitialContext ctx = new InitialContext();
                this.dataSource = (DataSource)ctx.lookup(this.getJndiName());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.dataSource;
    }

    public boolean isMailResource() {
        return this.getMailConfiguration() != null;
    }

    public boolean isURLResource() {
        return this.getType().equals(URL_RESOURCE_TYPE);
    }

    public boolean isJMSConnectionFactory() {
        String myType = this.getType();
        return myType.equals("javax.jms.QueueConnectionFactory") || myType.equals("javax.jms.TopicConnectionFactory");
    }

    public ResourcePrincipal getResourcePrincipal() {
        return this.resourcePrincipal;
    }

    public void setResourcePrincipal(ResourcePrincipal resourcePrincipal) {
        this.resourcePrincipal = resourcePrincipal;
    }

    public void setMailConfiguration(MailConfiguration mailConfiguration) {
        this.mailConfiguration = mailConfiguration;
    }

    public MailConfiguration getMailConfiguration() {
        return this.mailConfiguration;
    }

    public boolean equals(Object object) {
        if (object instanceof ResourceReference) {
            ResourceReference resourceReference = (ResourceReference)object;
            return resourceReference.getName().equals(this.getName());
        }
        return false;
    }

    public String toString() {
        String toString = "Res-Ref-Env-Property: " + super.getName() + "@" + this.getType() + "@" + super.getDescription();
        if (this.isResolved()) {
            toString = toString + " resolved as: jndi: " + this.getJndiName() + "@res principal: " + this.getResourcePrincipal() + "@mail: " + this.getMailConfiguration();
        }
        return toString;
    }
}

