/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ejb.ejbql;

import com.sun.ejb.ejbql.CmrField;
import com.sun.enterprise.deployment.CMRFieldInfo;
import com.sun.enterprise.deployment.JoinObjectDescriptor;
import com.sun.enterprise.deployment.PersistenceDescriptor;
import com.sun.enterprise.deployment.PersistentFieldInfo;
import com.sun.enterprise.deployment.RelationRoleDescriptor;
import com.sun.enterprise.deployment.RelationshipDescriptor;
import java.util.Iterator;
import java.util.Vector;

public class RelationshipInfo {
    private CmrField cmrField_;
    private Vector sourceFields_;
    private Vector sinkFields_;
    private Vector joinSourceFields_;
    private Vector joinSinkFields_;

    public RelationshipInfo(CmrField cmrField) {
        this.cmrField_ = cmrField;
        this.sourceFields_ = new Vector();
        this.sinkFields_ = new Vector();
        this.joinSourceFields_ = new Vector();
        this.joinSinkFields_ = new Vector();
        this.init();
    }

    private void init() {
        if (this.cmrField_.requiresJoining()) {
            if (this.cmrField_.hasJoinTable()) {
                RelationshipDescriptor relationshipDesc = this.cmrField_.getRelationshipDescriptor();
                PersistenceDescriptor joinTablePersistenceDesc = relationshipDesc.getJoinDescriptor().getPersistenceDescriptor();
                PersistentFieldInfo[] joinTableFields = joinTablePersistenceDesc.getPersistentFieldInfo();
                PersistenceDescriptor sourcePersistenceDesc = this.cmrField_.getSourcePersistenceDescriptor();
                PersistenceDescriptor sinkPersistenceDesc = this.cmrField_.getSinkPersistenceDescriptor();
                for (int i = 0; i < joinTableFields.length; ++i) {
                    PersistentFieldInfo next = joinTableFields[i];
                    PersistenceDescriptor relatedObj = next.relatedObj;
                    if (relatedObj == null) continue;
                    PersistentFieldInfo pkeyInfo = relatedObj.getPkeyFieldInfoByName(next.relatedName);
                    if (relatedObj.getTableName().equals(sourcePersistenceDesc.getTableName())) {
                        this.sourceFields_.add(pkeyInfo.columnName);
                        this.joinSourceFields_.add(next.columnName);
                        continue;
                    }
                    if (sinkPersistenceDesc != null && relatedObj.getTableName().equals(sinkPersistenceDesc.getTableName())) {
                        this.sinkFields_.add(pkeyInfo.columnName);
                        this.joinSinkFields_.add(next.columnName);
                        continue;
                    }
                    throw new IllegalArgumentException("Invalid join table field = " + joinTablePersistenceDesc.getTableName() + " : " + next.columnName);
                }
            } else {
                PersistenceDescriptor sourcePersistenceDesc = this.cmrField_.getSourcePersistenceDescriptor();
                PersistentFieldInfo[] sourcePkeyFields = sourcePersistenceDesc.getPkeyFieldInfo();
                RelationRoleDescriptor sinkRole = this.cmrField_.getSourceRoleDescriptor().getPartner();
                PersistentFieldInfo[] sinkFkeyFields = sinkRole.getCMRFieldInfo().fkeyFields;
                for (int j = 0; j < sinkFkeyFields.length; ++j) {
                    PersistentFieldInfo fkeyInfo = sinkFkeyFields[j];
                    for (int i = 0; i < sourcePkeyFields.length; ++i) {
                        PersistentFieldInfo pkeyInfo = sourcePkeyFields[i];
                        if (!pkeyInfo.name.equals(fkeyInfo.relatedName)) continue;
                        this.sourceFields_.add(pkeyInfo.columnName);
                        this.sinkFields_.add(fkeyInfo.columnName);
                    }
                }
            }
        } else {
            CMRFieldInfo cmrFieldInfo = this.cmrField_.getCMRFieldInfo();
            for (int i = 0; i < cmrFieldInfo.fkeyFields.length; ++i) {
                PersistentFieldInfo source = cmrFieldInfo.fkeyFields[i];
                this.sourceFields_.add(source.columnName);
                PersistenceDescriptor sinkPersistenceDesc = this.cmrField_.getSinkPersistenceDescriptor();
                PersistentFieldInfo sink = sinkPersistenceDesc.getPkeyFieldInfoByName(source.relatedName);
                this.sinkFields_.add(sink.columnName);
            }
        }
    }

    public Iterator getSourceFields() {
        return this.sourceFields_.iterator();
    }

    public Iterator getSinkFields() {
        return this.sinkFields_.iterator();
    }

    public boolean requiresJoining() {
        return this.cmrField_.requiresJoining();
    }

    public boolean hasJoinTable() {
        return this.cmrField_.hasJoinTable();
    }

    public String getJoinTableName() {
        if (this.requiresJoining()) {
            if (this.cmrField_.hasJoinTable()) {
                RelationshipDescriptor relationshipDesc = this.cmrField_.getRelationshipDescriptor();
                JoinObjectDescriptor joinDesc = relationshipDesc.getJoinDescriptor();
                String tableName = joinDesc.getPersistenceDescriptor().getTableName();
                return tableName;
            }
            PersistenceDescriptor sinkPersistenceDesc = this.cmrField_.getSinkPersistenceDescriptor();
            String sinkTableName = sinkPersistenceDesc.getTableName();
            return sinkTableName;
        }
        throw new IllegalArgumentException("no join table for " + this.cmrField_.getName());
    }

    public Iterator getJoinSourceFields() {
        return this.joinSourceFields_.iterator();
    }

    public Iterator getJoinSinkFields() {
        return this.joinSinkFields_.iterator();
    }
}

