/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.server.ejb.container;

import com.evermind.server.ejb.logging.EJBDeploymentMessages;
import com.oracle.server.ejb.container.deployment.ContainerEntityDescriptor;
import com.oracle.server.ejb.persistence.pm.PersistenceManager;

public class DeploymentInfo {
    private ContainerEntityDescriptor ed;
    private PersistenceManager pm;

    public DeploymentInfo(ContainerEntityDescriptor ed) throws InstantiationException {
        this.ed = ed;
        this.createPM();
    }

    public ContainerEntityDescriptor getEntityDescriptor() {
        return this.ed;
    }

    public PersistenceManager getPM() {
        return this.pm;
    }

    public String getPMName() {
        return this.ed.getPMName();
    }

    private void createPM() throws InstantiationException {
        try {
            Class<?> clazz = Class.forName(this.ed.getPMClassName());
            this.pm = (PersistenceManager)clazz.newInstance();
        }
        catch (ClassNotFoundException e) {
            EJBDeploymentMessages.warningPMClassNotFound(this.ed.getPMClassName());
            throw new InstantiationException("PM class not found " + e.getMessage());
        }
        catch (IllegalAccessException e) {
            EJBDeploymentMessages.warningIllegalAccessPMClass(e.getMessage());
            throw new InstantiationException("Illegal access instantiating the PM class " + e.getMessage());
        }
        catch (ClassCastException e) {
            EJBDeploymentMessages.warningPMInterfaceNotImplemented(e.getMessage());
            throw new InstantiationException("The PM class doesn't implement PersistenceManager interface: " + e.getMessage());
        }
    }
}

