/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jgroups;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Externalizable;
import java.io.IOException;
import java.io.InvalidClassException;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.jgroups.stack.IpAddress;

public class ObjectMarshaller {
    private final List indexToClass = new ArrayList();
    private final HashMap classToIndex = new HashMap();
    private final List buffers = new ArrayList();
    private int maxBuffers = 100;
    public static final String ORACLE_J2EE_CLUSTERING_IOSTREAM_FACTORY = "oracle.j2ee.clustering.iostream.factory";
    protected static ObjectInputOutputStreamFactory m_ioFactory = null;
    private static Object m_ioConstructorLock = new Object();

    public ObjectMarshaller() {
        this.map(IpAddress.class);
    }

    public void writeExternal(ObjectOutput out, Externalizable obj) throws IOException {
        int index = this.getMapping(obj.getClass());
        if (index == -1) {
            out.writeBoolean(false);
            out.writeUTF(obj.getClass().getName());
            obj.writeExternal(out);
        } else {
            out.writeBoolean(true);
            out.writeInt(index);
            obj.writeExternal(out);
        }
    }

    public void writeMarshalled(ObjectOutput out, Marshalled obj) throws IOException {
        int index = this.getMapping(obj.getClass());
        if (index == -1) {
            out.writeBoolean(false);
            out.writeUTF(obj.getClass().getName());
            obj.writeExternal(out, this);
        } else {
            out.writeBoolean(true);
            out.writeInt(index);
            obj.writeExternal(out, this);
        }
    }

    public Externalizable readExternal(ObjectInput in) throws ClassNotFoundException, IOException {
        Externalizable obj = null;
        if (in.readBoolean()) {
            Class clazz = this.getMapping(in.readInt());
            try {
                obj = (Externalizable)clazz.newInstance();
            }
            catch (InstantiationException e) {
                throw new InvalidClassException(clazz.getName(), "Cannot instantiate");
            }
            catch (IllegalAccessException e) {
                throw new InvalidClassException(clazz.getName(), "No public, no argument constructor");
            }
        }
        String className = in.readUTF();
        try {
            obj = (Externalizable)Thread.currentThread().getContextClassLoader().loadClass(className).newInstance();
        }
        catch (InstantiationException e) {
            throw new InvalidClassException(className, "Cannot instantiate");
        }
        catch (IllegalAccessException e) {
            throw new InvalidClassException(className, "No public, no argument constructor");
        }
        obj.readExternal(in);
        return obj;
    }

    public Marshalled readMarshalled(ObjectInput in) throws ClassNotFoundException, IOException {
        Marshalled obj = null;
        if (in.readBoolean()) {
            Class clazz = this.getMapping(in.readInt());
            try {
                obj = (Marshalled)clazz.newInstance();
            }
            catch (InstantiationException e) {
                throw new InvalidClassException(clazz.getName(), "Cannot instantiate");
            }
            catch (IllegalAccessException e) {
                throw new InvalidClassException(clazz.getName(), "No public, no argument constructor");
            }
        }
        String className = in.readUTF();
        try {
            obj = (Marshalled)Thread.currentThread().getContextClassLoader().loadClass(className).newInstance();
        }
        catch (InstantiationException e) {
            throw (InvalidClassException)new InvalidClassException(className, "Cannot instantiate: " + className).initCause(e);
        }
        catch (IllegalAccessException e) {
            throw new InvalidClassException(className, "No public, no argument constructor: " + className);
        }
        obj.readExternal(in, this);
        return obj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] externalizableToBytes(Externalizable obj) throws Exception {
        byte[] bytes;
        ByteArrayOutputStream baos = this.getBuffer();
        try {
            ObjectOutputStream out = ObjectMarshaller.getNewObjectOutputStream(baos);
            this.writeExternal(out, obj);
            out.close();
            bytes = baos.toByteArray();
        }
        finally {
            this.returnBuffer(baos);
        }
        return bytes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] marshalledToBytes(Marshalled obj) throws Exception {
        byte[] bytes;
        ByteArrayOutputStream baos = this.getBuffer();
        try {
            ObjectOutputStream out = new ObjectOutputStream(baos);
            this.writeMarshalled(out, obj);
            out.close();
            bytes = baos.toByteArray();
        }
        finally {
            this.returnBuffer(baos);
        }
        return bytes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] serializableToBytes(Serializable obj) throws Exception {
        byte[] bytes;
        if (ObjectMarshaller.isMarshalled(obj)) {
            return (byte[])obj;
        }
        ByteArrayOutputStream baos = this.getBuffer();
        try {
            ObjectOutputStream out = ObjectMarshaller.getNewObjectOutputStream(baos);
            out.writeObject(obj);
            out.close();
            bytes = baos.toByteArray();
        }
        finally {
            this.returnBuffer(baos);
        }
        return bytes;
    }

    public Externalizable bytesToExternalizable(byte[] bytes) throws Exception {
        ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
        ObjectInputStream in = ObjectMarshaller.getNewObjectInputStream(bais);
        return this.readExternal(in);
    }

    public Marshalled bytesToMarshalled(byte[] bytes) throws Exception {
        ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
        ObjectInputStream in = new ObjectInputStream(bais);
        return this.readMarshalled(in);
    }

    public Object bytesToSerializable(byte[] bytes) throws Exception {
        ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
        ObjectInputStream in = ObjectMarshaller.getNewObjectInputStream(bais);
        return in.readObject();
    }

    public int getMapping(Class clazz) {
        Integer i = (Integer)this.classToIndex.get(clazz);
        if (i == null) {
            return -1;
        }
        return i;
    }

    public Class getMapping(int i) {
        return (Class)this.indexToClass.get(i);
    }

    public void map(Class clazz) {
        if (this.classToIndex.get(clazz) == null) {
            this.indexToClass.add(clazz);
            this.classToIndex.put(clazz, new Integer(this.indexToClass.size() - 1));
        }
    }

    public synchronized void setMaxBuffers(int maxBuffers) {
        this.maxBuffers = maxBuffers;
        if (this.buffers.size() <= this.maxBuffers) {
            return;
        }
        int numDrop = this.maxBuffers - this.buffers.size();
        int i = 0;
        while (i < numDrop) {
            this.buffers.remove(this.buffers.size() - 1);
        }
    }

    public int getMaxBuffers() {
        return this.maxBuffers;
    }

    protected synchronized ByteArrayOutputStream getBuffer() {
        if (this.buffers.size() > 0) {
            return (ByteArrayOutputStream)this.buffers.remove(this.buffers.size() - 1);
        }
        return new ByteArrayOutputStream(4096);
    }

    protected synchronized void returnBuffer(ByteArrayOutputStream buffer) {
        buffer.reset();
        if (this.buffers.size() < this.maxBuffers) {
            this.buffers.add(buffer);
        }
    }

    public static boolean isMarshalled(Object o) {
        return o instanceof byte[];
    }

    public static ObjectOutputStream getNewObjectOutputStream(ByteArrayOutputStream baos) throws IOException {
        return ObjectMarshaller.getFactory().getNewObjectOutputStream(baos);
    }

    public static ObjectInputStream getNewObjectInputStream(ByteArrayInputStream bais) throws IOException {
        return ObjectMarshaller.getFactory().getNewObjectInputStream(bais);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static ObjectInputOutputStreamFactory getFactory() {
        Object object = m_ioConstructorLock;
        synchronized (object) {
            if (m_ioFactory == null) {
                try {
                    String factory = System.getProperty(ORACLE_J2EE_CLUSTERING_IOSTREAM_FACTORY);
                    if (factory == null) {
                        factory = "oracle.j2ee.clustering.EJBInputOutputStreamFactory";
                    }
                    Class<?> clazz = Class.forName(factory, true, Thread.currentThread().getContextClassLoader());
                    m_ioFactory = (ObjectInputOutputStreamFactory)clazz.newInstance();
                }
                catch (Exception e) {
                    m_ioFactory = new ObjectMarshallerInputOutputStreamFactory();
                }
            }
        }
        return m_ioFactory;
    }

    public static class ObjectMarshallerInputOutputStreamFactory
    implements ObjectInputOutputStreamFactory {
        public ObjectOutputStream getNewObjectOutputStream(ByteArrayOutputStream baos) throws IOException {
            return new ObjectOutputStream(baos);
        }

        public ObjectInputStream getNewObjectInputStream(ByteArrayInputStream bais) throws IOException {
            return new ObjectInputStream(this, bais){
                private final /* synthetic */ ObjectMarshallerInputOutputStreamFactory this$0;
                {
                    this.this$0 = this$0;
                    super(x0);
                }

                public Class resolveClass(ObjectStreamClass type) throws IOException, ClassNotFoundException {
                    return Class.forName(type.getName(), true, Thread.currentThread().getContextClassLoader());
                }
            };
        }
    }

    public static interface ObjectInputOutputStreamFactory {
        public ObjectOutputStream getNewObjectOutputStream(ByteArrayOutputStream var1) throws IOException;

        public ObjectInputStream getNewObjectInputStream(ByteArrayInputStream var1) throws IOException;
    }

    public static interface Marshalled {
        public void writeExternal(ObjectOutput var1, ObjectMarshaller var2) throws IOException;

        public void readExternal(ObjectInput var1, ObjectMarshaller var2) throws ClassNotFoundException, IOException;
    }
}

