/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jgroups;

import EDU.oswego.cs.dl.util.concurrent.Sync;
import com.oracle.jgroups.TestAndWaitLock;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.j2ee.util.TraceLogger;

public class InterruptableTestAndWaitLock
extends TestAndWaitLock {
    protected static final Logger m_logger = TraceLogger.getLogger(InterruptableTestAndWaitLock.class);
    private final ArrayList blocked = new ArrayList();

    public InterruptableTestAndWaitLock(String name) {
        super(name);
    }

    public InterruptableTestAndWaitLock() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void interrupt() {
        Sync sync = this.readLock;
        synchronized (sync) {
            if (m_logger.isLoggable(Level.FINEST)) {
                m_logger.log(Level.FINEST, "Lock: {0} Interrupting", this.name);
            }
            Iterator i = this.blocked.iterator();
            while (i.hasNext()) {
                ((Thread)i.next()).interrupt();
            }
            this.blocked.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doAcquire() throws InterruptedException {
        Sync sync = this.readLock;
        synchronized (sync) {
            this.blocked.add(Thread.currentThread());
            this.readLock.acquire();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean doAttempt(long msecs) throws InterruptedException {
        Sync sync = this.readLock;
        synchronized (sync) {
            this.blocked.add(Thread.currentThread());
            return this.readLock.attempt(msecs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doRelease() {
        Sync sync = this.readLock;
        synchronized (sync) {
            this.blocked.remove(Thread.currentThread());
            this.readLock.release();
        }
    }
}

