/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.iiop.server;

import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NameNotFoundException;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.OperationNotSupportedException;
import oracle.j2ee.corba.iiop.IIOPMessages;
import oracle.j2ee.iiop.IIOPInitialContextFactory;
import oracle.oc4j.corba.ClientOrbManager;
import oracle.oc4j.corba.IiopHandleDelegateImpl;

public class IIOPContext
implements Context {
    Context _ctx = null;
    Hashtable _env = null;
    Context iiopContext = null;

    public IIOPContext(Context ctx, Hashtable env) {
        this._ctx = ctx;
        this._env = env;
    }

    public Object lookup(Name name) throws NamingException {
        if (this._ctx == null) {
            throw new NamingException("Underlying context not initialized ..");
        }
        IIOPMessages.finestMsg("Looking up name " + name);
        return this._ctx.lookup(name);
    }

    public Object lookup(String name) throws NamingException {
        try {
            if (name.startsWith("corbaname:")) {
                return this.doARemoteLookup(name);
            }
            if (name.equals("java:comp/ORB")) {
                return ClientOrbManager.getClientOrb();
            }
            if (name.equals("java:comp/HandleDelegate")) {
                return new IiopHandleDelegateImpl();
            }
            if (this._ctx == null) {
                throw new NamingException("Underlying context not initialized ..");
            }
            IIOPMessages.finestMsg("Looking up name .. " + name);
            Object obj = this._ctx.lookup(name);
            IIOPMessages.finestMsg("Lookup returned " + obj);
            return obj;
        }
        catch (Exception e) {
            IIOPMessages.finerThrowableNoMsg(e);
            if (e instanceof NamingException) {
                throw (NamingException)e;
            }
            throw new NamingException(e.getMessage());
        }
    }

    public void bind(Name name, Object obj) throws NamingException {
        throw new OperationNotSupportedException("Bind operation not supported in IIOPContext");
    }

    public void bind(String name, Object obj) throws NamingException {
        throw new OperationNotSupportedException("Bind operation not supported in IIOPContext");
    }

    public void rebind(Name name, Object obj) throws NamingException {
        throw new OperationNotSupportedException("Bind operation not supported in IIOPContext");
    }

    public void rebind(String name, Object obj) throws NamingException {
        throw new OperationNotSupportedException("Bind operation not supported in IIOPContext");
    }

    public void unbind(Name name) throws NamingException {
        throw new OperationNotSupportedException("Bind operation not supported in IIOPContext");
    }

    public void unbind(String name) throws NamingException {
        throw new OperationNotSupportedException("Bind operation not supported in IIOPContext");
    }

    public void rename(Name oldName, Name newName) throws NamingException {
        throw new OperationNotSupportedException("Bind operation not supported in IIOPContext");
    }

    public void rename(String oldName, String newName) throws NamingException {
        throw new OperationNotSupportedException("Bind operation not supported in IIOPContext");
    }

    public NamingEnumeration list(Name name) throws NamingException {
        if (this._ctx == null) {
            throw new NamingException("Underlying context not initialized ..");
        }
        return this._ctx.list(name);
    }

    public NamingEnumeration list(String name) throws NamingException {
        if (this._ctx == null) {
            throw new NamingException("Underlying context not initialized ..");
        }
        return this._ctx.list(name);
    }

    public NamingEnumeration listBindings(Name name) throws NamingException {
        if (this._ctx == null) {
            throw new NamingException("Underlying context not initialized ..");
        }
        return this._ctx.listBindings(name);
    }

    public NamingEnumeration listBindings(String name) throws NamingException {
        if (this._ctx == null) {
            throw new NamingException("Underlying context not initialized ..");
        }
        return this._ctx.listBindings(name);
    }

    public void destroySubcontext(Name name) throws NamingException {
        throw new OperationNotSupportedException("Bind operation not supported in IIOPContext");
    }

    public void destroySubcontext(String name) throws NamingException {
        throw new OperationNotSupportedException("Bind operation not supported in IIOPContext");
    }

    public Context createSubcontext(Name name) throws NamingException {
        throw new OperationNotSupportedException("Bind operation not supported in IIOPContext");
    }

    public Context createSubcontext(String name) throws NamingException {
        throw new OperationNotSupportedException("Bind operation not supported in IIOPContext");
    }

    public Object lookupLink(Name name) throws NamingException {
        if (this._ctx == null) {
            throw new NamingException("Underlying context not initialized ..");
        }
        return this._ctx.lookupLink(name);
    }

    public Object lookupLink(String name) throws NamingException {
        if (this._ctx == null) {
            throw new NamingException("Underlying context not initialized ..");
        }
        return this._ctx.lookupLink(name);
    }

    public NameParser getNameParser(Name name) throws NamingException {
        if (this._ctx == null) {
            throw new NamingException("Underlying context not initialized ..");
        }
        return this._ctx.getNameParser(name);
    }

    public NameParser getNameParser(String name) throws NamingException {
        if (this._ctx == null) {
            throw new NamingException("Underlying context not initialized ..");
        }
        return this._ctx.getNameParser(name);
    }

    public Name composeName(Name name, Name prefix) throws NamingException {
        if (this._ctx == null) {
            throw new NamingException("Underlying context not initialized ..");
        }
        return this._ctx.composeName(name, prefix);
    }

    public String composeName(String name, String prefix) throws NamingException {
        if (this._ctx == null) {
            throw new NamingException("Underlying context not initialized ..");
        }
        return this._ctx.composeName(name, prefix);
    }

    public Object addToEnvironment(String propName, Object propVal) throws NamingException {
        if (this._ctx == null) {
            throw new NamingException("Underlying context not initialized ..");
        }
        return this._ctx.addToEnvironment(propName, propVal);
    }

    public Object removeFromEnvironment(String propName) throws NamingException {
        if (this._ctx == null) {
            throw new NamingException("Underlying context not initialized ..");
        }
        return this._ctx.removeFromEnvironment(propName);
    }

    public Hashtable getEnvironment() throws NamingException {
        if (this._ctx == null) {
            throw new NamingException("Underlying context not initialized ..");
        }
        return this._ctx.getEnvironment();
    }

    public void close() throws NamingException {
        if (this._ctx == null) {
            throw new NamingException("Underlying context not initialized ..");
        }
        this._ctx.close();
    }

    public String getNameInNamespace() throws NamingException {
        if (this._ctx == null) {
            throw new NamingException("Underlying context not initialized ..");
        }
        return this._ctx.getNameInNamespace();
    }

    Object doARemoteLookup(String name) throws NamingException {
        Context ctx = this.getIIOPContext();
        if (ctx != null) {
            return ctx.lookup(name);
        }
        throw new NameNotFoundException(name + " not found");
    }

    private Context getIIOPContext() {
        try {
            if (this.iiopContext == null) {
                this.iiopContext = IIOPInitialContextFactory.getCorbanameContext(ClientOrbManager.getClientProperties());
            }
        }
        catch (Exception e) {
            IIOPMessages.finerThrowableMsg("Caught exception while creating IIOPContext", e);
        }
        return this.iiopContext;
    }
}

