/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.corba.ee.impl.orb.config;

import com.evermind.util.IIOPProperties;
import com.oracle.corba.ee.impl.orb.config.ORBConfig;
import com.oracle.corba.ee.impl.orb.config.ORBConfigImpl;
import com.oracle.corba.ee.impl.orb.config.SunRIORBConstants;
import java.io.File;
import java.util.Map;
import java.util.Properties;
import oracle.oc4j.corba.POAPolicyCreationStrategy;

public class SunRIORBConfigImpl
implements ORBConfig {
    private Properties m_sysProps;
    private ORBConfig m_fileConfig;
    private PortConfigurationAccess m_portConfigAccess = new StandardPortConfigurationAccess();
    public static final String DEFAULT_INITIAL_HOST = "localhost";
    public static final String DEFAULT_INITIAL_PORT = "5555";
    public static final String DEFAULT_RI_ORB_INIT_REF = "NameService=corbaloc:iiop:1.2@localhost:5555/NameService";
    public static final String TRUSTED_CLIENTS = "com.oracle.corba.ee.security.trusted.clients";
    public static final String USE_SSL = "com.oracle.corba.ee.security.use.ssl";
    public static final String SSL_MUTUAL_AUTH_PORT = "com.oracle.corba.ee.security.ssl.mutual.auth.port";
    public static final String DEFAULT_SSL_MUTUAL_AUTH_PORT = "5557";
    public static final String SSL_PORT = "com.oracle.corba.ee.security.ssl.port";
    public static final String DEFAULT_SSL_PORT = "5556";
    public static final String KEYSTORE_LOC_PROP = "oc4j.iiop.keyStoreLoc";
    public static final String KEYSTORE_PASS_PROP = "oc4j.iiop.keyStorePass";
    public static final String TRUSTSTORE_LOC_PROP = "oc4j.iiop.trustStoreLoc";
    public static final String TRUSTSTORE_PASS_PROP = "oc4j.iiop.trustStorePass";
    private static final String DEFAULT_JKS_PASSWORD = "changeit";

    public SunRIORBConfigImpl() {
        this(new ORBConfigImpl());
    }

    public SunRIORBConfigImpl(ORBConfig fileConfig) {
        this(fileConfig, new StandardPortConfigurationAccess());
    }

    SunRIORBConfigImpl(ORBConfig config, PortConfigurationAccess portConfig) {
        this.m_fileConfig = config;
        this.m_portConfigAccess = portConfig;
    }

    protected Properties initDefaultRIORBSysProps() {
        Properties sysProps = new Properties();
        sysProps.setProperty("org.omg.CORBA.ORBInitialHost", DEFAULT_INITIAL_HOST);
        sysProps.setProperty("org.omg.CORBA.ORBInitialPort", DEFAULT_INITIAL_PORT);
        sysProps.setProperty("com.sun.CORBA.POA.ORBPersistentServerPort", DEFAULT_INITIAL_PORT);
        sysProps.setProperty("org.omg.CORBA.ORBInitRef", DEFAULT_RI_ORB_INIT_REF);
        sysProps.setProperty("com.sun.CORBA.POA.ORBServerId", "1000000");
        sysProps.setProperty("org.omg.CORBA.ORBClass", "com.sun.corba.ee.impl.orb.ORBImpl");
        sysProps.setProperty("javax.rmi.CORBA.PortableRemoteObjectClass", "com.sun.corba.ee.impl.javax.rmi.PortableRemoteObject");
        sysProps.setProperty("javax.rmi.CORBA.StubClass", "com.sun.corba.ee.impl.javax.rmi.CORBA.StubDelegateImpl");
        sysProps.setProperty("javax.rmi.CORBA.UtilClass", "com.sun.corba.ee.impl.javax.rmi.CORBA.Util");
        sysProps.setProperty("org.omg.PortableInterceptor.ORBInitializerClass." + SunRIORBConstants.DEFAULT_PI_INITIALIZER, "NO_VALUE");
        sysProps.setProperty("com.sun.CORBA.connection.ORBSocketFactoryClass", SunRIORBConstants.DEFAULT_SOCKET_FACTORY);
        return sysProps;
    }

    protected void setSecurityAssociatedProperties() {
        if ("true".equals(this.m_sysProps.getProperty(USE_SSL))) {
            if (this.m_sysProps.getProperty(TRUSTED_CLIENTS) == null) {
                this.m_sysProps.setProperty(TRUSTED_CLIENTS, "*");
            }
            this.m_sysProps.setProperty("com.sun.CORBA.connection.ORBListenSocket", "SSL:" + System.getProperty(SSL_PORT, DEFAULT_SSL_PORT) + ",SSL_MUTUALAUTH:" + System.getProperty(SSL_MUTUAL_AUTH_PORT, DEFAULT_SSL_MUTUAL_AUTH_PORT));
            if (this.m_sysProps.getProperty(TRUSTSTORE_LOC_PROP) == null) {
                this.m_sysProps.setProperty(TRUSTSTORE_LOC_PROP, System.getProperty("oracle.home") + File.separator + "config" + File.separator + "trustore.jks");
                this.m_sysProps.setProperty(TRUSTSTORE_PASS_PROP, DEFAULT_JKS_PASSWORD);
            }
            if (this.m_sysProps.getProperty(KEYSTORE_LOC_PROP) == null) {
                this.m_sysProps.setProperty(KEYSTORE_LOC_PROP, System.getProperty("oracle.home") + File.separator + "config" + File.separator + "keystore.jks");
                this.m_sysProps.setProperty(KEYSTORE_PASS_PROP, DEFAULT_JKS_PASSWORD);
            }
        }
    }

    public Properties getORBProperties() {
        if (this.m_sysProps == null || this.m_sysProps.size() == 0) {
            this.m_sysProps = this.initDefaultRIORBSysProps();
            this.m_sysProps.putAll((Map<?, ?>)this.m_fileConfig.getORBProperties());
            this.setOpmnOverridePorts(this.m_sysProps);
        }
        this.m_sysProps.putAll((Map<?, ?>)System.getProperties());
        this.setSecurityAssociatedProperties();
        this.resetPortDependentProperties();
        this.initDebug();
        return this.m_sysProps;
    }

    private void setOpmnOverridePorts(Properties m_sysProps) {
        if (this.m_portConfigAccess.getIIOPPortProperty() != null) {
            m_sysProps.setProperty("org.omg.CORBA.ORBInitialPort", this.m_portConfigAccess.getIIOPPortProperty());
        }
        if (this.m_portConfigAccess.getIIOPSSLPortProperty() != null) {
            m_sysProps.setProperty(SSL_PORT, this.m_portConfigAccess.getIIOPSSLPortProperty());
        }
        if (this.m_portConfigAccess.getIIOPSSLAuthPortProperty() != null) {
            m_sysProps.setProperty(SSL_MUTUAL_AUTH_PORT, this.m_portConfigAccess.getIIOPSSLAuthPortProperty());
        }
    }

    protected void resetPortDependentProperties() {
        this.m_sysProps.setProperty("com.sun.CORBA.POA.ORBPersistentServerPort", this.m_sysProps.getProperty("org.omg.CORBA.ORBInitialPort", DEFAULT_INITIAL_PORT));
        this.m_sysProps.setProperty("org.omg.CORBA.ORBInitRef", "NameService=corbaloc:iiop:1.2@" + this.m_sysProps.getProperty("org.omg.CORBA.ORBInitialHost", DEFAULT_INITIAL_HOST) + ":" + this.m_sysProps.getProperty("org.omg.CORBA.ORBInitialPort", DEFAULT_INITIAL_PORT) + "/NameService");
    }

    private void initDebug() {
        if ("true".equals(System.getProperty("com.oracle.corba.ee.debug"))) {
            this.m_sysProps.setProperty("com.sun.CORBA.ORBDebug", "poa,orb,naming,subcontract,transport,giop");
        }
    }

    public String[] getORBArguments() {
        if (this.m_sysProps == null) {
            this.m_sysProps = new Properties();
        }
        return new String[]{"-ORBInitRef", "NameService=corbaloc:iiop:1.2@" + this.m_sysProps.getProperty("org.omg.CORBA.ORBInitialHost", DEFAULT_INITIAL_HOST) + ":" + this.m_sysProps.getProperty("org.omg.CORBA.ORBInitialPort", DEFAULT_INITIAL_PORT) + "/NameService"};
    }

    public String getORBProviderClass() {
        return "com.oracle.corba.ee.impl.orb.SunRIORBProviderImpl";
    }

    public POAPolicyCreationStrategy getPOAPolicyCreationStrategy() {
        return this.m_fileConfig.getPOAPolicyCreationStrategy();
    }

    public boolean debug() {
        return this.m_fileConfig.debug();
    }

    private static class StandardPortConfigurationAccess
    implements PortConfigurationAccess {
        private static final int INVALID_PORT_NUMBER = 0;

        private StandardPortConfigurationAccess() {
        }

        public String getIIOPPortProperty() {
            int portIIOP = IIOPProperties.getPortIIOP();
            return portIIOP > 0 ? Integer.toString(portIIOP) : null;
        }

        public String getIIOPSSLPortProperty() {
            int portIIOPSSL = IIOPProperties.getPortIIOP1();
            return portIIOPSSL > 0 ? Integer.toString(portIIOPSSL) : null;
        }

        public String getIIOPSSLAuthPortProperty() {
            int portIIOPSSLAuth = IIOPProperties.getPortIIOP2();
            return portIIOPSSLAuth > 0 ? Integer.toString(portIIOPSSLAuth) : null;
        }
    }

    static interface PortConfigurationAccess {
        public String getIIOPPortProperty();

        public String getIIOPSSLPortProperty();

        public String getIIOPSSLAuthPortProperty();
    }
}

