/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.corba.ee.impl.orb.config;

import com.oracle.corba.ee.impl.orb.DefaultPoaPolicyCreationStrategyImpl;
import com.oracle.corba.ee.impl.orb.config.ORBConfig;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import oracle.oc4j.corba.POAPolicyCreationStrategy;

public class InternalSettingsORBConfigImpl
implements ORBConfig {
    private Properties m_sysProps;
    private Map m_propMap = new HashMap();

    public InternalSettingsORBConfigImpl() {
        this.m_propMap.put("port", "org.omg.CORBA.ORBInitialPort");
        this.m_propMap.put("host", "org.omg.CORBA.ORBInitialHost");
        this.m_propMap.put("ssl", "com.oracle.corba.ee.security.use.ssl");
        this.m_propMap.put("ssl-port", "com.oracle.corba.ee.security.ssl.port");
        this.m_propMap.put("ssl-client-server-auth-port", "com.oracle.corba.ee.security.ssl.mutual.auth.port");
        this.m_propMap.put("keystore", "oc4j.iiop.keyStoreLoc");
        this.m_propMap.put("keystore-password", "oc4j.iiop.keyStorePass");
        this.m_propMap.put("truststore", "oc4j.iiop.trustStoreLoc");
        this.m_propMap.put("truststore-password", "oc4j.iiop.trustStorePass");
        this.m_propMap.put("trusted-clients", "com.oracle.corba.ee.security.trusted.clients");
    }

    public InternalSettingsORBConfigImpl(Map properties) {
        this();
        this.m_sysProps = new Properties();
        Iterator entries = properties.entrySet().iterator();
        while (entries.hasNext()) {
            Map.Entry entry = entries.next();
            this.addToProperties(this.m_sysProps, (String)entry.getKey(), (String)entry.getValue());
        }
    }

    public Properties getORBProperties() {
        return this.m_sysProps == null ? new Properties() : this.m_sysProps;
    }

    private void addToProperties(Properties props, String name, String value) {
        props.put(this.getORBPropertyName(name), value);
    }

    private String getORBPropertyName(String name) {
        String propName = (String)this.m_propMap.get(name);
        return propName != null ? propName : name;
    }

    public String[] getORBArguments() {
        return new String[0];
    }

    public String getORBProviderClass() {
        return "com.oracle.corba.ee.impl.orb.SunRIORBProviderImpl";
    }

    public POAPolicyCreationStrategy getPOAPolicyCreationStrategy() {
        return new DefaultPoaPolicyCreationStrategyImpl();
    }

    public boolean debug() {
        return Boolean.TRUE.equals(Boolean.valueOf(this.m_sysProps.getProperty("com.oracle.corba.ee.debug")));
    }
}

