/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bricks.j2ee.test;

import com.oracle.bricks.j2ee.SessionManager;
import com.oracle.bricks.j2ee.test.Barbalat;
import com.oracle.bricks.j2ee.test.Worker;
import java.io.File;
import java.net.URL;

public class TestProcess {
    public static void main(String[] argv) throws Exception {
        int i;
        if (argv.length != 4) {
            TestProcess.usage();
        }
        URL stackConfig = new File(argv[1]).toURL();
        String applicationId = argv[2];
        int numWorkers = Integer.parseInt(argv[3]);
        SessionManager manager = new SessionManager(applicationId, 2, null, stackConfig);
        manager.start();
        Thread[] workers = new Thread[numWorkers];
        for (i = 0; i < numWorkers; ++i) {
            Runnable runnable = null;
            if (argv[0].equals("Worker")) {
                runnable = new Worker(i, manager);
            } else if (argv[0].equals("Barbalat")) {
                runnable = new Barbalat(i, manager);
            } else {
                TestProcess.usage();
            }
            workers[i] = new Thread(runnable, manager.getAddress() + " : " + i);
        }
        for (i = 0; i < numWorkers; ++i) {
            workers[i].start();
        }
        try {
            while (true) {
                Thread.sleep(1000L);
            }
        }
        catch (InterruptedException e) {
            return;
        }
    }

    private static void usage() {
        System.out.println("usage: java com.oracle.bricks.TestProcess <Barbalat | Worker> <stack config file> <group id> <num threads>");
        System.exit(1);
    }
}

