/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bricks.j2ee;

import com.oracle.bricks.Local;
import com.oracle.bricks.LocalObject;
import com.oracle.bricks.Manager;
import com.oracle.bricks.j2ee.EJBLiveSession;
import com.oracle.bricks.j2ee.EJBSession;
import com.oracle.bricks.j2ee.LiveSession;
import com.oracle.bricks.j2ee.Session;
import com.oracle.bricks.j2ee.SessionEventListener;
import com.oracle.bricks.j2ee.SessionReplica;
import com.oracle.jgroups.ObjectMarshaller;
import java.io.Serializable;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.j2ee.clustering.ClusteringTraceLogger;
import org.jgroups.ChannelException;
import org.jgroups.ChannelFactory;

public class SessionManager
extends Manager {
    private static final Logger m_logger = ClusteringTraceLogger.getTraceLogger(SessionManager.class);

    public SessionManager(String group, int writeQuota, ChannelFactory channelFactory, Object properties) throws ChannelException {
        super(group, channelFactory, properties, writeQuota);
    }

    public Session create(Serializable id) throws Exception {
        return this.create(id, null, -1, System.currentTimeMillis(), 1200);
    }

    public Session create(Serializable id, SessionEventListener listener, int addr, long creationTime, int timeout) throws Exception {
        LocalObject session = this.getLocalObject(id);
        if (session == null) {
            LiveSession s = new LiveSession(id, listener, addr, creationTime);
            s.setMaxInactiveTime(timeout);
            this.add(s);
            session = s;
        }
        return (Session)session.getFacade();
    }

    public EJBSession createEJB(long id, long creationTime) throws Exception {
        LocalObject session = this.getLocalObject(new Long(id));
        if (session == null) {
            session = new EJBLiveSession(id, creationTime);
            this.add(session);
        }
        return (EJBSession)session.getFacade();
    }

    public Local get(long id, int timeout) throws Exception {
        return this.get(new Long(id), timeout);
    }

    public void remove(long oid) throws InterruptedException {
        super.remove(new Long(oid));
    }

    public Local get(Serializable id, int timeout) throws InterruptedException, ChannelException, Exception {
        LocalObject session = (LocalObject)super.get(id, timeout);
        if (session == null) {
            return null;
        }
        return session.getFacade();
    }

    protected ObjectMarshaller getMarshaller() {
        ObjectMarshaller marshaller = super.getMarshaller();
        marshaller.map(SessionReplica.class);
        marshaller.map(SessionReplica.ApplyDelta.class);
        marshaller.map(String.class);
        marshaller.map(Integer.class);
        marshaller.map(Float.class);
        marshaller.map(Long.class);
        return marshaller;
    }

    public void migrateSessions(byte[] content) {
        this.nyi();
    }

    private void nyi() {
        if (m_logger.isLoggable(Level.FINEST)) {
            m_logger.log(Level.FINEST, "Not Yet Implemented: SessionManager");
        }
    }
}

