/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bricks.j2ee;

import com.evermind.server.ApplicationConfig;
import com.oracle.bricks.SessionManagerFactory;
import com.oracle.bricks.j2ee.FlowControlPolicy;
import com.oracle.bricks.j2ee.ReplicationPolicy;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.j2ee.clustering.ClusteringMessages;
import oracle.j2ee.clustering.ClusteringTraceLogger;
import oracle.oc4j.configuration.ConfigException;
import oracle.oc4j.configuration.XMLSerializableBase;
import org.w3c.dom.DOMException;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class JGroupConfig
extends XMLSerializableBase {
    private static final String VERIFY_SUSPECT = "VERIFY_SUSPECT(timeout=1500;down_thread=false;up_thread=false):";
    private static final String PBCAST_STABLE = "pbcast.STABLE(desired_avg_gossip=20000;down_thread=false;up_thread=false):";
    protected static final String MERGE_STRING = "MERGE2(min_interval=20000;max_interval=100000;down_thread=false;up_thread=false):";
    protected static final String OPMN_MERGE_STRING = "MERGE2(min_interval=60000;max_interval=61000):";
    protected static final String FD_STRING = "FD(timeout=20000;max_tries=5;down_thread=false;up_thread=false):";
    protected static final String FD_SOCK_STRING = "FD_SOCK(up_thread=false;down_thread=false):";
    protected static final String FRAG_STRING = "FRAG(frag_size=60000;down_thread=false;up_thread=true)";
    protected static final String UNICAST_STRING = "UNICAST(timeout=5000):";
    private static final int MULTICAST = 1;
    private static final int TUNNEL = 2;
    private static final int PEER = 3;
    private static final int DATABASE = 4;
    protected static final String EMPTY_STRING = "";
    protected static final String DEFAULT_MCAST_ADDR = "230.230.0.1";
    protected static final String DEFAULT_MCAST_PORT = "45567";
    protected static final String DEFAULT_TCP_START_PORT = "7800";
    protected static final String DEFAULT_OPMN_TCP_PORT = "0";
    protected static final String DEFAULT_TCP_RANGE = "5";
    protected static final String DEFAULT_PROMISE_TIMEOUT = "1000";
    protected static final String DEFAULT_TCP_TIMEOUT = "3000";
    protected static final String DEFAULT_WRITE_QUOTA = "1";
    protected static final String DEFAULT_ENABLED = "true";
    protected static final String DEFAULT_COLOCATION = "true";
    private static final String DEFAULT_ENCRYPTION = "false;";
    private static final String DEFAULT_ACK_TIMEOUT = "10000";
    private static final String DEFAULT_MCAST_TTL = "1";
    private static Logger m_logger = ClusteringTraceLogger.getTraceLogger(JGroupConfig.class);
    private String groupName;
    private String configuredURL;
    private String configuredPropString;
    private Object properties;
    private String mcast_addr = "230.230.0.1";
    private String mcast_port = "45567";
    private String mcast_ttl = "1";
    private String tcp_start_port = "7800";
    private String opmn_tcp_port = "0";
    private String tcp_range = "5";
    private int protocol = 1;
    private String writeQuota = "1";
    private ApplicationConfig applicationConfig;
    private boolean enabled = Boolean.valueOf("true");
    private String promiseTimeout = "1000";
    private String bind_addr = null;
    private boolean useEncryption = Boolean.valueOf("false;");
    private boolean allowColocation = Boolean.valueOf("true");
    private ArrayList peerList = new ArrayList(3);
    private String tcp_timeout = "3000";
    private boolean useOPMN = false;
    private boolean startedByOPMN = false;
    private boolean useDatabase = false;
    private String dataSourceName = null;
    private ReplicationPolicy replicationPolicy = null;
    private FlowControlPolicy m_flowControlPolicy = null;
    private long m_ackTimeout = -1L;

    protected JGroupConfig() {
    }

    public JGroupConfig(String fullPropString) {
        this.properties = fullPropString;
        this.initDefaultPolicies();
        this.properties = this.getJGroupsProps();
    }

    private void initDefaultPolicies() {
        String startedByOPMNStr = System.getProperty("OPMN", "false");
        if (startedByOPMNStr.equals("true")) {
            this.setStartedByOpmn(true);
        }
        this.replicationPolicy = new ReplicationPolicy();
        this.replicationPolicy.setReplicationTrigger(4);
        this.m_flowControlPolicy = new FlowControlPolicy();
    }

    public JGroupConfig(String fullPropString, boolean useMulticast, String mcast_addr, String mcast_port, String tcp_start_port, String tcp_range, int writeQuota) {
        this.properties = fullPropString;
        this.protocol = useMulticast ? 1 : 3;
        this.mcast_addr = mcast_addr;
        this.mcast_port = mcast_port;
        this.tcp_range = tcp_range;
        this.tcp_start_port = tcp_start_port;
        this.writeQuota = String.valueOf(writeQuota);
        this.initDefaultPolicies();
        this.properties = this.getJGroupsProps();
    }

    public JGroupConfig(ApplicationConfig app, Node node) throws ConfigException {
        this.applicationConfig = app;
        this.read(node);
    }

    public int getWriteQuota() {
        return Integer.parseInt(this.writeQuota);
    }

    public Object getJGroupsProps() {
        if (this.properties != null) {
            this.displayClusterConfig(this.properties);
            return this.properties;
        }
        StringBuffer buf = new StringBuffer();
        buf.append(this.getBroadcast());
        buf.append(this.getPing());
        buf.append(this.getMerge());
        buf.append(this.getFD());
        buf.append(this.getFD_SOCK());
        buf.append(this.getVerify());
        buf.append(this.getNakack());
        buf.append(this.getUnicast());
        buf.append(this.getStable());
        buf.append(this.getSecurity());
        buf.append(this.getGMS());
        buf.append(this.getFC());
        buf.append(this.getFrag());
        return buf.toString();
    }

    private void displayClusterConfig(Object config) {
        ClusteringMessages.fineClusterConfig(config);
        if (m_logger.isLoggable(Level.FINEST)) {
            m_logger.log(Level.FINEST, config.toString());
        }
    }

    protected boolean useMulticast() {
        return this.protocol == 1;
    }

    protected boolean useTunnel() {
        return this.protocol == 2;
    }

    protected boolean usePeer() {
        return this.protocol == 3;
    }

    public String getProtocol() {
        switch (this.protocol) {
            case 1: {
                return "MULTICAST";
            }
            case 2: {
                return "TUNNEL";
            }
            case 3: {
                return "PEER";
            }
            case 4: {
                return "DATABASE";
            }
        }
        return null;
    }

    public void setProtocol(String protocol) {
        this.resetProperties();
        if (protocol.equalsIgnoreCase("MULTICAST")) {
            this.protocol = 1;
        } else if (protocol.equalsIgnoreCase("TUNNEL")) {
            this.protocol = 2;
        } else if (protocol.equalsIgnoreCase("PEER")) {
            this.protocol = 3;
        } else if (protocol.equalsIgnoreCase("DATABASE")) {
            this.protocol = 4;
        } else {
            throw new RuntimeException("The protocol:  " + protocol + " is not supported");
        }
    }

    protected void resetProperties() {
        this.properties = null;
        SessionManagerFactory.removeManager(this);
    }

    private String getSecurity() {
        return EMPTY_STRING;
    }

    private String getFD() {
        return FD_STRING;
    }

    private String getFD_SOCK() {
        return FD_SOCK_STRING;
    }

    private String getFrag() {
        if (this.useMulticast()) {
            return FRAG_STRING;
        }
        return EMPTY_STRING;
    }

    protected String getFC() {
        if (this.hasFlowControl()) {
            StringBuffer ret = new StringBuffer("FC(");
            ret.append("max_credits=");
            ret.append(this.m_flowControlPolicy.getMaxCredits());
            ret.append(';');
            if (this.m_flowControlPolicy.isMinCreditsDefined()) {
                ret.append("min_credits=");
                ret.append(this.m_flowControlPolicy.getMinCredits());
                ret.append(';');
            } else {
                ret.append("min_threshold=");
                ret.append(this.m_flowControlPolicy.getThreshold());
                ret.append(';');
            }
            ret.append("down_thread=false):");
            return ret.toString();
        }
        return EMPTY_STRING;
    }

    private String getUnicast() {
        if (this.useMulticast()) {
            return UNICAST_STRING;
        }
        return EMPTY_STRING;
    }

    private String getMerge() {
        if (this.isUseOpmn()) {
            return OPMN_MERGE_STRING;
        }
        return MERGE_STRING;
    }

    private String getBroadcast() {
        if (this.useMulticast()) {
            return JGroupConfig.getUDP(this.mcast_addr, this.mcast_port, this.bind_addr, this.mcast_ttl);
        }
        if (this.usePeer()) {
            return this.getTCP();
        }
        if (this.useTunnel()) {
            this.nyi();
        }
        return EMPTY_STRING;
    }

    private String getNakack() {
        if (this.useMulticast()) {
            StringBuffer ret = new StringBuffer("pbcast.NAKACK(gc_lag=50;retransmit_timeout=300,600,1200,2400,4800;use_mcast_xmit=true;down_thread=false;max_xmit_size=60000");
            if (this.hasFlowControl()) {
                ret.append(";discard_delivered_msgs=true");
            }
            ret.append("):");
            return ret.toString();
        }
        return "pbcast.NAKACK(down_thread=true;up_thread=true;gc_lag=100;retransmit_timeout=3000):";
    }

    private String getStable() {
        if (this.hasFlowControl()) {
            StringBuffer ret = new StringBuffer("pbcast.STABLE(desired_avg_gossip=0;stability_delay=1000;down_thread=false;");
            int maxBytes = (int)Math.round(0.25 * (double)this.getFlowControlPolicy().getMaxCredits());
            ret.append("max_bytes=" + maxBytes + "):");
            return ret.toString();
        }
        return PBCAST_STABLE;
    }

    private String getVerify() {
        return VERIFY_SUSPECT;
    }

    private boolean isEncrypted() {
        return this.useEncryption;
    }

    private String getTCP() {
        StringBuffer buf = new StringBuffer("TCP(sock_conn_timeout=200;start_port=");
        if (this.isUseOpmn()) {
            buf.append(this.opmn_tcp_port);
        } else {
            buf.append(this.tcp_start_port);
        }
        if (this.bind_addr != null) {
            buf.append(";");
            buf.append("bind_addr=");
            buf.append(this.bind_addr);
        }
        buf.append("):");
        return buf.toString();
    }

    protected String getPing() {
        if (this.useMulticast()) {
            return this.getUDPPing();
        }
        if (this.usePeer()) {
            if (this.isUseOpmn()) {
                return this.getOPMNGOSSIP();
            }
            return this.getTCPPing();
        }
        if (this.useDatabase()) {
            return null;
        }
        return this.getTCPPing();
    }

    private String getTCPPing() {
        StringBuffer buf = new StringBuffer("TCPPING(initial_hosts=");
        for (int i = 0; i < this.peerList.size(); ++i) {
            PeerNode peer = (PeerNode)this.peerList.get(i);
            peer.write(buf);
            if (i == this.peerList.size() - 1) continue;
            buf.append(',');
        }
        buf.append(";port_range=");
        buf.append(this.tcp_range);
        buf.append(";timeout=");
        buf.append(this.tcp_timeout);
        buf.append(";num_initial_members=");
        buf.append(String.valueOf(this.peerList.size()));
        buf.append(";up_thread=true;down_thread=true):");
        return buf.toString();
    }

    private String getUDPPing() {
        return "PING(timeout=2000;num_initial_members=3):";
    }

    private String getOPMNGOSSIP() {
        return "opmn.jgroups.protocols.OPMNTCPGOSSIP(timeout=3000):";
    }

    protected String getGMS() {
        StringBuffer ret = new StringBuffer("pbcast.GMS(join_timeout=5000;join_retry_timeout=2000;shun=true;print_local_addr=true;down_thread=true;up_thread=true)");
        if (this.useMulticast() || this.hasFlowControl()) {
            ret.append(":");
        }
        return ret.toString();
    }

    private static String getUDP(String ip, String port, String bind_addr, String ttl) {
        StringBuffer ret = new StringBuffer("UDP(");
        ret.append("mcast_addr=");
        ret.append(ip);
        ret.append(';');
        ret.append("mcast_port=");
        ret.append(port);
        ret.append(';');
        if (bind_addr != null) {
            ret.append("bind_addr=");
            ret.append(bind_addr);
            ret.append(';');
        }
        ret.append("ip_ttl=");
        ret.append(ttl);
        ret.append(";");
        ret.append("mcast_send_buf_size=150000;");
        ret.append("mcast_recv_buf_size=80000):");
        return ret.toString();
    }

    public String getGroupName() {
        return this.groupName != null ? this.groupName : this.getApplicationName();
    }

    public void setGroupName(String gname) {
        this.groupName = gname;
    }

    public String getDataSourceName() {
        return this.dataSourceName;
    }

    public int getPromiseTimeout() {
        return Integer.parseInt(this.promiseTimeout);
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean flag) {
        this.enabled = flag;
    }

    public boolean useDatabase() {
        return this.protocol == 4;
    }

    public void read(Node node) throws DOMException, ConfigException {
        this.initDefaultPolicies();
        this.groupName = JGroupConfig.getAttribute("group-name", node, null);
        this.enabled = "true".equalsIgnoreCase(JGroupConfig.getAttribute("enabled", node, "true"));
        this.promiseTimeout = JGroupConfig.getIntAttribute("cache-miss-delay", node, String.valueOf(this.promiseTimeout));
        this.writeQuota = JGroupConfig.getIntAttribute("write-quota", node, String.valueOf(this.writeQuota));
        this.allowColocation = "true".equalsIgnoreCase(JGroupConfig.getAttribute("allow-colocation", node, "true"));
        this.replicationPolicy = ReplicationPolicy.read(node);
        this.m_flowControlPolicy = FlowControlPolicy.read(node);
        NodeList list = node.getChildNodes();
        if (list == null) {
            return;
        }
        if (list.getLength() == 0) {
            this.installDefaultConfig();
            return;
        }
        for (int i = 0; i < list.getLength(); ++i) {
            Node child = list.item(i);
            String name = child.getNodeName();
            if (name.equals("property-config") || name.equals("javagroups-config")) {
                try {
                    this.parseJavagroupConfig(child);
                    continue;
                }
                catch (MalformedURLException e) {
                    throw (ConfigException)new ConfigException("Invalid javagroups configuration").initCause(e);
                }
            }
            if (name.equals("protocol")) {
                this.parseProtocol(child);
                this.properties = (String)this.getJGroupsProps();
                continue;
            }
            if (name.equals("replication-policy")) {
                this.replicationPolicy = ReplicationPolicy.read(child);
                continue;
            }
            if (name.equalsIgnoreCase("synchronous-replication")) {
                this.parseAcknowledgeOnUpdate(child);
                continue;
            }
            if (!name.equals("flow-control-policy")) continue;
            this.m_flowControlPolicy = FlowControlPolicy.read(child);
        }
    }

    protected void parseAcknowledgeOnUpdate(Node child) {
        String attr = JGroupConfig.getAttribute("timeout", child, DEFAULT_ACK_TIMEOUT);
        this.setAckTimeout(attr);
    }

    public void setAckTimeout(String attr) {
        this.m_ackTimeout = Long.parseLong(attr);
    }

    public boolean hasAckTimeout() {
        return this.m_ackTimeout > -1L;
    }

    public long getAckTimeout() {
        return this.m_ackTimeout;
    }

    protected static String getAttribute(String attribute, Node node, String defaultValue) {
        String attr = JGroupConfig.getAttribute(attribute, node);
        if (attr != null) {
            return attr;
        }
        return defaultValue;
    }

    protected static String getAttribute(String attribute, Node node) {
        NamedNodeMap attrs;
        Node attrNode;
        if (node.hasAttributes() && (attrNode = (attrs = node.getAttributes()).getNamedItem(attribute)) != null) {
            return attrNode.getNodeValue();
        }
        return null;
    }

    private static String getIntAttribute(String attribute, Node node, String defaultValue) throws ConfigException {
        String retVal = JGroupConfig.getAttribute(attribute, node, defaultValue);
        JGroupConfig.validateInteger(retVal, "Illegal " + attribute + " value in " + node.getNodeName());
        return retVal;
    }

    private void installDefaultConfig() {
        this.properties = (String)this.getJGroupsProps();
    }

    private void parseJavagroupConfig(Node node) throws MalformedURLException {
        NodeList list = node.getChildNodes();
        if (list == null) {
            return;
        }
        for (int i = 0; i < list.getLength(); ++i) {
            Node child = list.item(i);
            String name = child.getNodeName();
            if (name.equals("url")) {
                this.setConfigUrl(child);
                continue;
            }
            if (!name.equals("property-string")) continue;
            this.setPropertyString(child);
        }
    }

    private void setConfigUrl(Node node) throws MalformedURLException {
        this.configuredURL = this.getNodeValue(node);
        this.properties = new URL(this.configuredURL);
    }

    private void setPropertyString(Node node) {
        this.configuredPropString = this.getNodeValue(node);
        this.properties = this.configuredPropString;
    }

    private String getNodeValue(Node node) {
        Node child = node.getLastChild();
        if (child == null) {
            return null;
        }
        return child.getNodeValue();
    }

    public void parseProtocol(Node node) throws DOMException, ConfigException {
        NodeList list = node.getChildNodes();
        if (list == null) {
            return;
        }
        for (int i = 0; i < list.getLength(); ++i) {
            Node child = list.item(i);
            String name = child.getNodeName();
            if (name.equals("multicast")) {
                this.parseMulticast(child);
                continue;
            }
            if (name.equals("tunnel")) {
                this.parseTunnel(child);
                continue;
            }
            if (name.equals("peer")) {
                this.parsePeer(child);
                continue;
            }
            if (name.equals("encryption")) {
                this.parseEncryption(child);
                continue;
            }
            if (name.equals("opmn")) {
                this.parseOpmn(child);
                continue;
            }
            if (!name.equals("database")) continue;
            this.parseDatabase(child);
        }
        if (this.usePeer() && !this.isUseOpmn() && this.peerList.size() == 0) {
            throw new ConfigException("The <peer> protocol must supply at least one peer node if OC4J is not started by OPMN");
        }
    }

    private void parseOpmn(Node child) {
        this.setUseOpmn(true);
        this.nyi();
    }

    private void parseDatabase(Node child) throws ConfigException {
        this.protocol = 4;
        this.dataSourceName = JGroupConfig.getAttribute("data-source", child, this.dataSourceName);
    }

    private void parseEncryption(Node child) {
        this.useEncryption = true;
        this.nyi();
    }

    private void parseTunnel(Node node) {
        this.protocol = 2;
        this.nyi();
    }

    private void parsePeer(Node node) throws ConfigException {
        NodeList list;
        this.protocol = 3;
        this.tcp_start_port = JGroupConfig.getIntAttribute("start-port", node, this.tcp_start_port);
        this.tcp_range = JGroupConfig.getIntAttribute("range", node, this.tcp_range);
        this.tcp_timeout = JGroupConfig.getIntAttribute("timeout", node, this.tcp_timeout);
        this.bind_addr = JGroupConfig.getAttribute("bind_addr", node, null);
        if (this.peerList == null) {
            this.peerList = new ArrayList();
        }
        if ((list = node.getChildNodes()) != null && list.getLength() != 0) {
            for (int i = 0; i < list.getLength(); ++i) {
                Node child = list.item(i);
                String name = child.getNodeName();
                if (name.equals("node")) {
                    this.peerList.add(new PeerNode(child));
                    continue;
                }
                if (!name.equals("opmn-discovery")) continue;
                if (this.startedByOPMN) {
                    this.setUseOpmn(true);
                    continue;
                }
                throw new ConfigException("The <opmn-discovery/> can't be used if OC4J is not started by OPMN");
            }
        }
        this.verifyUsingOpmn();
        if (this.isUseOpmn()) {
            try {
                this.opmn_tcp_port = System.getProperty("port." + this.getGroupName(), DEFAULT_OPMN_TCP_PORT);
                int tmpPort = Integer.parseInt(this.opmn_tcp_port);
            }
            catch (NumberFormatException nfe) {
                throw new ConfigException("System property port." + this.getGroupName() + " was not set to a number");
            }
        }
    }

    private void verifyUsingOpmn() {
        if (!this.isUseOpmn() && this.startedByOPMN && this.peerList.size() == 0) {
            this.setUseOpmn(true);
        }
    }

    private static void validateInteger(String intValue, String errorMessage) throws ConfigException {
        try {
            Integer.parseInt(intValue);
        }
        catch (NumberFormatException ex) {
            throw (ConfigException)new ConfigException(errorMessage).initCause(ex);
        }
    }

    private void parseMulticast(Node node) throws ConfigException {
        this.protocol = 1;
        this.mcast_addr = JGroupConfig.getAttribute("ip", node, this.mcast_addr);
        this.mcast_port = JGroupConfig.getIntAttribute("port", node, this.mcast_port);
        this.bind_addr = JGroupConfig.getAttribute("bind_addr", node, null);
        this.mcast_ttl = JGroupConfig.getAttribute("ttl", node, this.mcast_ttl);
    }

    public void write(PrintWriter out, String indent) throws IOException {
        out.print(indent);
        out.print("<cluster");
        JGroupConfig.writeAttribute(out, "enabled", String.valueOf(this.enabled), "true");
        JGroupConfig.writeAttribute(out, "group-name", this.groupName, null);
        JGroupConfig.writeAttribute(out, "cache-miss-delay", this.promiseTimeout, DEFAULT_PROMISE_TIMEOUT);
        JGroupConfig.writeAttribute(out, "write-quota", this.writeQuota, "1");
        JGroupConfig.writeAttribute(out, "allow-colocation", String.valueOf(this.allowColocation), "true");
        out.println(">");
        this.replicationPolicy.write(out, indent);
        if (!this.isUsingJGroupsProperty()) {
            this.m_flowControlPolicy.write(out, indent);
        }
        if (this.hasAckTimeout()) {
            this.writeAcknowledgeOnUpdate(out, indent);
        }
        if (this.isUsingJGroupsProperty()) {
            this.writeJavagroupsConfig(out, indent + "\t");
        } else {
            this.writeProtocol(out, indent + "\t");
        }
        out.print(indent);
        out.println("</cluster>");
    }

    private boolean isUsingJGroupsProperty() {
        return this.configuredPropString != null || this.configuredURL != null;
    }

    private void writeJavagroupsConfig(PrintWriter out, String indent) {
        out.print(indent);
        out.println("<property-config>");
        if (this.configuredURL != null) {
            out.print(indent);
            out.print("\t<url>");
            out.print(this.configuredURL);
            out.println("</url>");
        } else {
            out.print(indent);
            out.print("\t<property-string>");
            out.print(this.configuredPropString);
            out.println("</property-string>");
        }
        out.print(indent);
        out.println("</property-config>");
    }

    protected void writeProtocol(PrintWriter out, String indent) {
        out.print(indent);
        out.println("<protocol>");
        String subIndent = indent + "\t";
        if (this.useMulticast()) {
            this.writeMulticast(out, subIndent);
        } else if (this.usePeer()) {
            this.writePeer(out, subIndent);
        } else if (this.useTunnel()) {
            this.writeTunnel(out, subIndent);
        }
        if (this.isEncrypted()) {
            this.writeEncryption(out, subIndent);
        }
        if (this.useDatabase()) {
            this.writeDatabase(out, subIndent);
        }
        out.print(indent);
        out.println("</protocol>");
    }

    private void writeOpmnDiscovery(PrintWriter out, String indent) {
        out.print(indent);
        out.println("<opmn-discovery/>");
    }

    private void writeEncryption(PrintWriter out, String indent) {
        out.print(indent);
        out.println("<encryption/>");
    }

    private void writeTunnel(PrintWriter out, String indent) {
        out.print(indent);
        out.println("<tunnel/>");
    }

    private void writeMulticast(PrintWriter out, String indent) {
        out.print(indent);
        out.print("<multicast");
        JGroupConfig.writeAttribute(out, "ip", this.mcast_addr, DEFAULT_MCAST_ADDR);
        JGroupConfig.writeAttribute(out, "port", this.mcast_port, DEFAULT_MCAST_PORT);
        JGroupConfig.writeAttribute(out, "bind_addr", this.bind_addr, null);
        JGroupConfig.writeAttribute(out, "ttl", this.mcast_ttl, null);
        out.println("/>");
    }

    private void writeDatabase(PrintWriter out, String indent) {
        out.print(indent);
        out.print("<database");
        JGroupConfig.writeAttribute(out, "data-source", this.dataSourceName, EMPTY_STRING);
        out.println("/>");
    }

    static void writeAttribute(PrintWriter out, String attribute, Object value, Object defaultValue) {
        if (value == null) {
            return;
        }
        if (value.equals(defaultValue)) {
            return;
        }
        out.print(" ");
        out.print(attribute);
        out.print("=\"");
        out.print(value);
        out.print("\"");
    }

    private void writePeer(PrintWriter out, String indent) {
        this.verifyUsingOpmn();
        String nodeIndent = indent + indent;
        out.print(indent);
        out.print("<peer");
        if (this.isUseOpmn()) {
            out.println(">");
            this.writeOpmnDiscovery(out, nodeIndent);
        } else {
            JGroupConfig.writeAttribute(out, "start-port", this.tcp_start_port, DEFAULT_TCP_START_PORT);
            JGroupConfig.writeAttribute(out, "range", this.tcp_range, DEFAULT_TCP_RANGE);
            JGroupConfig.writeAttribute(out, "timeout", this.tcp_timeout, DEFAULT_TCP_TIMEOUT);
            JGroupConfig.writeAttribute(out, "bind_addr", this.bind_addr, null);
            out.println(">");
            for (int i = 0; i < this.peerList.size(); ++i) {
                PeerNode node = (PeerNode)this.peerList.get(i);
                node.write(out, nodeIndent);
            }
        }
        out.print(indent);
        out.println("</peer>");
    }

    public boolean allowColocation() {
        return this.allowColocation;
    }

    private void nyi() {
        this.nyi("Not Yet Implemented");
    }

    private void nyi(String message) {
        if (m_logger.isLoggable(Level.FINEST)) {
            m_logger.log(Level.FINEST, message);
        }
    }

    public ReplicationPolicy getReplicationPolicy() {
        return this.replicationPolicy;
    }

    public void setReplicationPolicy(ReplicationPolicy policy) {
        this.replicationPolicy = policy;
    }

    public String getApplicationName() {
        if (this.applicationConfig == null) {
            return null;
        }
        return this.applicationConfig.getName();
    }

    public void setApplicationConfig(ApplicationConfig appConfig) {
        this.applicationConfig = appConfig;
    }

    public String getBindAddress() {
        return this.bind_addr;
    }

    public void setBindAddress(String bindAddr) {
        this.resetProperties();
        this.bind_addr = bindAddr;
    }

    public String getMulticastAddress() {
        return this.mcast_addr;
    }

    public void setMulticastAddress(String mcast_addr) {
        this.resetProperties();
        this.mcast_addr = mcast_addr;
    }

    public String getMulticastPort() {
        return this.mcast_port;
    }

    public void setMultiCastPort(String mcast_port) {
        this.resetProperties();
        this.mcast_port = mcast_port;
    }

    public String getTCPRange() {
        return this.tcp_range;
    }

    public void setTCPRange(String tcp_range) {
        this.resetProperties();
        this.tcp_range = tcp_range;
    }

    public String getTCPStartPort() {
        return this.tcp_start_port;
    }

    public void setTCPStartPort(String tcp_start_port) {
        this.resetProperties();
        this.tcp_start_port = tcp_start_port;
    }

    public String getTCPTimeout() {
        return this.tcp_timeout;
    }

    public void setTCPTimeout(String tcp_timeout) {
        this.resetProperties();
        this.tcp_timeout = tcp_timeout;
    }

    public void addPeerList(String host, String port) {
        this.resetProperties();
        if (this.peerList == null) {
            this.peerList = new ArrayList();
        }
        this.peerList.add(new PeerNode(host, port));
    }

    public void setPeerList(ArrayList list) {
        this.resetProperties();
        this.peerList = list;
    }

    public ArrayList getPeerList() {
        ArrayList<String> aList = new ArrayList<String>(this.peerList.size());
        for (int i = 0; i < this.peerList.size(); ++i) {
            PeerNode peer = (PeerNode)this.peerList.get(i);
            aList.add(peer.toString());
        }
        return aList;
    }

    public void setDataSourceName(String dataSourceName) {
        this.dataSourceName = dataSourceName;
    }

    public void setAllowColocation(boolean allowColocation) {
        this.resetProperties();
        this.allowColocation = allowColocation;
    }

    public void setWriteQuota(String writeQuota) {
        this.resetProperties();
        this.writeQuota = writeQuota;
    }

    public boolean hasFlowControl() {
        return this.m_flowControlPolicy != null && this.m_flowControlPolicy.isEnabled();
    }

    public FlowControlPolicy getFlowControlPolicy() {
        return this.m_flowControlPolicy;
    }

    public void setFlowControlPolicy(FlowControlPolicy fcPolicy) {
        this.m_flowControlPolicy = fcPolicy;
    }

    public void writeAcknowledgeOnUpdate(PrintWriter out, String indent) {
        out.print(indent);
        out.print("<synchronous-replication ");
        JGroupConfig.writeAttribute(out, "timeout", new Long(this.m_ackTimeout).toString(), DEFAULT_ACK_TIMEOUT);
        out.println("/>");
    }

    public boolean isUseOpmn() {
        return this.useOPMN;
    }

    public void setUseOpmn(boolean useOpmn) {
        this.useOPMN = useOpmn;
    }

    void setStartedByOpmn(boolean startByOpmn) {
        this.startedByOPMN = startByOpmn;
    }

    public static class PeerNode {
        String host;
        String port = "7800";

        PeerNode() {
        }

        PeerNode(String host, String port) {
            this.host = host;
            if (port != null) {
                this.port = port;
            }
        }

        PeerNode(Node node) throws ConfigException {
            this.host = JGroupConfig.getAttribute("host", node, null);
            if (this.host == null) {
                throw new ConfigException("Must define a valid 'host' in a peer node");
            }
            this.port = JGroupConfig.getIntAttribute("port", node, this.port);
        }

        public String toString() {
            StringBuffer buf = new StringBuffer();
            this.write(buf);
            return buf.toString();
        }

        private void write(StringBuffer buf) {
            buf.append(this.host);
            buf.append('[');
            buf.append(this.port);
            buf.append(']');
        }

        private void write(PrintWriter out, String indent) {
            out.print(indent);
            out.print("<node");
            JGroupConfig.writeAttribute(out, "host", this.host, null);
            JGroupConfig.writeAttribute(out, "port", this.port, JGroupConfig.DEFAULT_TCP_START_PORT);
            out.println("/>");
        }
    }
}

