/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bricks.j2ee;

import com.evermind.server.ejb.EJBContainer;
import com.evermind.server.ejb.StatefulSessionEJBObject;
import com.oracle.bricks.Local;
import java.io.Serializable;
import javax.naming.NamingException;
import org.jgroups.Address;

public interface EJBSession
extends Local {
    public long getLastAccessed();

    public int getMaxInactiveTime();

    public void setEJBObject(StatefulSessionEJBObject var1) throws InterruptedException, NamingException;

    public void flush() throws InterruptedException;

    public void flush(boolean var1) throws InterruptedException;

    public String getUser();

    public long getCreationTime();

    public void setContainer(EJBContainer var1);

    public void setContextAttribute(String var1, Serializable var2) throws InterruptedException;

    public Serializable getContextAttribute(String var1);

    public void unmarshall() throws NamingException;

    public static class DeadSession
    implements EJBSession {
        private static final DeadSession singleton = new DeadSession();

        public static EJBSession getSingleton() {
            return singleton;
        }

        public long getLastAccessed() {
            throw new IllegalStateException("Session has been reaped");
        }

        public int getMaxInactiveTime() {
            throw new IllegalStateException("Session has been reaped");
        }

        public void setEJBObject(StatefulSessionEJBObject object) throws InterruptedException {
            throw new IllegalStateException("Session has been reaped");
        }

        public void flush() throws InterruptedException {
            throw new IllegalStateException("Session has been reaped");
        }

        public void flush(boolean passivate) throws InterruptedException {
            throw new IllegalStateException("Session has been reaped");
        }

        public long getCreationTime() {
            throw new IllegalStateException("Session has been reaped");
        }

        public void setContainer(EJBContainer container) {
            throw new IllegalStateException("Session has been reaped");
        }

        public void setContextAttribute(String name, Serializable value) {
            throw new IllegalStateException("Session has been reaped");
        }

        public Serializable getContextAttribute(String name) {
            throw new IllegalStateException("Session has been reaped");
        }

        public void unmarshall() throws NamingException {
            throw new IllegalStateException("Session has been reaped");
        }

        public String getUser() {
            throw new IllegalStateException("Session has been reaped");
        }

        public Serializable getId() {
            throw new IllegalStateException("Session has been reaped");
        }

        public Address getOwner() {
            throw new IllegalStateException("Session has been reaped");
        }

        public boolean isDisconnected() {
            return true;
        }
    }
}

