/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bricks.j2ee;

import com.oracle.bricks.LocalObject;
import com.oracle.bricks.Manager;
import com.oracle.bricks.Replica;
import com.oracle.bricks.j2ee.AckLiveSession;
import com.oracle.bricks.j2ee.SessionReplica;
import com.oracle.jgroups.AbstractGroup;
import com.oracle.jgroups.ObjectMarshaller;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.j2ee.clustering.ClusteringMessages;
import oracle.j2ee.util.TraceLogger;
import org.jgroups.Address;

public class AckSessionReplica
extends SessionReplica {
    protected long m_timeout;
    private static Logger m_logger = TraceLogger.getLogger(AckSessionReplica.class);

    public AckSessionReplica() {
        if (m_logger.isLoggable(Level.FINEST)) {
            m_logger.log(Level.FINEST, "creating AckSessionReplica no args");
        }
    }

    protected AckSessionReplica(AckLiveSession session, HashMap clonedAttributes, ObjectMarshaller marshaller) throws Exception {
        super(session, clonedAttributes, marshaller);
        this.m_timeout = session.getAcknowledgementTimeout();
        if (m_logger.isLoggable(Level.FINEST)) {
            m_logger.log(Level.FINEST, "creating AckSessionReplica with args");
        }
    }

    protected void applyDeltaWithAck(long lastAccessed, String user, Serializable[] puts, Serializable[] removes, int ackSeqNo, Address owner, Manager mgr) {
        this.applyDelta(lastAccessed, user, puts, removes);
        if (m_logger.isLoggable(Level.FINEST)) {
            m_logger.log(Level.FINEST, "AckSessionReplica::applyDeltaWithAck: id: " + this.getId() + ", ackSeqNo: " + ackSeqNo + ", owner: " + owner);
        }
        mgr.sendAckApplyDeltaMessage(this.getId(), ackSeqNo, owner);
    }

    protected LocalObject reify(ObjectMarshaller marshaller) {
        ClusteringMessages.fineHttpSessionFailover(this.getId());
        return new AckLiveSession(this, this.m_timeout);
    }

    public void readExternal(ObjectInput in, ObjectMarshaller marshaller) throws IOException, ClassNotFoundException {
        super.readExternal(in, marshaller);
        this.m_timeout = in.readLong();
    }

    public void writeExternal(ObjectOutput out, ObjectMarshaller marshaller) throws IOException {
        super.writeExternal(out, marshaller);
        out.writeLong(this.m_timeout);
    }

    public static class ApplyDeltaWithAck
    extends SessionReplica.ApplyDelta {
        private int ackSeqNo = -1;
        private Address owner;

        public ApplyDeltaWithAck() {
        }

        protected ApplyDeltaWithAck(Serializable id, long lastAccessed, String user, Serializable[] puts, Serializable[] removes, int ackSeqNo, Address owner) {
            super(id, lastAccessed, user, puts, removes);
            this.ackSeqNo = ackSeqNo;
            this.owner = owner;
        }

        public String toString() {
            return "ApplyDeltaWithAck- - " + this.id;
        }

        public final void dispatch(AbstractGroup manager) {
            Replica replica = ((Manager)manager).getReplica(this.id);
            this.applyTo(replica, (Manager)manager);
        }

        protected void applyTo(Replica replicated, Manager mgr) {
            if (replicated == null) {
                return;
            }
            ((AckSessionReplica)replicated).applyDeltaWithAck(this.lastAccessed, this.user, this.puts, this.removes, this.ackSeqNo, this.owner, mgr);
        }

        public void writeExternal(ObjectOutput out, ObjectMarshaller marshaller) throws IOException {
            super.writeExternal(out, marshaller);
            out.writeInt(this.ackSeqNo);
            marshaller.writeExternal(out, (Externalizable)this.owner);
        }

        public void readExternal(ObjectInput in, ObjectMarshaller marshaller) throws IOException, ClassNotFoundException {
            super.readExternal(in, marshaller);
            this.ackSeqNo = in.readInt();
            this.owner = (Address)marshaller.readExternal(in);
        }

        public int getAckSeqNo() {
            return this.ackSeqNo;
        }
    }
}

