/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.zip;

import com.evermind.io.IOUtils;
import com.evermind.io.InteractiveByteArrayOutputStream;
import com.evermind.util.ByteString;
import com.evermind.util.ServerProperties;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.zip.CRC32;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;

public class MemoryArchive {
    private static final boolean DEBUG_VERBOSE = false;
    private static final boolean REWRITE_STORED = true;
    public static final boolean ONLY_STORE = false;
    public static final int HASH_SIZE = 256;
    public static final int COMPRESSION_STORED = 0;
    public static final int COMPRESSION_SHRUNK = 1;
    public static final int COMPRESSION_REDUCED1 = 2;
    public static final int COMPRESSION_REDUCED2 = 3;
    public static final int COMPRESSION_REDUCED3 = 4;
    public static final int COMPRESSION_REDUCED4 = 5;
    public static final int COMPRESSION_IMPLODED = 6;
    public static final int COMPRESSION_TOKENIZED = 7;
    public static final int COMPRESSION_DEFLATED = 8;
    private int[][] hash;
    private byte[] archiveData;
    private int start;
    private int end;
    private boolean safe = true;
    private Map newEntries;
    private int readPos;
    private int bitShift;
    private String name;
    private static final boolean VERBOSE_READRECORD = false;

    public MemoryArchive(byte[] data, int start, int length, String name) {
        this.archiveData = data;
        this.start = start;
        this.end = start + length;
        this.name = name;
    }

    public void setData(byte[] data) {
        this.setData(data, 0, data == null ? 0 : data.length);
    }

    public void setData(byte[] data, int start, int length) {
        this.archiveData = data;
        this.start = start;
        this.end = start + length;
        this.hash = null;
        this.newEntries = null;
    }

    public void init() {
        try {
            int[][] hash = new int[256][];
            this.hash = hash;
            String reason = this.readCentralRecord();
            if (reason == null) {
                return;
            }
            if (this.isUnsafe()) {
                try {
                    ZipEntry entry;
                    CRC32 crc = null;
                    byte[] buffer = new byte[32768];
                    InteractiveByteArrayOutputStream byteOut = new InteractiveByteArrayOutputStream();
                    ZipInputStream in = new ZipInputStream(new ByteArrayInputStream(this.archiveData, this.start, this.end - this.start));
                    ZipOutputStream out = new ZipOutputStream(byteOut);
                    while ((entry = in.getNextEntry()) != null) {
                        ZipEntry outEntry = new ZipEntry(entry.getName());
                        if (entry.getTime() > 0L) {
                            outEntry.setTime(entry.getTime());
                        }
                        if (entry.getSize() >= 0L) {
                            outEntry.setSize(entry.getSize());
                        } else if (entry.isDirectory()) {
                            if (crc == null) {
                                crc = new CRC32();
                            } else {
                                crc.reset();
                            }
                            crc.update(buffer, 0, 0);
                            outEntry.setMethod(0);
                            outEntry.setSize(0L);
                            outEntry.setCompressedSize(0L);
                            outEntry.setCrc(crc.getValue());
                            out.putNextEntry(outEntry);
                            continue;
                        }
                        int length = 0;
                        if (entry.getSize() < 0L) {
                            length = in.read(buffer, 0, buffer.length);
                            if (length < 0) {
                                outEntry.setSize(0L);
                                out.putNextEntry(outEntry);
                                continue;
                            }
                            boolean allWritten = false;
                            while (true) {
                                if (length >= buffer.length) {
                                    byte[] newBuffer = new byte[buffer.length * 2];
                                    System.arraycopy(buffer, 0, newBuffer, 0, buffer.length);
                                    buffer = newBuffer;
                                }
                                int secondLength = in.read(buffer, length, buffer.length - length);
                                if (secondLength == -1) {
                                    outEntry.setSize(length);
                                    outEntry.setMethod(0);
                                    outEntry.setCompressedSize(length);
                                    if (crc == null) {
                                        crc = new CRC32();
                                        break;
                                    }
                                    crc.reset();
                                    break;
                                }
                                length += secondLength;
                            }
                            crc.update(buffer, 0, length);
                            outEntry.setCrc(crc.getValue());
                            out.putNextEntry(outEntry);
                            out.write(buffer, 0, length);
                            allWritten = true;
                            if (allWritten) continue;
                        }
                        out.putNextEntry(outEntry);
                        if (length > 0) {
                            out.write(buffer, 0, length);
                        }
                        while ((length = in.read(buffer, 0, buffer.length)) >= 0) {
                            out.write(buffer, 0, length);
                        }
                    }
                    out.close();
                    ByteString newContent = byteOut.toByteString();
                    this.archiveData = newContent.data;
                    this.start = newContent.offset;
                    this.end = newContent.getEnd();
                }
                catch (IOException e) {
                    // empty catch block
                }
            }
            byte[] data = this.archiveData;
            int pos = this.start;
            int end = this.end;
            while (pos < end) {
                int compressionMethod;
                int currentStartPos = pos;
                if (data[pos++] != 80 || data[pos++] != 75 || data[pos++] != 3 || data[pos++] != 4) {
                    if ((pos = MemoryArchive.findNext(data, end, pos)) < 0 || pos >= end - 10) break;
                    pos += 4;
                }
                pos += 2;
                int generalPurpose = ((char)data[pos++] & 0xFF) + (((char)data[pos++] & 0xFF) << 8);
                if ((compressionMethod = ((char)data[pos++] & 0xFF) + (((char)data[pos++] & 0xFF) << 8)) > 8) {
                    pos = MemoryArchive.findNext(data, end, currentStartPos + 1);
                    if (pos >= 0 && pos < end - 10) continue;
                } else {
                    int compressedSize;
                    pos += 8;
                    if (pos + (compressedSize = (((char)data[pos++] & 0xFF) << 0) + (((char)data[pos++] & 0xFF) << 8) + (((char)data[pos++] & 0xFF) << 16) + (((char)data[pos++] & 0xFF) << 24)) > end) {
                        pos = MemoryArchive.findNext(data, end, currentStartPos + 1);
                        if (pos >= 0 && pos < end - 10) continue;
                    } else {
                        int filenameLength;
                        int uncompressedSize = (((char)data[pos++] & 0xFF) << 0) + (((char)data[pos++] & 0xFF) << 8) + (((char)data[pos++] & 0xFF) << 16) + (((char)data[pos++] & 0xFF) << 24);
                        if ((filenameLength = ((char)data[pos++] & 0xFF) + (((char)data[pos++] & 0xFF) << 8)) > 512) {
                            pos = MemoryArchive.findNext(data, end, currentStartPos + 1);
                            if (pos >= 0 && pos < end - 10) continue;
                        } else {
                            int offset;
                            boolean sizeUnknown;
                            int extraInfoLength = ((char)data[pos++] & 0xFF) + (((char)data[pos++] & 0xFF) << 8);
                            boolean bl = sizeUnknown = (generalPurpose & 8) != 0;
                            if (ServerProperties.getZipDebug()) {
                                // empty if block
                            }
                            int hashCode = 0;
                            for (int hashPos = pos + filenameLength - 2; hashPos >= pos; hashPos -= 2) {
                                hashCode <<= 1;
                                hashCode += data[hashPos];
                            }
                            if (hashCode == 0) {
                                hashCode = 1;
                            }
                            if (hash[offset = hashCode & 0xFF] == null) {
                                hash[offset] = new int[4];
                                int[] currentHash = hash[offset];
                                currentHash[0] = hashCode;
                                currentHash[1] = currentStartPos;
                            } else {
                                int[] oldHash = hash[offset];
                                if (oldHash[oldHash.length - 2] == 0) {
                                    oldHash[oldHash.length - 2] = hashCode;
                                    oldHash[oldHash.length - 1] = currentStartPos;
                                } else {
                                    int[] newHash = new int[oldHash.length + 4];
                                    System.arraycopy(oldHash, 0, newHash, 0, oldHash.length);
                                    newHash[newHash.length - 4] = hashCode;
                                    newHash[newHash.length - 3] = currentStartPos;
                                    hash[offset] = newHash;
                                }
                            }
                            if ((pos += filenameLength + extraInfoLength) >= end) {
                                pos = MemoryArchive.findNext(data, end, currentStartPos + 1);
                                if (pos >= 0 && pos < end - 10) continue;
                            } else if (sizeUnknown) {
                                if (compressionMethod == 0) {
                                    pos += uncompressedSize;
                                    continue;
                                }
                                if (compressionMethod == 8 && ServerProperties.getZipDebug()) {
                                    pos = this.handleDeflated(data, pos);
                                    continue;
                                }
                                if ((pos = MemoryArchive.findNext(data, end, pos)) >= 0 && pos < end - 10) continue;
                            } else if (data[pos += compressedSize] == 80 && data[pos + 1] == 75 && data[pos + 2] == 3 && data[pos + 3] == 4 || (pos = MemoryArchive.findNext(data, end, currentStartPos + 1)) >= 0 && pos < end - 10) continue;
                        }
                    }
                }
                break;
            }
        }
        catch (Exception e) {
            if (ServerProperties.getZipDebug()) {
                System.out.println("File " + this.name + " is corrupted. " + e);
            }
            this.safe = false;
            return;
        }
        this.safe = !this.isUnsafe();
    }

    public boolean isUnsafe() {
        byte[] data = this.archiveData;
        int pos = this.start;
        int end = this.end;
        while (pos < end) {
            int filenameLength;
            int compressedSize;
            int compressionMethod;
            int currentStartPos = pos;
            if (data[pos++] != 80 || data[pos++] != 75 || data[pos++] != 3 || data[pos++] != 4) {
                return true;
            }
            pos += 2;
            int generalPurpose = ((char)data[pos++] & 0xFF) + (((char)data[pos++] & 0xFF) << 8);
            if ((compressionMethod = ((char)data[pos++] & 0xFF) + (((char)data[pos++] & 0xFF) << 8)) > 8) {
                return true;
            }
            pos += 8;
            if (pos + (compressedSize = (((char)data[pos++] & 0xFF) << 0) + (((char)data[pos++] & 0xFF) << 8) + (((char)data[pos++] & 0xFF) << 16) + (((char)data[pos++] & 0xFF) << 24)) > end) {
                return true;
            }
            int uncompressedSize = (((char)data[pos++] & 0xFF) << 0) + (((char)data[pos++] & 0xFF) << 8) + (((char)data[pos++] & 0xFF) << 16) + (((char)data[pos++] & 0xFF) << 24);
            if ((filenameLength = ((char)data[pos++] & 0xFF) + (((char)data[pos++] & 0xFF) << 8)) > 512) {
                return true;
            }
            int extraInfoLength = ((char)data[pos++] & 0xFF) + (((char)data[pos++] & 0xFF) << 8);
            boolean sizeUnknown = (generalPurpose & 8) != 0;
            int filenamePos = pos;
            if ((pos += filenameLength + extraInfoLength) >= end) {
                return true;
            }
            if (sizeUnknown & data[filenamePos + filenameLength - 1] == 47) {
                sizeUnknown = false;
                compressedSize = 0;
                uncompressedSize = 0;
                int stepsWalked = 18;
                pos += 18;
                while (pos < end - 3 && (data[pos] != 80 || data[pos + 1] != 75 || data[pos + 2] != 3 || data[pos + 3] != 4)) {
                    ++stepsWalked;
                    ++pos;
                }
            }
            if (sizeUnknown) {
                if (compressionMethod == 0) {
                    pos += uncompressedSize;
                    continue;
                }
                if (compressionMethod == 8 && ServerProperties.getZipDebug()) {
                    pos = this.handleDeflated(data, pos);
                    continue;
                }
                return true;
            }
            if (data[pos += compressedSize] == 80 && data[pos + 1] == 75 && data[pos + 2] == 3 && data[pos + 3] == 4) continue;
            while (pos < end - 3 && (data[pos] != 80 || data[pos + 1] != 75 || data[pos + 2] != 3 || data[pos + 3] != 4)) {
                ++pos;
            }
            return pos < end - 3;
        }
        return false;
    }

    public void writeFooter(InteractiveByteArrayOutputStream out) throws IOException {
        int numberOfEntries = 0;
        byte[] data = this.archiveData;
        int pos = this.start;
        int end = this.end;
        int startOfFooterPos = out.getPos();
        while (pos < end) {
            int filenameLength;
            int compressedSize;
            int compressionMethod;
            int currentStartPos = pos;
            if (data[pos++] != 80 || data[pos++] != 75 || data[pos++] != 3 || data[pos++] != 4) {
                if ((pos = MemoryArchive.findNext(data, end, pos)) < 0 || pos >= end - 10) break;
                pos += 4;
            }
            int startOfDataPos = pos;
            pos += 2;
            int generalPurpose = ((char)data[pos++] & 0xFF) + (((char)data[pos++] & 0xFF) << 8);
            if ((compressionMethod = ((char)data[pos++] & 0xFF) + (((char)data[pos++] & 0xFF) << 8)) > 8) {
                pos = MemoryArchive.findNext(data, end, currentStartPos + 1);
                if (pos >= 0 && pos < end - 10) continue;
                break;
            }
            pos += 8;
            if (pos + (compressedSize = (((char)data[pos++] & 0xFF) << 0) + (((char)data[pos++] & 0xFF) << 8) + (((char)data[pos++] & 0xFF) << 16) + (((char)data[pos++] & 0xFF) << 24)) > end) {
                pos = MemoryArchive.findNext(data, end, currentStartPos + 1);
                if (pos >= 0 && pos < end - 10) continue;
                break;
            }
            int uncompressedSize = (((char)data[pos++] & 0xFF) << 0) + (((char)data[pos++] & 0xFF) << 8) + (((char)data[pos++] & 0xFF) << 16) + (((char)data[pos++] & 0xFF) << 24);
            if ((filenameLength = ((char)data[pos++] & 0xFF) + (((char)data[pos++] & 0xFF) << 8)) > 512) {
                pos = MemoryArchive.findNext(data, end, currentStartPos + 1);
                if (pos >= 0 && pos < end - 10) continue;
                break;
            }
            int extraInfoLength = ((char)data[pos++] & 0xFF) + (((char)data[pos++] & 0xFF) << 8);
            boolean sizeUnknown = (generalPurpose & 8) != 0;
            ++numberOfEntries;
            int startOfEntryPos = out.getPos();
            out.write(80);
            out.write(75);
            out.write(1);
            out.write(2);
            out.write(data, startOfDataPos, 2);
            out.write(data, startOfDataPos, 26);
            out.write(0);
            out.write(0);
            out.write(0);
            out.write(0);
            out.write(0);
            out.write(0);
            out.write(0);
            out.write(0);
            out.write(0);
            out.write(0);
            int localOffset = startOfEntryPos - startOfFooterPos;
            out.write(localOffset);
            out.write(localOffset >> 8);
            out.write(localOffset >> 16);
            out.write(localOffset >> 24);
            out.write(data, startOfDataPos + 26, filenameLength + extraInfoLength);
            if ((pos += filenameLength + extraInfoLength) >= end) {
                pos = MemoryArchive.findNext(data, end, currentStartPos + 1);
                if (pos >= 0 && pos < end - 10) continue;
                break;
            }
            if (sizeUnknown) {
                if (compressionMethod == 0) {
                    pos += uncompressedSize;
                    continue;
                }
                if ((pos = MemoryArchive.findNext(data, end, pos)) >= 0 && pos < end - 10) continue;
                break;
            }
            if (data[pos += compressedSize] == 80 && data[pos + 1] == 75 && data[pos + 2] == 3 && data[pos + 3] == 4 || (pos = MemoryArchive.findNext(data, end, currentStartPos + 1)) >= 0 && pos < end - 10) continue;
            break;
        }
        out.write(80);
        out.write(75);
        out.write(5);
        out.write(6);
        out.write(0);
        out.write(0);
        out.write(0);
        out.write(0);
        out.write(numberOfEntries);
        out.write(numberOfEntries >> 8);
        out.write(numberOfEntries);
        out.write(numberOfEntries >> 8);
        out.write(startOfFooterPos - 10);
        out.write(startOfFooterPos - 10 >> 8);
        out.write(startOfFooterPos - 10 >> 16);
        out.write(startOfFooterPos - 10 >> 24);
        out.write(startOfFooterPos);
        out.write(startOfFooterPos >> 8);
        out.write(startOfFooterPos >> 16);
        out.write(startOfFooterPos >> 24);
        out.write(0);
        out.write(0);
    }

    public static int findNext(byte[] data, int end, int i) {
        while (i < end - 4) {
            if (data[i] == 80 && data[i + 1] == 75 && data[i + 2] == 3 && data[i + 3] == 4) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public int handleDeflated(byte[] data, int pos) {
        this.readPos = pos;
        boolean wasLastBlock = false;
        do {
            byte firstHeaderByte = data[pos++];
            int blockType = firstHeaderByte >> 1 & 3;
            wasLastBlock = (firstHeaderByte & 1) != 0;
            switch (blockType) {
                case 0: {
                    int blockLength = ((char)data[pos++] & 0xFF) + (((char)data[pos++] & 0xFF) << 8);
                    int compliment = (char)data[pos++] & 0xFF;
                    System.out.println("Stored block length: " + blockLength);
                    pos += blockLength;
                    break;
                }
                case 1: {
                    byte literal;
                    byte firstByte = data[pos++];
                    System.out.println("First byte: " + Integer.toHexString(firstByte));
                    while ((literal = data[pos++]) != 256) {
                    }
                    break;
                }
                case 2: {
                    System.out.println("Dynamic huffman...");
                    int literalCodeCount = this.readFiveBits() + 256;
                    int distCodeCount = this.readFiveBits() + 1;
                    int bitLengthCodeCount = this.readFourBits() + 3;
                    System.out.println("Literal code count: " + literalCodeCount);
                    System.out.println("Dist code count: " + distCodeCount);
                    System.out.println("Bit length code count: " + bitLengthCodeCount);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Illegal deflate blocktype: " + blockType);
                }
            }
            System.exit(1);
        } while (!wasLastBlock);
        return pos;
    }

    public boolean contains(String name) {
        return this.getOffset(name) >= 0;
    }

    public boolean contains(ByteString name) {
        return this.getOffset(name) >= 0;
    }

    public int getOffset(String name) {
        int offset;
        int[] hashes;
        if (this.hash == null) {
            this.init();
        }
        if (!this.safe) {
            return -1;
        }
        int hashCode = 0;
        int length = name.length();
        for (int hashPos = length - 2; hashPos >= 0; hashPos -= 2) {
            hashCode <<= 1;
            hashCode += (byte)name.charAt(hashPos);
        }
        if (hashCode == 0) {
            hashCode = 1;
        }
        if ((hashes = this.hash[offset = hashCode & 0xFF]) == null) {
            return -1;
        }
        for (int i = 0; i < hashes.length; i += 2) {
            int y;
            int startPos;
            byte[] data;
            int filenameLength;
            if (hashes[i] != hashCode || (filenameLength = ((char)(data = this.archiveData)[startPos = hashes[i + 1] + 26] & 0xFF) + (((char)data[startPos + 1] & 0xFF) << 8)) != length) continue;
            startPos += 4;
            for (y = 0; y < filenameLength && data[startPos + y] == (byte)name.charAt(y); ++y) {
            }
            if (y != filenameLength) continue;
            return hashes[i + 1];
        }
        return -1;
    }

    public int getOffset(ByteString name) {
        int offset;
        int[] hashes;
        if (this.hash == null) {
            this.init();
        }
        if (!this.safe) {
            return -1;
        }
        int hashCode = 0;
        int length = name.length;
        for (int hashPos = length - 2; hashPos >= 0; hashPos -= 2) {
            hashCode <<= 1;
            hashCode += (byte)name.charAt(hashPos);
        }
        if (hashCode == 0) {
            hashCode = 1;
        }
        if ((hashes = this.hash[offset = hashCode & 0xFF]) == null) {
            return -1;
        }
        for (int i = 0; i < hashes.length; i += 2) {
            int y;
            int startPos;
            byte[] data;
            int filenameLength;
            if (hashes[i] != hashCode || (filenameLength = ((char)(data = this.archiveData)[startPos = hashes[i + 1] + 26] & 0xFF) + (((char)data[startPos + 1] & 0xFF) << 8)) != length) continue;
            startPos += 4;
            for (y = 0; y < filenameLength && data[startPos + y] == name.data[name.offset + y]; ++y) {
            }
            if (y != filenameLength) continue;
            return hashes[i + 1];
        }
        return -1;
    }

    public ByteString getContent(ByteString name) throws IOException {
        Entry content;
        if (this.newEntries != null && (content = (Entry)this.newEntries.get(name.toString())) != null) {
            return new ByteString(content.data);
        }
        return this.getContent(this.getOffset(name));
    }

    public ByteString getContent(String name) throws IOException {
        Entry content;
        if (this.newEntries != null && (content = (Entry)this.newEntries.get(name)) != null) {
            return new ByteString(content.data);
        }
        return this.getContent(this.getOffset(name));
    }

    public ByteString getContent(int offset) throws IOException {
        if (offset < 0) {
            return null;
        }
        int compressionMethod = ((char)this.archiveData[offset + 8] & 0xFF) + (((char)this.archiveData[offset + 9] & 0xFF) << 8);
        if (compressionMethod == 0) {
            int filenameLength = ((char)this.archiveData[offset + 26] & 0xFF) + (((char)this.archiveData[offset + 27] & 0xFF) << 8);
            int extraLength = ((char)this.archiveData[offset + 28] & 0xFF) + (((char)this.archiveData[offset + 29] & 0xFF) << 8);
            int size = (((char)this.archiveData[offset + 22] & 0xFF) << 0) + (((char)this.archiveData[offset + 23] & 0xFF) << 8) + (((char)this.archiveData[offset + 24] & 0xFF) << 16) + (((char)this.archiveData[offset + 25] & 0xFF) << 24);
            return new ByteString(this.archiveData, offset += 30 + filenameLength + extraLength, size);
        }
        ZipInputStream zipIn = new ZipInputStream(new ByteArrayInputStream(this.archiveData, offset, this.end - offset));
        ZipEntry entry = zipIn.getNextEntry();
        int size = (int)entry.getSize();
        if (size > 0) {
            byte[] buffer = new byte[size];
            int bufferPos = 0;
            while (bufferPos < size && (bufferPos += zipIn.read(buffer, bufferPos, buffer.length - bufferPos)) >= 0) {
            }
            zipIn.close();
            return new ByteString(buffer);
        }
        ByteString result = new ByteString(IOUtils.getContent(zipIn));
        zipIn.close();
        return result;
    }

    public Collection getNames() {
        if (this.hash == null) {
            this.init();
        }
        ArrayList<String> names = new ArrayList<String>();
        if (!this.safe) {
            return names;
        }
        for (int i = 0; i < this.hash.length; ++i) {
            if (this.hash[i] == null) continue;
            int[] hashes = this.hash[i];
            for (int y = 0; y < hashes.length; y += 2) {
                if (hashes[y] == 0) continue;
                names.add(this.getName(hashes[y + 1]));
            }
        }
        if (this.newEntries != null) {
            names.removeAll(this.newEntries.keySet());
            names.addAll(this.newEntries.keySet());
        }
        return names;
    }

    public String getName(int pos) {
        int filenameLength = ((char)this.archiveData[pos + 26] & 0xFF) + (((char)this.archiveData[pos + 27] & 0xFF) << 8);
        return new String(this.archiveData, pos + 30, filenameLength);
    }

    public void write(String newEntry, Object newEntryData, long lastModified) throws IOException {
        if (this.newEntries == null) {
            this.newEntries = new HashMap();
        }
        this.newEntries.put(newEntry, new Entry((byte[])newEntryData, lastModified));
    }

    public void flushNewEntries() throws IOException {
        if (this.newEntries == null || this.newEntries.isEmpty()) {
            this.newEntries = null;
            return;
        }
        Iterator<Object> iterator = this.getNames().iterator();
        InteractiveByteArrayOutputStream byteOut = new InteractiveByteArrayOutputStream();
        ZipOutputStream zipOut = new ZipOutputStream(byteOut);
        Object crc = null;
        while (iterator.hasNext()) {
            ByteString data;
            String name = iterator.next().toString();
            if (this.newEntries.containsKey(name)) continue;
            ZipEntry entry = new ZipEntry(name);
            boolean isDirectory = name.endsWith("/");
            long entryModified = this.getLastModified(name);
            ByteString byteString = data = isDirectory ? null : this.getContent(name);
            if (entryModified > 0L) {
                entry.setTime(entryModified);
            }
            if (!isDirectory) {
                entry.setSize(data.length);
            }
            zipOut.putNextEntry(entry);
            if (!isDirectory) {
                zipOut.write(data.data, data.offset, data.length);
            }
            zipOut.closeEntry();
        }
        iterator = this.newEntries.entrySet().iterator();
        while (iterator.hasNext()) {
            byte[] data;
            Map.Entry mapEntry = (Map.Entry)iterator.next();
            String name = (String)mapEntry.getKey();
            Entry value = (Entry)mapEntry.getValue();
            ZipEntry entry = new ZipEntry(name);
            boolean isDirectory = name.endsWith("/");
            long entryModified = value.lastModified;
            byte[] byArray = data = isDirectory ? null : value.data;
            if (entryModified > 0L) {
                entry.setTime(entryModified);
            }
            if (!isDirectory) {
                if (data == null) continue;
                entry.setSize(data.length);
            }
            zipOut.putNextEntry(entry);
            if (!isDirectory) {
                zipOut.write(data, 0, data.length);
            }
            zipOut.closeEntry();
        }
        zipOut.close();
        zipOut.flush();
        ByteString content = byteOut.toByteString();
        this.newEntries = null;
        this.setData(content.data, content.offset, content.length);
    }

    public ByteString getData() throws IOException {
        if (this.newEntries != null && !this.newEntries.isEmpty()) {
            this.flushNewEntries();
        }
        return new ByteString(this.archiveData, this.start, this.end - this.start);
    }

    public long getLastModified(String name) throws IOException {
        Entry content;
        if (this.newEntries != null && (content = (Entry)this.newEntries.get(name)) != null) {
            return content.lastModified;
        }
        return this.getLastModified(this.getOffset(name));
    }

    public long getLastModified(ByteString name) throws IOException {
        Entry content;
        if (this.newEntries != null && (content = (Entry)this.newEntries.get(name.toString())) != null) {
            return content.lastModified;
        }
        return this.getLastModified(this.getOffset(name));
    }

    public long getLastModified(int offset) throws IOException {
        if (offset < 0) {
            return 0L;
        }
        int time = (((char)this.archiveData[offset + 10] & 0xFF) << 0) + (((char)this.archiveData[offset + 11] & 0xFF) << 8);
        int dateInt = (((char)this.archiveData[offset + 12] & 0xFF) << 0) + (((char)this.archiveData[offset + 13] & 0xFF) << 8);
        int monthDate = dateInt & 0x1F;
        int month = (dateInt & 0x1E0) / 32 - 1;
        int year = (dateInt & 0xFE00) / 512 + 1980;
        int hour = (time & 0xF800) / 2048;
        int minutes = (time & 0x7E0) / 32;
        int seconds = 2 * (time & 0x1F);
        Calendar calendar = Calendar.getInstance();
        calendar.set(1, year);
        calendar.set(2, month);
        calendar.set(5, monthDate);
        calendar.set(11, hour);
        calendar.set(12, minutes);
        calendar.set(13, seconds);
        calendar.set(14, 0);
        return calendar.getTimeInMillis();
    }

    public boolean containsDirectory(String name) {
        int nameLength = name.length();
        if (this.hash == null) {
            this.init();
        }
        if (!this.safe) {
            return false;
        }
        for (int i = 0; i < this.hash.length; ++i) {
            if (this.hash[i] == null) continue;
            int[] hashes = this.hash[i];
            for (int y = 0; y < hashes.length; y += 2) {
                int z;
                if (hashes[y] == 0) continue;
                int pos = hashes[y + 1];
                int filenameLength = ((char)this.archiveData[pos + 26] & 0xFF) + (((char)this.archiveData[pos + 27] & 0xFF) << 8);
                if (filenameLength <= nameLength || this.archiveData[(pos += 30) + nameLength] != 47) continue;
                for (z = 0; z < nameLength && this.archiveData[pos + z] == (byte)name.charAt(z); ++z) {
                }
                if (z != name.length()) continue;
                return true;
            }
        }
        return false;
    }

    public int getLength(String name) throws IOException {
        int offset = this.getOffset(name);
        if (offset < 0) {
            return 0;
        }
        int size = (((char)this.archiveData[offset + 22] & 0xFF) << 0) + (((char)this.archiveData[offset + 23] & 0xFF) << 8) + (((char)this.archiveData[offset + 24] & 0xFF) << 16) + (((char)this.archiveData[offset + 25] & 0xFF) << 24);
        if (size > 0) {
            return size;
        }
        return this.getContent(name).length();
    }

    public static void writeEntry(byte[] buffer, int pos, byte[] name, byte[] data) {
        buffer[pos++] = 80;
        buffer[pos++] = 75;
        buffer[pos++] = 3;
        buffer[pos++] = 4;
        System.arraycopy(data, 0, buffer, pos + 26, data.length);
    }

    public static void main(String[] args) throws IOException {
        byte[] data = IOUtils.getContent(new FileInputStream("C:\\petstore1.1.2\\petstore.ear"));
        MemoryArchive archive = new MemoryArchive(data, 0, data.length, "test");
        archive.init();
        archive.end = 4;
        archive.start = 0;
        archive.archiveData = new byte[]{51, 51, 51, 51};
        System.out.println("Done");
    }

    public int getEndOfMainArchives() throws IOException {
        if (this.start == this.end) {
            return this.end;
        }
        if (this.archiveData[this.end - 1] != 0 || this.archiveData[this.end - 2] != 0) {
            throw new IOException("Global comment wasnt zero length, unreadable archive");
        }
        int offset = ((char)this.archiveData[this.end - 6] & 0xFF) + (((char)this.archiveData[this.end - 5] & 0xFF) << 8) + (((char)this.archiveData[this.end - 4] & 0xFF) << 16) + (((char)this.archiveData[this.end - 3] & 0xFF) << 24);
        return this.start + offset;
    }

    protected int readByte() {
        switch (this.bitShift) {
            case 0: {
                return (char)this.archiveData[this.readPos++] & 0xFF;
            }
        }
        return (((char)this.archiveData[this.readPos++] & 0xFF) << this.bitShift) + (((char)this.archiveData[this.readPos] & 0xFF) >> 8 - this.bitShift) & 0xFF;
    }

    protected int readFiveBits() {
        switch (this.bitShift) {
            case 0: {
                this.bitShift = 5;
                return (char)this.archiveData[this.readPos] & 0x1F;
            }
            case 1: {
                this.bitShift = 6;
                return (char)this.archiveData[this.readPos] >> 1 & 0x1F;
            }
            case 2: {
                this.bitShift = 7;
                return (char)this.archiveData[this.readPos] >> 2 & 0x1F;
            }
            case 3: {
                this.bitShift = 0;
                return (char)this.archiveData[this.readPos] >> 3 & 0x1F;
            }
            case 4: {
                this.bitShift = 1;
                return (((char)this.archiveData[this.readPos++] >> 4 & 0x1F) << 1) + ((char)this.archiveData[this.readPos] & '\u0001');
            }
            case 5: {
                this.bitShift = 2;
                return (((char)this.archiveData[this.readPos++] >> 5 & 0x1F) << 2) + ((char)this.archiveData[this.readPos] & 3);
            }
            case 6: {
                this.bitShift = 3;
                return (((char)this.archiveData[this.readPos++] >> 6 & 0x1F) << 3) + ((char)this.archiveData[this.readPos] & 7);
            }
        }
        this.bitShift = 4;
        return (((char)this.archiveData[this.readPos++] >> 7 & 0x1F) << 4) + ((char)this.archiveData[this.readPos] & 0xF);
    }

    protected int readFourBits() {
        System.out.println("Read four: " + this.bitShift);
        switch (this.bitShift) {
            case 0: {
                this.bitShift = 4;
                return (char)this.archiveData[this.readPos] & 0xF;
            }
            case 1: {
                this.bitShift = 5;
                return (char)this.archiveData[this.readPos] >> 1 & 0xF;
            }
            case 2: {
                this.bitShift = 6;
                return (char)this.archiveData[this.readPos] >> 2 & 0xF;
            }
            case 3: {
                this.bitShift = 7;
                return (char)this.archiveData[this.readPos] >> 3 & 0xF;
            }
            case 4: {
                this.bitShift = 0;
                return (char)this.archiveData[this.readPos++] >> 4 & 0xF;
            }
            case 5: {
                this.bitShift = 1;
                return (((char)this.archiveData[this.readPos++] >> 5 & 0xF) << 1) + ((char)this.archiveData[this.readPos] & '\u0001');
            }
            case 6: {
                this.bitShift = 2;
                return (((char)this.archiveData[this.readPos++] >> 6 & 0xF) << 2) + ((char)this.archiveData[this.readPos] & 3);
            }
        }
        this.bitShift = 3;
        return (((char)this.archiveData[this.readPos++] >> 7 & 0xF) << 3) + ((char)this.archiveData[this.readPos] & 7);
    }

    protected boolean readBit() {
        switch (this.bitShift) {
            case 0: {
                this.bitShift = 1;
                return (this.archiveData[this.readPos] & 1) != 0;
            }
            case 1: {
                this.bitShift = 2;
                return (this.archiveData[this.readPos] & 2) != 0;
            }
            case 2: {
                this.bitShift = 3;
                return (this.archiveData[this.readPos] & 4) != 0;
            }
            case 3: {
                this.bitShift = 4;
                return (this.archiveData[this.readPos] & 8) != 0;
            }
            case 4: {
                this.bitShift = 5;
                return (this.archiveData[this.readPos] & 0x10) != 0;
            }
            case 5: {
                this.bitShift = 6;
                return (this.archiveData[this.readPos] & 0x20) != 0;
            }
            case 6: {
                this.bitShift = 7;
                return (this.archiveData[this.readPos] & 0x40) != 0;
            }
        }
        this.bitShift = 0;
        return (this.archiveData[this.readPos++] & 0x80) != 0;
    }

    protected String readCentralRecord() {
        try {
            int fileCommentLength;
            int extraFieldLength;
            int filenameLength;
            try {
                int centralDirPos = this.getEndOfMainArchives();
            }
            catch (IOException e) {
                return "IO Error: " + e.getMessage();
            }
            byte[] data = this.archiveData;
            int end = this.end;
            for (int pos = centralDirPos; pos < end; pos += filenameLength + extraFieldLength + fileCommentLength) {
                int offset;
                int relativeOffset;
                int startOfEntryPos = pos;
                if (data[pos++] != 80 || data[pos++] != 75 || data[pos++] != 1 || data[pos++] != 2) {
                    if (pos >= 4 && pos < end - 1 && data[pos - 3] == 80 && data[pos - 2] == 75 && data[pos - 1] == 5 && data[pos] == 6) {
                        return null;
                    }
                    return "Bad format, expected central directory file header at " + startOfEntryPos;
                }
                pos += 24;
                filenameLength = ((char)data[pos++] & 0xFF) + (((char)data[pos++] & 0xFF) << 8);
                extraFieldLength = ((char)data[pos++] & 0xFF) + (((char)data[pos++] & 0xFF) << 8);
                fileCommentLength = ((char)data[pos++] & 0xFF) + (((char)data[pos++] & 0xFF) << 8);
                pos += 8;
                int currentStartPos = relativeOffset = ((char)data[pos++] & 0xFF) + (((char)data[pos++] & 0xFF) << 8) + (((char)data[pos++] & 0xFF) << 16) + (((char)data[pos++] & 0xFF) << 24);
                int hashCode = 0;
                for (int hashPos = pos + filenameLength - 2; hashPos >= pos; hashPos -= 2) {
                    hashCode <<= 1;
                    hashCode += data[hashPos];
                }
                if (hashCode == 0) {
                    hashCode = 1;
                }
                if (this.hash[offset = hashCode & 0xFF] == null) {
                    this.hash[offset] = new int[4];
                    int[] currentHash = this.hash[offset];
                    currentHash[0] = hashCode;
                    currentHash[1] = currentStartPos;
                    continue;
                }
                int[] oldHash = this.hash[offset];
                if (oldHash[oldHash.length - 2] == 0) {
                    oldHash[oldHash.length - 2] = hashCode;
                    oldHash[oldHash.length - 1] = currentStartPos;
                    continue;
                }
                int[] newHash = new int[oldHash.length + 4];
                System.arraycopy(oldHash, 0, newHash, 0, oldHash.length);
                newHash[newHash.length - 4] = hashCode;
                newHash[newHash.length - 3] = currentStartPos;
                this.hash[offset] = newHash;
            }
            return null;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return "Corrupt central directory data";
        }
    }

    private class Entry {
        public byte[] data;
        public long lastModified;

        public Entry(byte[] data, long lastModified) {
            this.data = data;
            this.lastModified = lastModified;
        }
    }
}

