/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.util;

import com.evermind.security.User;
import com.evermind.security.UserManager;
import com.evermind.server.ApplicationConfig;
import java.lang.reflect.Constructor;
import java.security.Permission;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import oracle.oc4j.admin.jmx.shared.exceptions.JMXRuntimeException;
import oracle.oc4j.admin.management.shared.Group;

public class UserManagerUtils {
    public static boolean isCallerInRole(UserManager manager, String role, User user) {
        if (role.equalsIgnoreCase("[ALL]")) {
            return true;
        }
        if (manager == null || user == null) {
            return false;
        }
        com.evermind.security.Group group = manager.getGroup(role);
        if (group != null) {
            return user.isMemberOf(group);
        }
        User found = manager.getUser(role);
        return found != null && found.equals(user);
    }

    public static void addUser(UserManager usrmngr, String username, String password, String description) {
        try {
            User usr = usrmngr.createUser(username, password);
            if (description != null && usr != null) {
                usr.setDescription(description);
            }
        }
        catch (Exception e) {
            throw new JMXRuntimeException((Throwable)e, e.getMessage());
        }
    }

    public static void removeUser(UserManager usrmngr, String username) {
        try {
            User usr = usrmngr.getUser(username);
            if (usr == null) {
                throw new JMXRuntimeException("User named: " + username + " does not exist.");
            }
            usrmngr.remove(usr);
        }
        catch (Exception e) {
            throw new JMXRuntimeException((Throwable)e, e.getMessage());
        }
    }

    public static Set getGroupsForUser(ApplicationConfig config, String username) {
        HashSet<Group> groups = new HashSet<Group>();
        UserManager stop = config.getParentUserManager();
        for (UserManager userManager = config.getUserManager(); userManager != null && userManager != stop; userManager = userManager.getParent()) {
            User usr = userManager.getUser(username);
            if (usr == null) continue;
            Set set = usr.getGroups();
            Iterator iter = set.iterator();
            while (iter.hasNext()) {
                com.evermind.security.Group group = (com.evermind.security.Group)iter.next();
                groups.add(new Group(group.getName(), group.getDescription()));
            }
        }
        return groups;
    }

    public static Set getGroups(ApplicationConfig config) {
        HashSet<Group> groups = new HashSet<Group>();
        UserManager stop = config.getParentUserManager();
        for (UserManager userManager = config.getUserManager(); userManager != null && userManager != stop; userManager = userManager.getParent()) {
            int groupCnt = userManager.getGroupCount();
            List lst = userManager.getGroups(0, groupCnt);
            Iterator iter = lst.iterator();
            while (iter.hasNext()) {
                com.evermind.security.Group group = (com.evermind.security.Group)iter.next();
                groups.add(new Group(group.getName(), group.getDescription()));
            }
        }
        return groups;
    }

    public static void addGroup(UserManager usrmngr, String groupname, String description) {
        try {
            com.evermind.security.Group grp = usrmngr.createGroup(groupname);
            if (description != null && grp != null) {
                grp.setDescription(description);
            }
        }
        catch (Exception e) {
            throw new JMXRuntimeException((Throwable)e, e.getMessage());
        }
    }

    public static void removeGroup(UserManager usrmngr, String groupname) {
        try {
            com.evermind.security.Group grp = usrmngr.getGroup(groupname);
            if (grp == null) {
                throw new JMXRuntimeException("Group named: " + groupname + " does not exist.");
            }
            usrmngr.remove(grp);
        }
        catch (Exception e) {
            throw new JMXRuntimeException((Throwable)e, e.getMessage());
        }
    }

    public static void addUserToGroup(UserManager usrmngr, String username, String groupname) {
        try {
            com.evermind.security.Group grp;
            User usr = usrmngr.getUser(username);
            if (usr != null) {
                grp = usrmngr.getGroup(groupname);
                if (grp == null) {
                    throw new JMXRuntimeException("Group named: " + groupname + " does not exist.");
                }
            } else {
                throw new JMXRuntimeException("User named: " + username + " does not exist.");
            }
            usr.addToGroup(grp);
        }
        catch (Exception e) {
            throw new JMXRuntimeException((Throwable)e, e.getMessage());
        }
    }

    public static void removeUserFromGroup(UserManager usrmngr, String username, String groupname) {
        try {
            com.evermind.security.Group grp;
            User usr = usrmngr.getUser(username);
            if (usr != null) {
                grp = usrmngr.getGroup(groupname);
                if (grp == null) {
                    throw new JMXRuntimeException("Group named: " + groupname + " does not exist.");
                }
            } else {
                throw new JMXRuntimeException("User named: " + username + " does not exist.");
            }
            usr.removeFromGroup(grp);
        }
        catch (Exception e) {
            throw new JMXRuntimeException((Throwable)e, e.getMessage());
        }
    }

    public static Set getPermissionsForGroup(UserManager usrmngr, String groupname) {
        try {
            com.evermind.security.Group grp = usrmngr.getGroup(groupname);
            if (grp != null) {
                return grp.getPermissions();
            }
            throw new JMXRuntimeException("Group named: " + groupname + " does not exist.");
        }
        catch (Exception e) {
            throw new JMXRuntimeException((Throwable)e, e.getMessage());
        }
    }

    public static void addPermissionToGroup(UserManager usrmngr, String permissionclass, String permissionname, String actions, String groupname) {
        try {
            Object[] args;
            Class[] params;
            Class<?> cl;
            com.evermind.security.Group grp = usrmngr.getGroup(groupname);
            if (grp != null) {
                cl = Class.forName(permissionclass);
                params = null;
                args = null;
                if (actions == null) {
                    params = new Class[]{Class.forName("java.lang.String")};
                    args = new Object[]{permissionname};
                } else {
                    params = new Class[]{Class.forName("java.lang.String"), Class.forName("java.lang.String")};
                    args = new Object[]{permissionname, actions};
                }
            } else {
                throw new JMXRuntimeException("Group named: " + groupname + " does not exist.");
            }
            Constructor<?> constr = cl.getConstructor(params);
            Object perm = constr.newInstance(args);
            grp.addPermission((Permission)perm);
        }
        catch (Exception e) {
            throw new JMXRuntimeException((Throwable)e, e.getMessage());
        }
    }

    public static void removePermissionFromGroup(UserManager usrmngr, String permissionclass, String permissionname, String actions, String groupname) {
        try {
            Object[] args;
            Class[] params;
            Class<?> cl;
            com.evermind.security.Group grp = usrmngr.getGroup(groupname);
            if (grp != null) {
                cl = Class.forName(permissionclass);
                params = null;
                args = null;
                if (actions == null) {
                    params = new Class[]{Class.forName("java.lang.String")};
                    args = new Object[]{permissionname};
                } else {
                    params = new Class[]{Class.forName("java.lang.String"), Class.forName("java.lang.String")};
                    args = new Object[]{permissionname, actions};
                }
            } else {
                throw new JMXRuntimeException("Group named: " + groupname + " does not exist.");
            }
            Constructor<?> constr = cl.getConstructor(params);
            Object perm = constr.newInstance(args);
            grp.removePermission((Permission)perm);
        }
        catch (Exception e) {
            throw new JMXRuntimeException((Throwable)e, e.getMessage());
        }
    }
}

