/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.util;

import EDU.oswego.cs.dl.util.concurrent.CountDown;
import com.evermind.server.Application;
import com.evermind.server.ApplicationServer;
import com.evermind.server.ServerMessages;
import com.evermind.server.ejb.cache.CacheManagerTask;
import com.evermind.util.ServerProperties;
import com.evermind.util.Task;
import com.evermind.util.ThreadPool;
import java.util.logging.Logger;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import oracle.dms.instrument.NounIntf;
import oracle.j2ee.util.TraceLogger;
import oracle.oc4j.admin.jmx.server.Oc4jMBeanServerFactory;
import oracle.oc4j.admin.jmx.server.mbeans.model.ModelMBeanFactory;
import oracle.oc4j.admin.jmx.shared.exceptions.JMXRuntimeException;
import oracle.oc4j.admin.management.callbackinterfaces.TaskManagerCallBackIf;

public class TaskManager
implements Runnable,
TaskManagerCallBackIf {
    private static int taskSerialNumberCntr = 0;
    public static int taskManagerCntr = 0;
    private static int taskManagerCounter_ = 0;
    protected Task[] tasks = new Task[0];
    protected long granularity;
    protected boolean alive = false;
    protected Thread thread;
    protected ThreadPool threadPool;
    protected ThreadPool cxthreadPool;
    protected Task currentlyRunningTask;
    protected long lastKnownNotHavingReturned;
    private String taskManagerName_ = null;
    private NounIntf taskManagerNoun = null;
    private final CountDown taskManagerSynchronizer = new CountDown(1);
    private static Logger m_logger = TraceLogger.getLogger(TaskManager.class);

    public TaskManager(ThreadPool pool, ThreadPool cxpool) {
        this(1000L, pool, cxpool);
        this.alive = false;
    }

    public TaskManager(long granularity, ThreadPool pool, ThreadPool cxpool) {
        if (granularity < 1000L) {
            granularity = 1000L;
        }
        if (ApplicationServer.DMS_GATE) {
            this.taskManagerNoun = ApplicationServer.nounFactory().create(Application.getJ2eeNoun(), "Task Manager [" + ++taskManagerCntr + "]", "oc4j_taskManager");
            ApplicationServer.stateFactory().create(this.taskManagerNoun, "granularity", "milli-seconds", "granularity", granularity);
        }
        this.granularity = granularity;
        this.threadPool = pool;
        this.cxthreadPool = cxpool;
        this.taskManagerName_ = "TaskManager_" + taskManagerCounter_++;
        this.alive = false;
    }

    private static synchronized int getTaskSerialNumber() {
        return ++taskSerialNumberCntr;
    }

    public void addTask(Runnable runnable) {
        this.addTask(runnable, 0L);
    }

    public void addTask(Runnable runnable, long interval) {
        this.addTask(runnable, interval, runnable.getClass().getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTask(Runnable runnable, long interval, String taskNm) {
        if (interval < 0L) {
            interval = 0L;
        }
        Task newTask = new Task(runnable, interval, "TASK[" + TaskManager.getTaskSerialNumber() + "] " + taskNm, this.taskManagerNoun);
        TaskManager taskManager = this;
        synchronized (taskManager) {
            Task[] tasks = this.tasks;
            for (int i = 0; i < this.tasks.length; ++i) {
                if (!tasks[i].equals(newTask)) continue;
                return;
            }
            m_logger.fine("Adding task: " + newTask + " to the task list");
            Task[] newTasks = new Task[tasks.length + 1];
            System.arraycopy(tasks, 0, newTasks, 0, tasks.length);
            newTasks[newTasks.length - 1] = newTask;
            this.tasks = newTasks;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        TaskManager taskManager = this;
        synchronized (taskManager) {
            if (this.alive) {
                return;
            }
            this.alive = true;
            this.registerMBean();
            this.threadPool.launch(this);
            m_logger.finest("Task Manager started.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        TaskManager taskManager = this;
        synchronized (taskManager) {
            if (!this.alive) {
                return;
            }
            this.alive = false;
            this.unregisterMBean();
            try {
                if (this.thread != null) {
                    this.thread.notify();
                }
            }
            catch (IllegalMonitorStateException illegalMonitorStateException) {
                // empty catch block
            }
        }
        if (this.currentlyRunningTask == null) {
            ServerMessages.infoNoTasksExecuting();
            return;
        }
        try {
            String taskName = this.currentlyRunningTask.name;
            ServerMessages.infoWaitingForTaskToComplete(taskName);
            this.taskManagerSynchronizer.acquire();
            ServerMessages.infoTaskComplete(taskName);
        }
        catch (InterruptedException e) {
            m_logger.finest("Caught InterruptedException: " + e);
        }
    }

    public void stopAndCleanUp() {
        this.stop();
        this.tasks = new Task[0];
        this.threadPool = null;
        this.cxthreadPool = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeTask(Runnable runnable) {
        if (runnable == null) {
            return;
        }
        TaskManager taskManager = this;
        synchronized (taskManager) {
            Task[] tasks = this.tasks;
            for (int i = 0; i < tasks.length; ++i) {
                Task task = tasks[i];
                if (!task.runnable.equals(runnable)) continue;
                m_logger.finest("Removing task: " + task + " from the task list");
                Task[] newTasks = new Task[tasks.length - 1];
                System.arraycopy(tasks, 0, newTasks, 0, i);
                System.arraycopy(tasks, i + 1, newTasks, i, tasks.length - i - 1);
                this.tasks = newTasks;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        this.thread = Thread.currentThread();
        try {
            this.thread.setName("TaskManager");
        }
        catch (Throwable t) {
            // empty catch block
        }
        try {
            while (this.alive) {
                long time = 0L;
                long interval = 0L;
                Task[] tasks = this.tasks;
                long token = 0L;
                for (int i = 0; this.alive && i < tasks.length; ++i) {
                    Task task = tasks[i];
                    long start = System.currentTimeMillis();
                    if (task.interval == 0L) {
                        if (this.alive) {
                            task.schedule(this);
                        }
                    } else {
                        if (time == 0L) {
                            time = System.currentTimeMillis();
                        }
                        if (task.nextScheduledInvocation < time && this.alive) {
                            task.schedule(this);
                            task.nextScheduledInvocation = time + task.interval;
                        }
                    }
                    if (!ServerProperties.getContainerProfile()) continue;
                    long elapsed = System.currentTimeMillis() - start;
                    System.out.println("R " + task.name + " elapsed ms:" + elapsed + " s:" + elapsed / 1000L + " " + (long)task.hashCode());
                }
                if (!this.alive) break;
                try {
                    int sleepinterval;
                    this.lastKnownNotHavingReturned = 0L;
                    int cminterval = CacheManagerTask.instance().getWakeInterval();
                    if (this.granularity < (long)cminterval || cminterval == Integer.MAX_VALUE) {
                        Thread.sleep(this.granularity);
                        if (!this.threadPool.isDebug()) continue;
                        this.threadPool.printShort();
                        if (this.cxthreadPool == null || this.threadPool == this.cxthreadPool) continue;
                        this.cxthreadPool.printShort();
                        continue;
                    }
                    for (int s = sleepinterval = (int)Math.floor(this.granularity / (long)cminterval); s > 0; --s) {
                        Thread.sleep(cminterval);
                        if (s == 1) {
                            CacheManagerTask.instance().run();
                        }
                        if (!this.threadPool.isDebug()) continue;
                        this.threadPool.printShort();
                        if (this.cxthreadPool == null || this.threadPool == this.cxthreadPool) continue;
                        this.cxthreadPool.printShort();
                    }
                }
                catch (InterruptedException e) {
                }
            }
            Object var15_13 = null;
            m_logger.finest("Completed executing task: " + this.currentlyRunningTask);
            this.currentlyRunningTask = null;
            this.thread = null;
            this.taskManagerSynchronizer.release();
            return;
        }
        catch (Throwable throwable) {
            Object var15_14 = null;
            m_logger.finest("Completed executing task: " + this.currentlyRunningTask);
            this.currentlyRunningTask = null;
            this.thread = null;
            this.taskManagerSynchronizer.release();
            throw throwable;
        }
    }

    public long getLastKnownNotHavingReturned() {
        if (this.lastKnownNotHavingReturned == 0L) {
            this.lastKnownNotHavingReturned = System.currentTimeMillis();
        }
        return this.lastKnownNotHavingReturned;
    }

    public Task getCurrentlyRunningTask() {
        return this.currentlyRunningTask;
    }

    public Thread getThread() {
        return this.thread;
    }

    public long getgranularity() {
        return this.granularity;
    }

    public void setgranularity(long val) {
        this.granularity = val > 1000L ? val : 1000L;
    }

    public long getnumberOfTasks() {
        return this.tasks.length;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] gettaskNames() {
        TaskManager taskManager = this;
        synchronized (taskManager) {
            String[] names = new String[this.tasks.length];
            for (int i = 0; i < this.tasks.length; ++i) {
                names[i] = this.tasks[i].name + " interval: " + this.tasks[i].interval;
            }
            return names;
        }
    }

    private void registerMBean() {
        MBeanServer oc4jMBeanServer = Oc4jMBeanServerFactory.getMBeanServer();
        oracle.oc4j.admin.management.mbeans.TaskManager mbean = new oracle.oc4j.admin.management.mbeans.TaskManager(this, this.taskManagerName_);
        try {
            if (oc4jMBeanServer.isRegistered(mbean.getObjectName())) {
                oc4jMBeanServer.unregisterMBean(mbean.getObjectName());
            }
            oc4jMBeanServer.registerMBean(ModelMBeanFactory.getModelMBean(mbean), mbean.getObjectName());
        }
        catch (MalformedObjectNameException e) {
            e.printStackTrace();
            throw new JMXRuntimeException((Throwable)e);
        }
        catch (MBeanRegistrationException e) {
            e.printStackTrace();
            throw new JMXRuntimeException((Throwable)e);
        }
        catch (InstanceAlreadyExistsException e) {
            e.printStackTrace();
            throw new JMXRuntimeException((Throwable)e);
        }
        catch (InstanceNotFoundException e) {
            e.printStackTrace();
            throw new JMXRuntimeException((Throwable)e);
        }
        catch (NotCompliantMBeanException e) {
            e.printStackTrace();
            throw new JMXRuntimeException((Throwable)e);
        }
        catch (MBeanException e) {
            e.printStackTrace();
            throw new JMXRuntimeException((Throwable)e);
        }
    }

    private void unregisterMBean() {
        try {
            MBeanServer oc4jMBeanServer = Oc4jMBeanServerFactory.getMBeanServer();
            oracle.oc4j.admin.management.mbeans.TaskManager mbean = new oracle.oc4j.admin.management.mbeans.TaskManager(this, this.taskManagerName_);
            if (oc4jMBeanServer.isRegistered(mbean.getObjectName())) {
                oc4jMBeanServer.unregisterMBean(mbean.getObjectName());
            }
        }
        catch (MalformedObjectNameException e) {
            e.printStackTrace();
            throw new JMXRuntimeException((Throwable)e);
        }
        catch (InstanceNotFoundException e) {
            e.printStackTrace();
            throw new JMXRuntimeException((Throwable)e);
        }
        catch (MBeanRegistrationException e) {
            e.printStackTrace();
            throw new JMXRuntimeException((Throwable)e);
        }
    }
}

