/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.util;

import com.evermind.server.ApplicationServer;
import com.evermind.util.TaskManager;
import oracle.dms.instrument.NounIntf;
import oracle.dms.instrument.PhaseEventIntf;

public class Task {
    public long nextScheduledInvocation;
    public long interval;
    public Runnable runnable;
    public String name;
    private NounIntf taskNoun = null;
    private PhaseEventIntf runPE = null;

    public Task(Runnable runnable, long interval, String name, NounIntf parentNoun) {
        if (runnable == null) {
            throw new NullPointerException("The Runnable was null");
        }
        this.runnable = runnable;
        this.interval = interval;
        this.nextScheduledInvocation = System.currentTimeMillis();
        this.name = name;
        if (ApplicationServer.DMS_GATE) {
            this.taskNoun = ApplicationServer.nounFactory().create(parentNoun, name, "oc4j_task");
            ApplicationServer.stateFactory().create(this.taskNoun, "interval", "milli-seconds", "interval", interval);
            this.runPE = ApplicationServer.phaseEventFactory().create(this.taskNoun, "run()", "run()");
            this.runPE.deriveMetric(511);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void schedule(TaskManager tm) {
        long token = 0L;
        try {
            try {
                if (ApplicationServer.DMS_GATE && this.runPE != null) {
                    token = this.runPE.start();
                }
                tm.currentlyRunningTask = this;
                this.runnable.run();
            }
            catch (Throwable t) {
                Thread.currentThread().getThreadGroup().uncaughtException(Thread.currentThread(), t);
                Object var6_4 = null;
                tm.currentlyRunningTask = this;
                if (!ApplicationServer.DMS_GATE) return;
                if (this.runPE == null) return;
                this.runPE.stop(token);
                return;
            }
            Object var6_3 = null;
            tm.currentlyRunningTask = this;
            if (!ApplicationServer.DMS_GATE) return;
            if (this.runPE == null) return;
        }
        catch (Throwable throwable) {
            Object var6_5 = null;
            tm.currentlyRunningTask = this;
            if (!ApplicationServer.DMS_GATE) throw throwable;
            if (this.runPE == null) throw throwable;
            this.runPE.stop(token);
            throw throwable;
        }
        this.runPE.stop(token);
    }

    public boolean equals(Object other) {
        if (!(other instanceof Task)) {
            return false;
        }
        Task otherTask = (Task)other;
        return otherTask.interval == this.interval && otherTask.runnable.equals(this.runnable);
    }
}

