/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.util;

import com.evermind.util.ByteString;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.StringTokenizer;

public class StringUtils {
    public static String[] split(String string, String delimeter) {
        ArrayList<String> list = new ArrayList<String>();
        StringTokenizer tokenizer = new StringTokenizer(string, delimeter);
        while (tokenizer.hasMoreTokens()) {
            list.add(tokenizer.nextToken().trim());
        }
        return list.toArray(new String[list.size()]);
    }

    public static boolean passes(ByteString string, ByteString prefix, ByteString suffix) {
        int neededLength = 0;
        if (prefix != null) {
            if (!string.startsWith(prefix)) {
                return false;
            }
            neededLength += prefix.length;
        }
        if (suffix != null) {
            if (!string.endsWith(suffix)) {
                return false;
            }
            neededLength += suffix.length;
        }
        return neededLength <= string.length;
    }

    public static String join(String[] string, String delimeter) {
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < string.length; ++i) {
            buffer.append(string[i]);
            buffer.append(delimeter);
        }
        return buffer.toString();
    }

    public static String replace(String source, char original, String newDelimeter) {
        int swapIndex = source.indexOf(original);
        if (swapIndex >= 0) {
            StringBuffer result = new StringBuffer();
            int lastSwapIndex = 0;
            while (swapIndex >= 0) {
                result.append(source.substring(lastSwapIndex, swapIndex));
                result.append(newDelimeter);
                lastSwapIndex = swapIndex + 1;
                swapIndex = source.indexOf(original, lastSwapIndex);
            }
            if (lastSwapIndex < source.length()) {
                result.append(source.substring(lastSwapIndex, source.length()));
            }
            return result.toString();
        }
        return source;
    }

    public static String replace(String source, String original, String newDelimeter) {
        int swapIndex = source.indexOf(original);
        if (swapIndex >= 0) {
            StringBuffer result = new StringBuffer();
            int lastSwapIndex = 0;
            while (swapIndex >= 0) {
                result.append(source.substring(lastSwapIndex, swapIndex));
                result.append(newDelimeter);
                lastSwapIndex = swapIndex + original.length();
                swapIndex = source.indexOf(original, lastSwapIndex);
            }
            if (lastSwapIndex < source.length()) {
                result.append(source.substring(lastSwapIndex, source.length()));
            }
            return result.toString();
        }
        return source;
    }

    public static ByteString[] toByteString(String[] strings) {
        ByteString[] byteStrings = new ByteString[strings.length];
        for (int i = 0; i < byteStrings.length; ++i) {
            if (strings[i] == null) continue;
            byteStrings[i] = new ByteString(strings[i]);
        }
        return byteStrings;
    }

    public static ByteString[] toByteString(Collection collection) {
        ByteString[] byteStrings = new ByteString[collection.size()];
        Iterator iterator = collection.iterator();
        int i = 0;
        while (iterator.hasNext()) {
            Object object = iterator.next();
            if (object != null) {
                byteStrings[i] = new ByteString(object.toString());
            }
            ++i;
        }
        return byteStrings;
    }

    public static int getMatchedEndLength(String a, String b) {
        int size = a.length() > b.length() ? b.length() : a.length();
        for (int i = 0; i < size; ++i) {
            if (a.charAt(a.length() - i - 1) == b.charAt(b.length() - i - 1)) continue;
            return i;
        }
        return size;
    }

    public static int getMatchesIn(String content, String match) {
        int matchPos = 0;
        for (int i = 0; i < content.length(); ++i) {
            if (matchPos == match.length()) {
                return matchPos;
            }
            if (content.charAt(i) != match.charAt(matchPos)) continue;
            ++matchPos;
        }
        return matchPos;
    }

    public static int getMatchesInBackwards(String content, String match) {
        int matchPos = match.length() - 1;
        for (int i = content.length() - 1; i >= 0; --i) {
            if (matchPos == -1) {
                return match.length();
            }
            if (content.charAt(i) != match.charAt(matchPos)) continue;
            --matchPos;
        }
        return match.length() - 1 - matchPos;
    }

    public static String getShortName(String name, int maxNameLength) {
        if (name.length() <= maxNameLength) {
            return name;
        }
        int maxTailLength = Integer.toString(Integer.MIN_VALUE, 36).length();
        if (maxTailLength > maxNameLength) {
            maxTailLength = maxNameLength - 1;
        }
        String tail = name.substring(maxNameLength - maxTailLength - 1);
        if ((tail = Integer.toString(tail.hashCode(), 36).replace('-', '_')).length() > maxTailLength) {
            tail = tail.substring(0, maxTailLength);
        }
        return name.substring(0, maxNameLength - tail.length() - 1) + '_' + tail;
    }

    public static String dq(String base) {
        int len = base.length();
        if (len > 1 && base.charAt(0) == '\"' && base.charAt(len - 1) == '\"') {
            return base;
        }
        return "\"" + base + "\"";
    }
}

