/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.util;

import com.evermind.util.ServerProperties;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

class RotatedFile
implements FilenameFilter {
    private String filenameWOExt = "";
    private String longFilenameWOExt = "";
    private String extension = "";
    private File dir;
    private File baseFile;
    private File currentFile;
    private static long maxFileSize;
    private static int maxFileNumber;
    private static Calendar rotateTime;
    private Calendar nextDate;
    private static boolean isRotatable;

    public RotatedFile(String s) {
        this.parseFileName(s);
        this.initializeNextDate();
    }

    private void parseFileName(String s) {
        try {
            this.baseFile = new File(s);
            if (this.baseFile.isDirectory()) {
                throw new IOException(" is a directory.");
            }
            String lname = this.baseFile.getCanonicalPath();
            String sname = this.baseFile.getName();
            this.dir = new File(lname.substring(0, lname.lastIndexOf(sname)));
            int extIdx = sname.lastIndexOf(46);
            if (extIdx > -1) {
                this.extension = sname.substring(extIdx, sname.length());
                this.filenameWOExt = sname.substring(0, extIdx);
                this.longFilenameWOExt = lname.substring(0, lname.lastIndexOf(this.extension));
            } else {
                this.filenameWOExt = sname;
                this.longFilenameWOExt = lname;
            }
        }
        catch (IOException e) {
            System.err.println("[stdout/err rotation] IOException: " + this.baseFile + ":" + e.getMessage());
        }
    }

    private void initializeNextDate() {
        if (rotateTime != null) {
            this.nextDate = Calendar.getInstance();
            this.nextDate.set(11, rotateTime.get(11));
            this.nextDate.set(12, rotateTime.get(12));
            this.nextDate.set(13, 0);
            if (this.nextDate.before(Calendar.getInstance())) {
                this.nextDate.add(5, 1);
            }
        }
    }

    public File getNewFile() {
        if (isRotatable) {
            if (maxFileNumber > -1) {
                this.checkMaxFiles();
            }
            this.currentFile = new File(this.longFilenameWOExt + this.getTimeStamp() + this.extension);
        } else {
            this.currentFile = this.baseFile;
        }
        return this.currentFile;
    }

    public File getCurrentFile() {
        return this.currentFile;
    }

    public File getBaseFile() {
        return this.baseFile;
    }

    private String getTimeStamp() {
        return new SimpleDateFormat("_yyyy_MM_dd_HH_mm_ss").format(new Date());
    }

    public boolean isLimit() {
        boolean limit = false;
        if (maxFileSize > -1L && this.currentFile != null) {
            boolean bl = limit = this.currentFile.length() > maxFileSize;
        }
        if (this.nextDate != null && this.nextDate.getTimeInMillis() - System.currentTimeMillis() < 0L) {
            limit = true;
            this.nextDate.add(5, 1);
        }
        return limit;
    }

    private void checkMaxFiles() {
        File[] list;
        while ((list = this.dir.listFiles(this)) != null && list.length >= maxFileNumber) {
            File oldest = list[0];
            for (int i = 1; i < list.length; ++i) {
                if (list[i].lastModified() >= oldest.lastModified()) continue;
                oldest = list[i];
            }
            oldest.delete();
        }
    }

    public static boolean isRotatable() {
        return isRotatable;
    }

    public boolean accept(File dir, String name) {
        return name.startsWith(this.filenameWOExt) && name.endsWith(this.extension);
    }

    static {
        String rotateTimeStr;
        String maxFileNumberStr;
        maxFileSize = -1L;
        maxFileNumber = -1;
        isRotatable = false;
        double maxFileSizeDB = -1.0;
        double maxDateDB = -1.0;
        String maxFileSizeStr = ServerProperties.getStdstreamFilesize();
        if (maxFileSizeStr != null) {
            try {
                maxFileSizeDB = Double.parseDouble(maxFileSizeStr);
            }
            catch (NumberFormatException e) {
                System.err.println("[stdout/err rotation] Error on parsing \"stdstream.filesize\" option: " + e.getMessage());
            }
        }
        if ((maxFileNumberStr = ServerProperties.getStdstreamFilenumber()) != null) {
            try {
                maxFileNumber = Integer.parseInt(maxFileNumberStr);
            }
            catch (NumberFormatException e) {
                System.err.println("[stdout/err rotation] Error on parsing \"stdstream.filenumber\" option: " + e.getMessage());
            }
        }
        if ((rotateTimeStr = ServerProperties.getStdstreamRotatetime()) != null) {
            SimpleDateFormat sdf = new SimpleDateFormat("HH:mm");
            try {
                sdf.parse(rotateTimeStr);
                rotateTime = sdf.getCalendar();
                isRotatable = true;
            }
            catch (ParseException pe) {
                System.err.println("[stdout/err rotation] Error on parsing \"stdstream.rotatetime\" option: " + pe.getMessage());
            }
        }
        if (maxFileSizeDB > -1.0) {
            maxFileSize = (long)(maxFileSizeDB * 1024.0 * 1024.0);
            isRotatable = true;
        }
    }
}

