/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.util;

import com.evermind.io.ClassLoaderObjectInputStream;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigInteger;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;

public class ObjectUtils {
    private static final int INTEGER_CACHE_MIN_VALUE = -20;
    private static final int INTEGER_CACHE_MAX_VALUE = 100;
    private static final int INTEGER_CACHE_OFFSET = 20;
    private static final int INTEGER_CACHE_SIZE = 121;
    private static final Integer[] INTEGER_CACHE = new Integer[121];
    private static Map emptyMap;
    private static Set emptySet;

    public static final boolean equals(Object a, Object b) {
        if (a == null) {
            return b == null;
        }
        return a.equals(b);
    }

    public static final Object toObject(Object v) {
        return v;
    }

    public static final Object toObject(boolean v) {
        return new Boolean(v);
    }

    public static final Object toObject(byte v) {
        return new Byte(v);
    }

    public static final Object toObject(short v) {
        return new Short(v);
    }

    public static final Object toObject(char v) {
        return new Character(v);
    }

    public static final Object toObject(int v) {
        return new Integer(v);
    }

    public static final Object toObject(float v) {
        return new Float(v);
    }

    public static final Object toObject(long v) {
        return new Long(v);
    }

    public static final Object toObject(double v) {
        return new Double(v);
    }

    public static final int toInt(Object v) {
        return Integer.parseInt(v.toString());
    }

    public static final int toInt(String v) {
        return Integer.parseInt(v);
    }

    public static final int toInt(boolean v) {
        if (v) {
            return 1;
        }
        return 0;
    }

    public static final int toInt(int v) {
        return v;
    }

    public static final int toInt(char v) {
        return v;
    }

    public static final int toInt(short v) {
        return v;
    }

    public static final int toInt(float v) {
        return (int)v;
    }

    public static final int toInt(double v) {
        return (int)v;
    }

    public static final int toInt(long v) {
        return (int)v;
    }

    public static final int toInt(byte v) {
        return v;
    }

    public static final long toLong(Object v) {
        return Long.parseLong(v.toString());
    }

    public static final long toLong(String v) {
        return Long.parseLong(v);
    }

    public static final long toLong(boolean v) {
        if (v) {
            return 1L;
        }
        return 0L;
    }

    public static final long toLong(int v) {
        return v;
    }

    public static final long toLong(char v) {
        return v;
    }

    public static final long toLong(short v) {
        return v;
    }

    public static final long toLong(float v) {
        return (long)v;
    }

    public static final long toLong(double v) {
        return (long)v;
    }

    public static final long toLong(long v) {
        return v;
    }

    public static final long toLong(byte v) {
        return v;
    }

    public static final double toDouble(Object v) {
        return Double.parseDouble(v.toString());
    }

    public static final double toDouble(String v) {
        return Double.parseDouble(v);
    }

    public static final double toDouble(boolean v) {
        if (v) {
            return 1.0;
        }
        return 0.0;
    }

    public static final double toDouble(int v) {
        return v;
    }

    public static final double toDouble(char v) {
        return v;
    }

    public static final double toDouble(short v) {
        return v;
    }

    public static final double toDouble(float v) {
        return v;
    }

    public static final double toDouble(long v) {
        return v;
    }

    public static final double toDouble(double v) {
        return v;
    }

    public static final double toDouble(byte v) {
        return v;
    }

    public static final boolean toBoolean(Object v) {
        if (v == null) {
            return false;
        }
        return ObjectUtils.toBoolean(v.toString());
    }

    public static final boolean toBoolean(String v) {
        return "true".equalsIgnoreCase(v);
    }

    public static final boolean toBoolean(boolean v) {
        return v;
    }

    public static final boolean toBoolean(int v) {
        return v != 0;
    }

    public static final boolean toBoolean(char v) {
        return v != '\u0000';
    }

    public static final boolean toBoolean(short v) {
        return v != 0;
    }

    public static final boolean toBoolean(float v) {
        return v != 0.0f;
    }

    public static final boolean toBoolean(double v) {
        return v != 0.0;
    }

    public static final boolean toBoolean(long v) {
        return v != 0L;
    }

    public static final boolean toBoolean(byte v) {
        return v != 0;
    }

    public static final String toString(Object object) {
        if (object == null) {
            return null;
        }
        return object.toString();
    }

    public static final String toString(String object) {
        return object;
    }

    public static final String toString(boolean v) {
        return String.valueOf(v);
    }

    public static final String toString(byte v) {
        return String.valueOf(v);
    }

    public static final String toString(short v) {
        return String.valueOf(v);
    }

    public static final String toString(char v) {
        return String.valueOf(v);
    }

    public static final String toString(int v) {
        return String.valueOf(v);
    }

    public static final String toString(float v) {
        return String.valueOf(v);
    }

    public static final String toString(long v) {
        return String.valueOf(v);
    }

    public static final String toString(double v) {
        return String.valueOf(v);
    }

    public static final Object toBasicType(String value, String type) {
        if (value == null) {
            return null;
        }
        if (type == null || type.equals("java.lang.String")) {
            return value;
        }
        if (type.equals("java.lang.Integer") || type.equals("int")) {
            try {
                return Integer.valueOf(value);
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("Invalid Integer value");
            }
        }
        if (type.equals("java.lang.Float") || type.equals("float")) {
            try {
                return Float.valueOf(value);
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("Invalid Float value");
            }
        }
        if (type.equals("java.lang.Long") || type.equals("long")) {
            try {
                return Long.valueOf(value);
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("Invalid Long value");
            }
        }
        if (type.equals("java.lang.Double") || type.equals("double")) {
            try {
                return Double.valueOf(value);
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("Invalid Double value");
            }
        }
        if (type.equals("java.lang.Character") || type.equals("char")) {
            if (value.length() != 1) {
                throw new IllegalArgumentException("Invalid Character value");
            }
            return new Character(value.charAt(0));
        }
        if (type.equals("java.lang.Byte") || type.equals("byte")) {
            try {
                return Byte.valueOf(value);
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("Invalid Byte value");
            }
        }
        if (type.equals("java.lang.Short") || type.equals("short")) {
            try {
                return Short.valueOf(value);
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("Invalid Short value");
            }
        }
        if (type.equals("java.lang.Boolean") || type.equals("boolean")) {
            try {
                return Boolean.valueOf(value);
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("Invalid Boolean value");
            }
        }
        throw new IllegalArgumentException("Invalid attribute type: " + type);
    }

    public static void setProperty(Object object, String name, String value, boolean caseSensitive, boolean lenient) throws IllegalArgumentException, IntrospectionException, IllegalAccessException, InvocationTargetException {
        Class<?> type = object.getClass();
        PropertyDescriptor[] descriptors = Introspector.getBeanInfo(type).getPropertyDescriptors();
        ArrayList<String> names = new ArrayList<String>();
        for (int i = 0; i < descriptors.length; ++i) {
            if (descriptors[i].getWriteMethod() == null) continue;
            if (caseSensitive && descriptors[i].getName().equals(name) || !caseSensitive && descriptors[i].getName().equalsIgnoreCase(name)) {
                Method method = descriptors[i].getWriteMethod();
                Class<?> paramType = method.getParameterTypes()[0];
                Object param = ObjectUtils.toBasicType(value, paramType.getName());
                method.invoke(object, param);
                return;
            }
            names.add(descriptors[i].getName());
        }
        if (!lenient) {
            throw new IllegalArgumentException("No such property: " + name + ", existing writable properties are: " + names);
        }
    }

    public static String getStringProperty(Object object, String name, boolean caseSensitive, boolean lenient) throws IllegalArgumentException, IntrospectionException, IllegalAccessException, InvocationTargetException {
        Class<?> type = object.getClass();
        PropertyDescriptor[] descriptors = Introspector.getBeanInfo(type).getPropertyDescriptors();
        ArrayList<String> names = new ArrayList<String>();
        for (int i = 0; i < descriptors.length; ++i) {
            if (descriptors[i].getReadMethod() == null) continue;
            if (caseSensitive && descriptors[i].getName().equals(name) || !caseSensitive && descriptors[i].getName().equalsIgnoreCase(name)) {
                Method method = descriptors[i].getReadMethod();
                Object response = method.invoke(object, new Object[0]);
                if (response == null) {
                    return null;
                }
                return String.valueOf(response);
            }
            names.add(descriptors[i].getName());
        }
        if (!lenient) {
            throw new IllegalArgumentException("No such property: " + name + ", existing writable properties are: " + names);
        }
        return null;
    }

    public static Object getObject(byte[] data, ClassLoader loader) throws IOException, ClassNotFoundException {
        return ObjectUtils.getObject(new ByteArrayInputStream(data), loader);
    }

    public static Object getObject(InputStream in, ClassLoader loader) throws IOException, ClassNotFoundException {
        ClassLoaderObjectInputStream objectIn = new ClassLoaderObjectInputStream(in, loader);
        return objectIn.readObject();
    }

    public static String toString(Locale locale) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(locale.getLanguage());
        String country = locale.getCountry();
        if (country != null && country.length() == 2) {
            buffer.append('_');
            buffer.append(country);
        }
        return buffer.toString();
    }

    public static Locale toLocale(String string) {
        if (string == null) {
            return null;
        }
        if (string.length() == 2) {
            return new Locale(string, "");
        }
        if (string.length() == 5) {
            return new Locale(string.substring(0, 2), string.substring(3, 5));
        }
        return null;
    }

    public static BigInteger toBigInteger(String string) {
        if (string == null) {
            return null;
        }
        return new BigInteger(string);
    }

    public static Date toDate(Timestamp timestamp) {
        if (timestamp == null) {
            return null;
        }
        return new Date(((Date)timestamp).getTime());
    }

    public static InternetAddress toInternetAddress(String address) {
        if (address == null) {
            return null;
        }
        try {
            return new InternetAddress(address);
        }
        catch (AddressException e) {
            return null;
        }
    }

    public static Object getDefaultValue(Class type) {
        if (type.isPrimitive()) {
            if (type == Integer.TYPE) {
                return new Integer(0);
            }
            if (type == Float.TYPE) {
                return new Float(0.0);
            }
            if (type == Long.TYPE) {
                return new Long(0L);
            }
            if (type == Double.TYPE) {
                return new Double(0.0);
            }
            if (type == Byte.TYPE) {
                return new Byte(0);
            }
            if (type == Character.TYPE) {
                return new Character('\u0000');
            }
            if (type == Short.TYPE) {
                return new Short(0);
            }
            if (type == Boolean.TYPE) {
                return Boolean.FALSE;
            }
        }
        return null;
    }

    public static final Integer getInteger(int value) {
        if (value >= -20 && value <= 100) {
            int index = value + 20;
            Integer integer = INTEGER_CACHE[index];
            if (integer == null) {
                integer = ObjectUtils.INTEGER_CACHE[index] = new Integer(value);
            }
            return integer;
        }
        return new Integer(value);
    }

    public static final List toList(Iterator iterator) {
        ArrayList list = new ArrayList();
        while (iterator.hasNext()) {
            list.add(iterator.next());
        }
        return list;
    }

    public static Map getEmptyMap() {
        if (emptyMap == null) {
            emptyMap = Collections.unmodifiableMap(new HashMap());
        }
        return emptyMap;
    }

    public static Set getEmptySet() {
        if (emptySet == null) {
            emptySet = Collections.unmodifiableSet(new HashSet());
        }
        return emptySet;
    }

    public static int getInt(Object value, int defaultValue) {
        if (value instanceof Number) {
            return ((Number)value).intValue();
        }
        return defaultValue;
    }

    public static long getLong(Object value, long defaultValue) {
        if (value instanceof Number) {
            return ((Number)value).longValue();
        }
        return defaultValue;
    }

    public static int parseInt(String value, int defaultValue) {
        if (value == null) {
            return defaultValue;
        }
        return Integer.parseInt(value);
    }

    public static long parseLong(String value, long defaultValue) {
        if (value == null) {
            return defaultValue;
        }
        return Long.parseLong(value);
    }

    public static Object get(Set set, int pos) {
        Iterator iterator = set.iterator();
        for (int i = 0; i < pos; ++i) {
            iterator.next();
        }
        return iterator.next();
    }

    public static PropertyDescriptor getPropertyDescriptor(BeanInfo info, String name) {
        PropertyDescriptor[] descriptors = info.getPropertyDescriptors();
        for (int i = 0; i < descriptors.length; ++i) {
            if (!descriptors[i].getName().equals(name)) continue;
            return descriptors[i];
        }
        return null;
    }

    public static final byte toByte(char v) {
        return (byte)(v > '\u00ff' ? 63 : (int)v);
    }
}

