/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.util;

import com.evermind.naming.DelayedBinding;
import com.evermind.naming.FlatNameParser;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Map;
import javax.naming.Binding;
import javax.naming.CompositeName;
import javax.naming.Context;
import javax.naming.InvalidNameException;
import javax.naming.Name;
import javax.naming.NameAlreadyBoundException;
import javax.naming.NameClassPair;
import javax.naming.NameNotFoundException;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.NotContextException;
import javax.naming.OperationNotSupportedException;

public class MapContext
implements Context {
    private String displayName;
    private Map bindings;
    private String previousLookupName;
    private Object previousLookupValue;

    public MapContext(String displayName, Map map, boolean mutable) {
        this.displayName = displayName;
        this.bindings = map;
        if (this.bindings == null) {
            throw new NullPointerException("bingins were null");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object lookup(String name) throws NamingException {
        MapContext mapContext = this;
        synchronized (mapContext) {
            if (name == this.previousLookupName) {
                return this.previousLookupValue;
            }
        }
        if (name.equals("")) {
            return this;
        }
        Object answer = this.bindings.get(name);
        if (answer == null) {
            throw new NameNotFoundException(name + " not found" + (this.displayName == null ? "" : " in " + this.displayName));
        }
        if (answer instanceof DelayedBinding) {
            answer = ((DelayedBinding)answer).getInstance();
            this.bindings.put(name, answer);
        }
        MapContext mapContext2 = this;
        synchronized (mapContext2) {
            this.previousLookupName = name;
            this.previousLookupValue = answer;
        }
        return answer;
    }

    public Object lookup(Name name) throws NamingException {
        return this.lookup(name.toString());
    }

    void bindInitially(String name, Object obj) {
        this.bindings.put(name, obj);
    }

    public void bind(String name, Object obj) throws NamingException {
        throw new OperationNotSupportedException();
    }

    public void bind(Name name, Object obj) throws NamingException {
        this.bind(name.toString(), obj);
    }

    public synchronized void rebind(String name, Object obj) throws NamingException {
        this.previousLookupName = null;
        this.previousLookupValue = null;
        if (name.equals("")) {
            throw new InvalidNameException("Cannot bind empty name");
        }
        this.bindings.put(name, obj);
    }

    public void rebind(Name name, Object obj) throws NamingException {
        this.rebind(name.toString(), obj);
    }

    public synchronized void unbind(String name) throws NamingException {
        this.previousLookupName = null;
        this.previousLookupValue = null;
        if (name.equals("")) {
            throw new InvalidNameException("Cannot unbind empty name");
        }
        this.bindings.remove(name);
    }

    public void unbind(Name name) throws NamingException {
        this.unbind(name.toString());
    }

    public synchronized void rename(String oldname, String newname) throws NamingException {
        this.previousLookupName = null;
        this.previousLookupValue = null;
        if (oldname.equals("") || newname.equals("")) {
            throw new InvalidNameException("Cannot rename empty name");
        }
        if (this.bindings.get(newname) != null) {
            throw new NameAlreadyBoundException(newname + " is already bound");
        }
        Object oldBinding = this.bindings.remove(oldname);
        if (oldBinding == null) {
            throw new NameNotFoundException(oldname + " not bound");
        }
        this.bindings.put(newname, oldBinding);
    }

    public void rename(Name oldname, Name newname) throws NamingException {
        this.rename(oldname.toString(), newname.toString());
    }

    public NamingEnumeration list(String name) throws NamingException {
        if (name.equals("")) {
            return new FlatNames(Collections.enumeration(this.bindings.keySet()));
        }
        Object target = this.lookup(name);
        if (target instanceof Context) {
            return ((Context)target).list("");
        }
        throw new NotContextException(name + " cannot be listed");
    }

    public NamingEnumeration list(Name name) throws NamingException {
        return this.list(name.toString());
    }

    public NamingEnumeration listBindings(String name) throws NamingException {
        if (name.equals("")) {
            return new FlatBindings(Collections.enumeration(this.bindings.keySet()));
        }
        Object target = this.lookup(name);
        if (target instanceof Context) {
            return ((Context)target).listBindings("");
        }
        throw new NotContextException(name + " cannot be listed");
    }

    public NamingEnumeration listBindings(Name name) throws NamingException {
        return this.listBindings(name.toString());
    }

    public void destroySubcontext(String name) throws NamingException {
        throw new OperationNotSupportedException("This context does not support subcontexts");
    }

    public void destroySubcontext(Name name) throws NamingException {
        this.destroySubcontext(name.toString());
    }

    public Context createSubcontext(String name) throws NamingException {
        throw new OperationNotSupportedException("This Context does not support subcontexts");
    }

    public Context createSubcontext(Name name) throws NamingException {
        return this.createSubcontext(name.toString());
    }

    public Object lookupLink(String name) throws NamingException {
        return this.lookup(name);
    }

    public Object lookupLink(Name name) throws NamingException {
        return this.lookupLink(name.toString());
    }

    public NameParser getNameParser(String name) throws NamingException {
        return FlatNameParser.getInstance();
    }

    public NameParser getNameParser(Name name) throws NamingException {
        return this.getNameParser(name.toString());
    }

    public String composeName(String name, String prefix) throws NamingException {
        Name result = this.composeName(new CompositeName(name), new CompositeName(prefix));
        return result.toString();
    }

    public Name composeName(Name name, Name prefix) throws NamingException {
        Name result = (Name)prefix.clone();
        result.addAll(name);
        return result;
    }

    public Object addToEnvironment(String propName, Object propVal) throws NamingException {
        return null;
    }

    public Object removeFromEnvironment(String propName) throws NamingException {
        return null;
    }

    public Hashtable getEnvironment() throws NamingException {
        return new Hashtable();
    }

    public void close() throws NamingException {
    }

    public String toString() {
        return "[Context " + this.displayName + ": " + this.bindings + "]";
    }

    public String getNameInNamespace() {
        if (this.displayName == null) {
            return "";
        }
        return this.displayName;
    }

    class FlatBindings
    implements NamingEnumeration {
        Enumeration names;

        FlatBindings(Enumeration names) {
            this.names = names;
        }

        public boolean hasMoreElements() {
            return this.names.hasMoreElements();
        }

        public boolean hasMore() throws NamingException {
            return this.hasMoreElements();
        }

        public Object nextElement() {
            String name = (String)this.names.nextElement();
            return new Binding(name, MapContext.this.bindings.get(name));
        }

        public Object next() throws NamingException {
            return this.nextElement();
        }

        public void close() {
        }
    }

    class FlatNames
    implements NamingEnumeration {
        Enumeration names;

        FlatNames(Enumeration names) {
            this.names = names;
        }

        public boolean hasMoreElements() {
            return this.names.hasMoreElements();
        }

        public boolean hasMore() throws NamingException {
            return this.hasMoreElements();
        }

        public Object nextElement() {
            String name = (String)this.names.nextElement();
            String className = MapContext.this.bindings.get(name).getClass().getName();
            return new NameClassPair(name, className);
        }

        public Object next() throws NamingException {
            return this.nextElement();
        }

        public void close() {
        }
    }
}

