/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.util;

import com.evermind.util.IntLinkedEntry;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;

public class IntHashMap
extends AbstractMap {
    private IntLinkedEntry[] entries = new IntLinkedEntry[100];
    private int size;
    private final float loadFactor = 2.0f;

    public Set entrySet() {
        return new IntHashMapEntrySet();
    }

    public Object get(Object key) {
        try {
            return this.get(((Number)key).intValue());
        }
        catch (ClassCastException e) {
            return null;
        }
    }

    public Object get(int key) {
        int pos = key % this.entries.length;
        IntLinkedEntry entry = this.entries[pos];
        while (entry != null) {
            if (entry.key != key) continue;
            return entry.value;
        }
        return null;
    }

    public Object put(Object key, Object value) {
        return this.put(((Number)key).intValue(), value);
    }

    public Object put(int key, Object value) {
        int pos = key % this.entries.length;
        if (this.entries[pos] != null) {
            IntLinkedEntry entry = this.entries[pos];
            while (true) {
                if (entry.key == key) {
                    Object previousValue = entry.value;
                    entry.value = value;
                    return previousValue;
                }
                entry = entry.next;
            }
        }
        ++this.size;
        this.entries[pos] = new IntLinkedEntry(key, value, this.entries[pos]);
        if (this.size > this.entries.length) {
            this.setHashSize((int)((float)this.size * 2.0f));
        }
        return null;
    }

    public Object remove(Object key) {
        try {
            return this.remove(((Number)key).intValue());
        }
        catch (ClassCastException e) {
            return null;
        }
    }

    public Object remove(int key) {
        int pos = key % this.entries.length;
        if (this.entries[pos] != null) {
            IntLinkedEntry previousEntry = null;
            IntLinkedEntry entry = this.entries[pos];
            do {
                if (entry.key == key) {
                    --this.size;
                    if (previousEntry != null) {
                        previousEntry.next = entry.next;
                    } else {
                        this.entries[pos] = null;
                    }
                    return entry.value;
                }
                previousEntry = entry;
            } while ((entry = entry.next) != null);
        }
        return null;
    }

    public int size() {
        return this.size;
    }

    public void setHashSize(int length) {
        if (length == this.entries.length) {
            return;
        }
        if (length < 1) {
            throw new IllegalArgumentException("Invalid length");
        }
        IntLinkedEntry[] entries = this.entries;
        IntLinkedEntry[] newEntries = new IntLinkedEntry[length];
        for (int i = 0; i < entries.length; ++i) {
            if (entries[i] == null) continue;
            IntLinkedEntry next = entries[i];
            while (next != null) {
                IntLinkedEntry entry = next;
                next = entry.next;
                int pos = entry.key % length;
                entry.next = newEntries[pos];
                newEntries[pos] = entry;
            }
        }
        this.entries = newEntries;
    }

    public class IntHashMapEntrySet
    extends AbstractSet {
        public Iterator iterator() {
            return new IntHashMapEntrySetIterator();
        }

        public int size() {
            return IntHashMap.this.size;
        }
    }

    public class IntHashMapEntrySetIterator
    implements Iterator {
        private int pos;
        private IntLinkedEntry previousEntry;
        private IntLinkedEntry entry;

        public IntHashMapEntrySetIterator() {
            if (IntHashMap.this.entries[0] != null) {
                this.entry = IntHashMap.this.entries[0];
            } else {
                this.getNextEntry();
            }
        }

        public Object next() {
            if (this.entry == null) {
                throw new NoSuchElementException();
            }
            IntLinkedEntry entry = this.entry;
            this.getNextEntry();
            return entry;
        }

        public void remove() {
            if (this.entry == null) {
                throw new NoSuchElementException();
            }
            if (this.previousEntry != null && this.previousEntry.next == this.entry) {
                this.previousEntry.next = this.entry.next;
                this.entry = this.previousEntry;
                this.getNextEntry();
            } else {
                ((IntHashMap)IntHashMap.this).entries[this.pos] = null;
                this.getNextEntry();
            }
        }

        public boolean hasNext() {
            return this.entry != null;
        }

        private void getNextEntry() {
            this.previousEntry = this.entry;
            if (this.entry != null && this.entry.next != null) {
                this.entry = this.entry.next;
                return;
            }
            do {
                if (++this.pos < IntHashMap.this.entries.length) continue;
                this.entry = null;
                return;
            } while (IntHashMap.this.entries[this.pos] == null);
            this.entry = IntHashMap.this.entries[this.pos];
        }
    }
}

