/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.util;

import com.evermind.io.LastModifiedContainer;
import com.evermind.naming.SubContext;
import com.evermind.naming.archive.MemoryArchiveContext;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;

public class ConfigUtils {
    public static Properties readMultipleEntryProperties(String file) throws IOException {
        if (file.indexOf(":/") < 0) {
            return ConfigUtils.readMultipleEntryProperties(new File(file).toURL());
        }
        return ConfigUtils.readMultipleEntryProperties(new URL(file));
    }

    public static Properties readMultipleEntryProperties(URL url) throws IOException {
        String line;
        InputStream inStream = url.openConnection().getInputStream();
        BufferedReader in = new BufferedReader(new InputStreamReader(inStream));
        Properties properties = new Properties();
        while ((line = in.readLine()) != null) {
            StringTokenizer tokenizer;
            if (line.length() == 0 || line.charAt(0) == '#' || line.charAt(0) == ';' || !(tokenizer = new StringTokenizer(line, " \t")).hasMoreElements()) continue;
            String value = tokenizer.nextToken().intern();
            while (tokenizer.hasMoreElements()) {
                properties.put(tokenizer.nextToken().intern(), value);
            }
        }
        inStream.close();
        return properties;
    }

    public static Properties readProperties(String file) throws IOException {
        if (file.indexOf(":/") < 0) {
            return ConfigUtils.readProperties(new File(file).toURL());
        }
        return ConfigUtils.readProperties(new URL(file));
    }

    public static Properties readProperties(URL url) throws IOException {
        InputStream in = url.openStream();
        Properties properties = new Properties();
        String urlString = url.toExternalForm();
        properties.put("properties.directory", urlString.substring(0, urlString.lastIndexOf(47) + 1));
        properties.put("properties.source", urlString);
        properties.load(in);
        in.close();
        return properties;
    }

    public static String toPath(List paths) {
        StringBuffer result = new StringBuffer();
        for (int i = 0; i < paths.size(); ++i) {
            String path = (String)paths.get(i);
            if (i <= 0) continue;
            result.append(File.separatorChar);
            result.append(path);
        }
        return result.toString();
    }

    public static String getAbsolutePath(URL url, String relPath) {
        if (relPath == null) {
            return relPath;
        }
        if (relPath.startsWith(File.separator)) {
            return relPath;
        }
        String res = url.getFile() + relPath;
        return res;
    }

    public static void canonicalizeProperty(Properties properties, String name) {
        String value = ConfigUtils.canonicalize(properties.getProperty("properties.directory"), properties.getProperty(name));
        if (value != null) {
            properties.put(name, value);
        }
    }

    public static void canonicalizeMultipleProperties(Properties properties, String name) {
        StringBuffer buffer = new StringBuffer();
        String values = properties.getProperty(name);
        String directory = properties.getProperty("properties.directory");
        if (values == null) {
            return;
        }
        StringTokenizer tokenizer = new StringTokenizer(values, ";");
        while (tokenizer.hasMoreElements()) {
            buffer.append(ConfigUtils.canonicalize(directory, tokenizer.nextToken().trim()));
            buffer.append(';');
        }
        properties.put(name, buffer.toString());
    }

    public static String canonicalizeEntries(String base, String entries, boolean removeFileProtocol) {
        StringBuffer buffer = new StringBuffer();
        StringTokenizer tokenizer = new StringTokenizer(entries, ",");
        boolean first = true;
        while (tokenizer.hasMoreElements()) {
            String value = tokenizer.nextToken().trim();
            int equalsIndex = value.indexOf(61);
            if (equalsIndex < 0) continue;
            String key = value.substring(0, equalsIndex).trim();
            value = value.substring(equalsIndex + 1, value.length()).trim();
            if ((value = ConfigUtils.canonicalize(base, value)).startsWith("file:") && removeFileProtocol) {
                try {
                    value = new File(new URL(value).getFile().replace('/', File.separatorChar)).getAbsolutePath();
                }
                catch (MalformedURLException e) {
                    // empty catch block
                }
            }
            if (!first) {
                buffer.append(", ");
            }
            first = false;
            buffer.append(key);
            buffer.append('=');
            buffer.append(value);
        }
        return buffer.toString();
    }

    public static URL[] toURLs(String paths) {
        return ConfigUtils.toURLs(paths, System.getProperty("user.dir").concat(File.separator));
    }

    public static String canonicalize(String source, String value) {
        if (value == null) {
            return null;
        }
        if (value.indexOf(":/") > 0) {
            return value;
        }
        if (new File(value).isAbsolute()) {
            try {
                return new File(value).getCanonicalFile().toURL().toString();
            }
            catch (IOException e) {
                return new File(source, value).getPath();
            }
        }
        if (source == null) {
            return value;
        }
        if (source.indexOf(":/") > 0) {
            if (source.startsWith("file")) {
                try {
                    String path = new File(new URL(source + value).getFile()).getCanonicalFile().toURL().toString();
                    if (path.endsWith("/") || path.endsWith(File.separator)) {
                        path = path.substring(0, path.length() - 1);
                    }
                    return path;
                }
                catch (IOException e) {
                    // empty catch block
                }
            }
            return source + value;
        }
        try {
            return new File(source, value).getCanonicalFile().toURL().toString();
        }
        catch (IOException e) {
            return new File(source, value).getPath();
        }
    }

    public static Properties getEntries(String string) {
        Properties properties = new Properties();
        StringTokenizer tokenizer = new StringTokenizer(string, ",");
        while (tokenizer.hasMoreTokens()) {
            String entry = tokenizer.nextToken();
            int separatorPos = entry.indexOf(61);
            if (separatorPos < 0) {
                properties.put(entry.trim(), "");
                continue;
            }
            properties.put(entry.substring(0, separatorPos).trim(), entry.substring(separatorPos + 1, entry.length()).trim());
        }
        return properties;
    }

    public static URL[] toURLs(String paths, String base) {
        StringTokenizer tokenizer = new StringTokenizer(paths, ";,");
        ArrayList<URL> urls = new ArrayList<URL>();
        while (tokenizer.hasMoreElements()) {
            String path = tokenizer.nextToken();
            try {
                path = ConfigUtils.canonicalize(base, path);
            }
            catch (Throwable t) {
                // empty catch block
            }
            try {
                urls.add(new URL(path));
            }
            catch (MalformedURLException e) {}
        }
        return urls.toArray(new URL[urls.size()]);
    }

    public static String getURL(Properties properties) {
        String directory = properties.getProperty("properties.directory");
        if (directory == null) {
            return System.getProperty("user.dir");
        }
        return directory;
    }

    public static URL getPropertyURL(Properties properties, String name) {
        String value = ConfigUtils.canonicalize(properties.getProperty("properties.directory"), properties.getProperty(name));
        if (value == null) {
            return null;
        }
        try {
            return new URL(value);
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    public static URL[] getPropertyLenientURLs(Properties properties, String name) {
        return ConfigUtils.getLenientURLs(properties.getProperty(name), properties.getProperty("properties.directory"));
    }

    public static URL[] getLenientURLs(String urlString, String base) {
        if (urlString == null) {
            return new URL[0];
        }
        URL[] urls = ConfigUtils.toURLs(urlString, base);
        ArrayList urlList = new ArrayList();
        for (int i = 0; i < urls.length; ++i) {
            urlList.addAll(ConfigUtils.getURLs(urls[i]));
        }
        return urlList.toArray(new URL[urlList.size()]);
    }

    public static List getURLs(URL url) {
        ArrayList<URL> urls = new ArrayList<URL>();
        String fileString = url.getFile();
        File[] files = null;
        if (fileString.endsWith("/")) {
            fileString = fileString.substring(0, fileString.length() - 1);
            urls.add(url);
            files = new File(fileString).listFiles();
        } else {
            files = new File(fileString).listFiles();
            if (files != null) {
                try {
                    urls.add(new URL(url.toString().concat("/")));
                }
                catch (MalformedURLException e) {}
            } else {
                urls.add(url);
            }
        }
        if (files == null) {
            return urls;
        }
        try {
            for (int i = 0; i < files.length; ++i) {
                String path = files[i].getPath();
                if (!path.endsWith(".jar") && !path.endsWith(".zip")) continue;
                urls.add(files[i].getCanonicalFile().toURL());
            }
        }
        catch (MalformedURLException e) {
        }
        catch (IOException e) {
            // empty catch block
        }
        return urls;
    }

    public static void canonicalize(Properties properties) {
        String source = properties.getProperty("properties.directory");
        Iterator<Object> iterator = properties.keySet().iterator();
        while (iterator.hasNext()) {
            String key = (String)iterator.next();
            String value = properties.getProperty(key);
            if (value == null) continue;
            properties.put(key, ConfigUtils.canonicalize(source, value));
        }
    }

    public static void canonicalizeNonWildCards(Properties properties) {
        String source = properties.getProperty("properties.directory");
        Iterator<Object> iterator = properties.keySet().iterator();
        while (iterator.hasNext()) {
            String key = (String)iterator.next();
            String value = properties.getProperty(key);
            if (value == null || value.startsWith("*")) continue;
            properties.put(key, ConfigUtils.canonicalize(source, value));
        }
    }

    public static String getClasspath(URL[] urls) {
        StringBuffer classpath = new StringBuffer();
        for (int i = 0; i < urls.length; ++i) {
            if (!urls[i].getProtocol().equals("file")) continue;
            classpath.append(new File(urls[i].getFile()).getAbsolutePath());
            classpath.append(File.pathSeparatorChar);
        }
        return classpath.toString();
    }

    public static void canonicalizeProperties(Properties properties, String[] names) {
        for (int i = 0; i < names.length; ++i) {
            ConfigUtils.canonicalizeProperty(properties, names[i]);
        }
    }

    public static URL getURL(URL url, String extendingPath) throws MalformedURLException, IOException {
        File file;
        if (extendingPath.indexOf(":/") >= 0) {
            try {
                return new URL(extendingPath);
            }
            catch (MalformedURLException me) {
                // empty catch block
            }
        }
        if ((file = new File(extendingPath)).isAbsolute()) {
            return new File(file.getParentFile().getCanonicalPath() + File.separatorChar + file.getName()).toURL();
        }
        String urlDirectory = null;
        if (url != null) {
            if (url.getProtocol().equals("file")) {
                try {
                    urlDirectory = url.getFile();
                    if (!urlDirectory.endsWith("/")) {
                        urlDirectory = urlDirectory.substring(0, urlDirectory.lastIndexOf(47) + 1);
                    }
                    return new File(new File(urlDirectory + extendingPath).getParentFile().getCanonicalPath() + File.separatorChar + file.getName()).toURL();
                }
                catch (IOException e) {
                    // empty catch block
                }
            }
            if (!(urlDirectory = url.toExternalForm()).endsWith("/")) {
                urlDirectory = urlDirectory.substring(0, urlDirectory.lastIndexOf(47) + 1);
            }
        } else {
            urlDirectory = new File(System.getProperty("user.dir")).toURL().toExternalForm();
        }
        return new URL(urlDirectory + extendingPath);
    }

    public static long getLastModified(LastModifiedContainer context, String path) throws IOException {
        if (context instanceof SubContext) {
            SubContext sub = (SubContext)((Object)context);
            while (sub.getContext() instanceof SubContext) {
                sub = (SubContext)sub.getContext();
            }
            if (sub.getContext() instanceof MemoryArchiveContext) {
                context = (LastModifiedContainer)((Object)sub.getContext());
            }
        }
        if (context instanceof MemoryArchiveContext) {
            MemoryArchiveContext memory = (MemoryArchiveContext)context;
            while (true) {
                if (memory.getParent() instanceof MemoryArchiveContext) {
                    memory = (MemoryArchiveContext)memory.getParent();
                    continue;
                }
                if (!(memory.getParent() instanceof SubContext)) break;
                SubContext sub = (SubContext)memory.getParent();
                while (sub.getContext() instanceof SubContext) {
                    sub = (SubContext)sub.getContext();
                }
                if (!(sub.getContext() instanceof MemoryArchiveContext)) break;
                memory = (MemoryArchiveContext)sub.getContext();
            }
            return memory.getLastModified();
        }
        return context.getLastModified(path);
    }

    public static File toFile(URL url) throws MalformedURLException {
        String protocol = url.getProtocol();
        if (protocol != null && !protocol.equals("file")) {
            throw new MalformedURLException(url + " does not point at a File");
        }
        String path = url.getPath();
        if (path == null) {
            throw new MalformedURLException("URL has no path");
        }
        path = path.replace('/', File.separatorChar);
        return new File(path);
    }
}

