/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.util;

import com.evermind.util.Describable;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.Serializable;

public abstract class AbstractDescribable
implements Describable,
Serializable {
    public static final long serialVersionUID = -3523880675037507024L;
    private String name;
    private String displayName;
    private String description;
    private transient PropertyChangeSupport propertyChangeSupport;

    protected AbstractDescribable() {
    }

    protected AbstractDescribable(String name) {
        this.name = name;
    }

    protected AbstractDescribable(String name, String displayName, String description) {
        this.name = name;
        this.displayName = displayName;
        this.description = description;
    }

    public String getName() {
        return this.name;
    }

    public String getDisplayName() {
        if (this.displayName != null) {
            return this.displayName;
        }
        return this.name;
    }

    public String getDisplayNameOnly() {
        return this.displayName;
    }

    public String getDescription() {
        return this.description;
    }

    public void setName(String name) {
        String oldName = this.name;
        this.name = name;
        this.firePropertyChangeEvent("name", oldName, name);
    }

    public void setDisplayName(String displayName) {
        String oldName = this.displayName;
        this.displayName = displayName;
        this.firePropertyChangeEvent("displayName", oldName, displayName);
    }

    public void setDescription(String description) {
        String oldDescription = this.description;
        this.description = description;
        this.firePropertyChangeEvent("description", oldDescription, description);
    }

    public void firePropertyChangeEvent(String property, Object value, Object newValue) {
        if (this.propertyChangeSupport == null) {
            return;
        }
        this.propertyChangeSupport.firePropertyChange(property, value, newValue);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (this.propertyChangeSupport == null) {
            this.propertyChangeSupport = new PropertyChangeSupport(this);
        }
        this.propertyChangeSupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this.propertyChangeSupport == null) {
            return;
        }
        this.propertyChangeSupport.removePropertyChangeListener(listener);
    }
}

