/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.sql;

import com.evermind.security.Group;
import com.evermind.server.ApplicationServerUser;
import com.evermind.sql.DataSourceUserManager;
import java.math.BigInteger;
import java.security.Permission;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;

public class DataSourceUser
extends ApplicationServerUser {
    public long fetchedTime;

    public DataSourceUser(DataSourceUserManager manager, String username, String password, String issuer, BigInteger serial, Locale locale, long fetchedTime) {
        super(manager, username, password);
        this.certificateIssuerDN = issuer;
        this.certificateSerial = serial;
        this.locale = locale;
        this.fetchedTime = fetchedTime;
    }

    public void setCertificate(String issuerDN, BigInteger serial) {
        ((DataSourceUserManager)this.manager).updateUserInfo(this.username, issuerDN, serial, this.locale);
        super.setCertificate(issuerDN, serial);
    }

    public void setLocale(Locale locale) {
        ((DataSourceUserManager)this.manager).updateUserInfo(this.username, this.certificateIssuerDN, this.certificateSerial, locale);
        super.setLocale(locale);
    }

    public synchronized boolean hasPermission(Permission permission) {
        if (this.groups == null) {
            try {
                this.groups = ((DataSourceUserManager)this.manager).getGroups(this);
            }
            catch (SQLException e) {
                throw new RuntimeException("SQL error: " + e.getMessage());
            }
        }
        return super.hasPermission(permission);
    }

    public synchronized boolean isMemberOf(Group group) {
        boolean debug = ((DataSourceUserManager)this.manager).debug;
        if (this.manager.getDefaultGroups().contains(group)) {
            if (debug) {
                System.out.println(this.getName() + ".isMemberOf(" + group.getName() + "): yes (was a default group)");
            }
            return true;
        }
        if (this.groups == null) {
            try {
                this.groups = ((DataSourceUserManager)this.manager).getGroups(this);
            }
            catch (SQLException e) {
                throw new RuntimeException("SQL error: " + e.getMessage());
            }
        }
        if (this.groups == null) {
            if (debug) {
                System.out.println(this.getName() + ".isMemberOf(" + group.getName() + "): no");
            }
            return false;
        }
        if (debug) {
            System.out.println(this.getName() + ".isMemberOf(" + group.getName() + "): " + this.groups.contains(group.getName()));
        }
        return this.groups.contains(group);
    }

    public synchronized void addToGroup(Group group) {
        if (this.manager.getDefaultGroups().contains(group)) {
            return;
        }
        if (this.groups == null) {
            try {
                this.groups = ((DataSourceUserManager)this.manager).getGroups(this);
                if (this.groups == null) {
                    return;
                }
                if (!this.groups.contains(group)) {
                    this.groups.add(group);
                    ((DataSourceUserManager)this.manager).addToGroup(this, group);
                }
            }
            catch (SQLException e) {
                throw new RuntimeException("SQL error: " + e.getMessage());
            }
        }
    }

    public synchronized void removeFromGroup(Group group) {
        if (this.manager.getDefaultGroups().contains(group)) {
            return;
        }
        if (this.groups == null) {
            try {
                this.groups = ((DataSourceUserManager)this.manager).getGroups(this);
                if (this.groups == null) {
                    return;
                }
                if (this.groups.contains(group)) {
                    this.groups.remove(group);
                    ((DataSourceUserManager)this.manager).removeFromGroup(this, group);
                }
            }
            catch (SQLException e) {
                throw new RuntimeException("SQL error: " + e.getMessage());
            }
        }
    }

    public synchronized Set getGroups() {
        if (this.groups == null) {
            try {
                this.groups = ((DataSourceUserManager)this.manager).getGroups(this);
                if (this.groups == null) {
                    return new HashSet();
                }
            }
            catch (SQLException e) {
                throw new RuntimeException("SQL error: " + e.getMessage());
            }
        }
        return this.groups;
    }
}

